# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class ProductIdentifierApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_products_to_product_identifier(self, body, product_identifier_id, **kwargs):  # noqa: E501
        """Add products to a product identifier  # noqa: E501

        Adds one or more products to a product identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_products_to_product_identifier(body, product_identifier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be added. (required)
        :param int product_identifier_id: Id of the product identifier to which the products will get added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_products_to_product_identifier_with_http_info(body, product_identifier_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_products_to_product_identifier_with_http_info(body, product_identifier_id, **kwargs)  # noqa: E501
            return data

    def add_products_to_product_identifier_with_http_info(self, body, product_identifier_id, **kwargs):  # noqa: E501
        """Add products to a product identifier  # noqa: E501

        Adds one or more products to a product identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_products_to_product_identifier_with_http_info(body, product_identifier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be added. (required)
        :param int product_identifier_id: Id of the product identifier to which the products will get added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_identifier_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_products_to_product_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_products_to_product_identifier`")  # noqa: E501
        # verify the required parameter 'product_identifier_id' is set
        if ('product_identifier_id' not in params or
                params['product_identifier_id'] is None):
            raise ValueError("Missing the required parameter `product_identifier_id` when calling `add_products_to_product_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_identifier_id' in params:
            path_params['product_identifier_id'] = params['product_identifier_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers/{product_identifier_id}/products', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_product_identifier(self, body, **kwargs):  # noqa: E501
        """Create a new product identifier  # noqa: E501

        Product identifiers must have a product identifier that is unique under the tenant and protocols scope. They need to be assigned to at least one product. To create a product identifier for a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_identifier(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifierRequest body: Product identifier object that needs to be created. (required)
        :return: ProductIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_product_identifier_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_product_identifier_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_product_identifier_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new product identifier  # noqa: E501

        Product identifiers must have a product identifier that is unique under the tenant and protocols scope. They need to be assigned to at least one product. To create a product identifier for a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_identifier_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifierRequest body: Product identifier object that needs to be created. (required)
        :return: ProductIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_product_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_product_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductIdentifierResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_product_identifier_for_product(self, body, product_id, **kwargs):  # noqa: E501
        """Create a new product identifier for a product  # noqa: E501

        Product identifiers must have a product identifier that is unique under the tenant and protocols scope. To create a product identifier for a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_identifier_for_product(body, product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifierRequestNoProducts body: Object to be created. (required)
        :param int product_id: Id of the product (required)
        :return: ProductIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_product_identifier_for_product_with_http_info(body, product_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_product_identifier_for_product_with_http_info(body, product_id, **kwargs)  # noqa: E501
            return data

    def create_product_identifier_for_product_with_http_info(self, body, product_id, **kwargs):  # noqa: E501
        """Create a new product identifier for a product  # noqa: E501

        Product identifiers must have a product identifier that is unique under the tenant and protocols scope. To create a product identifier for a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_identifier_for_product_with_http_info(body, product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifierRequestNoProducts body: Object to be created. (required)
        :param int product_id: Id of the product (required)
        :return: ProductIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_product_identifier_for_product" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_product_identifier_for_product`")  # noqa: E501
        # verify the required parameter 'product_id' is set
        if ('product_id' not in params or
                params['product_id'] is None):
            raise ValueError("Missing the required parameter `product_id` when calling `create_product_identifier_for_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_id' in params:
            path_params['product_id'] = params['product_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/products/{product_id}/identifiers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductIdentifierResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_product_identifier(self, id, **kwargs):  # noqa: E501
        """Delete a product identifier  # noqa: E501

        Delete a specific resource product identifier identified by the id in the URL. To delete a product identifier of a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_identifier(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the product identifier to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_product_identifier_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_product_identifier_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_product_identifier_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a product identifier  # noqa: E501

        Delete a specific resource product identifier identified by the id in the URL. To delete a product identifier of a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_identifier_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the product identifier to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_product_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_product_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_identifier_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single product identifier  # noqa: E501

        Get a specific product identifier identified by the id in the URL.  Possible include values: ```products```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_identifier_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the product identifier to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: ProductIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_identifier_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_identifier_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_product_identifier_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single product identifier  # noqa: E501

        Get a specific product identifier identified by the id in the URL.  Possible include values: ```products```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_identifier_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the product identifier to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :return: ProductIdentifierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_identifier_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_product_identifier_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductIdentifierResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_identifiers(self, **kwargs):  # noqa: E501
        """Get a range of product identifiers  # noqa: E501

        Returns a list of product identifiers. If the query has no matches, the response is an empty list.  Possible include values: ```products```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_identifiers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str organization_name: Filter accepts `FIELDCOMM_GROUP`, `PROFIBUS_PROFINET`, `ODVA`, `MODBUS_ORGANIZATION`, `OTHER_ORGANIZATION`
        :param str protocol: Filter accepts `PROFIBUS`, `HART`, `ETHERNETIP`, `MODBUS`, `OTHERS
        :param str protocol_version: Filter accepts * as wildcard
        :param str product_identifier: Filter accepts * as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :return: ProductIdentifiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_identifiers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_product_identifiers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_product_identifiers_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of product identifiers  # noqa: E501

        Returns a list of product identifiers. If the query has no matches, the response is an empty list.  Possible include values: ```products```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_identifiers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str organization_name: Filter accepts `FIELDCOMM_GROUP`, `PROFIBUS_PROFINET`, `ODVA`, `MODBUS_ORGANIZATION`, `OTHER_ORGANIZATION`
        :param str protocol: Filter accepts `PROFIBUS`, `HART`, `ETHERNETIP`, `MODBUS`, `OTHERS
        :param str protocol_version: Filter accepts * as wildcard
        :param str product_identifier: Filter accepts * as wildcard
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :return: ProductIdentifiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'include', 'organization_name', 'protocol', 'protocol_version', 'product_identifier', 'tenant_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_identifiers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'organization_name' in params:
            query_params.append(('organization_name', params['organization_name']))  # noqa: E501
        if 'protocol' in params:
            query_params.append(('protocol', params['protocol']))  # noqa: E501
        if 'protocol_version' in params:
            query_params.append(('protocol_version', params['protocol_version']))  # noqa: E501
        if 'product_identifier' in params:
            query_params.append(('product_identifier', params['product_identifier']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductIdentifiersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_identifiers_of_product(self, product_id, **kwargs):  # noqa: E501
        """Get all product identifiers of one product  # noqa: E501

        Returns a list of all product identifiers belonging to a product. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``tenant``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_identifiers_of_product(product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int product_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :return: ProductIdentifiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_identifiers_of_product_with_http_info(product_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_identifiers_of_product_with_http_info(product_id, **kwargs)  # noqa: E501
            return data

    def get_product_identifiers_of_product_with_http_info(self, product_id, **kwargs):  # noqa: E501
        """Get all product identifiers of one product  # noqa: E501

        Returns a list of all product identifiers belonging to a product. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ``tenant``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_identifiers_of_product_with_http_info(product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int product_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :return: ProductIdentifiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_id', 'page', 'per_page', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_identifiers_of_product" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_id' is set
        if ('product_id' not in params or
                params['product_id'] is None):
            raise ValueError("Missing the required parameter `product_id` when calling `get_product_identifiers_of_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_id' in params:
            path_params['product_id'] = params['product_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/products/{product_id}/identifiers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductIdentifiersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_products_of_product_identifier(self, product_identifier_id, **kwargs):  # noqa: E501
        """Get all products of one product identifier  # noqa: E501

        Returns a list of all products of a product identifier that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array. Parameters supporting translation: ```name, description```. To get a translation set the ```Accept-Language``` header. Possible include values: ```status, tenant, parent, manufacturer, pictures, specifications, specifications[key1,key2], categories, categories.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products_of_product_identifier(product_identifier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int product_identifier_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str product_code: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: ProductsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_products_of_product_identifier_with_http_info(product_identifier_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_products_of_product_identifier_with_http_info(product_identifier_id, **kwargs)  # noqa: E501
            return data

    def get_products_of_product_identifier_with_http_info(self, product_identifier_id, **kwargs):  # noqa: E501
        """Get all products of one product identifier  # noqa: E501

        Returns a list of all products of a product identifier that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array. Parameters supporting translation: ```name, description```. To get a translation set the ```Accept-Language``` header. Possible include values: ```status, tenant, parent, manufacturer, pictures, specifications, specifications[key1,key2], categories, categories.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products_of_product_identifier_with_http_info(product_identifier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int product_identifier_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str product_code: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: ProductsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_identifier_id', 'page', 'per_page', 'include', 'product_code', 'name', 'manufacturer_id', 'status_id', 'category_id', 'parent_id', 'tenant_id', 'specifications_key', 'specifications_value', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_products_of_product_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_identifier_id' is set
        if ('product_identifier_id' not in params or
                params['product_identifier_id'] is None):
            raise ValueError("Missing the required parameter `product_identifier_id` when calling `get_products_of_product_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_identifier_id' in params:
            path_params['product_identifier_id'] = params['product_identifier_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'product_code' in params:
            query_params.append(('product_code', params['product_code']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers/{product_identifier_id}/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_product_identifier_from_product(self, body, product_id, **kwargs):  # noqa: E501
        """Remove product identifiers from a product  # noqa: E501

        Remove one or more product identifiers from an product. If the product identifier has no more related products, the product identifier will be deleted. To delete a product identifier of a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_product_identifier_from_product(body, product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifiers body: Resources that shall be removed. (required)
        :param int product_id: Id of the product from which the product identifiers will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_product_identifier_from_product_with_http_info(body, product_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_product_identifier_from_product_with_http_info(body, product_id, **kwargs)  # noqa: E501
            return data

    def remove_product_identifier_from_product_with_http_info(self, body, product_id, **kwargs):  # noqa: E501
        """Remove product identifiers from a product  # noqa: E501

        Remove one or more product identifiers from an product. If the product identifier has no more related products, the product identifier will be deleted. To delete a product identifier of a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_product_identifier_from_product_with_http_info(body, product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifiers body: Resources that shall be removed. (required)
        :param int product_id: Id of the product from which the product identifiers will removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_product_identifier_from_product" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_product_identifier_from_product`")  # noqa: E501
        # verify the required parameter 'product_id' is set
        if ('product_id' not in params or
                params['product_id'] is None):
            raise ValueError("Missing the required parameter `product_id` when calling `remove_product_identifier_from_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_id' in params:
            path_params['product_id'] = params['product_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/products/{product_id}/identifiers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_products_from_product_identifier(self, body, product_identifier_id, **kwargs):  # noqa: E501
        """Remove products from a product identifier  # noqa: E501

        Remove one or more products from a product identifier. If the product identifier has no more related products, the product identifier will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_products_from_product_identifier(body, product_identifier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be removed. (required)
        :param int product_identifier_id: Id of the product identifier from which the products will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_products_from_product_identifier_with_http_info(body, product_identifier_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_products_from_product_identifier_with_http_info(body, product_identifier_id, **kwargs)  # noqa: E501
            return data

    def remove_products_from_product_identifier_with_http_info(self, body, product_identifier_id, **kwargs):  # noqa: E501
        """Remove products from a product identifier  # noqa: E501

        Remove one or more products from a product identifier. If the product identifier has no more related products, the product identifier will be deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_products_from_product_identifier_with_http_info(body, product_identifier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be removed. (required)
        :param int product_identifier_id: Id of the product identifier from which the products will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_identifier_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_products_from_product_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_products_from_product_identifier`")  # noqa: E501
        # verify the required parameter 'product_identifier_id' is set
        if ('product_identifier_id' not in params or
                params['product_identifier_id'] is None):
            raise ValueError("Missing the required parameter `product_identifier_id` when calling `remove_products_from_product_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_identifier_id' in params:
            path_params['product_identifier_id'] = params['product_identifier_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers/{product_identifier_id}/products', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_product_identifier(self, body, id, **kwargs):  # noqa: E501
        """Update a product identifier  # noqa: E501

        Update accessible parameters of the requested resource. To update a product identifier for a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_identifier(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifierRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the product identifier to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_product_identifier_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_product_identifier_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_product_identifier_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a product identifier  # noqa: E501

        Update accessible parameters of the requested resource. To update a product identifier for a product you need the tenant admin role on the products tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_identifier_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIdentifierRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the product identifier to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_product_identifier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_product_identifier`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_product_identifier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/product/identifiers/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
