# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class HealthConditionCauseApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_health_condition_cause(self, body, health_condition_id, **kwargs):  # noqa: E501
        """Create a health condition cause  # noqa: E501

        Cause must have a code and at least one health condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_health_condition_cause(body, health_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthConditionCauseRequest body: Parameters that shall be updated. (required)
        :param int health_condition_id: The resource defined in the URL (required)
        :return: HealthConditionCauseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_health_condition_cause_with_http_info(body, health_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_health_condition_cause_with_http_info(body, health_condition_id, **kwargs)  # noqa: E501
            return data

    def create_health_condition_cause_with_http_info(self, body, health_condition_id, **kwargs):  # noqa: E501
        """Create a health condition cause  # noqa: E501

        Cause must have a code and at least one health condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_health_condition_cause_with_http_info(body, health_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthConditionCauseRequest body: Parameters that shall be updated. (required)
        :param int health_condition_id: The resource defined in the URL (required)
        :return: HealthConditionCauseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'health_condition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_health_condition_cause" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_health_condition_cause`")  # noqa: E501
        # verify the required parameter 'health_condition_id' is set
        if ('health_condition_id' not in params or
                params['health_condition_id'] is None):
            raise ValueError("Missing the required parameter `health_condition_id` when calling `create_health_condition_cause`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'health_condition_id' in params:
            path_params['health_condition_id'] = params['health_condition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/health_conditions/{health_condition_id}/causes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthConditionCauseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cause(self, health_condition_id, id, **kwargs):  # noqa: E501
        """Delete a health condition cause  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cause(health_condition_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int health_condition_id: The resource defined in the URL (required)
        :param int id: Id of the cause to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cause_with_http_info(health_condition_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cause_with_http_info(health_condition_id, id, **kwargs)  # noqa: E501
            return data

    def delete_cause_with_http_info(self, health_condition_id, id, **kwargs):  # noqa: E501
        """Delete a health condition cause  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cause_with_http_info(health_condition_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int health_condition_id: The resource defined in the URL (required)
        :param int id: Id of the cause to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['health_condition_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cause" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'health_condition_id' is set
        if ('health_condition_id' not in params or
                params['health_condition_id'] is None):
            raise ValueError("Missing the required parameter `health_condition_id` when calling `delete_cause`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_cause`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'health_condition_id' in params:
            path_params['health_condition_id'] = params['health_condition_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/health_conditions/{health_condition_id}/causes/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_health_condition_cause_by_id(self, health_condition_id, id, **kwargs):  # noqa: E501
        """Get a single health condition cause  # noqa: E501

        Get a specific cause identified by the id in the URL. Possible include value: ``remedies``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_health_condition_cause_by_id(health_condition_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int health_condition_id: The resource defined in the URL (required)
        :param int id: Id of the cause to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: HealthConditionCauseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_health_condition_cause_by_id_with_http_info(health_condition_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_health_condition_cause_by_id_with_http_info(health_condition_id, id, **kwargs)  # noqa: E501
            return data

    def get_health_condition_cause_by_id_with_http_info(self, health_condition_id, id, **kwargs):  # noqa: E501
        """Get a single health condition cause  # noqa: E501

        Get a specific cause identified by the id in the URL. Possible include value: ``remedies``  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_health_condition_cause_by_id_with_http_info(health_condition_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int health_condition_id: The resource defined in the URL (required)
        :param int id: Id of the cause to fetch (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: HealthConditionCauseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['health_condition_id', 'id', 'include', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_health_condition_cause_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'health_condition_id' is set
        if ('health_condition_id' not in params or
                params['health_condition_id'] is None):
            raise ValueError("Missing the required parameter `health_condition_id` when calling `get_health_condition_cause_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_health_condition_cause_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'health_condition_id' in params:
            path_params['health_condition_id'] = params['health_condition_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/health_conditions/{health_condition_id}/causes/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthConditionCauseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_health_condition_causes(self, health_condition_id, **kwargs):  # noqa: E501
        """Get all causes of a health condition  # noqa: E501

        Returns a list of causes of a health condition. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_health_condition_causes(health_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int health_condition_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str code: Filter accepts `*` as wildcard
        :param str description: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `code`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: Causes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_health_condition_causes_with_http_info(health_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_health_condition_causes_with_http_info(health_condition_id, **kwargs)  # noqa: E501
            return data

    def get_health_condition_causes_with_http_info(self, health_condition_id, **kwargs):  # noqa: E501
        """Get all causes of a health condition  # noqa: E501

        Returns a list of causes of a health condition. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_health_condition_causes_with_http_info(health_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int health_condition_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str code: Filter accepts `*` as wildcard
        :param str description: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `code`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: Causes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['health_condition_id', 'page', 'per_page', 'code', 'description', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_health_condition_causes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'health_condition_id' is set
        if ('health_condition_id' not in params or
                params['health_condition_id'] is None):
            raise ValueError("Missing the required parameter `health_condition_id` when calling `get_health_condition_causes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'health_condition_id' in params:
            path_params['health_condition_id'] = params['health_condition_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/health_conditions/{health_condition_id}/causes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Causes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_health_condition_cause(self, body, health_condition_id, id, **kwargs):  # noqa: E501
        """Update a health condition cause  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_health_condition_cause(body, health_condition_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthConditionCauseRequest body: Parameters that shall be updated. (required)
        :param int health_condition_id: The resource defined in the URL (required)
        :param int id: Id of the cause to update (required)
        :param str content_language: language of the content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_health_condition_cause_with_http_info(body, health_condition_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_health_condition_cause_with_http_info(body, health_condition_id, id, **kwargs)  # noqa: E501
            return data

    def update_health_condition_cause_with_http_info(self, body, health_condition_id, id, **kwargs):  # noqa: E501
        """Update a health condition cause  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_health_condition_cause_with_http_info(body, health_condition_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthConditionCauseRequest body: Parameters that shall be updated. (required)
        :param int health_condition_id: The resource defined in the URL (required)
        :param int id: Id of the cause to update (required)
        :param str content_language: language of the content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'health_condition_id', 'id', 'content_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_health_condition_cause" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_health_condition_cause`")  # noqa: E501
        # verify the required parameter 'health_condition_id' is set
        if ('health_condition_id' not in params or
                params['health_condition_id'] is None):
            raise ValueError("Missing the required parameter `health_condition_id` when calling `update_health_condition_cause`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_health_condition_cause`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'health_condition_id' in params:
            path_params['health_condition_id'] = params['health_condition_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'content_language' in params:
            header_params['Content-Language'] = params['content_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/health_conditions/{health_condition_id}/causes/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
