# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class BillOfMaterialApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_documents_to_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Add documents to a bill of material  # noqa: E501

        Add one or more documents to a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int bill_of_material_id: Id of the bill of material to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Add documents to a bill of material  # noqa: E501

        Add one or more documents to a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int bill_of_material_id: Id of the bill of material to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `add_documents_to_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_instrumentations_to_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Add instrumentations to a bill of material  # noqa: E501

        Add one or more instrumentations to a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentations_to_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be added. (required)
        :param int bill_of_material_id: Id of the bill of material to which the instrumentations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_instrumentations_to_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_instrumentations_to_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def add_instrumentations_to_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Add instrumentations to a bill of material  # noqa: E501

        Add one or more instrumentations to a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_instrumentations_to_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be added. (required)
        :param int bill_of_material_id: Id of the bill of material to which the instrumentations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_instrumentations_to_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_instrumentations_to_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `add_instrumentations_to_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/instrumentations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_request_for_quotations_to_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Add request for quotations to a bill of material  # noqa: E501

        Add one or more request for quotations to a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_request_for_quotations_to_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationIDs body: Resources that shall be added. (required)
        :param int bill_of_material_id: Id of the bill of material to which the request for quotations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_request_for_quotations_to_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_request_for_quotations_to_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def add_request_for_quotations_to_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Add request for quotations to a bill of material  # noqa: E501

        Add one or more request for quotations to a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_request_for_quotations_to_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationIDs body: Resources that shall be added. (required)
        :param int bill_of_material_id: Id of the bill of material to which the request for quotations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_request_for_quotations_to_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_request_for_quotations_to_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `add_request_for_quotations_to_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/request_for_quotations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_bill_of_material(self, body, **kwargs):  # noqa: E501
        """Create a new bill of material  # noqa: E501

        Create a new bill of material  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bill_of_material(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialRequest body: Object body that will be created. (required)
        :return: BillOfMaterialResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bill_of_material_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bill_of_material_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_bill_of_material_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new bill of material  # noqa: E501

        Create a new bill of material  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bill_of_material_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialRequest body: Object body that will be created. (required)
        :return: BillOfMaterialResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillOfMaterialResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bill_of_material(self, id, **kwargs):  # noqa: E501
        """Delete a bill of material  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bill_of_material(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the bill of material to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bill_of_material_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bill_of_material_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_bill_of_material_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a bill of material  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bill_of_material_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the bill of material to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bill_of_material_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single bill of material  # noqa: E501

        Get a specific bill of material identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_material_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the bill of material to fetch (required)
        :return: BillOfMaterialResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bill_of_material_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bill_of_material_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_bill_of_material_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single bill of material  # noqa: E501

        Get a specific bill of material identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_material_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the bill of material to fetch (required)
        :return: BillOfMaterialResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bill_of_material_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_bill_of_material_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillOfMaterialResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bill_of_materials(self, **kwargs):  # noqa: E501
        """Get a range of bill of materials  # noqa: E501

        Returns a list of bill of materials. If the query has no matches, the response is an empty list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_materials(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str author: Filter accepts `*` as wildcard
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: BillOfMaterialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bill_of_materials_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_bill_of_materials_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_bill_of_materials_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of bill of materials  # noqa: E501

        Returns a list of bill of materials. If the query has no matches, the response is an empty list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_materials_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str author: Filter accepts `*` as wildcard
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: BillOfMaterialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'name', 'author', '_date', 'date_from', 'date_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bill_of_materials" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillOfMaterialsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_bill_of_material(self, bill_of_material_id, **kwargs):  # noqa: E501
        """Get all documents of a bill of material  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_bill_of_material(bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bill_of_material_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_bill_of_material_with_http_info(bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_bill_of_material_with_http_info(bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_bill_of_material_with_http_info(self, bill_of_material_id, **kwargs):  # noqa: E501
        """Get all documents of a bill of material  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list.  Possible include values: ```status, tenant, classification, categories, categories.parent, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_bill_of_material_with_http_info(bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bill_of_material_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bill_of_material_id', 'page', 'per_page', 'include', 'name', 'document_version', 'number', 'status_id', 'classification_id', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `get_documents_of_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentations_of_bill_of_material(self, bill_of_material_id, **kwargs):  # noqa: E501
        """Get all instrumentations of a bill of material  # noqa: E501

        Returns a list of all instrumentations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_bill_of_material(bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bill_of_material_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentations_of_bill_of_material_with_http_info(bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentations_of_bill_of_material_with_http_info(bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentations_of_bill_of_material_with_http_info(self, bill_of_material_id, **kwargs):  # noqa: E501
        """Get all instrumentations of a bill of material  # noqa: E501

        Returns a list of all instrumentations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  Possible include values: ```specifications, specifications[key1,key2], pictures, tenant, parent, status, type```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentations_of_bill_of_material_with_http_info(bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bill_of_material_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str tag: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str type_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str specifications_key: Filter accepts `*` as wildcard (if used as single specifications filter), supports comma list of keys in connection with specifications_value filter
        :param str specifications_value: Filter accepts `*` as wildcard, supports comma list of values in connection with specifications_key filter. Does not work for vectors
        :param str criticality: Filter accepts undefined, low, medium or high
        :param str accessibility: Filter accepts undefined, easy, moderate or difficult
        :param str asset_status_id: One or multiple ids (comma list). Expected id format is integer. This retrieves all Instrumentations where at least one of its assets has one of the given statuses.
        :param str permission: Filter by permission of current user. Accepts `can_permit`, `can_delete`, `can_update`, `can_read` (default)
        :param str order_by: Order result by attribute value, accepts `id`, `tag`, `created_at` or `updated_at`, add `-` as a prefix for descending order. Default value is `id`
        :return: InstrumentationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bill_of_material_id', 'page', 'per_page', 'include', 'tag', 'status_id', 'type_id', 'parent_id', 'tenant_id', 'specifications_key', 'specifications_value', 'criticality', 'accessibility', 'asset_status_id', 'permission', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentations_of_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `get_instrumentations_of_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'type_id' in params:
            query_params.append(('type_id', params['type_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'specifications_key' in params:
            query_params.append(('specifications_key', params['specifications_key']))  # noqa: E501
        if 'specifications_value' in params:
            query_params.append(('specifications_value', params['specifications_value']))  # noqa: E501
        if 'criticality' in params:
            query_params.append(('criticality', params['criticality']))  # noqa: E501
        if 'accessibility' in params:
            query_params.append(('accessibility', params['accessibility']))  # noqa: E501
        if 'asset_status_id' in params:
            query_params.append(('asset_status_id', params['asset_status_id']))  # noqa: E501
        if 'permission' in params:
            query_params.append(('permission', params['permission']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/instrumentations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstrumentationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_request_for_quotations_of_bill_of_material(self, bill_of_material_id, **kwargs):  # noqa: E501
        """Get all request for quotations of a bill of material  # noqa: E501

        Returns a list of all request for quotations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotations_of_bill_of_material(bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bill_of_material_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str author: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: RequestForQuotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_request_for_quotations_of_bill_of_material_with_http_info(bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_request_for_quotations_of_bill_of_material_with_http_info(bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def get_request_for_quotations_of_bill_of_material_with_http_info(self, bill_of_material_id, **kwargs):  # noqa: E501
        """Get all request for quotations of a bill of material  # noqa: E501

        Returns a list of all request for quotations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotations_of_bill_of_material_with_http_info(bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bill_of_material_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str author: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: RequestForQuotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bill_of_material_id', 'page', 'per_page', 'name', 'number', 'status_id', '_date', 'date_from', 'date_to', 'sender_id', 'receiver_id', 'author', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_request_for_quotations_of_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `get_request_for_quotations_of_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/request_for_quotations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RequestForQuotationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_documents_from_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Remove documents from a bill of material  # noqa: E501

        Remove one or more documents from a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int bill_of_material_id: Id of the bill of material from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_documents_from_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_documents_from_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def remove_documents_from_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Remove documents from a bill of material  # noqa: E501

        Remove one or more documents from a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int bill_of_material_id: Id of the bill of material from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_documents_from_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_documents_from_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `remove_documents_from_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_instrumentations_from_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Remove instrumentations from a bill of material  # noqa: E501

        Remove one or more instrumentations from a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_from_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int bill_of_material_id: Id of the bill of material from which the instrumentations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_instrumentations_from_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_instrumentations_from_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def remove_instrumentations_from_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Remove instrumentations from a bill of material  # noqa: E501

        Remove one or more instrumentations from a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_instrumentations_from_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be removed. (required)
        :param int bill_of_material_id: Id of the bill of material from which the instrumentations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_instrumentations_from_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_instrumentations_from_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `remove_instrumentations_from_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/instrumentations', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_request_for_quotations_of_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Remove request for quotations from a bill of material  # noqa: E501

        Remove one or more request for quotations from a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_request_for_quotations_of_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationIDs body: Resources that shall be removed. (required)
        :param int bill_of_material_id: Id of the bill of material from which the request for quotations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_request_for_quotations_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_request_for_quotations_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def remove_request_for_quotations_of_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Remove request for quotations from a bill of material  # noqa: E501

        Remove one or more request for quotations from a bill of material.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_request_for_quotations_of_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationIDs body: Resources that shall be removed. (required)
        :param int bill_of_material_id: Id of the bill of material from which the request for quotations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_request_for_quotations_of_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_request_for_quotations_of_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `remove_request_for_quotations_of_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/request_for_quotations', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Replace the documents of a bill of material  # noqa: E501

        Replaces all documents belonging to a bill of material. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int bill_of_material_id: Id of the bill of material of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Replace the documents of a bill of material  # noqa: E501

        Replaces all documents belonging to a bill of material. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int bill_of_material_id: Id of the bill of material of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `replace_documents_of_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_instrumentations_of_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Replace the instrumentations of a bill of material  # noqa: E501

        Replaces all instrumentations belonging to a bill of material. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_instrumentations_of_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be replaced (required)
        :param int bill_of_material_id: Id of the bill of material of which the instrumentations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_instrumentations_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_instrumentations_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def replace_instrumentations_of_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Replace the instrumentations of a bill of material  # noqa: E501

        Replaces all instrumentations belonging to a bill of material. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_instrumentations_of_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InstrumentationIDs body: Resources that shall be replaced (required)
        :param int bill_of_material_id: Id of the bill of material of which the instrumentations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_instrumentations_of_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_instrumentations_of_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `replace_instrumentations_of_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/instrumentations', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_request_for_quotations_of_bill_of_material(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Replace the request for quotations of a bill of material  # noqa: E501

        Replaces all request for quotations belonging to a bill of material. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_request_for_quotations_of_bill_of_material(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationIDs body: Resources that shall be replaced (required)
        :param int bill_of_material_id: Id of the bill of material of which the request for quotations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_request_for_quotations_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_request_for_quotations_of_bill_of_material_with_http_info(body, bill_of_material_id, **kwargs)  # noqa: E501
            return data

    def replace_request_for_quotations_of_bill_of_material_with_http_info(self, body, bill_of_material_id, **kwargs):  # noqa: E501
        """Replace the request for quotations of a bill of material  # noqa: E501

        Replaces all request for quotations belonging to a bill of material. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_request_for_quotations_of_bill_of_material_with_http_info(body, bill_of_material_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationIDs body: Resources that shall be replaced (required)
        :param int bill_of_material_id: Id of the bill of material of which the request for quotations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bill_of_material_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_request_for_quotations_of_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_request_for_quotations_of_bill_of_material`")  # noqa: E501
        # verify the required parameter 'bill_of_material_id' is set
        if ('bill_of_material_id' not in params or
                params['bill_of_material_id'] is None):
            raise ValueError("Missing the required parameter `bill_of_material_id` when calling `replace_request_for_quotations_of_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bill_of_material_id' in params:
            path_params['bill_of_material_id'] = params['bill_of_material_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{bill_of_material_id}/request_for_quotations', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bill_of_material(self, body, id, **kwargs):  # noqa: E501
        """Update a bill of material  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bill_of_material(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the bill of material to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bill_of_material_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bill_of_material_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_bill_of_material_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a bill of material  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bill_of_material_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the bill of material to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bill_of_material" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_bill_of_material`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_bill_of_material`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/bill_of_materials/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
