#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by TatSu.
#
#    https://pypi.python.org/pypi/tatsu/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals

import sys

from tatsu.buffering import Buffer
from tatsu.parsing import Parser
from tatsu.parsing import tatsumasu, leftrec, nomemo
from tatsu.parsing import leftrec, nomemo  # noqa
from tatsu.util import re, generic_main  # noqa


KEYWORDS = {}  # type: ignore


class contentlineBuffer(Buffer):
    def __init__(
        self,
        text,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=None,
        namechars='',
        **kwargs
    ):
        super(contentlineBuffer, self).__init__(
            text,
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,
            namechars=namechars,
            **kwargs
        )


class contentlineParser(Parser):
    def __init__(
        self,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=None,
        left_recursion=False,
        parseinfo=True,
        keywords=None,
        namechars='',
        buffer_class=contentlineBuffer,
        **kwargs
    ):
        if keywords is None:
            keywords = KEYWORDS
        super(contentlineParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,
            left_recursion=left_recursion,
            parseinfo=parseinfo,
            keywords=keywords,
            namechars=namechars,
            buffer_class=buffer_class,
            **kwargs
        )

    @tatsumasu()
    def _start_(self):  # noqa
        self._contentline_()
        self.name_last_node('@')
        self._check_eof()

    @tatsumasu()
    def _full_(self):  # noqa
        self._contentline_()
        self.add_last_node_to_name('@')

        def block1():
            self._pattern('(\\r?\\n)+')
            self._contentline_()
            self.add_last_node_to_name('@')
        self._positive_closure(block1)
        self._pattern('(\\r?\\n)*')
        self._check_eof()

    @tatsumasu()
    def _contentline_(self):  # noqa
        self._ALPHADIGIT_MINUS_PLUS_()
        self.name_last_node('name')

        def block1():
            self._token(';')
            self._param_()
            self.add_last_node_to_name('params')
        self._closure(block1)
        self._token(':')
        self._VALUE_CHAR_STAR_()
        self.name_last_node('value')
        self.ast._define(
            ['name', 'value'],
            ['params']
        )

    @tatsumasu()
    def _param_(self):  # noqa
        self._ALPHADIGIT_MINUS_PLUS_()
        self.name_last_node('name')
        self._token('=')
        self._param_value_()
        self.add_last_node_to_name('values')

        def block2():
            self._token(',')
            self._param_value_()
            self.add_last_node_to_name('values')
        self._closure(block2)
        self.ast._define(
            ['name'],
            ['values']
        )

    @tatsumasu()
    def _param_value_(self):  # noqa
        with self._choice():
            with self._option():
                self._DQUOTE_()
                self._cut()
                self._QSAFE_CHAR_STAR_()
                self.name_last_node('value')
                self._DQUOTE_()
                self._constant('true')
                self.name_last_node('quoted')
            with self._option():
                self._SAFE_CHAR_STAR_()
                self.name_last_node('value')
                self._constant('false')
                self.name_last_node('quoted')
            self._error('no available options')
        self.ast._define(
            ['quoted', 'value'],
            []
        )

    @tatsumasu()
    def _ALPHADIGIT_MINUS_PLUS_(self):  # noqa
        self._pattern('[a-zA-Z0-9-]+')

    @tatsumasu()
    def _QSAFE_CHAR_STAR_(self):  # noqa
        self._pattern('[^\\x00-\\x08\\x0A-\\x1F\\x22\\x7F]*')

    @tatsumasu()
    def _SAFE_CHAR_STAR_(self):  # noqa
        self._pattern('[^\\x00-\\x08\\x0A-\\x1F\\x22\\x2C\\x3A\\x3B\\x7F]*')

    @tatsumasu()
    def _VALUE_CHAR_STAR_(self):  # noqa
        self._pattern('[^\\x00-\\x08\\x0A-\\x1F\\x7F]*')

    @tatsumasu()
    def _DQUOTE_(self):  # noqa
        self._token('"')


class contentlineSemantics(object):
    def start(self, ast):  # noqa
        return ast

    def full(self, ast):  # noqa
        return ast

    def contentline(self, ast):  # noqa
        return ast

    def param(self, ast):  # noqa
        return ast

    def param_value(self, ast):  # noqa
        return ast

    def ALPHADIGIT_MINUS_PLUS(self, ast):  # noqa
        return ast

    def QSAFE_CHAR_STAR(self, ast):  # noqa
        return ast

    def SAFE_CHAR_STAR(self, ast):  # noqa
        return ast

    def VALUE_CHAR_STAR(self, ast):  # noqa
        return ast

    def DQUOTE(self, ast):  # noqa
        return ast


def main(filename, start=None, **kwargs):
    if start is None:
        start = 'start'
    if not filename or filename == '-':
        text = sys.stdin.read()
    else:
        with open(filename) as f:
            text = f.read()
    parser = contentlineParser()
    return parser.parse(text, rule_name=start, filename=filename, **kwargs)


if __name__ == '__main__':
    import json
    from tatsu.util import asjson

    ast = generic_main(main, contentlineParser, name='contentline')
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(asjson(ast), indent=2))
    print()
