"""
General aviation report glossary
"""

# Initial reference:
# https://www.redimec.com.ar/contenido/productos/pdf/1421905575_1.pdf

# Duplicate enitries prioritized for METAR
METAR = {"BR": "Mist", "SS": "Sandstorm"}

# Regional locations. Some duplicates
NA_REGIONAL = {
    "AK": "Alaska",
    "AL": "Alabama",
    "ADRNDCK": "Adirondack",
    "ALGHNY": "Allegheny",
    "ALTA": "Alberta",
    "ALUTN": "Aleutian",
    "APLCN": "Appalachian",
    "APLCNS": "Appalachians",
    "AR": "Arkansas",
    "AZ": "Arizona",
    "BAJA": "Baja, California",
    "BC": "British Columbia",
    "BDA": "Bermuda",
    "BLKHLS": "Black Hills",
    "BOOTHEEL": "Bootheel",
    "BRKSHR": "Berkshire",
    "BRKSHRS": "Berkshires",
    "CA": "California",
    "CARIB": "Caribbean",
    "CASCDS": "Cascades",
    "CHSPK": "Chesapeake",
    "CNDN": "Canadian",
    "CO": "Colorado",
    "CONUS": "Continental U.S.",
    "DC": "District of Columbia",
    "DE": "Delaware",
    "DELMARVA": "Delaware-Maryland-Virginia",
    "DKTS": "Dakotas",
    "FL": "Florida",
    "GA": "Georgia",
    "GRTLKS": "Great Lakes",
    "HDSVLY": "Hudson Valley",
    "IA": "Iowa",
    "ID": "Idaho",
    "IL": "Illinois",
    "KS": "Kansas",
    "KY": "Kentucky",
    "LA": "Louisiana",
    "LABRDR": "Labrador",
    "MA": "Massachusetts",
    "MAN": "Manitoba",
    "MD": "Maryland",
    "ME": "Maine",
    "MEX": "Mexico",
    "MHKVLY": "Mohawk Valley",
    "MI": "Michigan",
    "MN": "Minnesota",
    "MO": "Missouri",
    "MS": "Mississippi",
    "MT": "Montana",
    "NB": "New Brunswick",
    "NC": "North Carolina",
    "ND": "North Dakota",
    "NEB": "Nebraska",
    "NEW ENG": "New England",
    "NFLD": "Newfoundland",
    "NH": "New Hampshire",
    "NJ": "New Jersey",
    "NM": "New Mexico",
    "NS": "Nova Scotia",
    "NV": "Nevada",
    "NY": "New York",
    "OH": "Ohio",
    "OK": "Oklahoma",
    "OR": "Oregon",
    "PA": "Pennsylvania",
    "PGTSND": "Puget Sound",
    "PUGET": "Puget Sound",
    "QUE": "Quebec",
    "RCKYS": "Rockies",
    "RI": "Rhode Island",
    "RIOGD": "Rio Grande",
    "SASK": "Saskatchewan",
    "SC": "South Carolina",
    "SD": "South Dakota",
    "SIERNEV": "Sierra Nevada",
    "SPLNS": "Southern Plains",
    "TN": "Tennessee",
    "TX": "Texas",
    "UT": "Utah",
    "VA": "Virginia",
    "VRISL": "Vancouver Island, BC",
    "VT": "Vermont",
    "WA": "Washington",
    "WI": "Wisconsin",
    "WPLTO": "Western Plateau",
    "WSTCH": "Wasatch Range",
    "WV": "West Virginia",
    "WY": "Wyoming",
    "YKN": "Yukon",
    "YLSTN": "Yellowstone",
}

GLOBAL = {
    "ABNDT": "Abundant",
    "ABNML": "Abnormal",
    "ABT": "About",
    "ABV": "Above",
    "AC": "Convective outlook or altocumulus",
    "ACC": "Altocumulus castellanus clouds",
    "ACCAS": "Altocumulus castellanus clouds",
    "ACCUM": "Accumulate",
    "ACFT": "Aircraft",
    "ACFT MSHP": "Aircraft Mishap",
    "ACLT": "Accelerate",
    "ACLTD": "Accelerated",
    "ACLTG": "Accelerating",
    "ACLTS": "Accelerates",
    "ACPY": "Accompany",
    "ACRS": "Across",
    "ACSL": "Altocumulus standing lenticular",
    "ACTV": "Active",
    "ACTVTY": "Activity",
    "ACYC": "Anticyclone",
    "ADJ": "Adjacent",
    "ADL": "Additional",
    "ADQT": "Adequate",
    "ADQTLY": "Adequately",
    "ADVCT": "Advect",
    "ADVCTD": "Advected",
    "ADVCTG": "Advecting",
    "ADVCTN": "Advection",
    "ADVCTS": "Advects",
    "ADVN": "Advance",
    "ADVNG": "Advancing",
    "ADVY": "Advisory",
    "ADVYS": "Advisories",
    "AFCT": "Affect",
    "AFCTD": "Affected",
    "AFCTG": "Affecting",
    "AFDK": "After dark",
    "AFOS": "Automated Field Operations System",
    "AFSS": "Automated Flight Service Station",
    "AFT": "After",
    "AFTN": "Afternoon",
    "AGL": "Above ground level",
    "AGN": "Again",
    "AGRD Agreed": "Agreed",
    "AGRMT Agreement": "Agreement",
    "AGRS Agrees": "Agrees",
    "AHD Ahead": "Ahead",
    "AIRMET": "Airman's Meteorological Information",
    "ALF": "Aloft",
    "ALG": "Along",
    "ALP": "Airport Location Point",
    "ALQDS": "All quadrants",
    "ALSTG": "Altimeter setting",
    "ALT": "Altitude",
    "ALTHO": "Although",
    "ALTM": "Altimeter",
    "AMD": "Amend",
    "AMDD": "Amended",
    "AMDG": "Amending",
    "AMDT": "Amendment",
    "AMP": "Amplify",
    "AMPG": "Amplifying",
    "AMPLTD": "Amplitude",
    "AMS": "Air mass",
    "AMT": "Amount",
    "ANLYS": "Analysis",
    "ANS": "Answer",
    "AO1": "Automated Reporting Station",
    "AO2": "Automated Reporting Station",
    "AOA": "At or above",
    "AOB": "At or below",
    "AP": "Anomalous Propagation",
    "APCH": "Approach",
    "APCHG": "Approaching",
    "APCHS": "Approaches",
    "APPR": "Appear",
    "APPRG": "Appearing",
    "APPRS": "Appears",
    "APRNT": "Apparent",
    "APRNTLY": "Apparently",
    "APRX": "Approximate",
    "APRXLY": "Approximately",
    "ARL": "Air Resources Lab",
    "ARND": "Around",
    "ARPT": "Airport",
    "ASAP": "As soon as possible",
    "ASL": "Above Sea Level",
    "ASMD": "As Amended",
    "ASOS": "Automated Surface Observing System",
    "ASSOCD": "Associated",
    "ASSOCN": "Association",
    "ATCT": "Air Traffic Control Tower",
    "ATLC": "Atlantic",
    "ATTM": "At this time",
    "ATTN": "Attention",
    "AUTO": "Automated report",
    "AVBL": "Available",
    "AVG": "Average",
    "AVN": "Aviation model",
    "AWC": "Aviation Weather Center",
    "AWIPS": "Advanced Interactive Weather Processing System",
    "AWOS": "Automated Weather Observing system",
    "AWT": "Awaiting",
    "AWW": "Alert Weather Watch",
    "AZM": "Azimuth",
    "B": "Began",
    "BACLIN": "Baroclinic",
    "BATROP": "Barotropic",
    "BC": "Patches",
    "BCFG": "Patchy fog",
    "BCH": "Beach",
    "BCKG": "Backing",
    "BCM": "Become",
    "BCMG": "Becoming",
    "BCMS": "Becomes",
    "BD": "Blowing dust",
    "BDRY": "Boundary",
    "BECMG": "Becoming",
    "BFDK": "Before dark",
    "BFR": "Before",
    "BGN": "Begin",
    "BGNG": "Beginning",
    "BGNS": "Begins",
    "BHND": "Behind",
    "BINOVC": "Breaks in overcast",
    "BKN": "Broken",
    "BL": "Blowing",
    "BLD": "Build",
    "BLDG": "Building",
    "BLDS": "Builds",
    "BLDUP": "Buildup",
    "BLKT": "Blanket",
    "BLKTG": "Blanketing",
    "BLKTS": "Blankets",
    "BLO": "Below or below clouds",
    "BLW": "Below",
    "BLZD": "Blizzard",
    "BN": "Blowing sand",
    "BND": "Bound",
    "BNDRY": "Boundary",
    "BNDRYS": "Boundaries",
    "BNTH": "Beneath",
    "BR": "Branch",
    "BRF": "Brief",
    "BRG": "Branching",
    "BRK": "Break",
    "BRKG": "Breaking",
    "BRKHIC": "Breaks in higher clouds",
    "BRKS": "Breaks",
    "BRM": "Barometer",
    "BRN": "Bulk Richardson Number",
    "BRS": "Branches",
    "BS": "Blowing snow",
    "BTWN": "Between",
    "BWER": "Bounded weak echo region",
    "BYD": "Beyond",
    "C": "Celsius",
    "CA": "Cloud-to-air lightning",
    "CAA": "Cold air advection",
    "CAPE": "Convective available potential energy",
    "CAS": "Committee for Aviation Services",
    "CAT": "Clear air turbulence",
    "CAVOK": "Ceiling and visibility OK",
    "CAVU": "Ceiling and visibility unlimited",
    "CB": "Cumulonimbus",
    "CBMAM": "Cumulonimbus Mammatus clouds",
    "CC": "Cirrocumulus",
    "CCL": "Convective condensation level",
    "CCLDS": "Clear of clouds",
    "CCLKWS": "Counterclockwise",
    "CCSL": "Cirrocumulus standing lenticular",
    "CDFNT": "Cold front",
    "CDFNTL": "Cold frontal",
    "CFP": "Cold front passage",
    "CG": "Cloud-to-ground lightning",
    "CHC": "Chance",
    "CHCS": "Chances",
    "CHG": "Change",
    "CHGD": "Changed",
    "CHGG": "Changing",
    "CHGS": "Changes",
    "CHI": "Cloud-Height indicator",
    "CHINO": "Sky condition at secondary location not available",
    "CHOP": "Choppy turbulence",
    "CI": "Cirrus",
    "CIG": "Ceiling",
    "CIGS": "Ceilings",
    "CIN": "Convective inhibition",
    "CLD": "Cloud",
    "CLDNS": "Cloudiness",
    "CLDS": "Clouds",
    "CLKWS": "Clockwise",
    "CLR": "Clear",
    "CLRG": "Clearing",
    "CLRS": "Clears",
    "CMPLX": "Complex",
    "CNCL": "Cancel",
    "CNCLD": "Canceled",
    "CNCLG": "Canceling",
    "CNCLS": "Cancels",
    "CNTR": "Center",
    "CNTRD": "Centered",
    "CNTRL": "Central",
    "CNTRLN": "Centerline",
    "CNTRS": "Centers",
    "CNTY": "County",
    "CNTYS": "Counties",
    "CNVG": "Converge",
    "CNVGG": "Converging",
    "CNVGNC": "Convergence",
    "CNVTN": "Convection",
    "CNVTV": "Convective",
    "CNVTVLY": "Convectively",
    "COMPAR": "Compare",
    "COMPARD": "Compared",
    "COMPARG": "Comparing",
    "COMPARS": "Compares",
    "COMPR": "Compare",
    "COMPRD": "Compared",
    "COMPRG": "Comparing",
    "COMPRS": "Compares",
    "COND": "Condition",
    "CONFDC": "Confidence",
    "CONS": "Continuous",
    "CONT": "Continue",
    "CONTD": "Continued",
    "CONTDVD": "Continental Divide",
    "CONTG": "Continuing",
    "CONTLY": "Continually",
    "CONTRAILS": "Condensation trails",
    "CONTS": "Continues",
    "COORD": "Coordinate",
    "COR": "Correction",
    "CPBL": "Capable",
    "CPC": "Climate Prediction Center",
    "CRC": "Circle",
    "CRCLC": "Circulate",
    "CRCLN": "Circulation",
    "CRLC": "Circulate",
    "CRLN": "Circulation",
    "CRNR": "Corner",
    "CRNRS": "Corners",
    "CRS": "Course",
    "CS": "Cirrostratus",
    "CSDR": "Consider",
    "CSDRBL": "Considerable",
    "CST": "Coast",
    "CSTL": "Coastal",
    "CT": "Connecticut",
    "CTA": "Control area",
    "CTC": "Contact",
    "CTGY": "Category",
    "CTSKLS": "Catskills",
    "CU": "Cumulus",
    "CUFRA": "Cumulus fractus",
    "CVR": "Cover",
    "CVRD": "Covered",
    "CVRG": "Covering",
    "CVRS": "Covers",
    "CWSU": "Center Weather Service Units",
    "CYC": "Cyclonic",
    "CYCLGN": "Cyclogenesis",
    "DABRK": "Daybreak",
    "DALGT": "Daylight",
    "DBL": "Double",
    "DCR": "Decrease",
    "DCRD": "Decreased",
    "DCRG": "Decreasing",
    "DCRGLY": "Decreasingly",
    "DCRS": "Decreases",
    "DEG": "Degree",
    "DEGS": "Degrees",
    "DFCLT": "Difficult",
    "DFCLTY": "Difficulty",
    "DFNT": "Definite",
    "DFNTLY": "Definitely",
    "DFRS": "Differs",
    "DFUS": "Diffuse",
    "DGNL": "Diagonal",
    "DGNLLY": "Diagonally",
    "DIGG": "Digging",
    "DIR": "Direction",
    "DISC": "Discontinue",
    "DISCD": "Discontinued",
    "DISCG": "Discontinuing",
    "DISRE": "Disregard",
    "DISRED": "Disregarded",
    "DISREG": "Disregarding",
    "DLA": "Delay",
    "DLAD": "Delayed",
    "DLT": "Delete",
    "DLTD": "Deleted",
    "DLTG": "Deleting",
    "DLY": "Daily",
    "DMG": "Damage",
    "DMGD": "Damaged",
    "DMGG": "Damaging",
    "DMNT": "Dominant",
    "DMSH": "Diminish",
    "DMSHD": "Diminished",
    "DMSHG": "Diminishing",
    "DMSHS": "Diminishes",
    "DNDFTS": "Downdrafts",
    "DNS": "Dense",
    "DNSLP": "Downslope",
    "DNSTRM": "Downstream",
    "DNWND": "Downwind",
    "DP": "Deep",
    "DPND": "Deepened",
    "DPNG": "Deepening",
    "DPNS": "Deepens",
    "DPR": "Deeper",
    "DPTH": "Depth",
    "DR": "Low Drifting",
    "DRDU": "Drifting dust",
    "DRFT": "Drift",
    "DRFTD": "Drifted",
    "DRFTG": "Drifting",
    "DRFTS": "Drifts",
    "DRSA": "Low drifting sand",
    "DRSN": "Low drifting snow",
    "DRZL": "Drizzle",
    "DS": "Duststorm",
    "DSCNT": "Descent",
    "DSIPT": "Dissipate",
    "DSIPTD": "Dissipated",
    "DSIPTG": "Dissipating",
    "DSIPTN": "Dissipation",
    "DSIPTS": "Dissipates",
    "DSND": "Descend",
    "DSNDG": "Descending",
    "DSNDS": "Descends",
    "DSNT": "Distant",
    "DSTBLZ": "Destabilize",
    "DSTBLZD": "Destabilized",
    "DSTBLZG": "Destabilizing",
    "DSTBLZN": "Destabilization",
    "DSTBLZS": "Destabilizes",
    "DSTC": "Distance",
    "DTRT": "Deteriorate",
    "DTRTD": "Deteriorated",
    "DTRTG": "Deteriorating",
    "DTRTS": "Deteriorates",
    "DU": "Widespread dust storm",
    "DURC": "During climb",
    "DURD": "During descent",
    "DURG": "During",
    "DURGC": "During climb",
    "DURGD": "During descent",
    "DURN": "Duration",
    "DVLP": "Develop",
    "DVLPD": "Developed",
    "DVLPG": "Developing",
    "DVLPMT": "Development",
    "DVLPS": "Develops",
    "DVRG": "Diverge",
    "DVRGG": "Diverging",
    "DVRGNC": "Divergence",
    "DVRGS": "Diverges",
    "DVV": "Downward vertical velocity",
    "DWNDFTS": "Downdrafts",
    "DWPNT": "Dew point",
    "DWPNTS": "Dew points",
    "DX": "Duplex",
    "DZ": "Drizzle",
    "E": "East",
    "EBND": "Eastbound",
    "EFCT": "Effect",
    "ELNGT": "Elongate",
    "ELNGTD": "Elongated",
    "ELSW": "Elsewhere",
    "EMBD": "Embedded",
    "EMBDD": "Embedded",
    "EMERG": "Emergency",
    "ENCTR": "Encounter",
    "ENDG": "Ending",
    "ENE": "East-northeast",
    "ENELY": "East-northeasterly",
    "ENERN": "East-northeastern",
    "ENEWD": "East-northeastward",
    "ENHNC": "Enhance",
    "ENHNCD": "Enhanced",
    "ENHNCG": "Enhancing",
    "ENHNCMNT": "Enhancement",
    "ENHNCS": "Enhances",
    "ENRT": "Enroute",
    "ENTR": "Entire",
    "ERN": "Eastern",
    "ERY": "Early",
    "ERYR": "Earlier",
    "ESE": "East-southeast",
    "ESELY": "East-southeasterly",
    "ESERN": "East-southeastern",
    "ESEWD": "East-southeastward",
    "ESNTL": "Essential",
    "EST": "Estimate",
    "ESTAB": "Establish",
    "ESTS": "Estimates",
    "ETA": "Estimated time of arrival",
    "ETC": "Et cetera",
    "ETIM": "Elapsed time",
    "EVE": "Evening",
    "EWD": "Eastward",
    "EXCLV": "Exclusive",
    "EXCLVLY": "Exclusively",
    "EXCP": "Except",
    "EXP": "Expected",
    "EXPC": "Expect",
    "EXPCD": "Expected",
    "EXPCG": "Expecting",
    "EXTD": "Extend",
    "EXTDD": "Extended",
    "EXTDG": "Extending",
    "EXTDS": "Extends",
    "EXTN": "Extension",
    "EXTRAP": "Extrapolate",
    "EXTRAPD": "Extrapolated",
    "EXTRM": "Extreme",
    "EXTRMLY": "Extremely",
    "EXTSV": "Extensive",
    "F": "Fahrenheit",
    "FA": "Aviation area forecast",
    "FAH": "Fahrenheit",
    "FAM": "Familiar",
    "FC": "Funnel cloud",
    "FCST": "Forecast",
    "FCSTD": "Forecasted",
    "FCSTG": "Forecasting",
    "FCSTR": "Forecaster",
    "FCSTS": "Forecasts",
    "FEW": "Few",
    "FG": "Fog",
    "FIBI": "Filed but impracticable to transmit",
    "FIG": "Figure",
    "FILG": "Filling",
    "FIR": "Flight information region",
    "FIRAV": "First available",
    "FIRST": "First observation after a break in coverage at manual station",
    "FIS": "Flight Information Service",
    "FIS-B": "Flight Information Service Broadcast",
    "FL": "Flight level",
    "FLG": "Falling",
    "FLRY": "Flurry",
    "FLRYS": "Flurries",
    "FLT": "Flight",
    "FLW": "Follow",
    "FLWG": "Following",
    "FM": "From",
    "FMT": "Format",
    "FNCTN": "Function",
    "FNT": "Front",
    "FNTGNS": "Frontogenesis",
    "FNTL": "Frontal",
    "FNTLYS": "Frontolysis",
    "FNTS": "Fronts",
    "FORNN": "Forenoon",
    "FPM": "Feet per minute",
    "FQT": "Frequent",
    "FQTLY": "Frequently",
    "FRM": "Form",
    "FRMG": "Forming",
    "FRMN": "Formation",
    "FROPA": "Frontal passage",
    "FROSFC": "Frontal surface",
    "FRQ": "Frequent",
    "FRST": "Frost",
    "FRWF": "Forecast wind factor",
    "FRZ": "Freeze",
    "FRZG": "Freezing",
    "FRZLVL": "Freezing level",
    "FRZN": "Frozen",
    "FT": "Feet or Terminal Forecast",
    "FTHR": "Further",
    "FU": "Smoke",
    "FV": "Flight visibility",
    "FVRBL": "Favorable",
    "FWD": "Forward",
    "FYI": "For your information",
    "FZ": "Freezing",
    "FZRANO": "Freezing rain sensor not available",
    "G": "Gust",
    "GEN": "General",
    "GENLY": "Generally",
    "GEO": "Geographic",
    "GEOREF": "Geographical reference",
    "GF": "Fog",
    "GICG": "Glaze icing",
    "GLFALSK": "Gulf of Alaska",
    "GLFCAL": "Gulf of California",
    "GLFMEX": "Gulf of Mexico",
    "GLFSTLAWR": "Gulf of St. Lawrence",
    "GND": "Ground",
    "GNDFG": "Ground fog",
    "GOES": "Geostationary Operational Environmental Satellite",
    "GR": "Hail",
    "GRAD": "Gradient",
    "GRDL": "Gradual",
    "GRDLY": "Gradually",
    "GRT": "Great",
    "GRTLY": "Greatly",
    "GRTR": "Greater",
    "GRTST": "Greatest",
    "GS": "Small hail",
    "GSTS": "Gusts",
    "GSTY": "Gusty",
    "GTS": "Global Telecommunication System",
    "GV": "Ground visibility",
    "HAZ": "Hazard",
    "HCVIS": "High clouds visible",
    "HDFRZ": "Hard freeze",
    "HDWND": "Head wind",
    "HGT": "Height",
    "HI": "High or Hawaii",
    "HIER": "Higher",
    "HIFOR": "High level forecast",
    "HLF": "Half",
    "HLSTO": "Hailstones",
    "HLTP": "Hilltop",
    "HLYR": "Haze layer",
    "HND": "Hundred",
    "HPC": "Hydrometeorological Prediction Center",
    "HR": "Hour",
    "HRS": "Hours",
    "HRZN": "Horizon",
    "HTG": "Heating",
    "HURCN": "Hurricane",
    "HUREP": "Hurricane report",
    "HV": "Have",
    "HVY": "Heavy",
    "HVYR": "Heavier",
    "HVYST": "Heaviest",
    "HWVR": "However",
    "HWY": "Highway",
    "HZ": "Haze",
    "IC": "Ice crystals or ice",
    "ICAO": "International Civil Aviation Organization",
    "ICG": "Icing",
    "ICGIC": "Icing in clouds",
    "ICGICIP": "Icing in clouds and in precipitation",
    "ICGIP": "Icing in precipitation",
    "IFR": "Instrument flight rules",
    "IMC": "Instrument meteorolgical conditions",
    "IMDT": "Immediate",
    "IMDTLY": "Immediately",
    "IMPL": "Impulse",
    "IMPLS": "Impulses",
    "IMPT": "Important",
    "INCL": "Include",
    "INCLD": "Included",
    "INCLG": "Including",
    "INCLS": "Includes",
    "INCR": "Increase",
    "INCRD": "Increased",
    "INCRG": "Increasing",
    "INCRGLY": "Increasingly",
    "INCRS": "Increases",
    "INDC": "Indicate",
    "INDCD": "Indicated",
    "INDCG": "Indicating",
    "INDCS": "Indicates",
    "INDEF": "Indefinite",
    "INFO": "Information",
    "INLD": "Inland",
    "INSTBY": "Instability",
    "INTCNTL": "Intercontinental",
    "INTER": "Intermittent",
    "INTL": "International",
    "INTMD": "Intermediate",
    "INTMT": "Intermittent",
    "INTMTLY": "Intermittently",
    "INTR": "Interior",
    "INTRMTRGN": "Intermountain region",
    "INTS": "Intense",
    "INTSFCN": "Intensification",
    "INTSFY": "Intensify",
    "INTSFYD": "Intensified",
    "INTSFYG": "Intensifying",
    "INTSFYS": "Intensifies",
    "INTSTY": "Intensity",
    "INTVL": "Interval",
    "INVOF": "In vicinity of",
    "INVRN": "Inversion",
    "IOVC": "In overcast",
    "IP": "Ice pellets",
    "IPV": "Improve",
    "IPVG": "Improving",
    "IR": "Infrared",
    "ISOL": "Isolate",
    "ISOLD": "Isolated",
    "JCTN": "Junction",
    "JTSTR": "Jet stream",
    "KFRST": "Killing frost",
    "KLYR": "Smoke layer aloft",
    "KMH": "Kilometers per hour",
    "KOCTY": "Smoke over city",
    "KT": "Knots",
    "L": "Left",
    "LAMP": "Local AWIPS MOS Program",
    "LAPS": "Local Analysis and Prediction System",
    "LAST": "Last observation before a break in coverage at a manual station",
    "LAT": "Latitude",
    "LAWRS": "Limited aviation weather reporting station",
    "LCL": "Local or Lifted condensation level",
    "LCLY": "Locally",
    "LCTD": "Located",
    "LCTMP": "Little change in temperature",
    "LCTN": "Location",
    "LDG": "Landing",
    "LEVEL": "Level",
    "LFM": "Limited fine mesh model",
    "LFTG": "Lifting",
    "LGRNG": "Long-range",
    "LGT": "Light",
    "LGTR": "Lighter",
    "LGWV": "Long wave",
    "LI": "Lifted Index",
    "LIFR": "Low instrument flight rules",
    "LIS": "Lifted Indices",
    "LK": "Lake",
    "LKLY": "Likely",
    "LKS": "Lakes",
    "LLJ": "Low level jet",
    "LLWAS": "Low-level wind shear alert system",
    "LLWS": "Low-level wind shear",
    "LMTD": "Limited",
    "LMTG": "Limiting",
    "LMTS": "Limits",
    "LN": "Line",
    "LNS": "LInes",
    "LO": "Low",
    "LONG": "Longitude",
    "LONGL": "Longitudinal",
    "LRG": "Large",
    "LRGLY": "Largely",
    "LRGR": "Larger",
    "LRGST": "Largest",
    "LST": "Local standard time",
    "LTD": "Limited",
    "LTG": "Lightning",
    "LTGCA": "Lightning cloud-to-air",
    "LTGCC": "Lightning cloud-to-cloud",
    "LTGCCCG": "Lightning cloud-to-cloud",
    "LTGCG": "Lightning cloud-to-ground",
    "LTGCW": "Lightning cloud-to-water",
    "LTGIC": "Lightning in cloud",
    "LTL": "Little",
    "LTLCG": "Little change",
    "LTR": "Later",
    "LTST": "Latest",
    "LV": "Leaving",
    "LVL": "Level",
    "LVLS": "Levels",
    "LWR": "Lower",
    "LWRD": "Lowered",
    "LWRG": "Lowering",
    "LYR": "Layer",
    "LYRD": "Layered",
    "LYRS": "Layers",
    "M": "Minus or Less than lowest sensor value",
    "MAX": "Maximum",
    "MB": "Millibars",
    "MCD": "Mesoscale discussion",
    "MDFY": "Modify",
    "MDFYD": "Modified",
    "MDFYG": "Modifying",
    "MDL": "Model",
    "MDLS": "Models",
    "MDT": "Moderate",
    "MDTLY": "Moderately",
    "MED": "Medium",
    "MEGG": "Merging",
    "MESO": "Mesoscale",
    "MET": "Meteorological",
    "METAR": "Aviation Routine Weather Report",
    "METRO": "Metropolitan",
    "MI": "Mile",
    "MID": "Middle",
    "MIDN": "Midnight",
    "MIFG": "Shallow fog",
    "MIL": "Military",
    "MIN": "Minimum",
    "MISG": "Missing",
    "MLTLVL": "Melting level",
    "MNLD": "Mainland",
    "MNLY": "Mainly",
    "MOD": "Moderate",
    "MOGR": "Moderate or greater",
    "MOS": "Model Output Statistics",
    "MOV": "Move",
    "MOVD": "Moved",
    "MOVG": "Moving",
    "MOVMT": "Movement",
    "MOVS": "Moves",
    "MPH": "Miles per hour",
    "MPS": "Meters per second",
    "MRGL": "Marginal",
    "MRGLLY": "Marginally",
    "MRNG": "Morning",
    "MRTM": "Maritime",
    "MSG": "Message",
    "MSL": "Mean sea level",
    "MST": "Most",
    "MSTLY": "Mostly",
    "MSTR": "Moisture",
    "MT": "Mountain",
    "MTN": "Mountain",
    "MTNS": "Mountains",
    "MTW": "Mountain wave",
    "MULT": "Multiple",
    "MULTILVL": "Multilevel",
    "MVFR": "Marginal visual flight rules",
    "MWO": "Meteorological Watch Office",
    "MX": "Mixed snow and ice",
    "MXD": "Mixed",
    "N": "North",
    "N/A": "Not applicable",
    "NAB": "Not above",
    "NAT": "North Atlantic",
    "NATL": "National",
    "NAV": "Navigation",
    "NAVAID": "Electronic navigation aid facility",
    "NBND": "Northbound",
    "NBRHD": "Neighborhood",
    "NC": "No change",
    "NCDC": "National Climatic Data Center",
    "NCEP": "National Center of Environmental Prediction",
    "NCO": "NCEP Central Operations",
    "NCWX": "No change in weather",
    "NE": "Northeast",
    "NEC": "Necessary",
    "NEG": "Negative",
    "NEGLY": "Negatively",
    "NELY": "Northeasterly",
    "NERN": "Northeastern",
    "NEWD": "Northeastward",
    "NGM": "Nested grid model",
    "NGT": "Night",
    "NHC": "National Hurricane Center",
    "NIL": "None",
    "NL": "No layers",
    "NLT": "Not later than",
    "NLY": "Northerly",
    "NM": "Nautical miles",
    "NMBR": "Number",
    "NMBRS": "Numbers",
    "NMC": "National Meteorological Center",
    "NML": "Normal",
    "NMRS": "Numerous",
    "NNE": "North-northeast",
    "NNELY": "North-northeasterly",
    "NNERN": "North-northeastern",
    "NNEWD": "North-northeastward",
    "NNNN": "End of message",
    "NNW": "North-northwest",
    "NNWLY": "North-northwesterly",
    "NNWRN": "North-northwestern",
    "NNWWD": "North-northwestward",
    "NOAA": "National Oceanic and Atmospheric Administration",
    "NOPAC": "Northern Pacific",
    "NOS": "National Ocean Service",
    "NOSPECI": "No SPECI reports are taken at station",
    "NPRS": "Nonpersistent",
    "NR": "Near",
    "NRLY": "Nearly",
    "NRN": "Northern",
    "NRW": "Narrow",
    "NSC": "No significant cloud",
    "NSW": "No significant weather",
    "NTFY": "Notify",
    "NTFYD": "Notified",
    "NVA": "Negative vorticity advection",
    "NW": "Northwest",
    "NWD": "Northward",
    "NWLY": "Northwesterly",
    "NWRN": "Northwestern",
    "NWS": "National Weather Service",
    "NXT": "Next",
    "OAT": "Outside air temperature",
    "OBND": "Outbound",
    "OBS": "Observation",
    "OBSC": "Obscure",
    "OBSCD": "Obscured",
    "OBSCG": "Obscuring",
    "OCFNT": "Occluded front",
    "OCLD": "Occlude",
    "OCLDD": "Occluded",
    "OCLDG": "Occluding",
    "OCLDS": "Occludes",
    "OCLN": "Occlusion",
    "OCNL": "Occasional",
    "OCNLY": "Occasionally",
    "OCR": "Occur",
    "OCRD": "Occurred",
    "OCRG": "Occurring",
    "OCRS": "Occurs",
    "OFC": "Office",
    "OFCM": "Office of the Federal Coordinator for Meteorology",
    "OFP": "Occluded frontal passage",
    "OFSHR": "Offshore",
    "OHD": "Overhead",
    "OMTNS": "Over mountains",
    "ONSHR": "On shore",
    "ORGPHC": "Orographic",
    "ORIG": "Original",
    "OSV": "Ocean station vessel",
    "OTLK": "Outlook",
    "OTP": "On top",
    "OTR": "Other",
    "OTRW": "Otherwise",
    "OUTFLO": "Outflow",
    "OV": "Over",
    "OVC": "Overcast",
    "OVHD": "Overhead",
    "OVNGT": "Overnight",
    "OVR": "Over",
    "OVRN": "Overrun",
    "OVRNG": "Overrunning",
    "OVTK": "Overtake",
    "OVTKG": "Overtaking",
    "OVTKS": "Overtakes",
    "P": "Higher than greatest sensor value",
    "P6SM": "Visibility forecast to be greater than 6 statute miles",
    "PAC": "Pacific",
    "PATWAS": "Pilot's automatic telephone weather answering service",
    "PBL": "Planetary boundary layer",
    "PCPN": "Precipitation",
    "PD": "Period",
    "PDMT": "Predominant",
    "PDS": "Periods",
    "PE": "Ice pellets",
    "PEN": "Peninsula",
    "PERM": "Permanent",
    "PHYS": "Physical",
    "PIBAL": "Pilot balloon observation",
    "PIREP": "Pilot weather report",
    "PK WND": "Peak wind",
    "PL": "Ice pellets",
    "PLNS": "Plains",
    "PLS": "Please",
    "PLTO": "Plateau",
    "PM": "Postmeridian",
    "PNHDL": "Panhandle",
    "PNO": "Precipitation amount not available",
    "PO": "Dust or sand swirls",
    "POS": "Positive",
    "POSLY": "Positively",
    "PPINA": "Radar weather report not available",
    "PPINE": "Radar weather report no echoes observed",
    "PPSN": "Present position",
    "PR": "Partial",
    "PRBL": "Probable",
    "PRBLTY": "Probability",
    "PRBLY": "Probably",
    "PRECD": "Precede",
    "PRECDD": "Preceded",
    "PRECDG": "Preceding",
    "PRECDS": "Precedes",
    "PRES": "Pressure",
    "PRESFR": "Pressure falling rapidly",
    "PRESRR": "Pressure rising rapidly",
    "PRFG": "Partial fog",
    "PRIM": "Primary",
    "PRIN": "Principal",
    "PRIND": "Present indications are",
    "PRJMP": "Pressure jump",
    "PROB": "Probability",
    "PROBC C": "Forecaster's assessment of the probability of occurrence of a thunderstorm or precipitation event, along with associated weather elements (wind, visibility, and/or sky condition) whose occurrences are directly related to, and contemporaneous with, the thunderstorm or precipitation event",
    "PROC": "Procedure",
    "PROD": "Produce",
    "PRODG": "Producing",
    "PROG": "Forecast",
    "PROGD": "Forecasted",
    "PROGS": "Forecasts",
    "PRSNT": "Present",
    "PRSNTLY": "Presently",
    "PRST": "Persist",
    "PRSTNC": "Persistence",
    "PRSTNT": "Persistent",
    "PRSTS": "Persists",
    "PRVD": "Provide",
    "PRVDD": "Provided",
    "PRVDG": "Providing",
    "PRVDS": "Provides",
    "PS": "Plus",
    "PSBL": "Possible",
    "PSBLTY": "Possibility",
    "PSBLY": "Possibly",
    "PSG": "Passage",
    "PSN": "Position",
    "PSND": "Positioned",
    "PTCHY": "Patchy",
    "PTLY": "Partly",
    "PTNL": "Potential",
    "PTNLY": "Potentially",
    "PTNS": "Portions",
    "PVA": "Positive vorticity advection",
    "PVL": "Prevail",
    "PVLD": "Prevailed",
    "PVLG": "Prevailing",
    "PVLS": "Prevails",
    "PVLT": "Prevalent",
    "PWB": "Pilot weather briefing",
    "PWINO": "Precipitation identifier sensor not available",
    "PWR": "Power",
    "PY": "Spray",
    "QN": "Question",
    "QPFERD": "NCEP excessive rainfall discussion",
    "QPFHSD": "NCEP heavy snow discussion",
    "QPFSPD": "NCEP special precipitation discussion",
    "QSTNRY": "Quasistationary",
    "QTR": "Quarter",
    "QUAD": "Quadrant",
    "R": "Right",
    "RA": "Rain",
    "RADAT": "Radiosonde additional data",
    "RAOB": "Radiosonde observation",
    "RCA": "Reach Cruising Altitude",
    "RCH": "Reach",
    "RCHD": "Reached",
    "RCHG": "Reaching",
    "RCHS": "Reaches",
    "RCKY": "Rocky",
    "RCMD": "Recommend",
    "RCMDD": "Recommended",
    "RCMDG": "Recommending",
    "RCMDS": "Recommends",
    "RCRD": "Record",
    "RCRDS": "Records",
    "RCV": "Receive",
    "RCVD": "Received",
    "RCVG": "Receiving",
    "RCVS": "Receives",
    "RDC": "Reduce",
    "RDGG": "Ridging",
    "RDOACT": "Radioactive",
    "RDR": "Radar",
    "RDVLP": "Redevelop",
    "RDVLPG": "Redeveloping",
    "RDVLPMT": "Redevelopment",
    "RE": "Regard",
    "RECON": "Reconnaissance",
    "REF": "Reference",
    "REPL": "Replace",
    "REPLD": "Replaced",
    "REPLG": "Replacing",
    "REPLS": "Replaces",
    "REQ": "Request",
    "REQS": "Requests",
    "REQSTD": "Requested",
    "RES": "Reserve",
    "RESP": "Response",
    "RESTR": "Restrict",
    "RGD": "Ragged",
    "RGL": "Regional model",
    "RGLR": "Regular",
    "RGN": "Region",
    "RGNS": "Regions",
    "RGT": "Right",
    "RH": "Relative humidity",
    "RHINO": "RHI not operative",
    "RIME": "Type of icing characterized by a rough, milky, opaque appearance",
    "RLBL": "Reliable",
    "RLTV": "Relative",
    "RLTVLY": "Relatively",
    "RM": "Remarks",
    "RMK": "Remark",
    "RMN": "Remain",
    "RMND": "Remained",
    "RMNDR": "Remainder",
    "RMNG": "Remaining",
    "RMNS": "Remains",
    "RNFL": "Rainfall",
    "RNG": "Range",
    "ROT": "Rotate",
    "ROTD": "Rotated",
    "ROTG": "Rotating",
    "ROTS": "Rotates",
    "RPD": "Rapid",
    "RPDLY": "Rapidly",
    "RPLC": "Replace",
    "RPLCD": "Replaced",
    "RPLCG": "Replacing",
    "RPLCS": "Replaces",
    "RPRT": "Report",
    "RPRTD": "Reported",
    "RPRTG": "Reporting",
    "RPRTS": "Reports",
    "RPT": "Repeat",
    "RPTG": "Repeating",
    "RPTS": "Repeats",
    "RQR": "Require",
    "RQRD": "Required",
    "RQRG": "Requiring",
    "RQRS": "Requires",
    "RS": "Receiver station",
    "RSG": "Rising",
    "RSN": "Reason",
    "RSNG": "Reasoning",
    "RSNS": "Reasons",
    "RSTR": "Restrict",
    "RSTRD": "Restricted",
    "RSTRG": "Restricting",
    "RSTRS": "Restricts",
    "RTRN": "Return",
    "RTRND": "Returned",
    "RTRNG": "Returning",
    "RTRNS": "Returns",
    "RUC": "Rapid Update Cycle",
    "RUF": "Rough",
    "RUFLY": "Roughly",
    "RVR": "Runway Visual Range",
    "RVRNO": "RVR system not available",
    "RVS": "Revise",
    "RVSD": "Revised",
    "RVSG": "Revising",
    "RVSS": "Revises",
    "RW": "Rain shower",
    "RWY": "Runway",
    "RY": "Runway",
    "S": "South",
    "SA": "Sand",
    "SAB": "Satellite Analysis Branch",
    "SAO": "Surface observation",
    "SATFY": "Satisfactory",
    "SBND": "Southbound",
    "SBSD": "Subside",
    "SBSDD": "Subsided",
    "SBSDNC": "Subsidence",
    "SBSDS": "Subsides",
    "SC": "Stratocumulus",
    "SCND": "Second",
    "SCNDRY": "Secondary",
    "SCSL": "Stratocumulus standing lenticular",
    "SCT": "Scattered",
    "SCTD": "Scattered",
    "SCTR": "Sector",
    "SE": "Southeast",
    "SEC": "Second",
    "SELY": "Southeasterly",
    "SEPN": "Separation",
    "SEQ": "Sequence",
    "SERN": "Southeastern",
    "SEV": "Severe",
    "SEWD": "Southeastward",
    "SFC": "Surface",
    "SFERICS": "Atmospherics",
    "SG": "Snow grains",
    "SGFNT": "Significant",
    "SGFNTLY": "Significantly",
    "SH": "Showers",
    "SHFT": "Shift",
    "SHFTD": "Shifted",
    "SHFTG": "Shifting",
    "SHFTS": "Shifts",
    "SHLD": "Shield",
    "SHLW": "Shallow",
    "SHRT": "Short",
    "SHRTLY": "Shortly",
    "SHRTWV": "Shortwave",
    "SHUD": "Should",
    "SHWR": "Shower",
    "SIG": "Signature",
    "SIGMET": "Significant meteorological information",
    "SIMUL": "Simultaneous",
    "SK": "Sky cover",
    "SKC": "Sky clear",
    "SKED": "Schedule",
    "SLD": "Solid",
    "SLGT": "Slight",
    "SLGTLY": "Slightly",
    "SLO": "Slow",
    "SLOLY": "Slowly",
    "SLOR": "Slower",
    "SLP": "Sea level pressure",
    "SLPG": "Sloping",
    "SLPNO": "Sea-level pressure not available",
    "SLT": "Sleet",
    "SLW": "Slow",
    "SLY": "Southerly",
    "SM": "Statute mile",
    "SMK": "Smoke",
    "SML": "Small",
    "SMLR": "Smaller",
    "SMRY": "Summary",
    "SMS": "Sunchronous meteorological satellite",
    "SMTH": "Smooth",
    "SMTHR": "Smoother",
    "SMTHST": "Smoothest",
    "SMTM": "Sometime",
    "SMWHT": "Somewhat",
    "SN": "Snow",
    "SNBNK": "Snowbank",
    "SND": "Sand",
    "SNFLK": "Snowflake",
    "SNGL": "Single",
    "SNOINCR": "Snow increase",
    "SNOINCRG": "Snow increasing",
    "SNST": "Sunset",
    "SNW": "Snow",
    "SNWFL": "Snowfall",
    "SOP": "Standard operating procedure",
    "SP": "Snow pellets",
    "SPC": "Storm Prediction Center",
    "SPCLY": "Especially",
    "SPD": "Speed",
    "SPECI": "Special observation",
    "SPENES": "Satellite precip. estimate statement",
    "SPKL": "Sprinkle",
    "SPRD": "Spread",
    "SPRDG": "Spreading",
    "SPRDS": "Spreads",
    "SPRL": "Spiral",
    "SQ": "Squall",
    "SQAL": "Squall",
    "SQL": "Squall line",
    "SQLN": "Squall line",
    "SR": "Sunrise",
    "SRN": "Southern",
    "SRND": "Surround",
    "SRNDD": "Surrounded",
    "SRNDG": "Surrounding",
    "SRNDS": "Surrounds",
    "SS": "Sunset",
    "SSE": "South-southeast",
    "SSELY": "South-southeasterly",
    "SSERN": "South-southeastern",
    "SSEWD": "South-southeastward",
    "SSW": "South-southwest",
    "SSWLY": "South-southwesterly",
    "SSWRN": "South-southwestern",
    "SSWWD": "South-southwestward",
    "ST": "Stratus",
    "STAGN": "Stagnation",
    "STBL": "Stable",
    "STBLTY": "Stability",
    "STD": "Standard",
    "STDY": "Steady",
    "STFR": "Stratus fractus",
    "STFRM": "Stratiform",
    "STG": "Strong",
    "STGLY": "Strongly",
    "STGR": "Stronger",
    "STGST": "Strongest",
    "STLT": "Satellite",
    "STM": "Storm",
    "STMS": "Storms",
    "STN": "Station",
    "STNR": "Stationary",
    "STNRY": "Stationary",
    "SUB": "Substitute",
    "SUBTRPCL": "Subtropical",
    "SUF": "Sufficient",
    "SUFLY": "Sufficiently",
    "SUG": "Suggest",
    "SUGG": "Suggesting",
    "SUGS": "Suggests",
    "SUP": "Supply",
    "SUPG": "Supplying",
    "SUPR": "Superior",
    "SUPSD": "Supersede",
    "SUPSDG": "Superseding",
    "SUPSDS": "Supersedes",
    "SVG": "Serving",
    "SVR": "Severe",
    "SVRL": "Several",
    "SW": "Southwest",
    "SW+": "Heavy snow shower",
    "SW-": "Light snow shower",
    "SWD": "Southward",
    "SWLG": "Swelling",
    "SWLY": "Southwesterly",
    "SWODY1": "SPC Severe Weather Outlook for Day 1",
    "SWOMCD": "SPC Mesoscale discussion",
    "SWRN": "Southwestern",
    "SWWD": "Southwestward",
    "SX": "Stability index",
    "SXN": "Section",
    "SYNOP": "Synoptic",
    "SYNS": "Synopsis",
    "SYS": "System",
    "T": "Thunder",
    "TA": "Temperature",
    "TACAN": "UHF Tactical Air Navigation Aid",
    "TAF": "Terminal Area Forecast",
    "TB": "Turbulence",
    "TC": "Tropical cyclone",
    "TCNTL": "Transcontinental",
    "TCU": "Towering cumulus",
    "TDA": "Today",
    "TEI": "Text element indicator",
    "TEMP": "Temperature",
    "TEMPO": "Temporary",
    "THD": "Thunderhead",
    "THDR": "Thunder",
    "THK": "Thick",
    "THKNG": "Thickening",
    "THKNS": "Thickness",
    "THKR": "Thicker",
    "THKST": "Thickest",
    "THN": "Thin",
    "THNG": "Thinning",
    "THNR": "Thinner",
    "THNST": "Thinnest",
    "THR": "Threshold",
    "THRFTR": "Thereafter",
    "THRU": "Through",
    "THRUT": "Throughout",
    "THSD": "Thousand",
    "THTN": "Threaten",
    "THTND": "Threatened",
    "THTNG": "Threatening",
    "THTNS": "Threatens",
    "TIL": "Until",
    "TKOF": "Takeoff",
    "TM": "Time",
    "TMPRY": "Temporary",
    "TMPRYLY": "Temporarily",
    "TMW": "Tomorrow",
    "TNDCY": "Tendency",
    "TNDCYS": "Tendencies",
    "TNGT": "Tonight",
    "TNTV": "Tentative",
    "TNTVLY": "Tentatively",
    "TOC": "Top of Climb",
    "TOP": "Top of Clouds",
    "TOPS": "Tops",
    "TOVC": "Top of overcast",
    "TP": "Type of aircraft",
    "TPG": "Topping",
    "TRBL": "Trouble",
    "TRIB": "Tributary",
    "TRKG": "Tracking",
    "TRML": "Terminal",
    "TRMT": "Terminate",
    "TRMTD": "Terminated",
    "TRMTG": "Terminating",
    "TRMTS": "Terminates",
    "TRNSP": "Transport",
    "TRNSPG": "Transporting",
    "TROF": "Trough",
    "TROFS": "Troughs",
    "TROP": "Tropopause",
    "TRPCD": "Tropical continental air mass",
    "TRPCL": "Tropical",
    "TRRN": "Terrain",
    "TRSN": "Transition",
    "TRW": "Thunderstorm",
    "TRW+": "Thunderstorm with heavy rain shower",
    "TS": "Thunderstorm",
    "TS+": "Thunderstorm with heavy snow",
    "TSFR": "Transfer",
    "TSFRD": "Transferred",
    "TSFRG": "Transferring",
    "TSFRS": "Transfers",
    "TSGR": "Thunderstorm with hail",
    "TSHWR": "Thundershower",
    "TSNO": "Thunderstorm information not available",
    "TSNT": "Transient",
    "TSQLS": "Thundersquall",
    "TSTM": "Thunderstorm",
    "TSW": "Thunderstorm with snow showers",
    "TSW+": "Thunderstorm with heavy snow showers",
    "TURB": "Turbulence",
    "TURBC": "Turbulence",
    "TURBT": "Turbulent",
    "TWD": "Toward",
    "TWDS": "Towards",
    "TWI": "Twilight",
    "TWR": "Tower",
    "TWRG": "Towering",
    "UA": "Pilot weather reports",
    "UDDF": "Up and downdrafts",
    "UIR": "Upper flight information region",
    "UN": "Unable",
    "UNAVBL": "Unavailable",
    "UNEC": "Unnecessary",
    "UNKN": "Unknown",
    "UNL": "Unlimited",
    "UNRELBL": "Unreliable",
    "UNRSTD": "Unrestricted",
    "UNSATFY": "Unsatisfactory",
    "UNSBL": "Unseasonable",
    "UNSTBL": "Unstable",
    "UNSTDY": "Unsteady",
    "UNSTL": "Unsettle",
    "UNSTLD": "Unsettled",
    "UNUSBL": "Unusable",
    "UP": "Unknown precipitation",
    "UPDFTS": "Updrafts",
    "UPR": "Upper",
    "UPSLP": "Upslope",
    "UPSTRM": "Upstream",
    "URG": "Urgent",
    "USBL": "Usable",
    "UTC": "Universal Time Coordinate",
    "UUA": "Urgent PIREP Weather Reports",
    "UVV": "Upward vertical velocity",
    "UWNDS": "Upper winds Varies",
    "V": "Varies",
    "VA": "Volcanic Ash",
    "VAAC": "Volcanic Ash Advisory Center",
    "VAAS": "Volcanic Ash Advisory Statement",
    "VAD": "Velocity azimuth display",
    "VAL": "Valley",
    "VARN": "Variation",
    "VC": "Vicinity",
    "VCNTY": "Vicinity",
    "VCOT": "VFR conditions on top",
    "VCTR": "Vector",
    "VCTS": "Thunderstorms in the vicinity",
    "VDUC": "VAS Data Utilization Center",
    "VFR": "Visual flight rules",
    "VFY": "Verify",
    "VFYD": "Verified",
    "VFYG": "Verifying",
    "VFYS": "Verifies",
    "VHF": "Very High Frequency",
    "VIS": "Visibility",
    "VLCTY": "Velocity",
    "VLCTYS": "Velocities",
    "VLNT": "Violent",
    "VLNTLY": "Violently",
    "VLY": "Valley",
    "VMC": "Visual meteorological conditions",
    "VOL": "Volume",
    "VOR": "VHF Omnidirectional Radio Range",
    "VORT": "Vorticity",
    "VORTAC": "VOR and TACAN combination",
    "VR": "Veer",
    "VRB": "Variable",
    "VRBL": "Variable",
    "VRG": "Veering",
    "VRS": "Veers",
    "VRT MOTN": "Vertical motion",
    "VRY": "Very",
    "VSB": "Visible",
    "VSBY": "Visibility",
    "VSBYDR": "Visibility decreasing rapidly",
    "VSBYIR": "Visibility increasing rapidly",
    "VSNO": "Visibility at secondary location not available",
    "VV": "Vertical visibility",
    "VWP": "VAD Wind profiler",
    "W": "West",
    "WAA": "Warm air advection",
    "WAFS": "Word Area Forecast System",
    "WBND": "Westbound",
    "WDLY": "Widely",
    "WDSPRD": "Widespread",
    "WEA": "Weather",
    "WFO": "Weather Forecast Office",
    "WFP": "Warm front passage",
    "WFSO": "Weather Forecast Service Office",
    "WI": "Within",
    "WIBIS": "Will be issued",
    "WID": "Width",
    "WINT": "Winter",
    "WK": "Weak",
    "WKDAY": "Weekday",
    "WKEND": "Weekend",
    "WKN": "Weaken",
    "WKNG": "Weakening",
    "WKNS": "Weakens",
    "WKR": "Weaker",
    "WKST": "Weakest",
    "WL": "Will",
    "WLY": "Westerly",
    "WMO": "World Meteorological Organization",
    "WND": "Wind",
    "WNDS": "Winds",
    "WNW": "West-northwest",
    "WNWLY": "West-northwesterly",
    "WNWRN": "West-northwestern",
    "WNWWD": "West-northwestward",
    "WO": "Without",
    "WRM": "Warm",
    "WRMFNT": "Warm front",
    "WRMFNTL": "Warm frontal",
    "WRMG": "Warming",
    "WRMR": "Warmer",
    "WRMST": "Warmest",
    "WRN": "Western",
    "WRNG": "Warning",
    "WRS": "Worse",
    "WS": "Wind shear",
    "WSFO": "Weather Service Forecast Office",
    "WSHFT": "Windshift",
    "WSO": "Weather service office",
    "WSPD": "Wind speed",
    "WSR-88D": "NWS Doppler Radar",
    "WSW": "West-southwest",
    "WSWLY": "West-southwesterly",
    "WSWRN": "West-southwestern",
    "WSWWD": "West-southwestward",
    "WTR": "Water",
    "WTSPT": "Waterspout",
    "WUD": "Would",
    "WV": "Wind",
    "WVS": "Waves",
    "WW": "Severe weather watch",
    "WWAMKC": "SPC status report",
    "WWD": "Westward",
    "WWS": "Severe weather watches",
    "WX": "Weather",
    "XCP": "Except",
    "XPC": "Expect",
    "XPCD": "Expected",
    "XPCG": "Expecting",
    "XPCS": "Expects",
    "XPLOS": "Explosive",
    "XTND": "Extend",
    "XTNDD": "Extended",
    "XTNDG": "Extending",
    "XTRM": "Extreme",
    "XTRMLY": "Extremely",
    "YDA": "Yesterday",
    "Z": "Zulu time",
    "ZL": "Freezing drizzle",
    "ZN": "Zone",
    "ZNS": "Zones",
    "ZR": "Freezing rain",
}
