# -*- coding: utf-8 -*-
# Generated by Django 1.11.13 on 2018-07-29 08:48
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import tcms.core.models.base
import tcms.issuetracker.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('testruns', '0004_fix_missing_migrations'),
        ('management', '0003_TestBuild_is_active_use_custom_bool_field'),
        ('testcases', '0006_unique_case_component'),
    ]

    operations = [
        migrations.CreateModel(
            name='Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('issue_key', models.CharField(help_text='Actual issue ID corresponding issue tracker. Different issue tracker may have issue IDs in different type or format. For example, in Bugzilla, it could be an integer, or in JIRA, it could be a string in format PROJECTNAME-number, e.g. PROJECT-1000.', max_length=50, validators=[django.core.validators.MaxLengthValidator(50, 'Issue key has too many characters. It must have at most 50 characters.')])),
                ('summary', models.CharField(blank=True, help_text='Summary of issue.', max_length=255, null=True)),
                ('description', models.TextField(blank=True, help_text='Description of issue.', null=True)),
                ('case', models.ForeignKey(help_text='A test case this issue is associated with.', on_delete=django.db.models.deletion.CASCADE, related_name='issues', to='testcases.TestCase')),
                ('case_run', models.ForeignKey(blank=True, help_text='A test case run this issue is associated with optionally.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='issues', to='testruns.TestCaseRun')),
            ],
            options={
                'db_table': 'issue_tracker_issues',
            },
        ),
        migrations.CreateModel(
            name='IssueTracker',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(db_index=True, default=True, help_text='Whether to enable this issue tracker in system wide.')),
                ('name', models.CharField(help_text='Issue tracker name.', max_length=50, unique=True)),
                ('description', models.CharField(blank=True, default='', help_text='A short description to this issue tracker.', max_length=255)),
                ('service_url', models.URLField(blank=True, default='', help_text='URL of this issue tracker.')),
                ('api_url', models.URLField(blank=True, default='', help_text='API URL of this issue tracker.')),
                ('issue_url_fmt', models.URLField(help_text="Formatter string used to construct a specific issue's URL. Format arguments: issue_key, product. For example, https://bugzilla.domain/show_bug.cgi?id=%(issue_key)s")),
                ('validate_regex', models.CharField(help_text='Regular expression in Python Regular Expression syntax, which is used to validate issue ID. This regex will be used in both JavaScript code and Python code. So, please write it carefully.', max_length=100, validators=[tcms.issuetracker.validators.validate_reg_exp])),
                ('allow_add_case_to_issue', models.BooleanField(default=False, help_text='Allow to add associated case to this issue.')),
                ('credential_type', models.CharField(choices=[('NoNeed', 'No need to login'), ('UserPwd', 'Username/Password authentication'), ('Token', 'Token based')], help_text='Type of credential', max_length=10)),
                ('class_path', models.CharField(default='tcms.issuetracker.models.IssueTrackerService', help_text='Importable path to the implementation for this issue tracker. Default is <code>tcms.issuetracker.models.IssueTrackerService</code>, which provides basic functionalities for general purpose. Set to a custom path for specific class inherited from <code>IssueTrackerService</code>', max_length=100, validators=[tcms.issuetracker.validators.validate_class_path])),
                ('issue_report_endpoint', models.CharField(help_text='The endpoint of this issue tracker service to file an issue.', max_length=50)),
                ('issue_report_params', models.CharField(help_text='Parameters used to format URL for reporting issue. Each line is a <code>key:value</code> pair of parameters. Nitrate provides a few parameters to format URL and additional parameters could be provided by system administrator as well. ', max_length=255)),
                ('issue_report_fmt', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'issue_trackers',
            },
            bases=(models.Model, tcms.core.models.base.UrlMixin),
        ),
        migrations.CreateModel(
            name='IssueTrackerProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of issue tracker product.', max_length=30, unique=True)),
            ],
            options={
                'db_table': 'issue_tracker_products',
            },
            bases=(models.Model, tcms.core.models.base.UrlMixin),
        ),
        migrations.CreateModel(
            name='ProductIssueTrackerRelationship',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('namespace', models.CharField(blank=True, help_text='A name which the issues reported for product should belong to in issue tracker. Different issue tracker services will use this namespace to construct specific URL for issue report. Namespace could be empty, if product is not under a namespace in issue tracker, or is the top level product with its own components. For example, in a Bugzilla instance, product A is a component of a product X, namespace should be the name of X.', max_length=30, null=True, validators=[django.core.validators.MaxLengthValidator(30)])),
                ('issue_tracker', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='issuetracker.IssueTracker')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='management.Product')),
            ],
            options={
                'db_table': 'product_issue_tracker_relationship',
            },
            bases=(models.Model, tcms.core.models.base.UrlMixin),
        ),
        migrations.CreateModel(
            name='TokenCredential',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('secret_file', models.CharField(blank=True, help_text='Alternative secret file in INI format including username and password.', max_length=100, null=True)),
                ('token', models.CharField(blank=True, help_text='Token used to log into remote issue tracker.', max_length=255, null=True)),
                ('until', models.DateField(blank=True, help_text='Optional expiration date. This is useful for Nitrate to determine whether the token has been expired before request. If omitted, request will be sent without checking the expiration date.', null=True)),
                ('issue_tracker', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='token_credential', to='issuetracker.IssueTracker')),
            ],
            options={
                'db_table': 'issue_tracker_token_credential',
            },
        ),
        migrations.CreateModel(
            name='UserPwdCredential',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('secret_file', models.CharField(blank=True, help_text='Alternative secret file in INI format including username and password.', max_length=100, null=True)),
                ('username', models.CharField(blank=True, help_text='Username to log into remote issue tracker.', max_length=100, null=True)),
                ('password', models.CharField(blank=True, help_text='Password used with username together to log into remote issue tracker.', max_length=255, null=True)),
                ('issue_tracker', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='user_pwd_credential', to='issuetracker.IssueTracker')),
            ],
            options={
                'db_table': 'issue_tracker_user_pwd_credential',
            },
        ),
        migrations.AddField(
            model_name='issuetracker',
            name='products',
            field=models.ManyToManyField(related_name='issue_trackers', through='issuetracker.ProductIssueTrackerRelationship', to='management.Product'),
        ),
        migrations.AddField(
            model_name='issuetracker',
            name='tracker_product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tracker_instances', to='issuetracker.IssueTrackerProduct'),
        ),
        migrations.AddField(
            model_name='issue',
            name='tracker',
            field=models.ForeignKey(help_text='Which issue tracker this issue belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='issues', to='issuetracker.IssueTracker'),
        ),
        migrations.AlterUniqueTogether(
            name='productissuetrackerrelationship',
            unique_together={('product', 'issue_tracker')},
        ),
        migrations.AlterUniqueTogether(
            name='issue',
            unique_together={('tracker', 'issue_key'), ('issue_key', 'case', 'case_run'), ('issue_key', 'case')},
        ),
    ]
