import setuptools
from setuptools import setup

# with open("README.md", "r") as fh:
#     long_description = fh.read()

setup(
    name="swap-python-sdk",
    version="0.1.9",
    author="",
    author_email="",
    description="SWAP Python SDK",
    # long_description=long_description,
    long_description_content_type="text/markdown",
    url="",
    packages=setuptools.find_packages(
        exclude=["*.tests", "*.tests.*", "tests.*", "tests"]
    ),
    install_requires=[
        "attrs==20.2.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "cachetools==4.1.1; python_version ~= '3.5'",
        "certifi==2020.6.20",
        "cffi==1.14.2",
        "chardet==3.0.4",
        "click==7.1.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "environs==8.0.0",
        "flask==1.1.2",
        "google-api-core[grpc]==1.22.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "google-api-python-client==1.11.0",
        "google-auth==1.21.1",
        "google-auth-httplib2==0.0.4",
        "google-auth-oauthlib==0.4.1",
        "google-cloud-core==1.4.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "google-cloud-pubsub==1.7.0",
        "google-cloud-storage==1.31.0",
        "google-crc32c==1.0.0; python_version >= '3.5'",
        "google-resumable-media==1.0.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "googleapis-common-protos[grpc]==1.52.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "grpc-google-iam-v1==0.12.3",
        "grpcio==1.29.0",
        "grpcio-tools==1.29.0",
        "httplib2==0.18.1",
        "idna==2.10; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "importlib-metadata==1.7.0; python_version < '3.8'",
        "itsdangerous==1.1.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "jinja2==2.11.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "jsonref==0.2",
        "jsonschema==3.2.0",
        "markupsafe==1.1.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "marshmallow==3.7.1",
        "oauthlib==3.1.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "protobuf==3.13.0",
        "pyasn1==0.4.8",
        "pyasn1-modules==0.2.8",
        "pycparser==2.20; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "pyjwt==1.7.1",
        "pyrsistent==0.16.0",
        "python-dotenv==0.14.0",
        "pytz==2020.1",
        "requests==2.24.0",
        "requests-oauthlib==1.3.0",
        "rsa==4.6; python_version >= '3.5'",
        "six==1.15.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2'",
        "uritemplate==3.0.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "urllib3==1.25.10; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4' and python_version < '4'",
        "werkzeug==1.0.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "zipp==3.1.0; python_version >= '3.6'",
    ],
    package_data={"swap": ["common/static/schemas/*"]},
    include_package_data=True,
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
)
