# timecast
Online time series analysis

[![pypi](https://badgen.net/pypi/v/timecast)](https://pypi.org/project/timecast/)
[![pyversions](https://img.shields.io/pypi/pyversions/timecast)](https://pypi.org/project/timecast)
[![security: bandit](https://img.shields.io/badge/security-bandit-yellow.svg)](https://github.com/PyCQA/bandit)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://github.com/MinRegret/timecast/blob/master/LICENSE)

[![build](https://github.com/MinRegret/timecast/workflows/build/badge.svg)](https://github.com/MinRegret/timecast/actions)
[![coverage](https://badgen.net/codecov/c/github/MinRegret/timecast)](https://codecov.io/github/MinRegret/timecast)
[![Documentation Status](https://readthedocs.org/projects/timecast/badge/?version=latest)](https://timecast.readthedocs.io/en/latest/?badge=latest)
[![doc coverage](https://raw.githubusercontent.com/MinRegret/timecast/master/.github/badges/docstring_coverage.svg?sanitize=true)](https://readthedocs.org/projects/timecast/)
[![tests](https://img.shields.io/azure-devops/tests/MinRegret/timecast/1?compact_message)](https://dev.azure.com/MinRegret/timecast/_build?definitionId=2&_a=summary)
[![smells](https://sonarcloud.io/api/project_badges/measure?project=danielsuo_proust&metric=code_smells)](https://sonarcloud.io/dashboard?id=danielsuo_proust)

## Setting up a development environment
[Insert typical language about using some python environment]. Within that
environment, run the following:

```python
# Install editable version of code
pip install -e .

# Install testing dependencies
pip install -e .[dev]

# Install pre-commit hooks
pre-commit install
```

## Contributing
We use the `pre-commit` tools to automatically lint (and fix, where possible)
for Python warnings, errors, and style. This runs automatically on `git commit`
and will either pass with no issue, make changes to files, and / or ask you to
make fixes. If the tests don't pass, the commit fails (a good thing! Keeps
history clean).

### Testing
We also use `pytest`, which we encourage you to run before contributing (`pytest
-n auto` for parallelized testing).

### Documentation
To update the doc coverage badge, run
```bash
docstring-coverage -b .github/badges/docstring_coverage.svg .
```

### Versioning
To update the version, run
```bash
bumpversion [major|minor|patch]
```
