"""
Common enums.
"""
from algora.common.base_enum import BaseEnum


class Order(BaseEnum):
    ASC = "ASC"
    DESC = "DESC"
    UNKNOWN = "UNKNOWN"


class SqlOperator(BaseEnum):
    NOT_IN = "NOT_IN"
    IN = "IN"
    NOT_EQUAL = "NOT_EQUAL"
    EQUAL = "EQUAL"
    LIKE = "LIKE"
    NOT_LIKE = "NOT_LIKE"
    GTE = "GTE"
    GT = "GT"
    LTE = "LTE"
    LT = "LT"
    UNKNOWN = "UNKNOWN"


class FieldType(BaseEnum):
    BOOLEAN = "BOOLEAN"
    DOUBLE = "DOUBLE"
    INTEGER = "INTEGER"
    TEXT = "TEXT"
    TIMESTAMP = "TIMESTAMP"
    DATETIME = "DATETIME"
    UNKNOWN = "UNKNOWN"


class PaymentType(BaseEnum):
    """Cash payment type, such as transaction cost"""

    MID_COST = "MID_COST"
    SLIPPAGE = "SLIPPAGE"


class UpdateRequestAction(BaseEnum):
    UPDATE = "UPDATE"
    COPY = "COPY"


class Currency(BaseEnum):
    """Currency, ISO 4217 currency code or exchange quote modifier (e.g. GBP vs GBp)"""

    _ = ""
    ACU = "ACU"
    ADP = "ADP"
    AED = "AED"
    AFA = "AFA"
    ALL = "ALL"
    AMD = "AMD"
    ANG = "ANG"
    AOA = "AOA"
    AOK = "AOK"
    AON = "AON"
    ARA = "ARA"
    ARS = "ARS"
    ARZ = "ARZ"
    ATS = "ATS"
    AUD = "AUD"
    AUZ = "AUZ"
    AZM = "AZM"
    AZN = "AZN"
    B03 = "B03"
    BAD = "BAD"
    BAK = "BAK"
    BAM = "BAM"
    BBD = "BBD"
    BDN = "BDN"
    BDT = "BDT"
    BEF = "BEF"
    BGL = "BGL"
    BGN = "BGN"
    BHD = "BHD"
    BIF = "BIF"
    BMD = "BMD"
    BND = "BND"
    BOB = "BOB"
    BR6 = "BR6"
    BRE = "BRE"
    BRF = "BRF"
    BRL = "BRL"
    BRR = "BRR"
    BSD = "BSD"
    BTC = "BTC"
    BTN = "BTN"
    BTR = "BTR"
    BWP = "BWP"
    BYR = "BYR"
    BZD = "BZD"
    C23 = "C23"
    CAC = "CAC"
    CAD = "CAD"
    CAZ = "CAZ"
    CCI = "CCI"
    CDF = "CDF"
    CFA = "CFA"
    CHF = "CHF"
    CHZ = "CHZ"
    CLF = "CLF"
    CLP = "CLP"
    CLZ = "CLZ"
    CNH = "CNH"
    CNO = "CNO"
    CNY = "CNY"
    CNZ = "CNZ"
    COP = "COP"
    COZ = "COZ"
    CPB = "CPB"
    CPI = "CPI"
    CRC = "CRC"
    CUP = "CUP"
    CVE = "CVE"
    CYP = "CYP"
    CZH = "CZH"
    CZK = "CZK"
    DAX = "DAX"
    DEM = "DEM"
    DIJ = "DIJ"
    DJF = "DJF"
    DKK = "DKK"
    DOP = "DOP"
    DZD = "DZD"
    E51 = "E51"
    E52 = "E52"
    E53 = "E53"
    E54 = "E54"
    ECI = "ECI"
    ECS = "ECS"
    ECU = "ECU"
    EEK = "EEK"
    EF0 = "EF0"
    EGP = "EGP"
    ESP = "ESP"
    ETB = "ETB"
    EUR = "EUR"
    EUZ = "EUZ"
    F06 = "F06"
    FED = "FED"
    FIM = "FIM"
    FJD = "FJD"
    FKP = "FKP"
    FRF = "FRF"
    FT1 = "FT1"
    GBP = "GBP"
    GBZ = "GBZ"
    GEK = "GEK"
    GEL = "GEL"
    GHC = "GHC"
    GHS = "GHS"
    GHY = "GHY"
    GIP = "GIP"
    GLD = "GLD"
    GLR = "GLR"
    GMD = "GMD"
    GNF = "GNF"
    GQE = "GQE"
    GRD = "GRD"
    GTQ = "GTQ"
    GWP = "GWP"
    GYD = "GYD"
    HKB = "HKB"
    HKD = "HKD"
    HNL = "HNL"
    HRK = "HRK"
    HSI = "HSI"
    HTG = "HTG"
    HUF = "HUF"
    IDB = "IDB"
    IDO = "IDO"
    IDR = "IDR"
    IEP = "IEP"
    IGP = "IGP"
    ILS = "ILS"
    INO = "INO"
    INP = "INP"
    INR = "INR"
    IPA = "IPA"
    IPX = "IPX"
    IQD = "IQD"
    IRR = "IRR"
    IRS = "IRS"
    ISI = "ISI"
    ISK = "ISK"
    ISO = "ISO"
    ITL = "ITL"
    J05 = "J05"
    JMD = "JMD"
    JNI = "JNI"
    JOD = "JOD"
    JPY = "JPY"
    JPZ = "JPZ"
    JZ9 = "JZ9"
    KES = "KES"
    KGS = "KGS"
    KHR = "KHR"
    KMF = "KMF"
    KOR = "KOR"
    KPW = "KPW"
    KRW = "KRW"
    KWD = "KWD"
    KYD = "KYD"
    KZT = "KZT"
    LAK = "LAK"
    LBA = "LBA"
    LBP = "LBP"
    LHY = "LHY"
    LKR = "LKR"
    LRD = "LRD"
    LSL = "LSL"
    LSM = "LSM"
    LTL = "LTL"
    LUF = "LUF"
    LVL = "LVL"
    LYD = "LYD"
    MAD = "MAD"
    MDL = "MDL"
    MGF = "MGF"
    MKD = "MKD"
    MMK = "MMK"
    MNT = "MNT"
    MOP = "MOP"
    MRO = "MRO"
    MTP = "MTP"
    MUR = "MUR"
    MVR = "MVR"
    MWK = "MWK"
    MXB = "MXB"
    MXN = "MXN"
    MXP = "MXP"
    MXW = "MXW"
    MXZ = "MXZ"
    MYO = "MYO"
    MYR = "MYR"
    MZM = "MZM"
    MZN = "MZN"
    NAD = "NAD"
    ND3 = "ND3"
    NGF = "NGF"
    NGI = "NGI"
    NGN = "NGN"
    NIC = "NIC"
    NLG = "NLG"
    NOK = "NOK"
    NOZ = "NOZ"
    NPR = "NPR"
    NZD = "NZD"
    NZZ = "NZZ"
    O08 = "O08"
    OMR = "OMR"
    PAB = "PAB"
    PEI = "PEI"
    PEN = "PEN"
    PEZ = "PEZ"
    PGK = "PGK"
    PHP = "PHP"
    PKR = "PKR"
    PLN = "PLN"
    PLZ = "PLZ"
    PSI = "PSI"
    PTE = "PTE"
    PYG = "PYG"
    QAR = "QAR"
    R2K = "R2K"
    ROL = "ROL"
    RON = "RON"
    RSD = "RSD"
    RUB = "RUB"
    RUF = "RUF"
    RUR = "RUR"
    RWF = "RWF"
    SAR = "SAR"
    SBD = "SBD"
    SCR = "SCR"
    SDP = "SDP"
    SDR = "SDR"
    SEK = "SEK"
    SET = "SET"
    SGD = "SGD"
    SGS = "SGS"
    SHP = "SHP"
    SKK = "SKK"
    SLL = "SLL"
    SRG = "SRG"
    SSI = "SSI"
    STD = "STD"
    SUR = "SUR"
    SVC = "SVC"
    SVT = "SVT"
    SYP = "SYP"
    SZL = "SZL"
    T21 = "T21"
    T51 = "T51"
    T52 = "T52"
    T53 = "T53"
    T54 = "T54"
    T55 = "T55"
    T71 = "T71"
    TE0 = "TE0"
    TED = "TED"
    TF9 = "TF9"
    THB = "THB"
    THO = "THO"
    TMM = "TMM"
    TND = "TND"
    TNT = "TNT"
    TOP = "TOP"
    TPE = "TPE"
    TPX = "TPX"
    TRB = "TRB"
    TRL = "TRL"
    TRY = "TRY"
    TRZ = "TRZ"
    TTD = "TTD"
    TWD = "TWD"
    TZS = "TZS"
    UAH = "UAH"
    UCB = "UCB"
    UDI = "UDI"
    UFC = "UFC"
    UFZ = "UFZ"
    UGS = "UGS"
    UGX = "UGX"
    USB = "USB"
    USD = "USD"
    UVR = "UVR"
    UYP = "UYP"
    UYU = "UYU"
    UZS = "UZS"
    VAC = "VAC"
    VEB = "VEB"
    VEF = "VEF"
    VES = "VES"
    VND = "VND"
    VUV = "VUV"
    WST = "WST"
    XAF = "XAF"
    XAG = "XAG"
    XAU = "XAU"
    XPD = "XPD"
    XPT = "XPT"
    XCD = "XCD"
    XDR = "XDR"
    XEU = "XEU"
    XOF = "XOF"
    XPF = "XPF"
    YDD = "YDD"
    YER = "YER"
    YUD = "YUD"
    YUN = "YUN"
    ZAL = "ZAL"
    ZAR = "ZAR"
    ZAZ = "ZAZ"
    ZMK = "ZMK"
    ZMW = "ZMW"
    ZRN = "ZRN"
    ZRZ = "ZRZ"
    ZWD = "ZWD"
    AUd = "AUd"
    BWp = "BWp"
    EUr = "EUr"
    GBp = "GBp"
    ILs = "ILs"
    KWd = "KWd"
    MWk = "MWk"
    SGd = "SGd"
    SZl = "SZl"
    USd = "USd"
    ZAr = "ZAr"
