import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AppRunner::Service`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export interface CfnServiceProps {
    /**
     * `AWS::AppRunner::Service.SourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration
     */
    readonly sourceConfiguration: CfnService.SourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::AppRunner::Service.AutoScalingConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn
     */
    readonly autoScalingConfigurationArn?: string;
    /**
     * `AWS::AppRunner::Service.EncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration
     */
    readonly encryptionConfiguration?: CfnService.EncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::AppRunner::Service.HealthCheckConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration
     */
    readonly healthCheckConfiguration?: CfnService.HealthCheckConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::AppRunner::Service.InstanceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration
     */
    readonly instanceConfiguration?: CfnService.InstanceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::AppRunner::Service.ServiceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename
     */
    readonly serviceName?: string;
    /**
     * `AWS::AppRunner::Service.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare class CfnService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppRunner::Service";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnService;
    /**
     * @external
     * @cloudformationAttribute ServiceArn
     */
    readonly attrServiceArn: string;
    /**
     * @external
     * @cloudformationAttribute ServiceId
     */
    readonly attrServiceId: string;
    /**
     * @external
     * @cloudformationAttribute ServiceUrl
     */
    readonly attrServiceUrl: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::AppRunner::Service.SourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration
     */
    sourceConfiguration: CfnService.SourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::AppRunner::Service.AutoScalingConfigurationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn
     */
    autoScalingConfigurationArn: string | undefined;
    /**
     * `AWS::AppRunner::Service.EncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration
     */
    encryptionConfiguration: CfnService.EncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppRunner::Service.HealthCheckConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration
     */
    healthCheckConfiguration: CfnService.HealthCheckConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppRunner::Service.InstanceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration
     */
    instanceConfiguration: CfnService.InstanceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppRunner::Service.ServiceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename
     */
    serviceName: string | undefined;
    /**
     * `AWS::AppRunner::Service.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppRunner::Service`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnServiceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html
     */
    interface AuthenticationConfigurationProperty {
        /**
         * `CfnService.AuthenticationConfigurationProperty.AccessRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-accessrolearn
         */
        readonly accessRoleArn?: string;
        /**
         * `CfnService.AuthenticationConfigurationProperty.ConnectionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-connectionarn
         */
        readonly connectionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html
     */
    interface CodeConfigurationProperty {
        /**
         * `CfnService.CodeConfigurationProperty.CodeConfigurationValues`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-codeconfigurationvalues
         */
        readonly codeConfigurationValues?: CfnService.CodeConfigurationValuesProperty | cdk.IResolvable;
        /**
         * `CfnService.CodeConfigurationProperty.ConfigurationSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-configurationsource
         */
        readonly configurationSource: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html
     */
    interface CodeConfigurationValuesProperty {
        /**
         * `CfnService.CodeConfigurationValuesProperty.BuildCommand`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-buildcommand
         */
        readonly buildCommand?: string;
        /**
         * `CfnService.CodeConfigurationValuesProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-port
         */
        readonly port?: string;
        /**
         * `CfnService.CodeConfigurationValuesProperty.Runtime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime
         */
        readonly runtime: string;
        /**
         * `CfnService.CodeConfigurationValuesProperty.RuntimeEnvironmentVariables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtimeenvironmentvariables
         */
        readonly runtimeEnvironmentVariables?: Array<CfnService.KeyValuePairProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnService.CodeConfigurationValuesProperty.StartCommand`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-startcommand
         */
        readonly startCommand?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html
     */
    interface CodeRepositoryProperty {
        /**
         * `CfnService.CodeRepositoryProperty.CodeConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-codeconfiguration
         */
        readonly codeConfiguration?: CfnService.CodeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnService.CodeRepositoryProperty.RepositoryUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-repositoryurl
         */
        readonly repositoryUrl: string;
        /**
         * `CfnService.CodeRepositoryProperty.SourceCodeVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-sourcecodeversion
         */
        readonly sourceCodeVersion: CfnService.SourceCodeVersionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnService.EncryptionConfigurationProperty.KmsKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html#cfn-apprunner-service-encryptionconfiguration-kmskey
         */
        readonly kmsKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html
     */
    interface HealthCheckConfigurationProperty {
        /**
         * `CfnService.HealthCheckConfigurationProperty.HealthyThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-healthythreshold
         */
        readonly healthyThreshold?: number;
        /**
         * `CfnService.HealthCheckConfigurationProperty.Interval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-interval
         */
        readonly interval?: number;
        /**
         * `CfnService.HealthCheckConfigurationProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-path
         */
        readonly path?: string;
        /**
         * `CfnService.HealthCheckConfigurationProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnService.HealthCheckConfigurationProperty.Timeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-timeout
         */
        readonly timeout?: number;
        /**
         * `CfnService.HealthCheckConfigurationProperty.UnhealthyThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-unhealthythreshold
         */
        readonly unhealthyThreshold?: number;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html
     */
    interface ImageConfigurationProperty {
        /**
         * `CfnService.ImageConfigurationProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port
         */
        readonly port?: string;
        /**
         * `CfnService.ImageConfigurationProperty.RuntimeEnvironmentVariables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-runtimeenvironmentvariables
         */
        readonly runtimeEnvironmentVariables?: Array<CfnService.KeyValuePairProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnService.ImageConfigurationProperty.StartCommand`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-startcommand
         */
        readonly startCommand?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html
     */
    interface ImageRepositoryProperty {
        /**
         * `CfnService.ImageRepositoryProperty.ImageConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageconfiguration
         */
        readonly imageConfiguration?: CfnService.ImageConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnService.ImageRepositoryProperty.ImageIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageidentifier
         */
        readonly imageIdentifier: string;
        /**
         * `CfnService.ImageRepositoryProperty.ImageRepositoryType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imagerepositorytype
         */
        readonly imageRepositoryType: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html
     */
    interface InstanceConfigurationProperty {
        /**
         * `CfnService.InstanceConfigurationProperty.Cpu`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
         */
        readonly cpu?: string;
        /**
         * `CfnService.InstanceConfigurationProperty.InstanceRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-instancerolearn
         */
        readonly instanceRoleArn?: string;
        /**
         * `CfnService.InstanceConfigurationProperty.Memory`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
         */
        readonly memory?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html
     */
    interface KeyValuePairProperty {
        /**
         * `CfnService.KeyValuePairProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-name
         */
        readonly name?: string;
        /**
         * `CfnService.KeyValuePairProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html
     */
    interface SourceCodeVersionProperty {
        /**
         * `CfnService.SourceCodeVersionProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-type
         */
        readonly type: string;
        /**
         * `CfnService.SourceCodeVersionProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AppRunner::Service`.
 *
 * @external
 * @cloudformationResource AWS::AppRunner::Service
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html
 */
export declare namespace CfnService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html
     */
    interface SourceConfigurationProperty {
        /**
         * `CfnService.SourceConfigurationProperty.AuthenticationConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-authenticationconfiguration
         */
        readonly authenticationConfiguration?: CfnService.AuthenticationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnService.SourceConfigurationProperty.AutoDeploymentsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-autodeploymentsenabled
         */
        readonly autoDeploymentsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnService.SourceConfigurationProperty.CodeRepository`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-coderepository
         */
        readonly codeRepository?: CfnService.CodeRepositoryProperty | cdk.IResolvable;
        /**
         * `CfnService.SourceConfigurationProperty.ImageRepository`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-imagerepository
         */
        readonly imageRepository?: CfnService.ImageRepositoryProperty | cdk.IResolvable;
    }
}
