import numpy as np
from py3gpp.nrPolarDecode import nrPolarDecode
from py3gpp.nrRateRecoverPolar import nrRateRecoverPolar
from py3gpp.nrCRCDecode import nrCRCDecode
from py3gpp.nrPBCHPRBS import nrPBCHPRBS


def nrBCHDecode(softbits, L, lssb=None, ncellid=None):
    K = 32
    E = 864
    L = 8
    N = 512
    matched = nrRateRecoverPolar(softbits, K, N, False, False)

    decoded = nrPolarDecode(matched, K, E, L)
    scrblk, crc_result = nrCRCDecode(decoded, "24C")

    if (lssb is None) or (ncellid is None):
        return scrblk, crc_result

    # descrambling according to TS38.212 7.1.2
    # fmt: off
    G = [16, 23, 18, 17, 8, 30, 10, 6, 24, 7, 0, 5, 3, 2, 1, 4, 9, 11, 12, 13, 14, 15, 19, 20, 21, 22, 25, 26, 27, 28,
         29, 31]
    # fmt: on
    SFN_PAYLOAD_BEGIN = 1
    SFN_PAYLOAD_LENGTH = 6
    SFN_2ND_LSB = SFN_PAYLOAD_LENGTH + 2
    SFN_3RD_LSB = SFN_PAYLOAD_LENGTH + 1
    v = 2 * scrblk[G[SFN_3RD_LSB]] + scrblk[G[SFN_2ND_LSB]]

    L_max = 8  # TODO: fix this
    A = 32
    if L_max in (4, 8):
        M = A - 3
    else:
        M = A - 6
    n = v * M
    tmp_seq = nrPBCHPRBS(ncellid, 0, len(scrblk) * 100)
    scrambling_seq = tmp_seq[n:][:A]
    scrambling_seq_final = np.zeros(A, "int")
    j = 0
    for i in range(A):
        is_ssb_idx = (i in (G[11], G[12], G[13])) and L_max == 64
        if is_ssb_idx or i == G[10] or i == G[SFN_2ND_LSB] or i == G[SFN_3RD_LSB]:
            scrambling_seq_final[i] = 0
        else:
            scrambling_seq_final[i] = scrambling_seq[j]
            j += 1
    a = np.bitwise_xor(scrambling_seq_final, scrblk)

    # deinterleaving according to TS38.212 7.1.1
    j_sfn = 0
    j_other = 14
    payload = np.empty(24, "int")
    for i in range(24):
        if (i >= SFN_PAYLOAD_BEGIN) and (i < (SFN_PAYLOAD_BEGIN + SFN_PAYLOAD_LENGTH)):
            payload[i] = a[G[j_sfn]]
            j_sfn += 1
        else:
            payload[i] = a[G[j_other]]
            j_other += 1
    lsbotfsfn = np.array([a[G[j_sfn]], a[G[j_sfn + 1]], a[G[j_sfn + 2]], a[G[j_sfn + 3]]])
    hrf = a[G[10]]
    msbidxoffset = 0  # TODO calculate this
    return scrblk, crc_result, payload, lsbotfsfn, hrf, msbidxoffset


def test_nrBCHDecode():
    # 3627MHz, 30720 KSPS
    # fmt: off
    softbits = np.array([98.0994, 100.2936, -100.1615, -111.2452, -101.7249, -101.5950, 78.5901, -77.7265, -76.4686, -81.3223, -115.8069, 89.6047, 85.9367, 104.1048, -98.2053, -106.7203, 83.1207, 88.2861, 83.8204, -109.2175, -124.4919, 94.6728, 91.5959, -89.5352, -101.8143, -123.6915, -103.1579, -108.0879, 100.9417, -95.5231, 122.5312, 99.6845, -78.9441, 115.9421, 65.5815, 90.9532, -88.9573, -85.7132, -83.5216, -78.7969, -54.1358, 75.8672, 84.9239, -89.5731, -92.8101, -76.0732, 72.9594, -74.3997, -68.2989, 93.4047, 95.1260, 79.8283, 80.2065, -89.3344, 68.9841, -77.7767, 95.8681, -79.4709, 62.2583, -63.4266, -91.1614, 81.0331, -83.1753, -95.7477, 93.8353, -80.0016, 83.2706, -104.8245, 75.5381, -89.3799, 86.4390, 84.6055, 43.8157, -100.4702, -79.0332, -89.0215, 109.9606, -99.6110, 111.9779, -101.8772, 79.3811, -78.2227, 109.3239, -70.7376, -90.1096, -93.8385, -83.5296, 79.8664, -107.2777, 86.7808, -83.8104, -89.5405, 83.9844, 88.8928, -114.4005, -81.6010, 68.2572, 100.1189, -94.9682, -106.6306, 94.3960, -75.7935, -80.0656, -80.4422, 80.0088, 78.5461, -101.9442, 101.2641, 79.4489, -82.3328, 85.9272, -93.2934, 96.1777, 88.5216, 84.3977, -82.6021, 84.0117, 95.0405, -86.1691, -74.1916, 108.7456, 86.4657, -75.5564, -99.4773, 74.5251, 98.5329, -83.2432, 70.5688, -68.4671, -79.3403, -62.6724, -60.8476, 67.8379, 91.1800, 87.8499, -101.2957, -69.6481, -74.5603, 70.1766, -99.2101, 101.3056, 57.1986, 87.5917, 84.1423, -76.4349, -65.0490, 66.5703, 77.3265, 70.3819, 58.6750, -61.8244, 94.9379, 68.1455, 80.8718, 71.4065, -89.3790, -42.6856, -64.9363, 76.2369, 69.3416, -66.9824, -62.7680, 60.1339, -78.9674, 65.3749, -64.6940, 50.0190, -89.6008, -59.3167, -63.1129, 61.5982, 48.8499, 65.2957, -44.2573, -67.7464, -87.8192, -64.3863, -64.0232, -58.3138, 79.5344, 67.9879, -79.1206, -79.1714, 60.2715, 72.0637, 87.6743, 87.1759, 81.4093, -74.1212, 100.5560, -82.5535, -56.7645, 73.3080, -55.5333, 61.1872, 83.1372, 72.6622, 56.7458, -90.9942, -99.5641, -62.1492, 75.1305, -67.2248, 82.1078, -71.9184, -96.0142, -82.4769, 63.0060, 90.7906, -100.7988, -64.6227, -98.9736, 89.3586, 78.5604, 99.6034, 55.0377, 83.2926, -72.7276, -98.3970, 71.7933, 61.7939, 67.9014, -69.5731, 73.2906, -78.2155, 88.4656, 78.1025, -62.1181, -66.5374, 74.3818, 84.9285, 65.4854, 60.3368, -59.9013, 62.8409, 45.3090, 58.8132, -90.1745, -80.5019, 76.9129, -70.8013, 63.1397, -52.9220, 80.8111, -76.1652, 76.7023, -66.0006, -52.8898, -67.6308, 85.2930, 78.6230, 75.2349, -75.5770, 61.5977, -82.0592, 56.5244, 53.0226, -60.5902, 68.6878, 71.6496, -79.5789, 68.2251, 69.2261, -57.2262, 67.4926, -56.8821, -78.9174, 54.9742, -77.1147, 72.3281, 45.8284, 74.1518, 73.6083, -91.9549, -48.5210, -68.8685, -87.2434, 55.9644, -90.2183, 76.1801, -85.3346, 66.5699, -93.3345, 46.6941, 74.9255, -85.1393, 65.0381, 59.5640, -96.2469, 74.1641, 71.7959, -84.9770, 75.2968, 43.3046, -75.7478, 79.3113, -67.3357, 83.5540, 88.1043, 92.9397, 60.5756, 96.0108, 68.6091, 56.8510, -65.9826, 84.1422, -68.0985, 74.0803, 66.0246, 83.8283, 78.7515, -80.7086, 52.4481, -66.9362, 56.3773, 65.2047, -60.8237, -76.4423, 79.9544, 76.8582, -81.4292, -84.7288, -61.2944, -77.7179, -74.2870, 73.8435, -68.7351, -50.0336, 55.0304, 84.1329, 68.3470, -42.6786, 51.2943, -66.9083, -66.1926, 79.1121, -76.3870, -74.6423, 50.1182, 43.6267, -69.2405, 65.5949, 78.9524, 64.1765, -55.5729, -64.7979, 61.4107, -74.2137, -74.3217, 62.0394, -74.1537, 69.4664, -59.2044, -69.6405, 89.3530, -68.6773, -78.4004, -57.7046, -56.9396, -56.8815, 84.8120, 85.3458, 72.9297, 90.6085, 110.8704, 81.9232, 78.7975, -75.6312, -96.5727, -98.9427, -77.9188, 81.6283, -92.4196, -81.5016, 116.7946, 111.1792, -104.2775, -102.8753, 105.5464, 73.3699, -121.8863, -83.9218, 99.9105, -76.7338, 71.2199, 84.3709, 123.7199, 78.3144, -110.0666, -102.4246, -94.3307, 82.9367, 96.7602, 97.7912, -85.7501, 88.8595, -71.4018, -73.5545, -58.8523, -103.0843, 97.3005, 78.5062, -109.6570, 85.2691, -91.4737, 87.4685, -87.5806, 106.0338, 76.4113, 112.0384, -78.9545, -67.7884, -70.9985, 84.6570, 98.7297, 91.5841, -83.0778, 108.2129, -94.8490, -87.3756, -111.9341, -86.7001, 95.5885, 115.4110, 72.8125, -106.4446, 80.6854, -90.9581, 87.6573, 68.6028, 103.3637, -92.1900, -74.7351, 68.3605, -64.5109, -86.4599, 92.2079, -62.3135, -47.5140, 74.8112, -55.6607, 72.2295, 98.2756, -54.4462, 104.4787, -76.8929, -84.0509, -87.5470, 73.5025, -53.7392, -64.1919, 106.1772, 79.7842, -69.1110, -79.4048, -98.8703, -57.1228, 62.4514, -93.6077, -45.7700, -68.4287, 71.8675, 66.7427, -63.6768, 88.1545, -38.5373, -73.9172, 86.9245, -65.0378, -62.6790, 76.2379, -54.8815, 70.4215, -64.9437, -64.9268, -78.1091, -52.9684, -53.5112, -67.4531, -47.4951, 54.0182, 62.7692, 47.2771, 64.6934, 62.8590, -63.9107, 52.5923, 69.3743, -64.8862, -76.7852, -60.9050, 51.3035, -61.0244, 75.3462, 66.0729, -50.1459, 61.4202, 80.4490, -65.3638, 65.9481, 66.2290, 68.6534, 48.4402, 76.8827, -88.6572, -102.7420, -94.8729, -128.7776, -122.5039, -111.4672, -105.0354, 107.5132, 103.2147, 78.4791, -91.9850, -118.4194, -89.0634, -99.9338, 68.9210, -113.2486, -88.3158, -77.0076, -84.4593, 114.6763, 96.4872, 78.5846, -65.8721, -113.1152, 103.4743, 124.3876, 74.8503, -111.0042, -115.5840, 75.8457, 107.1602, -101.2862, -89.0443, -131.2639, -95.0169, -101.6776, 106.5587, -78.8672, 92.0872, 105.8629, -109.0139, 50.6957, 105.2203, 100.3173, -83.0163, -97.1313, -102.9198, -86.2367, -100.8920, 86.1522, 104.5341, -74.0529, -89.6591, -101.4711, 98.3851, -92.3188, -59.4171, 86.5606, 95.3560, 76.2519, 86.0034, -75.5908, 89.9902, -103.9601, 84.5431, -83.6168, 96.2207, -84.1777, -80.5586, 106.1140, -76.2755, -92.6383, 108.8716, -95.8761, 80.0378, -67.9769, 65.6445, -116.9681, 85.3114, 109.5884, 91.3763, -90.7064, -61.7081, -79.5426, 89.5249, -81.9820, 70.1122, -97.1048, 71.0162, -72.2081, 70.7452, -68.1885, -78.1658, -64.9691, -88.9413, 70.8800, -73.4284, 67.9446, -79.6382, -91.0749, 77.7375, 68.4846, -82.4107, -79.2529, 81.4335, 72.5728, -89.3588, -78.6540, 92.1629, -65.8376, -76.2695, -83.2549, 80.5638, 94.5750, -60.8127, 73.1588, 77.3830, -64.2280, 87.9001, -50.0027, 74.8442, 77.8280, 84.9365, -70.2339, 64.0379, 57.4044, -59.0314, -88.0455, 72.6950, 98.6087, -71.2674, -94.3452, 73.3607, 71.5727, -75.9903, 80.2090, -50.2199, -75.6587, -86.5366, -103.7038, 70.0617, 90.0493, 89.7471, -88.2946, -54.0257, -87.2369, 104.4625, -101.5353, 75.7854, 68.2742, 80.7305, 77.2729, -83.7552, -90.5382, 70.7754, 67.1356, 88.4907, 89.6675, -83.6852, 56.8200, 83.4220, 49.2676, 80.1260, -67.0996, -100.2257, -62.5562, 75.4357, 91.5392, -83.0123, -80.0729, 88.1559, -55.6654, 58.4997, -59.6680, 59.0821, -54.8626, -62.0851, -75.4294, 80.2651, 95.2739, 56.2296, -84.7247, -84.6150, -88.8262, -89.2111, -75.9162, -82.6932, 103.5515, 77.6816, -80.6825, -64.4125, 94.4056, 85.2704, 69.7562, 71.3295, 82.7432, -94.7477, 78.6021, -70.5708, -84.3440, 61.8713, -63.7839, 78.0555, 72.4840, 87.6374, 80.3411, -73.9080, -70.8911, -65.8246, 86.3262, -61.6859, 82.9255, -84.0396, -82.9138, -77.9931, 89.1368, 91.1653, -58.5482, -83.5073, -91.3116, 81.2495, 72.2874, 50.0016, 78.0471, 75.1215, -56.0254, -74.3332, 71.5110, 73.3624, 88.9567, -75.8943, 79.7566, -78.3273, 64.4678, 69.8261, -79.9440, -71.2289, 75.2226, 86.5812, 57.9802, 87.2199, -81.0658, 65.3986, 86.4986, 69.7224, -61.1344, -105.0467, 69.2449, -70.9433, 83.4344, -66.6032, 45.1522, -79.4094, 100.2277, -78.2417, -56.4543, -73.5083, 69.4708, 78.7618, 81.4791, -70.0314, 62.5427, -71.5135, 80.7320, 90.4718, -52.8129, 63.6561, 73.7117, -78.8202, 79.6381, 53.8892, -93.3015, 73.8935, -52.2579, -60.2833, 73.9423, -54.7339, 84.4312, 56.7623, 71.1906, 89.4435, -49.7766, -80.5811, -55.8977, -58.8677, 65.5685, -59.9771, 65.0678, -81.6615, 90.2745, -74.4305, 63.1864, 83.6006, -61.6714, 90.0837, 48.1648, -84.9140, 78.1148, 71.4074, -57.1791, 67.8951, 68.7683, -70.2009, 83.4573, -74.6282, 77.8962, 59.5611, 97.0689, 64.6330, 78.7713, 97.5969, 69.7465, -43.0201, 48.7812, -49.1213, 82.9030, 83.1607, 68.3046, 54.6260, -102.0873, 50.2760, -89.6055, 94.5197, 79.3946, -75.8153, -67.4159, 67.0226, 77.0560, -53.7410, -77.2953, -72.9407, -71.2448, -42.4205, 56.0560, -60.4946, -76.4592, 54.7078, 56.2773, 59.4870, -65.7878, 73.5729, -55.4234, -85.4392, 48.5772, -81.6894, -49.8058, 65.9435, 76.8729, -44.9569, 75.1489, 80.0595, 63.9259, -54.6950, -72.6381, 47.5685, -70.2114, -36.2244, 61.3018, -57.1606, 48.6657])
    # fmt: on
    L = 8
    n_cellid = 967
    scrblk, crc_result, trblk, sfn4lsb, nHalfFrame, msbidxoffset = nrBCHDecode(softbits, L, 8, n_cellid)
    assert crc_result == 0, "nrBCHDecode CRC mismatch"
    # fmt: off
    scrblk_matlab = np.array([0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0])
    # fmt: on
    assert np.all(scrblk == scrblk_matlab), "nrBCHDecode scrblk mismatch"
    trblk_matlab = np.array([0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1])
    assert np.all(trblk == trblk_matlab), "nrBCHDecode trblk mismatch"
    assert np.all(sfn4lsb == np.array([0, 1, 1, 0])), "nrBCHDecode sfn4lsb mismatch"

    # 763 MHz, 15360 KSPS
    # fmt: off
    softbits = np.array([82.5750, 113.3921, -80.0223, -107.9469, 107.1828, 82.3972, -99.3177, -83.2826, 63.0573, -76.3982, -58.7430, 75.1685, 56.7567, 83.3607, -90.2660, -83.3609, -84.4812, -109.7901, 91.0847, -100.7578, 87.3754, 108.0147, -107.5424, 75.3873, 85.0611, -90.1551, -95.3247, -88.2591, -99.9391, -59.3420, 53.8979, -78.8893, -99.1796, -80.9242, -99.4671, -113.2637, 120.0966, -94.9459, 112.9044, -113.1659, 116.1122, -119.1580, -103.7929, 130.9606, -110.3838, 94.9982, 108.2276, -88.4509, -99.3462, -99.0186, -105.4547, -87.7845, -100.2287, -111.1923, -126.2514, -99.8499, 115.5299, -103.7754, 113.9903, -114.6728, 101.5987, 91.7459, 123.4426, 116.1098, 128.6089, 147.3167, 135.0334, -105.8058, 111.7742, -91.0208, 100.9787, 112.4169, 106.0920, -112.7692, -113.3942, -94.6016, 119.8624, -129.4268, -129.0784, -139.0027, -147.4339, -137.9706, -139.7371, 168.9476, 118.4564, 133.6139, 123.6344, -122.2581, -130.2336, 116.2150, -130.3959, -121.6971, 117.4981, 134.3620, 120.6320, -114.5065, 102.9050, 142.2294, -139.4960, -108.3635, -114.8796, 116.9040, 133.5083, -120.5103, 114.4581, -114.2923, 144.9352, -93.3072, -133.0601, 89.0811, -95.3975, 117.8231, 127.8072, 141.5036, -172.1390, 146.4898, 175.3758, -128.9291, -160.0553, -108.6573, -139.1393, 115.5183, -130.3919, -129.3820, -121.7200, 133.7360, -119.7581, -121.8150, 146.7024, 143.4000, 137.7670, 141.5597, 132.0067, 134.8745, 157.4775, 141.3887, -146.0634, 132.7527, -127.6803, 111.7439, -152.9079, -133.7437, -137.9670, -122.4805, -123.4011, -104.2477, 139.1322, 96.3771, -100.8671, -124.5910, 154.4445, 117.7623, -123.8879, 115.8072, 128.3588, -152.7402, -112.7132, -120.0929, 124.6848, 104.5612, -125.7529, -127.8855, -112.3819, 88.0618, 128.8829, 107.9122, 114.0298, -124.5468, -119.2659, 148.5332, -80.4229, -140.1450, 124.0993, 130.2999, 131.2856, -88.2892, 121.9778, 146.9438, -107.2020, 122.5428, -122.2951, -119.7113, 131.3325, -120.8516, -88.9099, 109.7756, 88.6699, 99.8972, 95.4893, 130.2544, -103.1554, 115.4828, -117.2606, -114.4294, 112.2838, 132.6565, 112.5561, -81.8013, -91.7419, 130.7606, -104.7168, 100.6019, -107.1938, 120.2243, 143.2509, -114.9247, 109.7027, -121.6213, 138.1879, 96.2803, 134.0618, 124.3492, -93.6536, 105.3695, -102.0471, 152.2889, -109.5598, 121.8715, 108.5998, -77.9316, 108.9791, -108.8592, -81.2293, 106.5347, 121.8417, 121.6304, -97.6023, 93.4441, 115.1223, -111.6224, -110.5655, -113.6080, -93.5121, 112.5508, -122.9158, -98.2309, -95.6772, 100.6279, -107.4098, -115.0877, -99.7082, -126.0933, -88.8253, 95.0749, -105.8976, 86.6394, -111.7056, -107.5135, -105.1683, 110.4049, 130.9100, 103.4700, -113.2755, 142.1104, 120.0209, 140.3338, -127.9207, -103.8298, 102.5930, 105.2434, -102.3209, -122.8679, 114.2258, 133.6379, -117.0037, 104.6195, 119.2559, -108.5925, -121.1894, -111.2413, 137.9461, 137.4382, 156.4242, 115.4223, 99.7335, 125.8445, 103.2774, 146.0504, 126.7507, 114.0518, -118.1504, 134.7480, -153.7985, 123.1097, -138.7996, -159.0199, -118.6106, -148.7355, -166.7645, -142.8961, 146.8005, -141.9136, 151.2512, 163.2981, -130.7950, 157.8577, 144.7501, -169.6860, -156.2705, -152.5093, -140.9826, -154.6105, 162.4890, -167.0813, 180.2118, 155.2139, 167.6711, -193.8353, -166.8299, -199.1618, -148.8544, 140.9397, 130.0787, -173.0331, 164.6123, 171.1981, -176.7927, -160.5573, -180.7434, 148.3250, 188.5417, 159.1370, 153.6430, 169.8628, -159.9139, 141.8233, -141.9024, 128.7954, -142.3331, 143.9670, 143.9358, -162.6456, 162.9169, -168.8708, -160.2417, 178.5514, -135.3742, -163.3955, 146.2148, 144.1944, 148.8045, -191.6442, -161.4174, 170.2638, -158.9688, 183.1682, -164.9548, 198.1992, 182.4017, -168.5952, 155.6881, -155.9664, 146.3857, 165.9731, 134.3682, -140.8322, 182.6997, -127.7343, 153.0142, 127.8926, 79.7846, -111.8354, -88.4584, -93.5406, 87.0468, -97.9718, -94.4564, -92.8716, -85.3790, -79.3785, 90.9018, -88.5981, -57.6750, 85.2261, 107.1603, 87.0861, 54.3545, -123.3165, 114.7896, 94.5555, 103.1447, -111.6793, 112.7708, 91.5155, -125.1716, -83.5019, -120.1686, -103.2582, -92.5963, -124.1001, -100.5143, -126.1645, 102.8390, -105.0328, 94.1511, -93.2265, 113.5997, 107.5787, 120.7173, 129.9468, 125.1875, 121.0117, 144.5051, -118.8835, -91.9924, -97.7512, -113.7258, 118.5452, 79.0600, -106.4509, 91.9206, 110.7021, -110.2726, -121.3606, -85.0726, 112.4517, 124.2706, 107.6742, -109.1589, -107.6235, -117.0310, 161.8372, 107.8281, -101.5878, 144.9284, -163.3965, 133.1566, -126.3896, -153.9877, 123.1329, -163.4600, 109.7547, 126.4185, 147.6662, -134.8376, -168.7568, 133.6947, 135.1979, -133.3918, -137.8377, 140.2286, -143.0219, -142.7813, 134.5299, 164.5272, 166.1977, -147.4292, -153.2312, -160.5116, -159.0015, 171.8143, -168.8520, -130.0848, 176.7736, 170.9887, 163.4369, 159.9409, -184.5917, 173.7362, 184.5632, 169.4585, -151.0317, 153.1556, 205.3197, 149.7317, 184.7204, -173.2542, 173.0971, -158.5936, -165.3253, 150.7521, -170.7971, -211.2068, 143.9106, 167.8748, 156.6539, 145.1632, 174.3617, -154.5459, 122.6319, -149.8160, -191.8253, -180.1576, -171.0038, 179.7277, -163.9454, 163.3425, -140.1815, 149.1972, -147.3440, -159.8726, 138.3285, -156.8236, 148.8570, 144.2687, -133.2399, -164.4516, -125.7419, -162.5756, 151.3408, -174.0279, 108.1955, -125.9024, -171.5926, -96.7717, 63.6126, 57.9602, 90.2093, -100.1450, 88.8259, 75.4796, 98.2771, 55.4740, 93.4507, -74.4340, -85.7365, 87.4715, 58.2564, -52.6425, -104.5773, 69.1102, -86.9357, -93.8170, 98.6647, 117.1150, 84.8759, -111.5262, -100.3369, -110.7571, -57.3404, 64.3638, -114.1491, 120.8146, 67.6023, -108.2190, 85.3514, 95.2874, -110.2713, -87.5335, -114.7666, -99.5823, -111.4816, 111.5668, -97.0641, -109.5932, -100.9237, -121.2483, -95.5747, 89.0462, -88.6349, 114.8752, -120.9783, 114.7983, -83.7736, -126.0205, 88.2298, -115.6184, 94.9599, 125.0192, -120.4913, -117.4119, -132.4650, -87.5749, -107.4384, -128.7228, -133.8102, -157.9953, -159.9163, 105.3687, -116.4501, 166.1505, -105.4588, 130.4902, 101.7602, 121.5602, 137.3694, 137.8802, 147.2730, 131.5072, -122.0718, 121.9478, -145.3853, 128.3672, 161.0570, 155.3975, -126.6754, -128.6952, -140.2077, 131.8614, -122.0646, -143.7984, -141.2273, -133.7571, -139.3787, -137.5789, 123.0765, 152.1266, 121.5626, 140.5875, -150.3690, -129.4814, 144.5130, -136.1234, -123.1712, 130.6739, 99.4281, 118.0780, -116.1446, 112.0309, 127.3234, -123.2876, -134.7226, -134.0430, 120.2659, 153.7417, -128.2490, 153.0122, -125.0609, 115.6891, -161.8799, -147.0173, 112.2619, -133.0227, 137.1605, 113.3008, 101.3802, -136.4892, 119.7385, 125.4681, -115.6768, -141.5562, -114.5742, -125.8031, 153.9496, -138.7724, -133.8690, -140.8807, 142.2572, -111.2552, -115.9100, 122.1576, 108.4045, 131.3098, 154.2692, 137.8089, 130.2091, 137.8157, 131.2618, -127.4708, 149.4783, -122.3172, 150.5876, -124.2237, -140.8865, -121.2710, -141.0779, -132.6206, -141.4449, 137.7812, 117.0035, -140.3325, -137.6557, 136.0747, 99.6773, -97.4987, 126.4665, 105.1043, -132.5817, -117.5495, -119.1149, 122.7755, 148.1779, -119.3301, -108.0891, -117.7185, 108.8029, 131.9922, 133.0347, 116.3098, -148.9990, -113.1766, 138.5013, -121.9871, -115.0572, 115.1980, 128.4460, 98.0744, -132.1959, 100.8614, 76.2990, -101.1097, 114.0203, -111.8430, -111.9559, 101.6132, -125.4992, -120.7653, 109.0130, 95.3579, 108.3185, 131.2153, 123.4268, -107.8207, 97.5336, -124.3085, -120.5422, 114.8631, 109.7145, 101.6554, -97.9293, -104.0397, 107.4845, -116.4622, 86.3447, -131.9483, 140.0414, 130.1737, -119.0102, 145.3387, -129.4867, 89.1851, 130.0195, 162.4631, 81.1954, -98.7306, 63.5028, -148.4119, 102.0081, -109.7095, 125.6055, 115.3125, -88.9048, 86.4840, -100.0795, -127.7580, 122.4241, 120.0291, 105.4468, -124.2581, 115.8915, 103.9371, -87.2202, -120.8202, -122.0862, -126.1834, 121.9397, -102.2874, -88.3509, -130.5982, 86.6435, -119.7403, -105.5058, -105.2672, -105.9440, -102.0673, 148.0039, -114.3069, 121.4947, -96.7930, -117.6496, -105.9323, 117.8486, 114.8054, 130.5891, -125.6708, 134.6842, 122.7460, 131.5243, -134.0863, -111.6346, 112.5575, 108.6692, -159.5754, -111.2821, 152.5956, 125.3160, -123.8117, 141.8753, 126.7014, -131.0836, -121.1845, -136.6026, 140.3844, 121.5463, 139.5336, 131.7128, 131.7534, 180.2313, 129.1670, 179.2473, 167.3191, 174.1449, -155.5236, 174.0159, -161.0521, 154.3035, -142.4553, -139.9424, -135.3941, -121.5791, -155.9870, -145.8981, 151.5255, -131.5804, 145.4778, 157.8842, -173.2766, 133.0321, 150.4627, -141.1292, -175.2108, -143.7717, -155.5422, -146.4069, 148.6027, -140.5347, 127.7697, 121.7458, 154.3176, -145.0195, -144.1343, -151.6663, -159.2730, 120.3406, 162.6023, -144.2867, 146.9765, 164.9119, -175.9264, -161.5839, -161.0670, 149.6474, 155.5198, 201.4658, 158.1542, 130.2323, -150.7431, 118.8111, -149.4962, 176.3754, -120.6726, 144.8415, 149.5831, -159.5288, 171.8942, -148.1254, -159.8187, 173.0536, -172.7605, -163.8374, 182.4481, 166.0627, 157.1612, -157.9084, -166.9241, 136.4145, -149.9790, 144.8813, -139.9943, 144.7120, 106.8378, -167.2169, 173.4762, -134.2760])
    # fmt: on
    L = 8
    n_cellid = 309
    scrblk, crc_result, trblk, sfn4lsb, nHalfFrame, msbidxoffset = nrBCHDecode(softbits, L, 8, n_cellid)
    assert crc_result == 0, "nrBCHDecode CRC mismatch"
    # fmt: off
    scrblk_matlab = np.array([0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1])
    # fmt: on
    assert np.all(scrblk == scrblk_matlab), "nrBCHDecode scrblk mismatch"
    # fmt: off
    trblk_matlab = np.array([0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1])
    # fmt: on
    assert np.all(trblk == trblk_matlab), "nrBCHDecode trblk mismatch"
    assert np.all(sfn4lsb == np.array([0, 1, 0, 0])), "nrBCHDecode sfn4lsb mismatch"
