from __future__ import annotations
from typing import Literal

IconTypes = Literal[
    "account",
    "activate_breakpoints",
    "add",
    "archive",
    "arrow_both",
    "arrow_circle_down",
    "arrow_circle_left",
    "arrow_circle_right",
    "arrow_circle_up",
    "arrow_down",
    "arrow_left",
    "arrow_right",
    "arrow_small_down",
    "arrow_small_left",
    "arrow_small_right",
    "arrow_small_up",
    "arrow_swap",
    "arrow_up",
    "azure_devops",
    "azure",
    "beaker_stop",
    "beaker",
    "bell_dot",
    "bell_slash_dot",
    "bell_slash",
    "bell",
    "blank",
    "bold",
    "book",
    "bookmark",
    "bracket_dot",
    "bracket_error",
    "briefcase",
    "broadcast",
    "browser",
    "bug",
    "calendar",
    "call_incoming",
    "call_outgoing",
    "case_sensitive",
    "check_all",
    "check",
    "checklist",
    "chevron_down",
    "chevron_left",
    "chevron_right",
    "chevron_up",
    "chip",
    "chrome_close",
    "chrome_maximize",
    "chrome_minimize",
    "chrome_restore",
    "circle_filled",
    "circle_large_filled",
    "circle_large",
    "circle_slash",
    "circle_small_filled",
    "circle_small",
    "circle",
    "circuit_board",
    "clear_all",
    "clippy",
    "close_all",
    "close",
    "cloud_download",
    "cloud_upload",
    "cloud",
    "code_oss",
    "code",
    "coffee",
    "collapse_all",
    "color_mode",
    "combine",
    "comment_discussion",
    "comment_draft",
    "comment_unresolved",
    "comment",
    "compass_active",
    "compass_dot",
    "compass",
    "copilot",
    "copy",
    "coverage",
    "credit_card",
    "dash",
    "dashboard",
    "database",
    "debug_all",
    "debug_alt_small",
    "debug_alt",
    "debug_breakpoint_conditional_unverified",
    "debug_breakpoint_conditional",
    "debug_breakpoint_data_unverified",
    "debug_breakpoint_data",
    "debug_breakpoint_function_unverified",
    "debug_breakpoint_function",
    "debug_breakpoint_log_unverified",
    "debug_breakpoint_log",
    "debug_breakpoint_unsupported",
    "debug_console",
    "debug_continue_small",
    "debug_continue",
    "debug_coverage",
    "debug_disconnect",
    "debug_line_by_line",
    "debug_pause",
    "debug_rerun",
    "debug_restart_frame",
    "debug_restart",
    "debug_reverse_continue",
    "debug_stackframe_active",
    "debug_stackframe",
    "debug_start",
    "debug_step_back",
    "debug_step_into",
    "debug_step_out",
    "debug_step_over",
    "debug_stop",
    "debug",
    "desktop_download",
    "device_camera_video",
    "device_camera",
    "device_mobile",
    "diff_added",
    "diff_ignored",
    "diff_modified",
    "diff_multiple",
    "diff_removed",
    "diff_renamed",
    "diff_single",
    "diff",
    "discard",
    "edit",
    "editor_layout",
    "ellipsis",
    "empty_window",
    "error_small",
    "error",
    "exclude",
    "expand_all",
    "export",
    "extensions",
    "eye_closed",
    "eye",
    "feedback",
    "file_binary",
    "file_code",
    "file_media",
    "file_pdf",
    "file_submodule",
    "file_symlink_directory",
    "file_symlink_file",
    "file_zip",
    "file",
    "files",
    "filter_filled",
    "filter",
    "flame",
    "fold_down",
    "fold_up",
    "fold",
    "folder_active",
    "folder_library",
    "folder_opened",
    "folder",
    "game",
    "gear",
    "gift",
    "gist_secret",
    "gist",
    "git_commit",
    "git_compare",
    "git_fetch",
    "git_merge",
    "git_pull_request_closed",
    "git_pull_request_create",
    "git_pull_request_draft",
    "git_pull_request_go_to_changes",
    "git_pull_request_new_changes",
    "git_pull_request",
    "git_stash_apply",
    "git_stash_pop",
    "git_stash",
    "github_action",
    "github_alt",
    "github_inverted",
    "github_project",
    "github",
    "globe",
    "go_to_file",
    "go_to_search",
    "grabber",
    "graph_left",
    "graph_line",
    "graph_scatter",
    "graph",
    "gripper",
    "group_by_ref_type",
    "heart_filled",
    "heart",
    "history",
    "home",
    "horizontal_rule",
    "hubot",
    "inbox",
    "indent",
    "info",
    "insert",
    "inspect",
    "issue_draft",
    "issue_reopened",
    "issues",
    "italic",
    "jersey",
    "json",
    "kebab_vertical",
    "key",
    "law",
    "layers_active",
    "layers_dot",
    "layers",
    "layout_activitybar_left",
    "layout_activitybar_right",
    "layout_centered",
    "layout_menubar",
    "layout_panel_center",
    "layout_panel_justify",
    "layout_panel_left",
    "layout_panel_off",
    "layout_panel_right",
    "layout_panel",
    "layout_sidebar_left_off",
    "layout_sidebar_left",
    "layout_sidebar_right_off",
    "layout_sidebar_right",
    "layout_statusbar",
    "layout",
    "library",
    "lightbulb_autofix",
    "lightbulb_sparkle",
    "lightbulb",
    "link_external",
    "link",
    "list_filter",
    "list_flat",
    "list_ordered",
    "list_selection",
    "list_tree",
    "list_unordered",
    "live_share",
    "loading",
    "location",
    "lock_small",
    "lock",
    "magnet",
    "mail_read",
    "mail",
    "map_filled",
    "map_vertical_filled",
    "map_vertical",
    "map",
    "markdown",
    "megaphone",
    "mention",
    "menu",
    "merge",
    "mic_filled",
    "mic",
    "milestone",
    "mirror",
    "mortar_board",
    "move",
    "multiple_windows",
    "music",
    "mute",
    "new_file",
    "new_folder",
    "newline",
    "no_newline",
    "note",
    "notebook_template",
    "notebook",
    "octoface",
    "open_preview",
    "organization",
    "output",
    "package",
    "paintcan",
    "pass_filled",
    "pass",
    "percentage",
    "person_add",
    "person",
    "piano",
    "pie_chart",
    "pin",
    "pinned_dirty",
    "pinned",
    "play_circle",
    "play",
    "plug",
    "preserve_case",
    "preview",
    "primitive_square",
    "project",
    "pulse",
    "question",
    "quote",
    "radio_tower",
    "reactions",
    "record_keys",
    "record_small",
    "record",
    "redo",
    "references",
    "refresh",
    "regex",
    "remote_explorer",
    "remote",
    "remove",
    "replace_all",
    "replace",
    "reply",
    "repo_clone",
    "repo_force_push",
    "repo_forked",
    "repo_pull",
    "repo_push",
    "repo",
    "report",
    "request_changes",
    "robot",
    "rocket",
    "root_folder_opened",
    "root_folder",
    "rss",
    "ruby",
    "run_above",
    "run_all_coverage",
    "run_all",
    "run_below",
    "run_coverage",
    "run_errors",
    "save_all",
    "save_as",
    "save",
    "screen_full",
    "screen_normal",
    "search_fuzzy",
    "search_stop",
    "search",
    "send",
    "server_environment",
    "server_process",
    "server",
    "settings_gear",
    "settings",
    "share",
    "shield",
    "sign_in",
    "sign_out",
    "smiley",
    "snake",
    "sort_precedence",
    "source_control",
    "sparkle_filled",
    "sparkle",
    "split_horizontal",
    "split_vertical",
    "squirrel",
    "star_empty",
    "star_full",
    "star_half",
    "stop_circle",
    "surround_with",
    "symbol_array",
    "symbol_boolean",
    "symbol_class",
    "symbol_color",
    "symbol_constant",
    "symbol_enum_member",
    "symbol_enum",
    "symbol_event",
    "symbol_field",
    "symbol_file",
    "symbol_interface",
    "symbol_key",
    "symbol_keyword",
    "symbol_method",
    "symbol_misc",
    "symbol_namespace",
    "symbol_numeric",
    "symbol_operator",
    "symbol_parameter",
    "symbol_property",
    "symbol_ruler",
    "symbol_snippet",
    "symbol_string",
    "symbol_structure",
    "symbol_variable",
    "sync_ignored",
    "sync",
    "table",
    "tag",
    "target",
    "tasklist",
    "telescope",
    "terminal_bash",
    "terminal_cmd",
    "terminal_debian",
    "terminal_linux",
    "terminal_powershell",
    "terminal_tmux",
    "terminal_ubuntu",
    "terminal",
    "text_size",
    "three_bars",
    "thumbsdown_filled",
    "thumbsdown",
    "thumbsup_filled",
    "thumbsup",
    "tools",
    "trash",
    "triangle_down",
    "triangle_left",
    "triangle_right",
    "triangle_up",
    "twitter",
    "type_hierarchy_sub",
    "type_hierarchy_super",
    "type_hierarchy",
    "unfold",
    "ungroup_by_ref_type",
    "unlock",
    "unmute",
    "unverified",
    "variable_group",
    "verified_filled",
    "verified",
    "versions",
    "vm_active",
    "vm_connect",
    "vm_outline",
    "vm_running",
    "vm",
    "vr",
    "vscode_insiders",
    "vscode",
    "wand",
    "warning",
    "watch",
    "whitespace",
    "whole_word",
    "window",
    "word_wrap",
    "workspace_trusted",
    "workspace_unknown",
    "workspace_untrusted",
    "zoom_in",
    "zoom_out",
    "dh_add_small",
    "dh_arrow_to_bottom",
    "dh_arrow_to_top",
    "dh_check_square",
    "dh_chevron_down_square",
    "dh_circle_large_outline_notch",
    "dh_clock",
    "dh_exclamation",
    "dh_eye_slash",
    "dh_eye",
    "dh_file_certificate",
    "dh_file_csv",
    "dh_file_download",
    "dh_file_print",
    "dh_file_search",
    "dh_file_spreadsheet",
    "dh_filter_filled",
    "dh_filter_slash",
    "dh_freeze",
    "dh_gear_filled",
    "dh_gears_filled",
    "dh_graph_line_down",
    "dh_graph_line_up",
    "dh_i_cursor",
    "dh_input",
    "dh_new_circle_large_filled",
    "dh_new_square_filled",
    "dh_organization_add",
    "dh_pandas",
    "dh_panels",
    "dh_python",
    "dh_refresh",
    "dh_remove_square_filled",
    "dh_run_selection",
    "dh_shapes",
    "dh_share_filled",
    "dh_share",
    "dh_sort_alpha_down",
    "dh_sort_alpha_up",
    "dh_sort_amount_down",
    "dh_sort_down",
    "dh_sort_slash",
    "dh_sort_up",
    "dh_sort",
    "dh_split_both",
    "dh_square_filled",
    "dh_sticky_note_filled",
    "dh_strikethrough",
    "dh_table",
    "dh_trash_undo",
    "dh_triangle_down_square",
    "dh_truck",
    "dh_underline",
    "dh_unlink",
    "dh_user_incognito",
    "dh_user",
    "dh_warning_circle_filled",
    "dh_warning_filled",
]

IconMapping = {
    "vsAccount": "vsAccount",
    "vsActivateBreakpoints": "vsActivateBreakpoints",
    "vsAdd": "vsAdd",
    "vsArchive": "vsArchive",
    "vsArrowBoth": "vsArrowBoth",
    "vsArrowCircleDown": "vsArrowCircleDown",
    "vsArrowCircleLeft": "vsArrowCircleLeft",
    "vsArrowCircleRight": "vsArrowCircleRight",
    "vsArrowCircleUp": "vsArrowCircleUp",
    "vsArrowDown": "vsArrowDown",
    "vsArrowLeft": "vsArrowLeft",
    "vsArrowRight": "vsArrowRight",
    "vsArrowSmallDown": "vsArrowSmallDown",
    "vsArrowSmallLeft": "vsArrowSmallLeft",
    "vsArrowSmallRight": "vsArrowSmallRight",
    "vsArrowSmallUp": "vsArrowSmallUp",
    "vsArrowSwap": "vsArrowSwap",
    "vsArrowUp": "vsArrowUp",
    "vsAzureDevops": "vsAzureDevops",
    "vsAzure": "vsAzure",
    "vsBeakerStop": "vsBeakerStop",
    "vsBeaker": "vsBeaker",
    "vsBellDot": "vsBellDot",
    "vsBellSlashDot": "vsBellSlashDot",
    "vsBellSlash": "vsBellSlash",
    "vsBell": "vsBell",
    "vsBlank": "vsBlank",
    "vsBold": "vsBold",
    "vsBook": "vsBook",
    "vsBookmark": "vsBookmark",
    "vsBracketDot": "vsBracketDot",
    "vsBracketError": "vsBracketError",
    "vsBriefcase": "vsBriefcase",
    "vsBroadcast": "vsBroadcast",
    "vsBrowser": "vsBrowser",
    "vsBug": "vsBug",
    "vsCalendar": "vsCalendar",
    "vsCallIncoming": "vsCallIncoming",
    "vsCallOutgoing": "vsCallOutgoing",
    "vsCaseSensitive": "vsCaseSensitive",
    "vsCheckAll": "vsCheckAll",
    "vsCheck": "vsCheck",
    "vsChecklist": "vsChecklist",
    "vsChevronDown": "vsChevronDown",
    "vsChevronLeft": "vsChevronLeft",
    "vsChevronRight": "vsChevronRight",
    "vsChevronUp": "vsChevronUp",
    "vsChip": "vsChip",
    "vsChromeClose": "vsChromeClose",
    "vsChromeMaximize": "vsChromeMaximize",
    "vsChromeMinimize": "vsChromeMinimize",
    "vsChromeRestore": "vsChromeRestore",
    "vsCircleFilled": "vsCircleFilled",
    "vsCircleLargeFilled": "vsCircleLargeFilled",
    "vsCircleLarge": "vsCircleLarge",
    "vsCircleSlash": "vsCircleSlash",
    "vsCircleSmallFilled": "vsCircleSmallFilled",
    "vsCircleSmall": "vsCircleSmall",
    "vsCircle": "vsCircle",
    "vsCircuitBoard": "vsCircuitBoard",
    "vsClearAll": "vsClearAll",
    "vsClippy": "vsClippy",
    "vsCloseAll": "vsCloseAll",
    "vsClose": "vsClose",
    "vsCloudDownload": "vsCloudDownload",
    "vsCloudUpload": "vsCloudUpload",
    "vsCloud": "vsCloud",
    "vsCodeOss": "vsCodeOss",
    "vsCode": "vsCode",
    "vsCoffee": "vsCoffee",
    "vsCollapseAll": "vsCollapseAll",
    "vsColorMode": "vsColorMode",
    "vsCombine": "vsCombine",
    "vsCommentDiscussion": "vsCommentDiscussion",
    "vsCommentDraft": "vsCommentDraft",
    "vsCommentUnresolved": "vsCommentUnresolved",
    "vsComment": "vsComment",
    "vsCompassActive": "vsCompassActive",
    "vsCompassDot": "vsCompassDot",
    "vsCompass": "vsCompass",
    "vsCopilot": "vsCopilot",
    "vsCopy": "vsCopy",
    "vsCoverage": "vsCoverage",
    "vsCreditCard": "vsCreditCard",
    "vsDash": "vsDash",
    "vsDashboard": "vsDashboard",
    "vsDatabase": "vsDatabase",
    "vsDebugAll": "vsDebugAll",
    "vsDebugAltSmall": "vsDebugAltSmall",
    "vsDebugAlt": "vsDebugAlt",
    "vsDebugBreakpointConditionalUnverified": "vsDebugBreakpointConditionalUnverified",
    "vsDebugBreakpointConditional": "vsDebugBreakpointConditional",
    "vsDebugBreakpointDataUnverified": "vsDebugBreakpointDataUnverified",
    "vsDebugBreakpointData": "vsDebugBreakpointData",
    "vsDebugBreakpointFunctionUnverified": "vsDebugBreakpointFunctionUnverified",
    "vsDebugBreakpointFunction": "vsDebugBreakpointFunction",
    "vsDebugBreakpointLogUnverified": "vsDebugBreakpointLogUnverified",
    "vsDebugBreakpointLog": "vsDebugBreakpointLog",
    "vsDebugBreakpointUnsupported": "vsDebugBreakpointUnsupported",
    "vsDebugConsole": "vsDebugConsole",
    "vsDebugContinueSmall": "vsDebugContinueSmall",
    "vsDebugContinue": "vsDebugContinue",
    "vsDebugCoverage": "vsDebugCoverage",
    "vsDebugDisconnect": "vsDebugDisconnect",
    "vsDebugLineByLine": "vsDebugLineByLine",
    "vsDebugPause": "vsDebugPause",
    "vsDebugRerun": "vsDebugRerun",
    "vsDebugRestartFrame": "vsDebugRestartFrame",
    "vsDebugRestart": "vsDebugRestart",
    "vsDebugReverseContinue": "vsDebugReverseContinue",
    "vsDebugStackframeActive": "vsDebugStackframeActive",
    "vsDebugStackframe": "vsDebugStackframe",
    "vsDebugStart": "vsDebugStart",
    "vsDebugStepBack": "vsDebugStepBack",
    "vsDebugStepInto": "vsDebugStepInto",
    "vsDebugStepOut": "vsDebugStepOut",
    "vsDebugStepOver": "vsDebugStepOver",
    "vsDebugStop": "vsDebugStop",
    "vsDebug": "vsDebug",
    "vsDesktopDownload": "vsDesktopDownload",
    "vsDeviceCameraVideo": "vsDeviceCameraVideo",
    "vsDeviceCamera": "vsDeviceCamera",
    "vsDeviceMobile": "vsDeviceMobile",
    "vsDiffAdded": "vsDiffAdded",
    "vsDiffIgnored": "vsDiffIgnored",
    "vsDiffModified": "vsDiffModified",
    "vsDiffMultiple": "vsDiffMultiple",
    "vsDiffRemoved": "vsDiffRemoved",
    "vsDiffRenamed": "vsDiffRenamed",
    "vsDiffSingle": "vsDiffSingle",
    "vsDiff": "vsDiff",
    "vsDiscard": "vsDiscard",
    "vsEdit": "vsEdit",
    "vsEditorLayout": "vsEditorLayout",
    "vsEllipsis": "vsEllipsis",
    "vsEmptyWindow": "vsEmptyWindow",
    "vsErrorSmall": "vsErrorSmall",
    "vsError": "vsError",
    "vsExclude": "vsExclude",
    "vsExpandAll": "vsExpandAll",
    "vsExport": "vsExport",
    "vsExtensions": "vsExtensions",
    "vsEyeClosed": "vsEyeClosed",
    "vsEye": "vsEye",
    "vsFeedback": "vsFeedback",
    "vsFileBinary": "vsFileBinary",
    "vsFileCode": "vsFileCode",
    "vsFileMedia": "vsFileMedia",
    "vsFilePdf": "vsFilePdf",
    "vsFileSubmodule": "vsFileSubmodule",
    "vsFileSymlinkDirectory": "vsFileSymlinkDirectory",
    "vsFileSymlinkFile": "vsFileSymlinkFile",
    "vsFileZip": "vsFileZip",
    "vsFile": "vsFile",
    "vsFiles": "vsFiles",
    "vsFilterFilled": "vsFilterFilled",
    "vsFilter": "vsFilter",
    "vsFlame": "vsFlame",
    "vsFoldDown": "vsFoldDown",
    "vsFoldUp": "vsFoldUp",
    "vsFold": "vsFold",
    "vsFolderActive": "vsFolderActive",
    "vsFolderLibrary": "vsFolderLibrary",
    "vsFolderOpened": "vsFolderOpened",
    "vsFolder": "vsFolder",
    "vsGame": "vsGame",
    "vsGear": "vsGear",
    "vsGift": "vsGift",
    "vsGistSecret": "vsGistSecret",
    "vsGist": "vsGist",
    "vsGitCommit": "vsGitCommit",
    "vsGitCompare": "vsGitCompare",
    "vsGitFetch": "vsGitFetch",
    "vsGitMerge": "vsGitMerge",
    "vsGitPullRequestClosed": "vsGitPullRequestClosed",
    "vsGitPullRequestCreate": "vsGitPullRequestCreate",
    "vsGitPullRequestDraft": "vsGitPullRequestDraft",
    "vsGitPullRequestGoToChanges": "vsGitPullRequestGoToChanges",
    "vsGitPullRequestNewChanges": "vsGitPullRequestNewChanges",
    "vsGitPullRequest": "vsGitPullRequest",
    "vsGitStashApply": "vsGitStashApply",
    "vsGitStashPop": "vsGitStashPop",
    "vsGitStash": "vsGitStash",
    "vsGithubAction": "vsGithubAction",
    "vsGithubAlt": "vsGithubAlt",
    "vsGithubInverted": "vsGithubInverted",
    "vsGithubProject": "vsGithubProject",
    "vsGithub": "vsGithub",
    "vsGlobe": "vsGlobe",
    "vsGoToFile": "vsGoToFile",
    "vsGoToSearch": "vsGoToSearch",
    "vsGrabber": "vsGrabber",
    "vsGraphLeft": "vsGraphLeft",
    "vsGraphLine": "vsGraphLine",
    "vsGraphScatter": "vsGraphScatter",
    "vsGraph": "vsGraph",
    "vsGripper": "vsGripper",
    "vsGroupByRefType": "vsGroupByRefType",
    "vsHeartFilled": "vsHeartFilled",
    "vsHeart": "vsHeart",
    "vsHistory": "vsHistory",
    "vsHome": "vsHome",
    "vsHorizontalRule": "vsHorizontalRule",
    "vsHubot": "vsHubot",
    "vsInbox": "vsInbox",
    "vsIndent": "vsIndent",
    "vsInfo": "vsInfo",
    "vsInsert": "vsInsert",
    "vsInspect": "vsInspect",
    "vsIssueDraft": "vsIssueDraft",
    "vsIssueReopened": "vsIssueReopened",
    "vsIssues": "vsIssues",
    "vsItalic": "vsItalic",
    "vsJersey": "vsJersey",
    "vsJson": "vsJson",
    "vsKebabVertical": "vsKebabVertical",
    "vsKey": "vsKey",
    "vsLaw": "vsLaw",
    "vsLayersActive": "vsLayersActive",
    "vsLayersDot": "vsLayersDot",
    "vsLayers": "vsLayers",
    "vsLayoutActivitybarLeft": "vsLayoutActivitybarLeft",
    "vsLayoutActivitybarRight": "vsLayoutActivitybarRight",
    "vsLayoutCentered": "vsLayoutCentered",
    "vsLayoutMenubar": "vsLayoutMenubar",
    "vsLayoutPanelCenter": "vsLayoutPanelCenter",
    "vsLayoutPanelJustify": "vsLayoutPanelJustify",
    "vsLayoutPanelLeft": "vsLayoutPanelLeft",
    "vsLayoutPanelOff": "vsLayoutPanelOff",
    "vsLayoutPanelRight": "vsLayoutPanelRight",
    "vsLayoutPanel": "vsLayoutPanel",
    "vsLayoutSidebarLeftOff": "vsLayoutSidebarLeftOff",
    "vsLayoutSidebarLeft": "vsLayoutSidebarLeft",
    "vsLayoutSidebarRightOff": "vsLayoutSidebarRightOff",
    "vsLayoutSidebarRight": "vsLayoutSidebarRight",
    "vsLayoutStatusbar": "vsLayoutStatusbar",
    "vsLayout": "vsLayout",
    "vsLibrary": "vsLibrary",
    "vsLightbulbAutofix": "vsLightbulbAutofix",
    "vsLightbulbSparkle": "vsLightbulbSparkle",
    "vsLightbulb": "vsLightbulb",
    "vsLinkExternal": "vsLinkExternal",
    "vsLink": "vsLink",
    "vsListFilter": "vsListFilter",
    "vsListFlat": "vsListFlat",
    "vsListOrdered": "vsListOrdered",
    "vsListSelection": "vsListSelection",
    "vsListTree": "vsListTree",
    "vsListUnordered": "vsListUnordered",
    "vsLiveShare": "vsLiveShare",
    "vsLoading": "vsLoading",
    "vsLocation": "vsLocation",
    "vsLockSmall": "vsLockSmall",
    "vsLock": "vsLock",
    "vsMagnet": "vsMagnet",
    "vsMailRead": "vsMailRead",
    "vsMail": "vsMail",
    "vsMapFilled": "vsMapFilled",
    "vsMapVerticalFilled": "vsMapVerticalFilled",
    "vsMapVertical": "vsMapVertical",
    "vsMap": "vsMap",
    "vsMarkdown": "vsMarkdown",
    "vsMegaphone": "vsMegaphone",
    "vsMention": "vsMention",
    "vsMenu": "vsMenu",
    "vsMerge": "vsMerge",
    "vsMicFilled": "vsMicFilled",
    "vsMic": "vsMic",
    "vsMilestone": "vsMilestone",
    "vsMirror": "vsMirror",
    "vsMortarBoard": "vsMortarBoard",
    "vsMove": "vsMove",
    "vsMultipleWindows": "vsMultipleWindows",
    "vsMusic": "vsMusic",
    "vsMute": "vsMute",
    "vsNewFile": "vsNewFile",
    "vsNewFolder": "vsNewFolder",
    "vsNewline": "vsNewline",
    "vsNoNewline": "vsNoNewline",
    "vsNote": "vsNote",
    "vsNotebookTemplate": "vsNotebookTemplate",
    "vsNotebook": "vsNotebook",
    "vsOctoface": "vsOctoface",
    "vsOpenPreview": "vsOpenPreview",
    "vsOrganization": "vsOrganization",
    "vsOutput": "vsOutput",
    "vsPackage": "vsPackage",
    "vsPaintcan": "vsPaintcan",
    "vsPassFilled": "vsPassFilled",
    "vsPass": "vsPass",
    "vsPercentage": "vsPercentage",
    "vsPersonAdd": "vsPersonAdd",
    "vsPerson": "vsPerson",
    "vsPiano": "vsPiano",
    "vsPieChart": "vsPieChart",
    "vsPin": "vsPin",
    "vsPinnedDirty": "vsPinnedDirty",
    "vsPinned": "vsPinned",
    "vsPlayCircle": "vsPlayCircle",
    "vsPlay": "vsPlay",
    "vsPlug": "vsPlug",
    "vsPreserveCase": "vsPreserveCase",
    "vsPreview": "vsPreview",
    "vsPrimitiveSquare": "vsPrimitiveSquare",
    "vsProject": "vsProject",
    "vsPulse": "vsPulse",
    "vsQuestion": "vsQuestion",
    "vsQuote": "vsQuote",
    "vsRadioTower": "vsRadioTower",
    "vsReactions": "vsReactions",
    "vsRecordKeys": "vsRecordKeys",
    "vsRecordSmall": "vsRecordSmall",
    "vsRecord": "vsRecord",
    "vsRedo": "vsRedo",
    "vsReferences": "vsReferences",
    "vsRefresh": "vsRefresh",
    "vsRegex": "vsRegex",
    "vsRemoteExplorer": "vsRemoteExplorer",
    "vsRemote": "vsRemote",
    "vsRemove": "vsRemove",
    "vsReplaceAll": "vsReplaceAll",
    "vsReplace": "vsReplace",
    "vsReply": "vsReply",
    "vsRepoClone": "vsRepoClone",
    "vsRepoForcePush": "vsRepoForcePush",
    "vsRepoForked": "vsRepoForked",
    "vsRepoPull": "vsRepoPull",
    "vsRepoPush": "vsRepoPush",
    "vsRepo": "vsRepo",
    "vsReport": "vsReport",
    "vsRequestChanges": "vsRequestChanges",
    "vsRobot": "vsRobot",
    "vsRocket": "vsRocket",
    "vsRootFolderOpened": "vsRootFolderOpened",
    "vsRootFolder": "vsRootFolder",
    "vsRss": "vsRss",
    "vsRuby": "vsRuby",
    "vsRunAbove": "vsRunAbove",
    "vsRunAllCoverage": "vsRunAllCoverage",
    "vsRunAll": "vsRunAll",
    "vsRunBelow": "vsRunBelow",
    "vsRunCoverage": "vsRunCoverage",
    "vsRunErrors": "vsRunErrors",
    "vsSaveAll": "vsSaveAll",
    "vsSaveAs": "vsSaveAs",
    "vsSave": "vsSave",
    "vsScreenFull": "vsScreenFull",
    "vsScreenNormal": "vsScreenNormal",
    "vsSearchFuzzy": "vsSearchFuzzy",
    "vsSearchStop": "vsSearchStop",
    "vsSearch": "vsSearch",
    "vsSend": "vsSend",
    "vsServerEnvironment": "vsServerEnvironment",
    "vsServerProcess": "vsServerProcess",
    "vsServer": "vsServer",
    "vsSettingsGear": "vsSettingsGear",
    "vsSettings": "vsSettings",
    "vsShare": "vsShare",
    "vsShield": "vsShield",
    "vsSignIn": "vsSignIn",
    "vsSignOut": "vsSignOut",
    "vsSmiley": "vsSmiley",
    "vsSnake": "vsSnake",
    "vsSortPrecedence": "vsSortPrecedence",
    "vsSourceControl": "vsSourceControl",
    "vsSparkleFilled": "vsSparkleFilled",
    "vsSparkle": "vsSparkle",
    "vsSplitHorizontal": "vsSplitHorizontal",
    "vsSplitVertical": "vsSplitVertical",
    "vsSquirrel": "vsSquirrel",
    "vsStarEmpty": "vsStarEmpty",
    "vsStarFull": "vsStarFull",
    "vsStarHalf": "vsStarHalf",
    "vsStopCircle": "vsStopCircle",
    "vsSurroundWith": "vsSurroundWith",
    "vsSymbolArray": "vsSymbolArray",
    "vsSymbolBoolean": "vsSymbolBoolean",
    "vsSymbolClass": "vsSymbolClass",
    "vsSymbolColor": "vsSymbolColor",
    "vsSymbolConstant": "vsSymbolConstant",
    "vsSymbolEnumMember": "vsSymbolEnumMember",
    "vsSymbolEnum": "vsSymbolEnum",
    "vsSymbolEvent": "vsSymbolEvent",
    "vsSymbolField": "vsSymbolField",
    "vsSymbolFile": "vsSymbolFile",
    "vsSymbolInterface": "vsSymbolInterface",
    "vsSymbolKey": "vsSymbolKey",
    "vsSymbolKeyword": "vsSymbolKeyword",
    "vsSymbolMethod": "vsSymbolMethod",
    "vsSymbolMisc": "vsSymbolMisc",
    "vsSymbolNamespace": "vsSymbolNamespace",
    "vsSymbolNumeric": "vsSymbolNumeric",
    "vsSymbolOperator": "vsSymbolOperator",
    "vsSymbolParameter": "vsSymbolParameter",
    "vsSymbolProperty": "vsSymbolProperty",
    "vsSymbolRuler": "vsSymbolRuler",
    "vsSymbolSnippet": "vsSymbolSnippet",
    "vsSymbolString": "vsSymbolString",
    "vsSymbolStructure": "vsSymbolStructure",
    "vsSymbolVariable": "vsSymbolVariable",
    "vsSyncIgnored": "vsSyncIgnored",
    "vsSync": "vsSync",
    "vsTable": "vsTable",
    "vsTag": "vsTag",
    "vsTarget": "vsTarget",
    "vsTasklist": "vsTasklist",
    "vsTelescope": "vsTelescope",
    "vsTerminalBash": "vsTerminalBash",
    "vsTerminalCmd": "vsTerminalCmd",
    "vsTerminalDebian": "vsTerminalDebian",
    "vsTerminalLinux": "vsTerminalLinux",
    "vsTerminalPowershell": "vsTerminalPowershell",
    "vsTerminalTmux": "vsTerminalTmux",
    "vsTerminalUbuntu": "vsTerminalUbuntu",
    "vsTerminal": "vsTerminal",
    "vsTextSize": "vsTextSize",
    "vsThreeBars": "vsThreeBars",
    "vsThumbsdownFilled": "vsThumbsdownFilled",
    "vsThumbsdown": "vsThumbsdown",
    "vsThumbsupFilled": "vsThumbsupFilled",
    "vsThumbsup": "vsThumbsup",
    "vsTools": "vsTools",
    "vsTrash": "vsTrash",
    "vsTriangleDown": "vsTriangleDown",
    "vsTriangleLeft": "vsTriangleLeft",
    "vsTriangleRight": "vsTriangleRight",
    "vsTriangleUp": "vsTriangleUp",
    "vsTwitter": "vsTwitter",
    "vsTypeHierarchySub": "vsTypeHierarchySub",
    "vsTypeHierarchySuper": "vsTypeHierarchySuper",
    "vsTypeHierarchy": "vsTypeHierarchy",
    "vsUnfold": "vsUnfold",
    "vsUngroupByRefType": "vsUngroupByRefType",
    "vsUnlock": "vsUnlock",
    "vsUnmute": "vsUnmute",
    "vsUnverified": "vsUnverified",
    "vsVariableGroup": "vsVariableGroup",
    "vsVerifiedFilled": "vsVerifiedFilled",
    "vsVerified": "vsVerified",
    "vsVersions": "vsVersions",
    "vsVmActive": "vsVmActive",
    "vsVmConnect": "vsVmConnect",
    "vsVmOutline": "vsVmOutline",
    "vsVmRunning": "vsVmRunning",
    "vsVm": "vsVm",
    "vsVr": "vsVr",
    "vsVscodeInsiders": "vsVscodeInsiders",
    "vsVscode": "vsVscode",
    "vsWand": "vsWand",
    "vsWarning": "vsWarning",
    "vsWatch": "vsWatch",
    "vsWhitespace": "vsWhitespace",
    "vsWholeWord": "vsWholeWord",
    "vsWindow": "vsWindow",
    "vsWordWrap": "vsWordWrap",
    "vsWorkspaceTrusted": "vsWorkspaceTrusted",
    "vsWorkspaceUnknown": "vsWorkspaceUnknown",
    "vsWorkspaceUntrusted": "vsWorkspaceUntrusted",
    "vsZoomIn": "vsZoomIn",
    "vsZoomOut": "vsZoomOut",
    "dhAddSmall": "dhAddSmall",
    "dhArrowToBottom": "dhArrowToBottom",
    "dhArrowToTop": "dhArrowToTop",
    "dhCheckSquare": "dhCheckSquare",
    "dhChevronDownSquare": "dhChevronDownSquare",
    "dhCircleLargeOutlineNotch": "dhCircleLargeOutlineNotch",
    "dhClock": "dhClock",
    "dhExclamation": "dhExclamation",
    "dhEyeSlash": "dhEyeSlash",
    "dhEye": "dhEye",
    "dhFileCertificate": "dhFileCertificate",
    "dhFileCsv": "dhFileCsv",
    "dhFileDownload": "dhFileDownload",
    "dhFilePrint": "dhFilePrint",
    "dhFileSearch": "dhFileSearch",
    "dhFileSpreadsheet": "dhFileSpreadsheet",
    "dhFilterFilled": "dhFilterFilled",
    "dhFilterSlash": "dhFilterSlash",
    "dhFreeze": "dhFreeze",
    "dhGearFilled": "dhGearFilled",
    "dhGearsFilled": "dhGearsFilled",
    "dhGraphLineDown": "dhGraphLineDown",
    "dhGraphLineUp": "dhGraphLineUp",
    "dhICursor": "dhICursor",
    "dhInput": "dhInput",
    "dhNewCircleLargeFilled": "dhNewCircleLargeFilled",
    "dhNewSquareFilled": "dhNewSquareFilled",
    "dhOrganizationAdd": "dhOrganizationAdd",
    "dhPandas": "dhPandas",
    "dhPanels": "dhPanels",
    "dhPython": "dhPython",
    "dhRefresh": "dhRefresh",
    "dhRemoveSquareFilled": "dhRemoveSquareFilled",
    "dhRunSelection": "dhRunSelection",
    "dhShapes": "dhShapes",
    "dhShareFilled": "dhShareFilled",
    "dhShare": "dhShare",
    "dhSortAlphaDown": "dhSortAlphaDown",
    "dhSortAlphaUp": "dhSortAlphaUp",
    "dhSortAmountDown": "dhSortAmountDown",
    "dhSortDown": "dhSortDown",
    "dhSortSlash": "dhSortSlash",
    "dhSortUp": "dhSortUp",
    "dhSort": "dhSort",
    "dhSplitBoth": "dhSplitBoth",
    "dhSquareFilled": "dhSquareFilled",
    "dhStickyNoteFilled": "dhStickyNoteFilled",
    "dhStrikethrough": "dhStrikethrough",
    "dhTable": "dhTable",
    "dhTrashUndo": "dhTrashUndo",
    "dhTriangleDownSquare": "dhTriangleDownSquare",
    "dhTruck": "dhTruck",
    "dhUnderline": "dhUnderline",
    "dhUnlink": "dhUnlink",
    "dhUserIncognito": "dhUserIncognito",
    "dhUser": "dhUser",
    "dhWarningCircleFilled": "dhWarningCircleFilled",
    "dhWarningFilled": "dhWarningFilled",
    "Account": "vsAccount",
    "ActivateBreakpoints": "vsActivateBreakpoints",
    "Add": "vsAdd",
    "Archive": "vsArchive",
    "ArrowBoth": "vsArrowBoth",
    "ArrowCircleDown": "vsArrowCircleDown",
    "ArrowCircleLeft": "vsArrowCircleLeft",
    "ArrowCircleRight": "vsArrowCircleRight",
    "ArrowCircleUp": "vsArrowCircleUp",
    "ArrowDown": "vsArrowDown",
    "ArrowLeft": "vsArrowLeft",
    "ArrowRight": "vsArrowRight",
    "ArrowSmallDown": "vsArrowSmallDown",
    "ArrowSmallLeft": "vsArrowSmallLeft",
    "ArrowSmallRight": "vsArrowSmallRight",
    "ArrowSmallUp": "vsArrowSmallUp",
    "ArrowSwap": "vsArrowSwap",
    "ArrowUp": "vsArrowUp",
    "AzureDevops": "vsAzureDevops",
    "Azure": "vsAzure",
    "BeakerStop": "vsBeakerStop",
    "Beaker": "vsBeaker",
    "BellDot": "vsBellDot",
    "BellSlashDot": "vsBellSlashDot",
    "BellSlash": "vsBellSlash",
    "Bell": "vsBell",
    "Blank": "vsBlank",
    "Bold": "vsBold",
    "Book": "vsBook",
    "Bookmark": "vsBookmark",
    "BracketDot": "vsBracketDot",
    "BracketError": "vsBracketError",
    "Briefcase": "vsBriefcase",
    "Broadcast": "vsBroadcast",
    "Browser": "vsBrowser",
    "Bug": "vsBug",
    "Calendar": "vsCalendar",
    "CallIncoming": "vsCallIncoming",
    "CallOutgoing": "vsCallOutgoing",
    "CaseSensitive": "vsCaseSensitive",
    "CheckAll": "vsCheckAll",
    "Check": "vsCheck",
    "Checklist": "vsChecklist",
    "ChevronDown": "vsChevronDown",
    "ChevronLeft": "vsChevronLeft",
    "ChevronRight": "vsChevronRight",
    "ChevronUp": "vsChevronUp",
    "Chip": "vsChip",
    "ChromeClose": "vsChromeClose",
    "ChromeMaximize": "vsChromeMaximize",
    "ChromeMinimize": "vsChromeMinimize",
    "ChromeRestore": "vsChromeRestore",
    "CircleFilled": "vsCircleFilled",
    "CircleLargeFilled": "vsCircleLargeFilled",
    "CircleLarge": "vsCircleLarge",
    "CircleSlash": "vsCircleSlash",
    "CircleSmallFilled": "vsCircleSmallFilled",
    "CircleSmall": "vsCircleSmall",
    "Circle": "vsCircle",
    "CircuitBoard": "vsCircuitBoard",
    "ClearAll": "vsClearAll",
    "Clippy": "vsClippy",
    "CloseAll": "vsCloseAll",
    "Close": "vsClose",
    "CloudDownload": "vsCloudDownload",
    "CloudUpload": "vsCloudUpload",
    "Cloud": "vsCloud",
    "CodeOss": "vsCodeOss",
    "Code": "vsCode",
    "Coffee": "vsCoffee",
    "CollapseAll": "vsCollapseAll",
    "ColorMode": "vsColorMode",
    "Combine": "vsCombine",
    "CommentDiscussion": "vsCommentDiscussion",
    "CommentDraft": "vsCommentDraft",
    "CommentUnresolved": "vsCommentUnresolved",
    "Comment": "vsComment",
    "CompassActive": "vsCompassActive",
    "CompassDot": "vsCompassDot",
    "Compass": "vsCompass",
    "Copilot": "vsCopilot",
    "Copy": "vsCopy",
    "Coverage": "vsCoverage",
    "CreditCard": "vsCreditCard",
    "Dash": "vsDash",
    "Dashboard": "vsDashboard",
    "Database": "vsDatabase",
    "DebugAll": "vsDebugAll",
    "DebugAltSmall": "vsDebugAltSmall",
    "DebugAlt": "vsDebugAlt",
    "DebugBreakpointConditionalUnverified": "vsDebugBreakpointConditionalUnverified",
    "DebugBreakpointConditional": "vsDebugBreakpointConditional",
    "DebugBreakpointDataUnverified": "vsDebugBreakpointDataUnverified",
    "DebugBreakpointData": "vsDebugBreakpointData",
    "DebugBreakpointFunctionUnverified": "vsDebugBreakpointFunctionUnverified",
    "DebugBreakpointFunction": "vsDebugBreakpointFunction",
    "DebugBreakpointLogUnverified": "vsDebugBreakpointLogUnverified",
    "DebugBreakpointLog": "vsDebugBreakpointLog",
    "DebugBreakpointUnsupported": "vsDebugBreakpointUnsupported",
    "DebugConsole": "vsDebugConsole",
    "DebugContinueSmall": "vsDebugContinueSmall",
    "DebugContinue": "vsDebugContinue",
    "DebugCoverage": "vsDebugCoverage",
    "DebugDisconnect": "vsDebugDisconnect",
    "DebugLineByLine": "vsDebugLineByLine",
    "DebugPause": "vsDebugPause",
    "DebugRerun": "vsDebugRerun",
    "DebugRestartFrame": "vsDebugRestartFrame",
    "DebugRestart": "vsDebugRestart",
    "DebugReverseContinue": "vsDebugReverseContinue",
    "DebugStackframeActive": "vsDebugStackframeActive",
    "DebugStackframe": "vsDebugStackframe",
    "DebugStart": "vsDebugStart",
    "DebugStepBack": "vsDebugStepBack",
    "DebugStepInto": "vsDebugStepInto",
    "DebugStepOut": "vsDebugStepOut",
    "DebugStepOver": "vsDebugStepOver",
    "DebugStop": "vsDebugStop",
    "Debug": "vsDebug",
    "DesktopDownload": "vsDesktopDownload",
    "DeviceCameraVideo": "vsDeviceCameraVideo",
    "DeviceCamera": "vsDeviceCamera",
    "DeviceMobile": "vsDeviceMobile",
    "DiffAdded": "vsDiffAdded",
    "DiffIgnored": "vsDiffIgnored",
    "DiffModified": "vsDiffModified",
    "DiffMultiple": "vsDiffMultiple",
    "DiffRemoved": "vsDiffRemoved",
    "DiffRenamed": "vsDiffRenamed",
    "DiffSingle": "vsDiffSingle",
    "Diff": "vsDiff",
    "Discard": "vsDiscard",
    "Edit": "vsEdit",
    "EditorLayout": "vsEditorLayout",
    "Ellipsis": "vsEllipsis",
    "EmptyWindow": "vsEmptyWindow",
    "ErrorSmall": "vsErrorSmall",
    "Error": "vsError",
    "Exclude": "vsExclude",
    "ExpandAll": "vsExpandAll",
    "Export": "vsExport",
    "Extensions": "vsExtensions",
    "EyeClosed": "vsEyeClosed",
    "Eye": "vsEye",
    "Feedback": "vsFeedback",
    "FileBinary": "vsFileBinary",
    "FileCode": "vsFileCode",
    "FileMedia": "vsFileMedia",
    "FilePdf": "vsFilePdf",
    "FileSubmodule": "vsFileSubmodule",
    "FileSymlinkDirectory": "vsFileSymlinkDirectory",
    "FileSymlinkFile": "vsFileSymlinkFile",
    "FileZip": "vsFileZip",
    "File": "vsFile",
    "Files": "vsFiles",
    "FilterFilled": "vsFilterFilled",
    "Filter": "vsFilter",
    "Flame": "vsFlame",
    "FoldDown": "vsFoldDown",
    "FoldUp": "vsFoldUp",
    "Fold": "vsFold",
    "FolderActive": "vsFolderActive",
    "FolderLibrary": "vsFolderLibrary",
    "FolderOpened": "vsFolderOpened",
    "Folder": "vsFolder",
    "Game": "vsGame",
    "Gear": "vsGear",
    "Gift": "vsGift",
    "GistSecret": "vsGistSecret",
    "Gist": "vsGist",
    "GitCommit": "vsGitCommit",
    "GitCompare": "vsGitCompare",
    "GitFetch": "vsGitFetch",
    "GitMerge": "vsGitMerge",
    "GitPullRequestClosed": "vsGitPullRequestClosed",
    "GitPullRequestCreate": "vsGitPullRequestCreate",
    "GitPullRequestDraft": "vsGitPullRequestDraft",
    "GitPullRequestGoToChanges": "vsGitPullRequestGoToChanges",
    "GitPullRequestNewChanges": "vsGitPullRequestNewChanges",
    "GitPullRequest": "vsGitPullRequest",
    "GitStashApply": "vsGitStashApply",
    "GitStashPop": "vsGitStashPop",
    "GitStash": "vsGitStash",
    "GithubAction": "vsGithubAction",
    "GithubAlt": "vsGithubAlt",
    "GithubInverted": "vsGithubInverted",
    "GithubProject": "vsGithubProject",
    "Github": "vsGithub",
    "Globe": "vsGlobe",
    "GoToFile": "vsGoToFile",
    "GoToSearch": "vsGoToSearch",
    "Grabber": "vsGrabber",
    "GraphLeft": "vsGraphLeft",
    "GraphLine": "vsGraphLine",
    "GraphScatter": "vsGraphScatter",
    "Graph": "vsGraph",
    "Gripper": "vsGripper",
    "GroupByRefType": "vsGroupByRefType",
    "HeartFilled": "vsHeartFilled",
    "Heart": "vsHeart",
    "History": "vsHistory",
    "Home": "vsHome",
    "HorizontalRule": "vsHorizontalRule",
    "Hubot": "vsHubot",
    "Inbox": "vsInbox",
    "Indent": "vsIndent",
    "Info": "vsInfo",
    "Insert": "vsInsert",
    "Inspect": "vsInspect",
    "IssueDraft": "vsIssueDraft",
    "IssueReopened": "vsIssueReopened",
    "Issues": "vsIssues",
    "Italic": "vsItalic",
    "Jersey": "vsJersey",
    "Json": "vsJson",
    "KebabVertical": "vsKebabVertical",
    "Key": "vsKey",
    "Law": "vsLaw",
    "LayersActive": "vsLayersActive",
    "LayersDot": "vsLayersDot",
    "Layers": "vsLayers",
    "LayoutActivitybarLeft": "vsLayoutActivitybarLeft",
    "LayoutActivitybarRight": "vsLayoutActivitybarRight",
    "LayoutCentered": "vsLayoutCentered",
    "LayoutMenubar": "vsLayoutMenubar",
    "LayoutPanelCenter": "vsLayoutPanelCenter",
    "LayoutPanelJustify": "vsLayoutPanelJustify",
    "LayoutPanelLeft": "vsLayoutPanelLeft",
    "LayoutPanelOff": "vsLayoutPanelOff",
    "LayoutPanelRight": "vsLayoutPanelRight",
    "LayoutPanel": "vsLayoutPanel",
    "LayoutSidebarLeftOff": "vsLayoutSidebarLeftOff",
    "LayoutSidebarLeft": "vsLayoutSidebarLeft",
    "LayoutSidebarRightOff": "vsLayoutSidebarRightOff",
    "LayoutSidebarRight": "vsLayoutSidebarRight",
    "LayoutStatusbar": "vsLayoutStatusbar",
    "Layout": "vsLayout",
    "Library": "vsLibrary",
    "LightbulbAutofix": "vsLightbulbAutofix",
    "LightbulbSparkle": "vsLightbulbSparkle",
    "Lightbulb": "vsLightbulb",
    "LinkExternal": "vsLinkExternal",
    "Link": "vsLink",
    "ListFilter": "vsListFilter",
    "ListFlat": "vsListFlat",
    "ListOrdered": "vsListOrdered",
    "ListSelection": "vsListSelection",
    "ListTree": "vsListTree",
    "ListUnordered": "vsListUnordered",
    "LiveShare": "vsLiveShare",
    "Loading": "vsLoading",
    "Location": "vsLocation",
    "LockSmall": "vsLockSmall",
    "Lock": "vsLock",
    "Magnet": "vsMagnet",
    "MailRead": "vsMailRead",
    "Mail": "vsMail",
    "MapFilled": "vsMapFilled",
    "MapVerticalFilled": "vsMapVerticalFilled",
    "MapVertical": "vsMapVertical",
    "Map": "vsMap",
    "Markdown": "vsMarkdown",
    "Megaphone": "vsMegaphone",
    "Mention": "vsMention",
    "Menu": "vsMenu",
    "Merge": "vsMerge",
    "MicFilled": "vsMicFilled",
    "Mic": "vsMic",
    "Milestone": "vsMilestone",
    "Mirror": "vsMirror",
    "MortarBoard": "vsMortarBoard",
    "Move": "vsMove",
    "MultipleWindows": "vsMultipleWindows",
    "Music": "vsMusic",
    "Mute": "vsMute",
    "NewFile": "vsNewFile",
    "NewFolder": "vsNewFolder",
    "Newline": "vsNewline",
    "NoNewline": "vsNoNewline",
    "Note": "vsNote",
    "NotebookTemplate": "vsNotebookTemplate",
    "Notebook": "vsNotebook",
    "Octoface": "vsOctoface",
    "OpenPreview": "vsOpenPreview",
    "Organization": "vsOrganization",
    "Output": "vsOutput",
    "Package": "vsPackage",
    "Paintcan": "vsPaintcan",
    "PassFilled": "vsPassFilled",
    "Pass": "vsPass",
    "Percentage": "vsPercentage",
    "PersonAdd": "vsPersonAdd",
    "Person": "vsPerson",
    "Piano": "vsPiano",
    "PieChart": "vsPieChart",
    "Pin": "vsPin",
    "PinnedDirty": "vsPinnedDirty",
    "Pinned": "vsPinned",
    "PlayCircle": "vsPlayCircle",
    "Play": "vsPlay",
    "Plug": "vsPlug",
    "PreserveCase": "vsPreserveCase",
    "Preview": "vsPreview",
    "PrimitiveSquare": "vsPrimitiveSquare",
    "Project": "vsProject",
    "Pulse": "vsPulse",
    "Question": "vsQuestion",
    "Quote": "vsQuote",
    "RadioTower": "vsRadioTower",
    "Reactions": "vsReactions",
    "RecordKeys": "vsRecordKeys",
    "RecordSmall": "vsRecordSmall",
    "Record": "vsRecord",
    "Redo": "vsRedo",
    "References": "vsReferences",
    "Refresh": "vsRefresh",
    "Regex": "vsRegex",
    "RemoteExplorer": "vsRemoteExplorer",
    "Remote": "vsRemote",
    "Remove": "vsRemove",
    "ReplaceAll": "vsReplaceAll",
    "Replace": "vsReplace",
    "Reply": "vsReply",
    "RepoClone": "vsRepoClone",
    "RepoForcePush": "vsRepoForcePush",
    "RepoForked": "vsRepoForked",
    "RepoPull": "vsRepoPull",
    "RepoPush": "vsRepoPush",
    "Repo": "vsRepo",
    "Report": "vsReport",
    "RequestChanges": "vsRequestChanges",
    "Robot": "vsRobot",
    "Rocket": "vsRocket",
    "RootFolderOpened": "vsRootFolderOpened",
    "RootFolder": "vsRootFolder",
    "Rss": "vsRss",
    "Ruby": "vsRuby",
    "RunAbove": "vsRunAbove",
    "RunAllCoverage": "vsRunAllCoverage",
    "RunAll": "vsRunAll",
    "RunBelow": "vsRunBelow",
    "RunCoverage": "vsRunCoverage",
    "RunErrors": "vsRunErrors",
    "SaveAll": "vsSaveAll",
    "SaveAs": "vsSaveAs",
    "Save": "vsSave",
    "ScreenFull": "vsScreenFull",
    "ScreenNormal": "vsScreenNormal",
    "SearchFuzzy": "vsSearchFuzzy",
    "SearchStop": "vsSearchStop",
    "Search": "vsSearch",
    "Send": "vsSend",
    "ServerEnvironment": "vsServerEnvironment",
    "ServerProcess": "vsServerProcess",
    "Server": "vsServer",
    "SettingsGear": "vsSettingsGear",
    "Settings": "vsSettings",
    "Share": "vsShare",
    "Shield": "vsShield",
    "SignIn": "vsSignIn",
    "SignOut": "vsSignOut",
    "Smiley": "vsSmiley",
    "Snake": "vsSnake",
    "SortPrecedence": "vsSortPrecedence",
    "SourceControl": "vsSourceControl",
    "SparkleFilled": "vsSparkleFilled",
    "Sparkle": "vsSparkle",
    "SplitHorizontal": "vsSplitHorizontal",
    "SplitVertical": "vsSplitVertical",
    "Squirrel": "vsSquirrel",
    "StarEmpty": "vsStarEmpty",
    "StarFull": "vsStarFull",
    "StarHalf": "vsStarHalf",
    "StopCircle": "vsStopCircle",
    "SurroundWith": "vsSurroundWith",
    "SymbolArray": "vsSymbolArray",
    "SymbolBoolean": "vsSymbolBoolean",
    "SymbolClass": "vsSymbolClass",
    "SymbolColor": "vsSymbolColor",
    "SymbolConstant": "vsSymbolConstant",
    "SymbolEnumMember": "vsSymbolEnumMember",
    "SymbolEnum": "vsSymbolEnum",
    "SymbolEvent": "vsSymbolEvent",
    "SymbolField": "vsSymbolField",
    "SymbolFile": "vsSymbolFile",
    "SymbolInterface": "vsSymbolInterface",
    "SymbolKey": "vsSymbolKey",
    "SymbolKeyword": "vsSymbolKeyword",
    "SymbolMethod": "vsSymbolMethod",
    "SymbolMisc": "vsSymbolMisc",
    "SymbolNamespace": "vsSymbolNamespace",
    "SymbolNumeric": "vsSymbolNumeric",
    "SymbolOperator": "vsSymbolOperator",
    "SymbolParameter": "vsSymbolParameter",
    "SymbolProperty": "vsSymbolProperty",
    "SymbolRuler": "vsSymbolRuler",
    "SymbolSnippet": "vsSymbolSnippet",
    "SymbolString": "vsSymbolString",
    "SymbolStructure": "vsSymbolStructure",
    "SymbolVariable": "vsSymbolVariable",
    "SyncIgnored": "vsSyncIgnored",
    "Sync": "vsSync",
    "Table": "vsTable",
    "Tag": "vsTag",
    "Target": "vsTarget",
    "Tasklist": "vsTasklist",
    "Telescope": "vsTelescope",
    "TerminalBash": "vsTerminalBash",
    "TerminalCmd": "vsTerminalCmd",
    "TerminalDebian": "vsTerminalDebian",
    "TerminalLinux": "vsTerminalLinux",
    "TerminalPowershell": "vsTerminalPowershell",
    "TerminalTmux": "vsTerminalTmux",
    "TerminalUbuntu": "vsTerminalUbuntu",
    "Terminal": "vsTerminal",
    "TextSize": "vsTextSize",
    "ThreeBars": "vsThreeBars",
    "ThumbsdownFilled": "vsThumbsdownFilled",
    "Thumbsdown": "vsThumbsdown",
    "ThumbsupFilled": "vsThumbsupFilled",
    "Thumbsup": "vsThumbsup",
    "Tools": "vsTools",
    "Trash": "vsTrash",
    "TriangleDown": "vsTriangleDown",
    "TriangleLeft": "vsTriangleLeft",
    "TriangleRight": "vsTriangleRight",
    "TriangleUp": "vsTriangleUp",
    "Twitter": "vsTwitter",
    "TypeHierarchySub": "vsTypeHierarchySub",
    "TypeHierarchySuper": "vsTypeHierarchySuper",
    "TypeHierarchy": "vsTypeHierarchy",
    "Unfold": "vsUnfold",
    "UngroupByRefType": "vsUngroupByRefType",
    "Unlock": "vsUnlock",
    "Unmute": "vsUnmute",
    "Unverified": "vsUnverified",
    "VariableGroup": "vsVariableGroup",
    "VerifiedFilled": "vsVerifiedFilled",
    "Verified": "vsVerified",
    "Versions": "vsVersions",
    "VmActive": "vsVmActive",
    "VmConnect": "vsVmConnect",
    "VmOutline": "vsVmOutline",
    "VmRunning": "vsVmRunning",
    "Vm": "vsVm",
    "Vr": "vsVr",
    "VscodeInsiders": "vsVscodeInsiders",
    "Vscode": "vsVscode",
    "Wand": "vsWand",
    "Warning": "vsWarning",
    "Watch": "vsWatch",
    "Whitespace": "vsWhitespace",
    "WholeWord": "vsWholeWord",
    "Window": "vsWindow",
    "WordWrap": "vsWordWrap",
    "WorkspaceTrusted": "vsWorkspaceTrusted",
    "WorkspaceUnknown": "vsWorkspaceUnknown",
    "WorkspaceUntrusted": "vsWorkspaceUntrusted",
    "ZoomIn": "vsZoomIn",
    "ZoomOut": "vsZoomOut",
    "vs_account": "vsAccount",
    "vs_activate_breakpoints": "vsActivateBreakpoints",
    "vs_add": "vsAdd",
    "vs_archive": "vsArchive",
    "vs_arrow_both": "vsArrowBoth",
    "vs_arrow_circle_down": "vsArrowCircleDown",
    "vs_arrow_circle_left": "vsArrowCircleLeft",
    "vs_arrow_circle_right": "vsArrowCircleRight",
    "vs_arrow_circle_up": "vsArrowCircleUp",
    "vs_arrow_down": "vsArrowDown",
    "vs_arrow_left": "vsArrowLeft",
    "vs_arrow_right": "vsArrowRight",
    "vs_arrow_small_down": "vsArrowSmallDown",
    "vs_arrow_small_left": "vsArrowSmallLeft",
    "vs_arrow_small_right": "vsArrowSmallRight",
    "vs_arrow_small_up": "vsArrowSmallUp",
    "vs_arrow_swap": "vsArrowSwap",
    "vs_arrow_up": "vsArrowUp",
    "vs_azure_devops": "vsAzureDevops",
    "vs_azure": "vsAzure",
    "vs_beaker_stop": "vsBeakerStop",
    "vs_beaker": "vsBeaker",
    "vs_bell_dot": "vsBellDot",
    "vs_bell_slash_dot": "vsBellSlashDot",
    "vs_bell_slash": "vsBellSlash",
    "vs_bell": "vsBell",
    "vs_blank": "vsBlank",
    "vs_bold": "vsBold",
    "vs_book": "vsBook",
    "vs_bookmark": "vsBookmark",
    "vs_bracket_dot": "vsBracketDot",
    "vs_bracket_error": "vsBracketError",
    "vs_briefcase": "vsBriefcase",
    "vs_broadcast": "vsBroadcast",
    "vs_browser": "vsBrowser",
    "vs_bug": "vsBug",
    "vs_calendar": "vsCalendar",
    "vs_call_incoming": "vsCallIncoming",
    "vs_call_outgoing": "vsCallOutgoing",
    "vs_case_sensitive": "vsCaseSensitive",
    "vs_check_all": "vsCheckAll",
    "vs_check": "vsCheck",
    "vs_checklist": "vsChecklist",
    "vs_chevron_down": "vsChevronDown",
    "vs_chevron_left": "vsChevronLeft",
    "vs_chevron_right": "vsChevronRight",
    "vs_chevron_up": "vsChevronUp",
    "vs_chip": "vsChip",
    "vs_chrome_close": "vsChromeClose",
    "vs_chrome_maximize": "vsChromeMaximize",
    "vs_chrome_minimize": "vsChromeMinimize",
    "vs_chrome_restore": "vsChromeRestore",
    "vs_circle_filled": "vsCircleFilled",
    "vs_circle_large_filled": "vsCircleLargeFilled",
    "vs_circle_large": "vsCircleLarge",
    "vs_circle_slash": "vsCircleSlash",
    "vs_circle_small_filled": "vsCircleSmallFilled",
    "vs_circle_small": "vsCircleSmall",
    "vs_circle": "vsCircle",
    "vs_circuit_board": "vsCircuitBoard",
    "vs_clear_all": "vsClearAll",
    "vs_clippy": "vsClippy",
    "vs_close_all": "vsCloseAll",
    "vs_close": "vsClose",
    "vs_cloud_download": "vsCloudDownload",
    "vs_cloud_upload": "vsCloudUpload",
    "vs_cloud": "vsCloud",
    "vs_code_oss": "vsCodeOss",
    "vs_code": "vsCode",
    "vs_coffee": "vsCoffee",
    "vs_collapse_all": "vsCollapseAll",
    "vs_color_mode": "vsColorMode",
    "vs_combine": "vsCombine",
    "vs_comment_discussion": "vsCommentDiscussion",
    "vs_comment_draft": "vsCommentDraft",
    "vs_comment_unresolved": "vsCommentUnresolved",
    "vs_comment": "vsComment",
    "vs_compass_active": "vsCompassActive",
    "vs_compass_dot": "vsCompassDot",
    "vs_compass": "vsCompass",
    "vs_copilot": "vsCopilot",
    "vs_copy": "vsCopy",
    "vs_coverage": "vsCoverage",
    "vs_credit_card": "vsCreditCard",
    "vs_dash": "vsDash",
    "vs_dashboard": "vsDashboard",
    "vs_database": "vsDatabase",
    "vs_debug_all": "vsDebugAll",
    "vs_debug_alt_small": "vsDebugAltSmall",
    "vs_debug_alt": "vsDebugAlt",
    "vs_debug_breakpoint_conditional_unverified": "vsDebugBreakpointConditionalUnverified",
    "vs_debug_breakpoint_conditional": "vsDebugBreakpointConditional",
    "vs_debug_breakpoint_data_unverified": "vsDebugBreakpointDataUnverified",
    "vs_debug_breakpoint_data": "vsDebugBreakpointData",
    "vs_debug_breakpoint_function_unverified": "vsDebugBreakpointFunctionUnverified",
    "vs_debug_breakpoint_function": "vsDebugBreakpointFunction",
    "vs_debug_breakpoint_log_unverified": "vsDebugBreakpointLogUnverified",
    "vs_debug_breakpoint_log": "vsDebugBreakpointLog",
    "vs_debug_breakpoint_unsupported": "vsDebugBreakpointUnsupported",
    "vs_debug_console": "vsDebugConsole",
    "vs_debug_continue_small": "vsDebugContinueSmall",
    "vs_debug_continue": "vsDebugContinue",
    "vs_debug_coverage": "vsDebugCoverage",
    "vs_debug_disconnect": "vsDebugDisconnect",
    "vs_debug_line_by_line": "vsDebugLineByLine",
    "vs_debug_pause": "vsDebugPause",
    "vs_debug_rerun": "vsDebugRerun",
    "vs_debug_restart_frame": "vsDebugRestartFrame",
    "vs_debug_restart": "vsDebugRestart",
    "vs_debug_reverse_continue": "vsDebugReverseContinue",
    "vs_debug_stackframe_active": "vsDebugStackframeActive",
    "vs_debug_stackframe": "vsDebugStackframe",
    "vs_debug_start": "vsDebugStart",
    "vs_debug_step_back": "vsDebugStepBack",
    "vs_debug_step_into": "vsDebugStepInto",
    "vs_debug_step_out": "vsDebugStepOut",
    "vs_debug_step_over": "vsDebugStepOver",
    "vs_debug_stop": "vsDebugStop",
    "vs_debug": "vsDebug",
    "vs_desktop_download": "vsDesktopDownload",
    "vs_device_camera_video": "vsDeviceCameraVideo",
    "vs_device_camera": "vsDeviceCamera",
    "vs_device_mobile": "vsDeviceMobile",
    "vs_diff_added": "vsDiffAdded",
    "vs_diff_ignored": "vsDiffIgnored",
    "vs_diff_modified": "vsDiffModified",
    "vs_diff_multiple": "vsDiffMultiple",
    "vs_diff_removed": "vsDiffRemoved",
    "vs_diff_renamed": "vsDiffRenamed",
    "vs_diff_single": "vsDiffSingle",
    "vs_diff": "vsDiff",
    "vs_discard": "vsDiscard",
    "vs_edit": "vsEdit",
    "vs_editor_layout": "vsEditorLayout",
    "vs_ellipsis": "vsEllipsis",
    "vs_empty_window": "vsEmptyWindow",
    "vs_error_small": "vsErrorSmall",
    "vs_error": "vsError",
    "vs_exclude": "vsExclude",
    "vs_expand_all": "vsExpandAll",
    "vs_export": "vsExport",
    "vs_extensions": "vsExtensions",
    "vs_eye_closed": "vsEyeClosed",
    "vs_eye": "vsEye",
    "vs_feedback": "vsFeedback",
    "vs_file_binary": "vsFileBinary",
    "vs_file_code": "vsFileCode",
    "vs_file_media": "vsFileMedia",
    "vs_file_pdf": "vsFilePdf",
    "vs_file_submodule": "vsFileSubmodule",
    "vs_file_symlink_directory": "vsFileSymlinkDirectory",
    "vs_file_symlink_file": "vsFileSymlinkFile",
    "vs_file_zip": "vsFileZip",
    "vs_file": "vsFile",
    "vs_files": "vsFiles",
    "vs_filter_filled": "vsFilterFilled",
    "vs_filter": "vsFilter",
    "vs_flame": "vsFlame",
    "vs_fold_down": "vsFoldDown",
    "vs_fold_up": "vsFoldUp",
    "vs_fold": "vsFold",
    "vs_folder_active": "vsFolderActive",
    "vs_folder_library": "vsFolderLibrary",
    "vs_folder_opened": "vsFolderOpened",
    "vs_folder": "vsFolder",
    "vs_game": "vsGame",
    "vs_gear": "vsGear",
    "vs_gift": "vsGift",
    "vs_gist_secret": "vsGistSecret",
    "vs_gist": "vsGist",
    "vs_git_commit": "vsGitCommit",
    "vs_git_compare": "vsGitCompare",
    "vs_git_fetch": "vsGitFetch",
    "vs_git_merge": "vsGitMerge",
    "vs_git_pull_request_closed": "vsGitPullRequestClosed",
    "vs_git_pull_request_create": "vsGitPullRequestCreate",
    "vs_git_pull_request_draft": "vsGitPullRequestDraft",
    "vs_git_pull_request_go_to_changes": "vsGitPullRequestGoToChanges",
    "vs_git_pull_request_new_changes": "vsGitPullRequestNewChanges",
    "vs_git_pull_request": "vsGitPullRequest",
    "vs_git_stash_apply": "vsGitStashApply",
    "vs_git_stash_pop": "vsGitStashPop",
    "vs_git_stash": "vsGitStash",
    "vs_github_action": "vsGithubAction",
    "vs_github_alt": "vsGithubAlt",
    "vs_github_inverted": "vsGithubInverted",
    "vs_github_project": "vsGithubProject",
    "vs_github": "vsGithub",
    "vs_globe": "vsGlobe",
    "vs_go_to_file": "vsGoToFile",
    "vs_go_to_search": "vsGoToSearch",
    "vs_grabber": "vsGrabber",
    "vs_graph_left": "vsGraphLeft",
    "vs_graph_line": "vsGraphLine",
    "vs_graph_scatter": "vsGraphScatter",
    "vs_graph": "vsGraph",
    "vs_gripper": "vsGripper",
    "vs_group_by_ref_type": "vsGroupByRefType",
    "vs_heart_filled": "vsHeartFilled",
    "vs_heart": "vsHeart",
    "vs_history": "vsHistory",
    "vs_home": "vsHome",
    "vs_horizontal_rule": "vsHorizontalRule",
    "vs_hubot": "vsHubot",
    "vs_inbox": "vsInbox",
    "vs_indent": "vsIndent",
    "vs_info": "vsInfo",
    "vs_insert": "vsInsert",
    "vs_inspect": "vsInspect",
    "vs_issue_draft": "vsIssueDraft",
    "vs_issue_reopened": "vsIssueReopened",
    "vs_issues": "vsIssues",
    "vs_italic": "vsItalic",
    "vs_jersey": "vsJersey",
    "vs_json": "vsJson",
    "vs_kebab_vertical": "vsKebabVertical",
    "vs_key": "vsKey",
    "vs_law": "vsLaw",
    "vs_layers_active": "vsLayersActive",
    "vs_layers_dot": "vsLayersDot",
    "vs_layers": "vsLayers",
    "vs_layout_activitybar_left": "vsLayoutActivitybarLeft",
    "vs_layout_activitybar_right": "vsLayoutActivitybarRight",
    "vs_layout_centered": "vsLayoutCentered",
    "vs_layout_menubar": "vsLayoutMenubar",
    "vs_layout_panel_center": "vsLayoutPanelCenter",
    "vs_layout_panel_justify": "vsLayoutPanelJustify",
    "vs_layout_panel_left": "vsLayoutPanelLeft",
    "vs_layout_panel_off": "vsLayoutPanelOff",
    "vs_layout_panel_right": "vsLayoutPanelRight",
    "vs_layout_panel": "vsLayoutPanel",
    "vs_layout_sidebar_left_off": "vsLayoutSidebarLeftOff",
    "vs_layout_sidebar_left": "vsLayoutSidebarLeft",
    "vs_layout_sidebar_right_off": "vsLayoutSidebarRightOff",
    "vs_layout_sidebar_right": "vsLayoutSidebarRight",
    "vs_layout_statusbar": "vsLayoutStatusbar",
    "vs_layout": "vsLayout",
    "vs_library": "vsLibrary",
    "vs_lightbulb_autofix": "vsLightbulbAutofix",
    "vs_lightbulb_sparkle": "vsLightbulbSparkle",
    "vs_lightbulb": "vsLightbulb",
    "vs_link_external": "vsLinkExternal",
    "vs_link": "vsLink",
    "vs_list_filter": "vsListFilter",
    "vs_list_flat": "vsListFlat",
    "vs_list_ordered": "vsListOrdered",
    "vs_list_selection": "vsListSelection",
    "vs_list_tree": "vsListTree",
    "vs_list_unordered": "vsListUnordered",
    "vs_live_share": "vsLiveShare",
    "vs_loading": "vsLoading",
    "vs_location": "vsLocation",
    "vs_lock_small": "vsLockSmall",
    "vs_lock": "vsLock",
    "vs_magnet": "vsMagnet",
    "vs_mail_read": "vsMailRead",
    "vs_mail": "vsMail",
    "vs_map_filled": "vsMapFilled",
    "vs_map_vertical_filled": "vsMapVerticalFilled",
    "vs_map_vertical": "vsMapVertical",
    "vs_map": "vsMap",
    "vs_markdown": "vsMarkdown",
    "vs_megaphone": "vsMegaphone",
    "vs_mention": "vsMention",
    "vs_menu": "vsMenu",
    "vs_merge": "vsMerge",
    "vs_mic_filled": "vsMicFilled",
    "vs_mic": "vsMic",
    "vs_milestone": "vsMilestone",
    "vs_mirror": "vsMirror",
    "vs_mortar_board": "vsMortarBoard",
    "vs_move": "vsMove",
    "vs_multiple_windows": "vsMultipleWindows",
    "vs_music": "vsMusic",
    "vs_mute": "vsMute",
    "vs_new_file": "vsNewFile",
    "vs_new_folder": "vsNewFolder",
    "vs_newline": "vsNewline",
    "vs_no_newline": "vsNoNewline",
    "vs_note": "vsNote",
    "vs_notebook_template": "vsNotebookTemplate",
    "vs_notebook": "vsNotebook",
    "vs_octoface": "vsOctoface",
    "vs_open_preview": "vsOpenPreview",
    "vs_organization": "vsOrganization",
    "vs_output": "vsOutput",
    "vs_package": "vsPackage",
    "vs_paintcan": "vsPaintcan",
    "vs_pass_filled": "vsPassFilled",
    "vs_pass": "vsPass",
    "vs_percentage": "vsPercentage",
    "vs_person_add": "vsPersonAdd",
    "vs_person": "vsPerson",
    "vs_piano": "vsPiano",
    "vs_pie_chart": "vsPieChart",
    "vs_pin": "vsPin",
    "vs_pinned_dirty": "vsPinnedDirty",
    "vs_pinned": "vsPinned",
    "vs_play_circle": "vsPlayCircle",
    "vs_play": "vsPlay",
    "vs_plug": "vsPlug",
    "vs_preserve_case": "vsPreserveCase",
    "vs_preview": "vsPreview",
    "vs_primitive_square": "vsPrimitiveSquare",
    "vs_project": "vsProject",
    "vs_pulse": "vsPulse",
    "vs_question": "vsQuestion",
    "vs_quote": "vsQuote",
    "vs_radio_tower": "vsRadioTower",
    "vs_reactions": "vsReactions",
    "vs_record_keys": "vsRecordKeys",
    "vs_record_small": "vsRecordSmall",
    "vs_record": "vsRecord",
    "vs_redo": "vsRedo",
    "vs_references": "vsReferences",
    "vs_refresh": "vsRefresh",
    "vs_regex": "vsRegex",
    "vs_remote_explorer": "vsRemoteExplorer",
    "vs_remote": "vsRemote",
    "vs_remove": "vsRemove",
    "vs_replace_all": "vsReplaceAll",
    "vs_replace": "vsReplace",
    "vs_reply": "vsReply",
    "vs_repo_clone": "vsRepoClone",
    "vs_repo_force_push": "vsRepoForcePush",
    "vs_repo_forked": "vsRepoForked",
    "vs_repo_pull": "vsRepoPull",
    "vs_repo_push": "vsRepoPush",
    "vs_repo": "vsRepo",
    "vs_report": "vsReport",
    "vs_request_changes": "vsRequestChanges",
    "vs_robot": "vsRobot",
    "vs_rocket": "vsRocket",
    "vs_root_folder_opened": "vsRootFolderOpened",
    "vs_root_folder": "vsRootFolder",
    "vs_rss": "vsRss",
    "vs_ruby": "vsRuby",
    "vs_run_above": "vsRunAbove",
    "vs_run_all_coverage": "vsRunAllCoverage",
    "vs_run_all": "vsRunAll",
    "vs_run_below": "vsRunBelow",
    "vs_run_coverage": "vsRunCoverage",
    "vs_run_errors": "vsRunErrors",
    "vs_save_all": "vsSaveAll",
    "vs_save_as": "vsSaveAs",
    "vs_save": "vsSave",
    "vs_screen_full": "vsScreenFull",
    "vs_screen_normal": "vsScreenNormal",
    "vs_search_fuzzy": "vsSearchFuzzy",
    "vs_search_stop": "vsSearchStop",
    "vs_search": "vsSearch",
    "vs_send": "vsSend",
    "vs_server_environment": "vsServerEnvironment",
    "vs_server_process": "vsServerProcess",
    "vs_server": "vsServer",
    "vs_settings_gear": "vsSettingsGear",
    "vs_settings": "vsSettings",
    "vs_share": "vsShare",
    "vs_shield": "vsShield",
    "vs_sign_in": "vsSignIn",
    "vs_sign_out": "vsSignOut",
    "vs_smiley": "vsSmiley",
    "vs_snake": "vsSnake",
    "vs_sort_precedence": "vsSortPrecedence",
    "vs_source_control": "vsSourceControl",
    "vs_sparkle_filled": "vsSparkleFilled",
    "vs_sparkle": "vsSparkle",
    "vs_split_horizontal": "vsSplitHorizontal",
    "vs_split_vertical": "vsSplitVertical",
    "vs_squirrel": "vsSquirrel",
    "vs_star_empty": "vsStarEmpty",
    "vs_star_full": "vsStarFull",
    "vs_star_half": "vsStarHalf",
    "vs_stop_circle": "vsStopCircle",
    "vs_surround_with": "vsSurroundWith",
    "vs_symbol_array": "vsSymbolArray",
    "vs_symbol_boolean": "vsSymbolBoolean",
    "vs_symbol_class": "vsSymbolClass",
    "vs_symbol_color": "vsSymbolColor",
    "vs_symbol_constant": "vsSymbolConstant",
    "vs_symbol_enum_member": "vsSymbolEnumMember",
    "vs_symbol_enum": "vsSymbolEnum",
    "vs_symbol_event": "vsSymbolEvent",
    "vs_symbol_field": "vsSymbolField",
    "vs_symbol_file": "vsSymbolFile",
    "vs_symbol_interface": "vsSymbolInterface",
    "vs_symbol_key": "vsSymbolKey",
    "vs_symbol_keyword": "vsSymbolKeyword",
    "vs_symbol_method": "vsSymbolMethod",
    "vs_symbol_misc": "vsSymbolMisc",
    "vs_symbol_namespace": "vsSymbolNamespace",
    "vs_symbol_numeric": "vsSymbolNumeric",
    "vs_symbol_operator": "vsSymbolOperator",
    "vs_symbol_parameter": "vsSymbolParameter",
    "vs_symbol_property": "vsSymbolProperty",
    "vs_symbol_ruler": "vsSymbolRuler",
    "vs_symbol_snippet": "vsSymbolSnippet",
    "vs_symbol_string": "vsSymbolString",
    "vs_symbol_structure": "vsSymbolStructure",
    "vs_symbol_variable": "vsSymbolVariable",
    "vs_sync_ignored": "vsSyncIgnored",
    "vs_sync": "vsSync",
    "vs_table": "vsTable",
    "vs_tag": "vsTag",
    "vs_target": "vsTarget",
    "vs_tasklist": "vsTasklist",
    "vs_telescope": "vsTelescope",
    "vs_terminal_bash": "vsTerminalBash",
    "vs_terminal_cmd": "vsTerminalCmd",
    "vs_terminal_debian": "vsTerminalDebian",
    "vs_terminal_linux": "vsTerminalLinux",
    "vs_terminal_powershell": "vsTerminalPowershell",
    "vs_terminal_tmux": "vsTerminalTmux",
    "vs_terminal_ubuntu": "vsTerminalUbuntu",
    "vs_terminal": "vsTerminal",
    "vs_text_size": "vsTextSize",
    "vs_three_bars": "vsThreeBars",
    "vs_thumbsdown_filled": "vsThumbsdownFilled",
    "vs_thumbsdown": "vsThumbsdown",
    "vs_thumbsup_filled": "vsThumbsupFilled",
    "vs_thumbsup": "vsThumbsup",
    "vs_tools": "vsTools",
    "vs_trash": "vsTrash",
    "vs_triangle_down": "vsTriangleDown",
    "vs_triangle_left": "vsTriangleLeft",
    "vs_triangle_right": "vsTriangleRight",
    "vs_triangle_up": "vsTriangleUp",
    "vs_twitter": "vsTwitter",
    "vs_type_hierarchy_sub": "vsTypeHierarchySub",
    "vs_type_hierarchy_super": "vsTypeHierarchySuper",
    "vs_type_hierarchy": "vsTypeHierarchy",
    "vs_unfold": "vsUnfold",
    "vs_ungroup_by_ref_type": "vsUngroupByRefType",
    "vs_unlock": "vsUnlock",
    "vs_unmute": "vsUnmute",
    "vs_unverified": "vsUnverified",
    "vs_variable_group": "vsVariableGroup",
    "vs_verified_filled": "vsVerifiedFilled",
    "vs_verified": "vsVerified",
    "vs_versions": "vsVersions",
    "vs_vm_active": "vsVmActive",
    "vs_vm_connect": "vsVmConnect",
    "vs_vm_outline": "vsVmOutline",
    "vs_vm_running": "vsVmRunning",
    "vs_vm": "vsVm",
    "vs_vr": "vsVr",
    "vs_vscode_insiders": "vsVscodeInsiders",
    "vs_vscode": "vsVscode",
    "vs_wand": "vsWand",
    "vs_warning": "vsWarning",
    "vs_watch": "vsWatch",
    "vs_whitespace": "vsWhitespace",
    "vs_whole_word": "vsWholeWord",
    "vs_window": "vsWindow",
    "vs_word_wrap": "vsWordWrap",
    "vs_workspace_trusted": "vsWorkspaceTrusted",
    "vs_workspace_unknown": "vsWorkspaceUnknown",
    "vs_workspace_untrusted": "vsWorkspaceUntrusted",
    "vs_zoom_in": "vsZoomIn",
    "vs_zoom_out": "vsZoomOut",
    "dh_add_small": "dhAddSmall",
    "dh_arrow_to_bottom": "dhArrowToBottom",
    "dh_arrow_to_top": "dhArrowToTop",
    "dh_check_square": "dhCheckSquare",
    "dh_chevron_down_square": "dhChevronDownSquare",
    "dh_circle_large_outline_notch": "dhCircleLargeOutlineNotch",
    "dh_clock": "dhClock",
    "dh_exclamation": "dhExclamation",
    "dh_eye_slash": "dhEyeSlash",
    "dh_eye": "dhEye",
    "dh_file_certificate": "dhFileCertificate",
    "dh_file_csv": "dhFileCsv",
    "dh_file_download": "dhFileDownload",
    "dh_file_print": "dhFilePrint",
    "dh_file_search": "dhFileSearch",
    "dh_file_spreadsheet": "dhFileSpreadsheet",
    "dh_filter_filled": "dhFilterFilled",
    "dh_filter_slash": "dhFilterSlash",
    "dh_freeze": "dhFreeze",
    "dh_gear_filled": "dhGearFilled",
    "dh_gears_filled": "dhGearsFilled",
    "dh_graph_line_down": "dhGraphLineDown",
    "dh_graph_line_up": "dhGraphLineUp",
    "dh_i_cursor": "dhICursor",
    "dh_input": "dhInput",
    "dh_new_circle_large_filled": "dhNewCircleLargeFilled",
    "dh_new_square_filled": "dhNewSquareFilled",
    "dh_organization_add": "dhOrganizationAdd",
    "dh_pandas": "dhPandas",
    "dh_panels": "dhPanels",
    "dh_python": "dhPython",
    "dh_refresh": "dhRefresh",
    "dh_remove_square_filled": "dhRemoveSquareFilled",
    "dh_run_selection": "dhRunSelection",
    "dh_shapes": "dhShapes",
    "dh_share_filled": "dhShareFilled",
    "dh_share": "dhShare",
    "dh_sort_alpha_down": "dhSortAlphaDown",
    "dh_sort_alpha_up": "dhSortAlphaUp",
    "dh_sort_amount_down": "dhSortAmountDown",
    "dh_sort_down": "dhSortDown",
    "dh_sort_slash": "dhSortSlash",
    "dh_sort_up": "dhSortUp",
    "dh_sort": "dhSort",
    "dh_split_both": "dhSplitBoth",
    "dh_square_filled": "dhSquareFilled",
    "dh_sticky_note_filled": "dhStickyNoteFilled",
    "dh_strikethrough": "dhStrikethrough",
    "dh_table": "dhTable",
    "dh_trash_undo": "dhTrashUndo",
    "dh_triangle_down_square": "dhTriangleDownSquare",
    "dh_truck": "dhTruck",
    "dh_underline": "dhUnderline",
    "dh_unlink": "dhUnlink",
    "dh_user_incognito": "dhUserIncognito",
    "dh_user": "dhUser",
    "dh_warning_circle_filled": "dhWarningCircleFilled",
    "dh_warning_filled": "dhWarningFilled",
    "account": "vsAccount",
    "activate_breakpoints": "vsActivateBreakpoints",
    "add": "vsAdd",
    "archive": "vsArchive",
    "arrow_both": "vsArrowBoth",
    "arrow_circle_down": "vsArrowCircleDown",
    "arrow_circle_left": "vsArrowCircleLeft",
    "arrow_circle_right": "vsArrowCircleRight",
    "arrow_circle_up": "vsArrowCircleUp",
    "arrow_down": "vsArrowDown",
    "arrow_left": "vsArrowLeft",
    "arrow_right": "vsArrowRight",
    "arrow_small_down": "vsArrowSmallDown",
    "arrow_small_left": "vsArrowSmallLeft",
    "arrow_small_right": "vsArrowSmallRight",
    "arrow_small_up": "vsArrowSmallUp",
    "arrow_swap": "vsArrowSwap",
    "arrow_up": "vsArrowUp",
    "azure_devops": "vsAzureDevops",
    "azure": "vsAzure",
    "beaker_stop": "vsBeakerStop",
    "beaker": "vsBeaker",
    "bell_dot": "vsBellDot",
    "bell_slash_dot": "vsBellSlashDot",
    "bell_slash": "vsBellSlash",
    "bell": "vsBell",
    "blank": "vsBlank",
    "bold": "vsBold",
    "book": "vsBook",
    "bookmark": "vsBookmark",
    "bracket_dot": "vsBracketDot",
    "bracket_error": "vsBracketError",
    "briefcase": "vsBriefcase",
    "broadcast": "vsBroadcast",
    "browser": "vsBrowser",
    "bug": "vsBug",
    "calendar": "vsCalendar",
    "call_incoming": "vsCallIncoming",
    "call_outgoing": "vsCallOutgoing",
    "case_sensitive": "vsCaseSensitive",
    "check_all": "vsCheckAll",
    "check": "vsCheck",
    "checklist": "vsChecklist",
    "chevron_down": "vsChevronDown",
    "chevron_left": "vsChevronLeft",
    "chevron_right": "vsChevronRight",
    "chevron_up": "vsChevronUp",
    "chip": "vsChip",
    "chrome_close": "vsChromeClose",
    "chrome_maximize": "vsChromeMaximize",
    "chrome_minimize": "vsChromeMinimize",
    "chrome_restore": "vsChromeRestore",
    "circle_filled": "vsCircleFilled",
    "circle_large_filled": "vsCircleLargeFilled",
    "circle_large": "vsCircleLarge",
    "circle_slash": "vsCircleSlash",
    "circle_small_filled": "vsCircleSmallFilled",
    "circle_small": "vsCircleSmall",
    "circle": "vsCircle",
    "circuit_board": "vsCircuitBoard",
    "clear_all": "vsClearAll",
    "clippy": "vsClippy",
    "close_all": "vsCloseAll",
    "close": "vsClose",
    "cloud_download": "vsCloudDownload",
    "cloud_upload": "vsCloudUpload",
    "cloud": "vsCloud",
    "code_oss": "vsCodeOss",
    "code": "vsCode",
    "coffee": "vsCoffee",
    "collapse_all": "vsCollapseAll",
    "color_mode": "vsColorMode",
    "combine": "vsCombine",
    "comment_discussion": "vsCommentDiscussion",
    "comment_draft": "vsCommentDraft",
    "comment_unresolved": "vsCommentUnresolved",
    "comment": "vsComment",
    "compass_active": "vsCompassActive",
    "compass_dot": "vsCompassDot",
    "compass": "vsCompass",
    "copilot": "vsCopilot",
    "copy": "vsCopy",
    "coverage": "vsCoverage",
    "credit_card": "vsCreditCard",
    "dash": "vsDash",
    "dashboard": "vsDashboard",
    "database": "vsDatabase",
    "debug_all": "vsDebugAll",
    "debug_alt_small": "vsDebugAltSmall",
    "debug_alt": "vsDebugAlt",
    "debug_breakpoint_conditional_unverified": "vsDebugBreakpointConditionalUnverified",
    "debug_breakpoint_conditional": "vsDebugBreakpointConditional",
    "debug_breakpoint_data_unverified": "vsDebugBreakpointDataUnverified",
    "debug_breakpoint_data": "vsDebugBreakpointData",
    "debug_breakpoint_function_unverified": "vsDebugBreakpointFunctionUnverified",
    "debug_breakpoint_function": "vsDebugBreakpointFunction",
    "debug_breakpoint_log_unverified": "vsDebugBreakpointLogUnverified",
    "debug_breakpoint_log": "vsDebugBreakpointLog",
    "debug_breakpoint_unsupported": "vsDebugBreakpointUnsupported",
    "debug_console": "vsDebugConsole",
    "debug_continue_small": "vsDebugContinueSmall",
    "debug_continue": "vsDebugContinue",
    "debug_coverage": "vsDebugCoverage",
    "debug_disconnect": "vsDebugDisconnect",
    "debug_line_by_line": "vsDebugLineByLine",
    "debug_pause": "vsDebugPause",
    "debug_rerun": "vsDebugRerun",
    "debug_restart_frame": "vsDebugRestartFrame",
    "debug_restart": "vsDebugRestart",
    "debug_reverse_continue": "vsDebugReverseContinue",
    "debug_stackframe_active": "vsDebugStackframeActive",
    "debug_stackframe": "vsDebugStackframe",
    "debug_start": "vsDebugStart",
    "debug_step_back": "vsDebugStepBack",
    "debug_step_into": "vsDebugStepInto",
    "debug_step_out": "vsDebugStepOut",
    "debug_step_over": "vsDebugStepOver",
    "debug_stop": "vsDebugStop",
    "debug": "vsDebug",
    "desktop_download": "vsDesktopDownload",
    "device_camera_video": "vsDeviceCameraVideo",
    "device_camera": "vsDeviceCamera",
    "device_mobile": "vsDeviceMobile",
    "diff_added": "vsDiffAdded",
    "diff_ignored": "vsDiffIgnored",
    "diff_modified": "vsDiffModified",
    "diff_multiple": "vsDiffMultiple",
    "diff_removed": "vsDiffRemoved",
    "diff_renamed": "vsDiffRenamed",
    "diff_single": "vsDiffSingle",
    "diff": "vsDiff",
    "discard": "vsDiscard",
    "edit": "vsEdit",
    "editor_layout": "vsEditorLayout",
    "ellipsis": "vsEllipsis",
    "empty_window": "vsEmptyWindow",
    "error_small": "vsErrorSmall",
    "error": "vsError",
    "exclude": "vsExclude",
    "expand_all": "vsExpandAll",
    "export": "vsExport",
    "extensions": "vsExtensions",
    "eye_closed": "vsEyeClosed",
    "eye": "vsEye",
    "feedback": "vsFeedback",
    "file_binary": "vsFileBinary",
    "file_code": "vsFileCode",
    "file_media": "vsFileMedia",
    "file_pdf": "vsFilePdf",
    "file_submodule": "vsFileSubmodule",
    "file_symlink_directory": "vsFileSymlinkDirectory",
    "file_symlink_file": "vsFileSymlinkFile",
    "file_zip": "vsFileZip",
    "file": "vsFile",
    "files": "vsFiles",
    "filter_filled": "vsFilterFilled",
    "filter": "vsFilter",
    "flame": "vsFlame",
    "fold_down": "vsFoldDown",
    "fold_up": "vsFoldUp",
    "fold": "vsFold",
    "folder_active": "vsFolderActive",
    "folder_library": "vsFolderLibrary",
    "folder_opened": "vsFolderOpened",
    "folder": "vsFolder",
    "game": "vsGame",
    "gear": "vsGear",
    "gift": "vsGift",
    "gist_secret": "vsGistSecret",
    "gist": "vsGist",
    "git_commit": "vsGitCommit",
    "git_compare": "vsGitCompare",
    "git_fetch": "vsGitFetch",
    "git_merge": "vsGitMerge",
    "git_pull_request_closed": "vsGitPullRequestClosed",
    "git_pull_request_create": "vsGitPullRequestCreate",
    "git_pull_request_draft": "vsGitPullRequestDraft",
    "git_pull_request_go_to_changes": "vsGitPullRequestGoToChanges",
    "git_pull_request_new_changes": "vsGitPullRequestNewChanges",
    "git_pull_request": "vsGitPullRequest",
    "git_stash_apply": "vsGitStashApply",
    "git_stash_pop": "vsGitStashPop",
    "git_stash": "vsGitStash",
    "github_action": "vsGithubAction",
    "github_alt": "vsGithubAlt",
    "github_inverted": "vsGithubInverted",
    "github_project": "vsGithubProject",
    "github": "vsGithub",
    "globe": "vsGlobe",
    "go_to_file": "vsGoToFile",
    "go_to_search": "vsGoToSearch",
    "grabber": "vsGrabber",
    "graph_left": "vsGraphLeft",
    "graph_line": "vsGraphLine",
    "graph_scatter": "vsGraphScatter",
    "graph": "vsGraph",
    "gripper": "vsGripper",
    "group_by_ref_type": "vsGroupByRefType",
    "heart_filled": "vsHeartFilled",
    "heart": "vsHeart",
    "history": "vsHistory",
    "home": "vsHome",
    "horizontal_rule": "vsHorizontalRule",
    "hubot": "vsHubot",
    "inbox": "vsInbox",
    "indent": "vsIndent",
    "info": "vsInfo",
    "insert": "vsInsert",
    "inspect": "vsInspect",
    "issue_draft": "vsIssueDraft",
    "issue_reopened": "vsIssueReopened",
    "issues": "vsIssues",
    "italic": "vsItalic",
    "jersey": "vsJersey",
    "json": "vsJson",
    "kebab_vertical": "vsKebabVertical",
    "key": "vsKey",
    "law": "vsLaw",
    "layers_active": "vsLayersActive",
    "layers_dot": "vsLayersDot",
    "layers": "vsLayers",
    "layout_activitybar_left": "vsLayoutActivitybarLeft",
    "layout_activitybar_right": "vsLayoutActivitybarRight",
    "layout_centered": "vsLayoutCentered",
    "layout_menubar": "vsLayoutMenubar",
    "layout_panel_center": "vsLayoutPanelCenter",
    "layout_panel_justify": "vsLayoutPanelJustify",
    "layout_panel_left": "vsLayoutPanelLeft",
    "layout_panel_off": "vsLayoutPanelOff",
    "layout_panel_right": "vsLayoutPanelRight",
    "layout_panel": "vsLayoutPanel",
    "layout_sidebar_left_off": "vsLayoutSidebarLeftOff",
    "layout_sidebar_left": "vsLayoutSidebarLeft",
    "layout_sidebar_right_off": "vsLayoutSidebarRightOff",
    "layout_sidebar_right": "vsLayoutSidebarRight",
    "layout_statusbar": "vsLayoutStatusbar",
    "layout": "vsLayout",
    "library": "vsLibrary",
    "lightbulb_autofix": "vsLightbulbAutofix",
    "lightbulb_sparkle": "vsLightbulbSparkle",
    "lightbulb": "vsLightbulb",
    "link_external": "vsLinkExternal",
    "link": "vsLink",
    "list_filter": "vsListFilter",
    "list_flat": "vsListFlat",
    "list_ordered": "vsListOrdered",
    "list_selection": "vsListSelection",
    "list_tree": "vsListTree",
    "list_unordered": "vsListUnordered",
    "live_share": "vsLiveShare",
    "loading": "vsLoading",
    "location": "vsLocation",
    "lock_small": "vsLockSmall",
    "lock": "vsLock",
    "magnet": "vsMagnet",
    "mail_read": "vsMailRead",
    "mail": "vsMail",
    "map_filled": "vsMapFilled",
    "map_vertical_filled": "vsMapVerticalFilled",
    "map_vertical": "vsMapVertical",
    "map": "vsMap",
    "markdown": "vsMarkdown",
    "megaphone": "vsMegaphone",
    "mention": "vsMention",
    "menu": "vsMenu",
    "merge": "vsMerge",
    "mic_filled": "vsMicFilled",
    "mic": "vsMic",
    "milestone": "vsMilestone",
    "mirror": "vsMirror",
    "mortar_board": "vsMortarBoard",
    "move": "vsMove",
    "multiple_windows": "vsMultipleWindows",
    "music": "vsMusic",
    "mute": "vsMute",
    "new_file": "vsNewFile",
    "new_folder": "vsNewFolder",
    "newline": "vsNewline",
    "no_newline": "vsNoNewline",
    "note": "vsNote",
    "notebook_template": "vsNotebookTemplate",
    "notebook": "vsNotebook",
    "octoface": "vsOctoface",
    "open_preview": "vsOpenPreview",
    "organization": "vsOrganization",
    "output": "vsOutput",
    "package": "vsPackage",
    "paintcan": "vsPaintcan",
    "pass_filled": "vsPassFilled",
    "pass": "vsPass",
    "percentage": "vsPercentage",
    "person_add": "vsPersonAdd",
    "person": "vsPerson",
    "piano": "vsPiano",
    "pie_chart": "vsPieChart",
    "pin": "vsPin",
    "pinned_dirty": "vsPinnedDirty",
    "pinned": "vsPinned",
    "play_circle": "vsPlayCircle",
    "play": "vsPlay",
    "plug": "vsPlug",
    "preserve_case": "vsPreserveCase",
    "preview": "vsPreview",
    "primitive_square": "vsPrimitiveSquare",
    "project": "vsProject",
    "pulse": "vsPulse",
    "question": "vsQuestion",
    "quote": "vsQuote",
    "radio_tower": "vsRadioTower",
    "reactions": "vsReactions",
    "record_keys": "vsRecordKeys",
    "record_small": "vsRecordSmall",
    "record": "vsRecord",
    "redo": "vsRedo",
    "references": "vsReferences",
    "refresh": "vsRefresh",
    "regex": "vsRegex",
    "remote_explorer": "vsRemoteExplorer",
    "remote": "vsRemote",
    "remove": "vsRemove",
    "replace_all": "vsReplaceAll",
    "replace": "vsReplace",
    "reply": "vsReply",
    "repo_clone": "vsRepoClone",
    "repo_force_push": "vsRepoForcePush",
    "repo_forked": "vsRepoForked",
    "repo_pull": "vsRepoPull",
    "repo_push": "vsRepoPush",
    "repo": "vsRepo",
    "report": "vsReport",
    "request_changes": "vsRequestChanges",
    "robot": "vsRobot",
    "rocket": "vsRocket",
    "root_folder_opened": "vsRootFolderOpened",
    "root_folder": "vsRootFolder",
    "rss": "vsRss",
    "ruby": "vsRuby",
    "run_above": "vsRunAbove",
    "run_all_coverage": "vsRunAllCoverage",
    "run_all": "vsRunAll",
    "run_below": "vsRunBelow",
    "run_coverage": "vsRunCoverage",
    "run_errors": "vsRunErrors",
    "save_all": "vsSaveAll",
    "save_as": "vsSaveAs",
    "save": "vsSave",
    "screen_full": "vsScreenFull",
    "screen_normal": "vsScreenNormal",
    "search_fuzzy": "vsSearchFuzzy",
    "search_stop": "vsSearchStop",
    "search": "vsSearch",
    "send": "vsSend",
    "server_environment": "vsServerEnvironment",
    "server_process": "vsServerProcess",
    "server": "vsServer",
    "settings_gear": "vsSettingsGear",
    "settings": "vsSettings",
    "share": "vsShare",
    "shield": "vsShield",
    "sign_in": "vsSignIn",
    "sign_out": "vsSignOut",
    "smiley": "vsSmiley",
    "snake": "vsSnake",
    "sort_precedence": "vsSortPrecedence",
    "source_control": "vsSourceControl",
    "sparkle_filled": "vsSparkleFilled",
    "sparkle": "vsSparkle",
    "split_horizontal": "vsSplitHorizontal",
    "split_vertical": "vsSplitVertical",
    "squirrel": "vsSquirrel",
    "star_empty": "vsStarEmpty",
    "star_full": "vsStarFull",
    "star_half": "vsStarHalf",
    "stop_circle": "vsStopCircle",
    "surround_with": "vsSurroundWith",
    "symbol_array": "vsSymbolArray",
    "symbol_boolean": "vsSymbolBoolean",
    "symbol_class": "vsSymbolClass",
    "symbol_color": "vsSymbolColor",
    "symbol_constant": "vsSymbolConstant",
    "symbol_enum_member": "vsSymbolEnumMember",
    "symbol_enum": "vsSymbolEnum",
    "symbol_event": "vsSymbolEvent",
    "symbol_field": "vsSymbolField",
    "symbol_file": "vsSymbolFile",
    "symbol_interface": "vsSymbolInterface",
    "symbol_key": "vsSymbolKey",
    "symbol_keyword": "vsSymbolKeyword",
    "symbol_method": "vsSymbolMethod",
    "symbol_misc": "vsSymbolMisc",
    "symbol_namespace": "vsSymbolNamespace",
    "symbol_numeric": "vsSymbolNumeric",
    "symbol_operator": "vsSymbolOperator",
    "symbol_parameter": "vsSymbolParameter",
    "symbol_property": "vsSymbolProperty",
    "symbol_ruler": "vsSymbolRuler",
    "symbol_snippet": "vsSymbolSnippet",
    "symbol_string": "vsSymbolString",
    "symbol_structure": "vsSymbolStructure",
    "symbol_variable": "vsSymbolVariable",
    "sync_ignored": "vsSyncIgnored",
    "sync": "vsSync",
    "table": "vsTable",
    "tag": "vsTag",
    "target": "vsTarget",
    "tasklist": "vsTasklist",
    "telescope": "vsTelescope",
    "terminal_bash": "vsTerminalBash",
    "terminal_cmd": "vsTerminalCmd",
    "terminal_debian": "vsTerminalDebian",
    "terminal_linux": "vsTerminalLinux",
    "terminal_powershell": "vsTerminalPowershell",
    "terminal_tmux": "vsTerminalTmux",
    "terminal_ubuntu": "vsTerminalUbuntu",
    "terminal": "vsTerminal",
    "text_size": "vsTextSize",
    "three_bars": "vsThreeBars",
    "thumbsdown_filled": "vsThumbsdownFilled",
    "thumbsdown": "vsThumbsdown",
    "thumbsup_filled": "vsThumbsupFilled",
    "thumbsup": "vsThumbsup",
    "tools": "vsTools",
    "trash": "vsTrash",
    "triangle_down": "vsTriangleDown",
    "triangle_left": "vsTriangleLeft",
    "triangle_right": "vsTriangleRight",
    "triangle_up": "vsTriangleUp",
    "twitter": "vsTwitter",
    "type_hierarchy_sub": "vsTypeHierarchySub",
    "type_hierarchy_super": "vsTypeHierarchySuper",
    "type_hierarchy": "vsTypeHierarchy",
    "unfold": "vsUnfold",
    "ungroup_by_ref_type": "vsUngroupByRefType",
    "unlock": "vsUnlock",
    "unmute": "vsUnmute",
    "unverified": "vsUnverified",
    "variable_group": "vsVariableGroup",
    "verified_filled": "vsVerifiedFilled",
    "verified": "vsVerified",
    "versions": "vsVersions",
    "vm_active": "vsVmActive",
    "vm_connect": "vsVmConnect",
    "vm_outline": "vsVmOutline",
    "vm_running": "vsVmRunning",
    "vm": "vsVm",
    "vr": "vsVr",
    "vscode_insiders": "vsVscodeInsiders",
    "vscode": "vsVscode",
    "wand": "vsWand",
    "warning": "vsWarning",
    "watch": "vsWatch",
    "whitespace": "vsWhitespace",
    "whole_word": "vsWholeWord",
    "window": "vsWindow",
    "word_wrap": "vsWordWrap",
    "workspace_trusted": "vsWorkspaceTrusted",
    "workspace_unknown": "vsWorkspaceUnknown",
    "workspace_untrusted": "vsWorkspaceUntrusted",
    "zoom_in": "vsZoomIn",
    "zoom_out": "vsZoomOut",
}
