# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiYarnUtilization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'avg_cpu_utilization': 'float',
        'max_cpu_utilization': 'float',
        'avg_cpu_daily_peak': 'float',
        'max_cpu_utilization_timestamp_ms': 'int',
        'avg_cpu_utilization_percentage': 'float',
        'max_cpu_utilization_percentage': 'float',
        'avg_cpu_daily_peak_percentage': 'float',
        'avg_memory_utilization': 'float',
        'max_memory_utilization': 'float',
        'avg_memory_daily_peak': 'float',
        'max_memory_utilization_timestamp_ms': 'int',
        'avg_memory_utilization_percentage': 'float',
        'max_memory_utilization_percentage': 'float',
        'avg_memory_daily_peak_percentage': 'float',
        'tenant_utilizations': 'ApiYarnTenantUtilizationList',
        'error_message': 'str'
    }

    attribute_map = {
        'avg_cpu_utilization': 'avgCpuUtilization',
        'max_cpu_utilization': 'maxCpuUtilization',
        'avg_cpu_daily_peak': 'avgCpuDailyPeak',
        'max_cpu_utilization_timestamp_ms': 'maxCpuUtilizationTimestampMs',
        'avg_cpu_utilization_percentage': 'avgCpuUtilizationPercentage',
        'max_cpu_utilization_percentage': 'maxCpuUtilizationPercentage',
        'avg_cpu_daily_peak_percentage': 'avgCpuDailyPeakPercentage',
        'avg_memory_utilization': 'avgMemoryUtilization',
        'max_memory_utilization': 'maxMemoryUtilization',
        'avg_memory_daily_peak': 'avgMemoryDailyPeak',
        'max_memory_utilization_timestamp_ms': 'maxMemoryUtilizationTimestampMs',
        'avg_memory_utilization_percentage': 'avgMemoryUtilizationPercentage',
        'max_memory_utilization_percentage': 'maxMemoryUtilizationPercentage',
        'avg_memory_daily_peak_percentage': 'avgMemoryDailyPeakPercentage',
        'tenant_utilizations': 'tenantUtilizations',
        'error_message': 'errorMessage'
    }

    def __init__(self, avg_cpu_utilization=None, max_cpu_utilization=None, avg_cpu_daily_peak=None, max_cpu_utilization_timestamp_ms=None, avg_cpu_utilization_percentage=None, max_cpu_utilization_percentage=None, avg_cpu_daily_peak_percentage=None, avg_memory_utilization=None, max_memory_utilization=None, avg_memory_daily_peak=None, max_memory_utilization_timestamp_ms=None, avg_memory_utilization_percentage=None, max_memory_utilization_percentage=None, avg_memory_daily_peak_percentage=None, tenant_utilizations=None, error_message=None):
        """
        ApiYarnUtilization - a model defined in Swagger
        """

        self._avg_cpu_utilization = None
        self._max_cpu_utilization = None
        self._avg_cpu_daily_peak = None
        self._max_cpu_utilization_timestamp_ms = None
        self._avg_cpu_utilization_percentage = None
        self._max_cpu_utilization_percentage = None
        self._avg_cpu_daily_peak_percentage = None
        self._avg_memory_utilization = None
        self._max_memory_utilization = None
        self._avg_memory_daily_peak = None
        self._max_memory_utilization_timestamp_ms = None
        self._avg_memory_utilization_percentage = None
        self._max_memory_utilization_percentage = None
        self._avg_memory_daily_peak_percentage = None
        self._tenant_utilizations = None
        self._error_message = None

        if avg_cpu_utilization is not None:
          self.avg_cpu_utilization = avg_cpu_utilization
        if max_cpu_utilization is not None:
          self.max_cpu_utilization = max_cpu_utilization
        if avg_cpu_daily_peak is not None:
          self.avg_cpu_daily_peak = avg_cpu_daily_peak
        if max_cpu_utilization_timestamp_ms is not None:
          self.max_cpu_utilization_timestamp_ms = max_cpu_utilization_timestamp_ms
        if avg_cpu_utilization_percentage is not None:
          self.avg_cpu_utilization_percentage = avg_cpu_utilization_percentage
        if max_cpu_utilization_percentage is not None:
          self.max_cpu_utilization_percentage = max_cpu_utilization_percentage
        if avg_cpu_daily_peak_percentage is not None:
          self.avg_cpu_daily_peak_percentage = avg_cpu_daily_peak_percentage
        if avg_memory_utilization is not None:
          self.avg_memory_utilization = avg_memory_utilization
        if max_memory_utilization is not None:
          self.max_memory_utilization = max_memory_utilization
        if avg_memory_daily_peak is not None:
          self.avg_memory_daily_peak = avg_memory_daily_peak
        if max_memory_utilization_timestamp_ms is not None:
          self.max_memory_utilization_timestamp_ms = max_memory_utilization_timestamp_ms
        if avg_memory_utilization_percentage is not None:
          self.avg_memory_utilization_percentage = avg_memory_utilization_percentage
        if max_memory_utilization_percentage is not None:
          self.max_memory_utilization_percentage = max_memory_utilization_percentage
        if avg_memory_daily_peak_percentage is not None:
          self.avg_memory_daily_peak_percentage = avg_memory_daily_peak_percentage
        if tenant_utilizations is not None:
          self.tenant_utilizations = tenant_utilizations
        if error_message is not None:
          self.error_message = error_message

    @property
    def avg_cpu_utilization(self):
        """
        Gets the avg_cpu_utilization of this ApiYarnUtilization.
        Average number of VCores used by YARN applications during the report window.

        :return: The avg_cpu_utilization of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_cpu_utilization

    @avg_cpu_utilization.setter
    def avg_cpu_utilization(self, avg_cpu_utilization):
        """
        Sets the avg_cpu_utilization of this ApiYarnUtilization.
        Average number of VCores used by YARN applications during the report window.

        :param avg_cpu_utilization: The avg_cpu_utilization of this ApiYarnUtilization.
        :type: float
        """

        self._avg_cpu_utilization = avg_cpu_utilization

    @property
    def max_cpu_utilization(self):
        """
        Gets the max_cpu_utilization of this ApiYarnUtilization.
        Maximum number of VCores used by YARN applications during the report window.

        :return: The max_cpu_utilization of this ApiYarnUtilization.
        :rtype: float
        """
        return self._max_cpu_utilization

    @max_cpu_utilization.setter
    def max_cpu_utilization(self, max_cpu_utilization):
        """
        Sets the max_cpu_utilization of this ApiYarnUtilization.
        Maximum number of VCores used by YARN applications during the report window.

        :param max_cpu_utilization: The max_cpu_utilization of this ApiYarnUtilization.
        :type: float
        """

        self._max_cpu_utilization = max_cpu_utilization

    @property
    def avg_cpu_daily_peak(self):
        """
        Gets the avg_cpu_daily_peak of this ApiYarnUtilization.
        Average daily peak VCores used by YARN applications during the report window. The number is computed by first finding the maximum resource consumption per day and then taking their mean.

        :return: The avg_cpu_daily_peak of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_cpu_daily_peak

    @avg_cpu_daily_peak.setter
    def avg_cpu_daily_peak(self, avg_cpu_daily_peak):
        """
        Sets the avg_cpu_daily_peak of this ApiYarnUtilization.
        Average daily peak VCores used by YARN applications during the report window. The number is computed by first finding the maximum resource consumption per day and then taking their mean.

        :param avg_cpu_daily_peak: The avg_cpu_daily_peak of this ApiYarnUtilization.
        :type: float
        """

        self._avg_cpu_daily_peak = avg_cpu_daily_peak

    @property
    def max_cpu_utilization_timestamp_ms(self):
        """
        Gets the max_cpu_utilization_timestamp_ms of this ApiYarnUtilization.
        Timestamp corresponds to maximum number of VCores used by YARN applications during the report window.

        :return: The max_cpu_utilization_timestamp_ms of this ApiYarnUtilization.
        :rtype: int
        """
        return self._max_cpu_utilization_timestamp_ms

    @max_cpu_utilization_timestamp_ms.setter
    def max_cpu_utilization_timestamp_ms(self, max_cpu_utilization_timestamp_ms):
        """
        Sets the max_cpu_utilization_timestamp_ms of this ApiYarnUtilization.
        Timestamp corresponds to maximum number of VCores used by YARN applications during the report window.

        :param max_cpu_utilization_timestamp_ms: The max_cpu_utilization_timestamp_ms of this ApiYarnUtilization.
        :type: int
        """

        self._max_cpu_utilization_timestamp_ms = max_cpu_utilization_timestamp_ms

    @property
    def avg_cpu_utilization_percentage(self):
        """
        Gets the avg_cpu_utilization_percentage of this ApiYarnUtilization.
        Average percentage of VCores used by YARN applications during the report window.

        :return: The avg_cpu_utilization_percentage of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_cpu_utilization_percentage

    @avg_cpu_utilization_percentage.setter
    def avg_cpu_utilization_percentage(self, avg_cpu_utilization_percentage):
        """
        Sets the avg_cpu_utilization_percentage of this ApiYarnUtilization.
        Average percentage of VCores used by YARN applications during the report window.

        :param avg_cpu_utilization_percentage: The avg_cpu_utilization_percentage of this ApiYarnUtilization.
        :type: float
        """

        self._avg_cpu_utilization_percentage = avg_cpu_utilization_percentage

    @property
    def max_cpu_utilization_percentage(self):
        """
        Gets the max_cpu_utilization_percentage of this ApiYarnUtilization.
        Maximum percentage of VCores used by YARN applications during the report window.

        :return: The max_cpu_utilization_percentage of this ApiYarnUtilization.
        :rtype: float
        """
        return self._max_cpu_utilization_percentage

    @max_cpu_utilization_percentage.setter
    def max_cpu_utilization_percentage(self, max_cpu_utilization_percentage):
        """
        Sets the max_cpu_utilization_percentage of this ApiYarnUtilization.
        Maximum percentage of VCores used by YARN applications during the report window.

        :param max_cpu_utilization_percentage: The max_cpu_utilization_percentage of this ApiYarnUtilization.
        :type: float
        """

        self._max_cpu_utilization_percentage = max_cpu_utilization_percentage

    @property
    def avg_cpu_daily_peak_percentage(self):
        """
        Gets the avg_cpu_daily_peak_percentage of this ApiYarnUtilization.
        Average daily peak percentage of VCores used by YARN applications during the report window.

        :return: The avg_cpu_daily_peak_percentage of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_cpu_daily_peak_percentage

    @avg_cpu_daily_peak_percentage.setter
    def avg_cpu_daily_peak_percentage(self, avg_cpu_daily_peak_percentage):
        """
        Sets the avg_cpu_daily_peak_percentage of this ApiYarnUtilization.
        Average daily peak percentage of VCores used by YARN applications during the report window.

        :param avg_cpu_daily_peak_percentage: The avg_cpu_daily_peak_percentage of this ApiYarnUtilization.
        :type: float
        """

        self._avg_cpu_daily_peak_percentage = avg_cpu_daily_peak_percentage

    @property
    def avg_memory_utilization(self):
        """
        Gets the avg_memory_utilization of this ApiYarnUtilization.
        Average memory used by YARN applications during the report window.

        :return: The avg_memory_utilization of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_memory_utilization

    @avg_memory_utilization.setter
    def avg_memory_utilization(self, avg_memory_utilization):
        """
        Sets the avg_memory_utilization of this ApiYarnUtilization.
        Average memory used by YARN applications during the report window.

        :param avg_memory_utilization: The avg_memory_utilization of this ApiYarnUtilization.
        :type: float
        """

        self._avg_memory_utilization = avg_memory_utilization

    @property
    def max_memory_utilization(self):
        """
        Gets the max_memory_utilization of this ApiYarnUtilization.
        Maximum memory used by YARN applications during the report window.

        :return: The max_memory_utilization of this ApiYarnUtilization.
        :rtype: float
        """
        return self._max_memory_utilization

    @max_memory_utilization.setter
    def max_memory_utilization(self, max_memory_utilization):
        """
        Sets the max_memory_utilization of this ApiYarnUtilization.
        Maximum memory used by YARN applications during the report window.

        :param max_memory_utilization: The max_memory_utilization of this ApiYarnUtilization.
        :type: float
        """

        self._max_memory_utilization = max_memory_utilization

    @property
    def avg_memory_daily_peak(self):
        """
        Gets the avg_memory_daily_peak of this ApiYarnUtilization.
        Average daily peak memory used by YARN applications during the report window. The number is computed by first finding the maximum resource consumption per day and then taking their mean.

        :return: The avg_memory_daily_peak of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_memory_daily_peak

    @avg_memory_daily_peak.setter
    def avg_memory_daily_peak(self, avg_memory_daily_peak):
        """
        Sets the avg_memory_daily_peak of this ApiYarnUtilization.
        Average daily peak memory used by YARN applications during the report window. The number is computed by first finding the maximum resource consumption per day and then taking their mean.

        :param avg_memory_daily_peak: The avg_memory_daily_peak of this ApiYarnUtilization.
        :type: float
        """

        self._avg_memory_daily_peak = avg_memory_daily_peak

    @property
    def max_memory_utilization_timestamp_ms(self):
        """
        Gets the max_memory_utilization_timestamp_ms of this ApiYarnUtilization.
        Timestamp corresponds to maximum memory used by YARN applications during the report window.

        :return: The max_memory_utilization_timestamp_ms of this ApiYarnUtilization.
        :rtype: int
        """
        return self._max_memory_utilization_timestamp_ms

    @max_memory_utilization_timestamp_ms.setter
    def max_memory_utilization_timestamp_ms(self, max_memory_utilization_timestamp_ms):
        """
        Sets the max_memory_utilization_timestamp_ms of this ApiYarnUtilization.
        Timestamp corresponds to maximum memory used by YARN applications during the report window.

        :param max_memory_utilization_timestamp_ms: The max_memory_utilization_timestamp_ms of this ApiYarnUtilization.
        :type: int
        """

        self._max_memory_utilization_timestamp_ms = max_memory_utilization_timestamp_ms

    @property
    def avg_memory_utilization_percentage(self):
        """
        Gets the avg_memory_utilization_percentage of this ApiYarnUtilization.
        Average percentage memory used by YARN applications during the report window.

        :return: The avg_memory_utilization_percentage of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_memory_utilization_percentage

    @avg_memory_utilization_percentage.setter
    def avg_memory_utilization_percentage(self, avg_memory_utilization_percentage):
        """
        Sets the avg_memory_utilization_percentage of this ApiYarnUtilization.
        Average percentage memory used by YARN applications during the report window.

        :param avg_memory_utilization_percentage: The avg_memory_utilization_percentage of this ApiYarnUtilization.
        :type: float
        """

        self._avg_memory_utilization_percentage = avg_memory_utilization_percentage

    @property
    def max_memory_utilization_percentage(self):
        """
        Gets the max_memory_utilization_percentage of this ApiYarnUtilization.
        Maximum percentage of memory used by YARN applications during the report window.

        :return: The max_memory_utilization_percentage of this ApiYarnUtilization.
        :rtype: float
        """
        return self._max_memory_utilization_percentage

    @max_memory_utilization_percentage.setter
    def max_memory_utilization_percentage(self, max_memory_utilization_percentage):
        """
        Sets the max_memory_utilization_percentage of this ApiYarnUtilization.
        Maximum percentage of memory used by YARN applications during the report window.

        :param max_memory_utilization_percentage: The max_memory_utilization_percentage of this ApiYarnUtilization.
        :type: float
        """

        self._max_memory_utilization_percentage = max_memory_utilization_percentage

    @property
    def avg_memory_daily_peak_percentage(self):
        """
        Gets the avg_memory_daily_peak_percentage of this ApiYarnUtilization.
        Average daily peak percentage of memory used by YARN applications during the report window.

        :return: The avg_memory_daily_peak_percentage of this ApiYarnUtilization.
        :rtype: float
        """
        return self._avg_memory_daily_peak_percentage

    @avg_memory_daily_peak_percentage.setter
    def avg_memory_daily_peak_percentage(self, avg_memory_daily_peak_percentage):
        """
        Sets the avg_memory_daily_peak_percentage of this ApiYarnUtilization.
        Average daily peak percentage of memory used by YARN applications during the report window.

        :param avg_memory_daily_peak_percentage: The avg_memory_daily_peak_percentage of this ApiYarnUtilization.
        :type: float
        """

        self._avg_memory_daily_peak_percentage = avg_memory_daily_peak_percentage

    @property
    def tenant_utilizations(self):
        """
        Gets the tenant_utilizations of this ApiYarnUtilization.
        A list of tenant utilization reports.

        :return: The tenant_utilizations of this ApiYarnUtilization.
        :rtype: ApiYarnTenantUtilizationList
        """
        return self._tenant_utilizations

    @tenant_utilizations.setter
    def tenant_utilizations(self, tenant_utilizations):
        """
        Sets the tenant_utilizations of this ApiYarnUtilization.
        A list of tenant utilization reports.

        :param tenant_utilizations: The tenant_utilizations of this ApiYarnUtilization.
        :type: ApiYarnTenantUtilizationList
        """

        self._tenant_utilizations = tenant_utilizations

    @property
    def error_message(self):
        """
        Gets the error_message of this ApiYarnUtilization.
        error message of utilization report.

        :return: The error_message of this ApiYarnUtilization.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this ApiYarnUtilization.
        error message of utilization report.

        :param error_message: The error_message of this ApiYarnUtilization.
        :type: str
        """

        self._error_message = error_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiYarnUtilization):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
