# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiRollingUpgradeServicesArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'upgrade_from_cdh_version': 'str',
        'upgrade_to_cdh_version': 'str',
        'slave_batch_size': 'int',
        'sleep_seconds': 'int',
        'slave_fail_count_threshold': 'int',
        'upgrade_service_names': 'list[str]'
    }

    attribute_map = {
        'upgrade_from_cdh_version': 'upgradeFromCdhVersion',
        'upgrade_to_cdh_version': 'upgradeToCdhVersion',
        'slave_batch_size': 'slaveBatchSize',
        'sleep_seconds': 'sleepSeconds',
        'slave_fail_count_threshold': 'slaveFailCountThreshold',
        'upgrade_service_names': 'upgradeServiceNames'
    }

    def __init__(self, upgrade_from_cdh_version=None, upgrade_to_cdh_version=None, slave_batch_size=None, sleep_seconds=None, slave_fail_count_threshold=None, upgrade_service_names=None):
        """
        ApiRollingUpgradeServicesArgs - a model defined in Swagger
        """

        self._upgrade_from_cdh_version = None
        self._upgrade_to_cdh_version = None
        self._slave_batch_size = None
        self._sleep_seconds = None
        self._slave_fail_count_threshold = None
        self._upgrade_service_names = None

        if upgrade_from_cdh_version is not None:
          self.upgrade_from_cdh_version = upgrade_from_cdh_version
        if upgrade_to_cdh_version is not None:
          self.upgrade_to_cdh_version = upgrade_to_cdh_version
        if slave_batch_size is not None:
          self.slave_batch_size = slave_batch_size
        if sleep_seconds is not None:
          self.sleep_seconds = sleep_seconds
        if slave_fail_count_threshold is not None:
          self.slave_fail_count_threshold = slave_fail_count_threshold
        if upgrade_service_names is not None:
          self.upgrade_service_names = upgrade_service_names

    @property
    def upgrade_from_cdh_version(self):
        """
        Gets the upgrade_from_cdh_version of this ApiRollingUpgradeServicesArgs.
        Current CDH Version of the services. Example versions are: \"5.1.0\", \"5.2.2\" or \"5.4.0\"

        :return: The upgrade_from_cdh_version of this ApiRollingUpgradeServicesArgs.
        :rtype: str
        """
        return self._upgrade_from_cdh_version

    @upgrade_from_cdh_version.setter
    def upgrade_from_cdh_version(self, upgrade_from_cdh_version):
        """
        Sets the upgrade_from_cdh_version of this ApiRollingUpgradeServicesArgs.
        Current CDH Version of the services. Example versions are: \"5.1.0\", \"5.2.2\" or \"5.4.0\"

        :param upgrade_from_cdh_version: The upgrade_from_cdh_version of this ApiRollingUpgradeServicesArgs.
        :type: str
        """

        self._upgrade_from_cdh_version = upgrade_from_cdh_version

    @property
    def upgrade_to_cdh_version(self):
        """
        Gets the upgrade_to_cdh_version of this ApiRollingUpgradeServicesArgs.
        Target CDH Version for the services. The CDH version should already be present and activated on the nodes. Example versions are: \"5.1.0\", \"5.2.2\" or \"5.4.0\"

        :return: The upgrade_to_cdh_version of this ApiRollingUpgradeServicesArgs.
        :rtype: str
        """
        return self._upgrade_to_cdh_version

    @upgrade_to_cdh_version.setter
    def upgrade_to_cdh_version(self, upgrade_to_cdh_version):
        """
        Sets the upgrade_to_cdh_version of this ApiRollingUpgradeServicesArgs.
        Target CDH Version for the services. The CDH version should already be present and activated on the nodes. Example versions are: \"5.1.0\", \"5.2.2\" or \"5.4.0\"

        :param upgrade_to_cdh_version: The upgrade_to_cdh_version of this ApiRollingUpgradeServicesArgs.
        :type: str
        """

        self._upgrade_to_cdh_version = upgrade_to_cdh_version

    @property
    def slave_batch_size(self):
        """
        Gets the slave_batch_size of this ApiRollingUpgradeServicesArgs.
        Number of hosts with slave roles to upgrade at a time. Must be greater than zero. Default is 1.

        :return: The slave_batch_size of this ApiRollingUpgradeServicesArgs.
        :rtype: int
        """
        return self._slave_batch_size

    @slave_batch_size.setter
    def slave_batch_size(self, slave_batch_size):
        """
        Sets the slave_batch_size of this ApiRollingUpgradeServicesArgs.
        Number of hosts with slave roles to upgrade at a time. Must be greater than zero. Default is 1.

        :param slave_batch_size: The slave_batch_size of this ApiRollingUpgradeServicesArgs.
        :type: int
        """

        self._slave_batch_size = slave_batch_size

    @property
    def sleep_seconds(self):
        """
        Gets the sleep_seconds of this ApiRollingUpgradeServicesArgs.
        Number of seconds to sleep between restarts of slave host batches.  Must be greater than or equal to 0. Default is 0.

        :return: The sleep_seconds of this ApiRollingUpgradeServicesArgs.
        :rtype: int
        """
        return self._sleep_seconds

    @sleep_seconds.setter
    def sleep_seconds(self, sleep_seconds):
        """
        Sets the sleep_seconds of this ApiRollingUpgradeServicesArgs.
        Number of seconds to sleep between restarts of slave host batches.  Must be greater than or equal to 0. Default is 0.

        :param sleep_seconds: The sleep_seconds of this ApiRollingUpgradeServicesArgs.
        :type: int
        """

        self._sleep_seconds = sleep_seconds

    @property
    def slave_fail_count_threshold(self):
        """
        Gets the slave_fail_count_threshold of this ApiRollingUpgradeServicesArgs.
        The threshold for number of slave host batches that are allowed to fail to restart before the entire command is considered failed.  Must be greater than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>

        :return: The slave_fail_count_threshold of this ApiRollingUpgradeServicesArgs.
        :rtype: int
        """
        return self._slave_fail_count_threshold

    @slave_fail_count_threshold.setter
    def slave_fail_count_threshold(self, slave_fail_count_threshold):
        """
        Sets the slave_fail_count_threshold of this ApiRollingUpgradeServicesArgs.
        The threshold for number of slave host batches that are allowed to fail to restart before the entire command is considered failed.  Must be greater than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>

        :param slave_fail_count_threshold: The slave_fail_count_threshold of this ApiRollingUpgradeServicesArgs.
        :type: int
        """

        self._slave_fail_count_threshold = slave_fail_count_threshold

    @property
    def upgrade_service_names(self):
        """
        Gets the upgrade_service_names of this ApiRollingUpgradeServicesArgs.
        List of services to upgrade. Only the services that support rolling upgrade should be included.

        :return: The upgrade_service_names of this ApiRollingUpgradeServicesArgs.
        :rtype: list[str]
        """
        return self._upgrade_service_names

    @upgrade_service_names.setter
    def upgrade_service_names(self, upgrade_service_names):
        """
        Sets the upgrade_service_names of this ApiRollingUpgradeServicesArgs.
        List of services to upgrade. Only the services that support rolling upgrade should be included.

        :param upgrade_service_names: The upgrade_service_names of this ApiRollingUpgradeServicesArgs.
        :type: list[str]
        """

        self._upgrade_service_names = upgrade_service_names

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiRollingUpgradeServicesArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
