# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiRollingRestartArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'slave_batch_size': 'int',
        'sleep_seconds': 'int',
        'slave_fail_count_threshold': 'int',
        'stale_configs_only': 'bool',
        'un_upgraded_only': 'bool',
        'restart_role_types': 'list[str]',
        'restart_role_names': 'list[str]'
    }

    attribute_map = {
        'slave_batch_size': 'slaveBatchSize',
        'sleep_seconds': 'sleepSeconds',
        'slave_fail_count_threshold': 'slaveFailCountThreshold',
        'stale_configs_only': 'staleConfigsOnly',
        'un_upgraded_only': 'unUpgradedOnly',
        'restart_role_types': 'restartRoleTypes',
        'restart_role_names': 'restartRoleNames'
    }

    def __init__(self, slave_batch_size=None, sleep_seconds=None, slave_fail_count_threshold=None, stale_configs_only=None, un_upgraded_only=None, restart_role_types=None, restart_role_names=None):
        """
        ApiRollingRestartArgs - a model defined in Swagger
        """

        self._slave_batch_size = None
        self._sleep_seconds = None
        self._slave_fail_count_threshold = None
        self._stale_configs_only = None
        self._un_upgraded_only = None
        self._restart_role_types = None
        self._restart_role_names = None

        if slave_batch_size is not None:
          self.slave_batch_size = slave_batch_size
        if sleep_seconds is not None:
          self.sleep_seconds = sleep_seconds
        if slave_fail_count_threshold is not None:
          self.slave_fail_count_threshold = slave_fail_count_threshold
        if stale_configs_only is not None:
          self.stale_configs_only = stale_configs_only
        if un_upgraded_only is not None:
          self.un_upgraded_only = un_upgraded_only
        if restart_role_types is not None:
          self.restart_role_types = restart_role_types
        if restart_role_names is not None:
          self.restart_role_names = restart_role_names

    @property
    def slave_batch_size(self):
        """
        Gets the slave_batch_size of this ApiRollingRestartArgs.
        Number of slave roles to restart at a time. Must be greater than zero. Default is 1.  Please note that for HDFS, this number should be less than the replication factor (default 3) to ensure data availability during rolling restart.

        :return: The slave_batch_size of this ApiRollingRestartArgs.
        :rtype: int
        """
        return self._slave_batch_size

    @slave_batch_size.setter
    def slave_batch_size(self, slave_batch_size):
        """
        Sets the slave_batch_size of this ApiRollingRestartArgs.
        Number of slave roles to restart at a time. Must be greater than zero. Default is 1.  Please note that for HDFS, this number should be less than the replication factor (default 3) to ensure data availability during rolling restart.

        :param slave_batch_size: The slave_batch_size of this ApiRollingRestartArgs.
        :type: int
        """

        self._slave_batch_size = slave_batch_size

    @property
    def sleep_seconds(self):
        """
        Gets the sleep_seconds of this ApiRollingRestartArgs.
        Number of seconds to sleep between restarts of slave role batches.  Must be greater than or equal to 0. Default is 0.

        :return: The sleep_seconds of this ApiRollingRestartArgs.
        :rtype: int
        """
        return self._sleep_seconds

    @sleep_seconds.setter
    def sleep_seconds(self, sleep_seconds):
        """
        Sets the sleep_seconds of this ApiRollingRestartArgs.
        Number of seconds to sleep between restarts of slave role batches.  Must be greater than or equal to 0. Default is 0.

        :param sleep_seconds: The sleep_seconds of this ApiRollingRestartArgs.
        :type: int
        """

        self._sleep_seconds = sleep_seconds

    @property
    def slave_fail_count_threshold(self):
        """
        Gets the slave_fail_count_threshold of this ApiRollingRestartArgs.
        The threshold for number of slave batches that are allowed to fail to restart before the entire command is considered failed.  Must be greather than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>

        :return: The slave_fail_count_threshold of this ApiRollingRestartArgs.
        :rtype: int
        """
        return self._slave_fail_count_threshold

    @slave_fail_count_threshold.setter
    def slave_fail_count_threshold(self, slave_fail_count_threshold):
        """
        Sets the slave_fail_count_threshold of this ApiRollingRestartArgs.
        The threshold for number of slave batches that are allowed to fail to restart before the entire command is considered failed.  Must be greather than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>

        :param slave_fail_count_threshold: The slave_fail_count_threshold of this ApiRollingRestartArgs.
        :type: int
        """

        self._slave_fail_count_threshold = slave_fail_count_threshold

    @property
    def stale_configs_only(self):
        """
        Gets the stale_configs_only of this ApiRollingRestartArgs.
        Restart roles with stale configs only.

        :return: The stale_configs_only of this ApiRollingRestartArgs.
        :rtype: bool
        """
        return self._stale_configs_only

    @stale_configs_only.setter
    def stale_configs_only(self, stale_configs_only):
        """
        Sets the stale_configs_only of this ApiRollingRestartArgs.
        Restart roles with stale configs only.

        :param stale_configs_only: The stale_configs_only of this ApiRollingRestartArgs.
        :type: bool
        """

        self._stale_configs_only = stale_configs_only

    @property
    def un_upgraded_only(self):
        """
        Gets the un_upgraded_only of this ApiRollingRestartArgs.
        Restart roles that haven't been upgraded yet.

        :return: The un_upgraded_only of this ApiRollingRestartArgs.
        :rtype: bool
        """
        return self._un_upgraded_only

    @un_upgraded_only.setter
    def un_upgraded_only(self, un_upgraded_only):
        """
        Sets the un_upgraded_only of this ApiRollingRestartArgs.
        Restart roles that haven't been upgraded yet.

        :param un_upgraded_only: The un_upgraded_only of this ApiRollingRestartArgs.
        :type: bool
        """

        self._un_upgraded_only = un_upgraded_only

    @property
    def restart_role_types(self):
        """
        Gets the restart_role_types of this ApiRollingRestartArgs.
        Role types to restart. If not specified, all startable roles are restarted.  Both role types and role names should not be specified.

        :return: The restart_role_types of this ApiRollingRestartArgs.
        :rtype: list[str]
        """
        return self._restart_role_types

    @restart_role_types.setter
    def restart_role_types(self, restart_role_types):
        """
        Sets the restart_role_types of this ApiRollingRestartArgs.
        Role types to restart. If not specified, all startable roles are restarted.  Both role types and role names should not be specified.

        :param restart_role_types: The restart_role_types of this ApiRollingRestartArgs.
        :type: list[str]
        """

        self._restart_role_types = restart_role_types

    @property
    def restart_role_names(self):
        """
        Gets the restart_role_names of this ApiRollingRestartArgs.
        List of specific roles to restart. If none are specified, then all roles of specified role types are restarted.  Both role types and role names should not be specified.

        :return: The restart_role_names of this ApiRollingRestartArgs.
        :rtype: list[str]
        """
        return self._restart_role_names

    @restart_role_names.setter
    def restart_role_names(self, restart_role_names):
        """
        Sets the restart_role_names of this ApiRollingRestartArgs.
        List of specific roles to restart. If none are specified, then all roles of specified role types are restarted.  Both role types and role names should not be specified.

        :param restart_role_names: The restart_role_names of this ApiRollingRestartArgs.
        :type: list[str]
        """

        self._restart_role_names = restart_role_names

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiRollingRestartArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
