# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiRemoteDataContext(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'end_point_id': 'str',
        'end_points': 'list[ApiEndPoint]',
        'configs': 'list[ApiMapEntry]',
        'cluster_version': 'str'
    }

    attribute_map = {
        'end_point_id': 'endPointId',
        'end_points': 'endPoints',
        'configs': 'configs',
        'cluster_version': 'clusterVersion'
    }

    def __init__(self, end_point_id=None, end_points=None, configs=None, cluster_version=None):
        """
        ApiRemoteDataContext - a model defined in Swagger
        """

        self._end_point_id = None
        self._end_points = None
        self._configs = None
        self._cluster_version = None

        if end_point_id is not None:
          self.end_point_id = end_point_id
        if end_points is not None:
          self.end_points = end_points
        if configs is not None:
          self.configs = configs
        if cluster_version is not None:
          self.cluster_version = cluster_version

    @property
    def end_point_id(self):
        """
        Gets the end_point_id of this ApiRemoteDataContext.
        A string to uniquely identify the SDX cluster.

        :return: The end_point_id of this ApiRemoteDataContext.
        :rtype: str
        """
        return self._end_point_id

    @end_point_id.setter
    def end_point_id(self, end_point_id):
        """
        Sets the end_point_id of this ApiRemoteDataContext.
        A string to uniquely identify the SDX cluster.

        :param end_point_id: The end_point_id of this ApiRemoteDataContext.
        :type: str
        """

        self._end_point_id = end_point_id

    @property
    def end_points(self):
        """
        Gets the end_points of this ApiRemoteDataContext.
        List of endPoints exported by this SDX cluster.

        :return: The end_points of this ApiRemoteDataContext.
        :rtype: list[ApiEndPoint]
        """
        return self._end_points

    @end_points.setter
    def end_points(self, end_points):
        """
        Sets the end_points of this ApiRemoteDataContext.
        List of endPoints exported by this SDX cluster.

        :param end_points: The end_points of this ApiRemoteDataContext.
        :type: list[ApiEndPoint]
        """

        self._end_points = end_points

    @property
    def configs(self):
        """
        Gets the configs of this ApiRemoteDataContext.
        SDX cluster specifc options.

        :return: The configs of this ApiRemoteDataContext.
        :rtype: list[ApiMapEntry]
        """
        return self._configs

    @configs.setter
    def configs(self, configs):
        """
        Sets the configs of this ApiRemoteDataContext.
        SDX cluster specifc options.

        :param configs: The configs of this ApiRemoteDataContext.
        :type: list[ApiMapEntry]
        """

        self._configs = configs

    @property
    def cluster_version(self):
        """
        Gets the cluster_version of this ApiRemoteDataContext.
        Cluster version

        :return: The cluster_version of this ApiRemoteDataContext.
        :rtype: str
        """
        return self._cluster_version

    @cluster_version.setter
    def cluster_version(self, cluster_version):
        """
        Sets the cluster_version of this ApiRemoteDataContext.
        Cluster version

        :param cluster_version: The cluster_version of this ApiRemoteDataContext.
        :type: str
        """

        self._cluster_version = cluster_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiRemoteDataContext):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
