# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiParcelState(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'progress': 'int',
        'total_progress': 'int',
        'count': 'int',
        'total_count': 'int',
        'errors': 'list[str]',
        'warnings': 'list[str]'
    }

    attribute_map = {
        'progress': 'progress',
        'total_progress': 'totalProgress',
        'count': 'count',
        'total_count': 'totalCount',
        'errors': 'errors',
        'warnings': 'warnings'
    }

    def __init__(self, progress=None, total_progress=None, count=None, total_count=None, errors=None, warnings=None):
        """
        ApiParcelState - a model defined in Swagger
        """

        self._progress = None
        self._total_progress = None
        self._count = None
        self._total_count = None
        self._errors = None
        self._warnings = None

        if progress is not None:
          self.progress = progress
        if total_progress is not None:
          self.total_progress = total_progress
        if count is not None:
          self.count = count
        if total_count is not None:
          self.total_count = total_count
        if errors is not None:
          self.errors = errors
        if warnings is not None:
          self.warnings = warnings

    @property
    def progress(self):
        """
        Gets the progress of this ApiParcelState.
        The progress of the state transition.

        :return: The progress of this ApiParcelState.
        :rtype: int
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """
        Sets the progress of this ApiParcelState.
        The progress of the state transition.

        :param progress: The progress of this ApiParcelState.
        :type: int
        """

        self._progress = progress

    @property
    def total_progress(self):
        """
        Gets the total_progress of this ApiParcelState.
        The total amount that #getProgress() needs to get to.

        :return: The total_progress of this ApiParcelState.
        :rtype: int
        """
        return self._total_progress

    @total_progress.setter
    def total_progress(self, total_progress):
        """
        Sets the total_progress of this ApiParcelState.
        The total amount that #getProgress() needs to get to.

        :param total_progress: The total_progress of this ApiParcelState.
        :type: int
        """

        self._total_progress = total_progress

    @property
    def count(self):
        """
        Gets the count of this ApiParcelState.
        The current hosts that have completed.

        :return: The count of this ApiParcelState.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this ApiParcelState.
        The current hosts that have completed.

        :param count: The count of this ApiParcelState.
        :type: int
        """

        self._count = count

    @property
    def total_count(self):
        """
        Gets the total_count of this ApiParcelState.
        The total amount that #getCount() needs to get to.

        :return: The total_count of this ApiParcelState.
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count):
        """
        Sets the total_count of this ApiParcelState.
        The total amount that #getCount() needs to get to.

        :param total_count: The total_count of this ApiParcelState.
        :type: int
        """

        self._total_count = total_count

    @property
    def errors(self):
        """
        Gets the errors of this ApiParcelState.
        The errors that exist for this parcel.

        :return: The errors of this ApiParcelState.
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this ApiParcelState.
        The errors that exist for this parcel.

        :param errors: The errors of this ApiParcelState.
        :type: list[str]
        """

        self._errors = errors

    @property
    def warnings(self):
        """
        Gets the warnings of this ApiParcelState.
        The warnings that exist for this parcel.

        :return: The warnings of this ApiParcelState.
        :rtype: list[str]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """
        Sets the warnings of this ApiParcelState.
        The warnings that exist for this parcel.

        :param warnings: The warnings of this ApiParcelState.
        :type: list[str]
        """

        self._warnings = warnings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiParcelState):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
