# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiOzoneS3GatewayInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aws_access_key': 'str',
        'aws_secret': 'str',
        'rest_url': 'str',
        'bucket': 'str'
    }

    attribute_map = {
        'aws_access_key': 'awsAccessKey',
        'aws_secret': 'awsSecret',
        'rest_url': 'restUrl',
        'bucket': 'bucket'
    }

    def __init__(self, aws_access_key=None, aws_secret=None, rest_url=None, bucket=None):
        """
        ApiOzoneS3GatewayInfo - a model defined in Swagger
        """

        self._aws_access_key = None
        self._aws_secret = None
        self._rest_url = None
        self._bucket = None

        if aws_access_key is not None:
          self.aws_access_key = aws_access_key
        if aws_secret is not None:
          self.aws_secret = aws_secret
        if rest_url is not None:
          self.rest_url = rest_url
        if bucket is not None:
          self.bucket = bucket

    @property
    def aws_access_key(self):
        """
        Gets the aws_access_key of this ApiOzoneS3GatewayInfo.
        The AWS access key for a particular Ozone service

        :return: The aws_access_key of this ApiOzoneS3GatewayInfo.
        :rtype: str
        """
        return self._aws_access_key

    @aws_access_key.setter
    def aws_access_key(self, aws_access_key):
        """
        Sets the aws_access_key of this ApiOzoneS3GatewayInfo.
        The AWS access key for a particular Ozone service

        :param aws_access_key: The aws_access_key of this ApiOzoneS3GatewayInfo.
        :type: str
        """

        self._aws_access_key = aws_access_key

    @property
    def aws_secret(self):
        """
        Gets the aws_secret of this ApiOzoneS3GatewayInfo.
        The AWS secret associated with the access key

        :return: The aws_secret of this ApiOzoneS3GatewayInfo.
        :rtype: str
        """
        return self._aws_secret

    @aws_secret.setter
    def aws_secret(self, aws_secret):
        """
        Sets the aws_secret of this ApiOzoneS3GatewayInfo.
        The AWS secret associated with the access key

        :param aws_secret: The aws_secret of this ApiOzoneS3GatewayInfo.
        :type: str
        """

        self._aws_secret = aws_secret

    @property
    def rest_url(self):
        """
        Gets the rest_url of this ApiOzoneS3GatewayInfo.
        The rest url, in host:port format, of the Ozone S3 Gateway

        :return: The rest_url of this ApiOzoneS3GatewayInfo.
        :rtype: str
        """
        return self._rest_url

    @rest_url.setter
    def rest_url(self, rest_url):
        """
        Sets the rest_url of this ApiOzoneS3GatewayInfo.
        The rest url, in host:port format, of the Ozone S3 Gateway

        :param rest_url: The rest_url of this ApiOzoneS3GatewayInfo.
        :type: str
        """

        self._rest_url = rest_url

    @property
    def bucket(self):
        """
        Gets the bucket of this ApiOzoneS3GatewayInfo.
        The Ozone address of the created S3 bucket

        :return: The bucket of this ApiOzoneS3GatewayInfo.
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """
        Sets the bucket of this ApiOzoneS3GatewayInfo.
        The Ozone address of the created S3 bucket

        :param bucket: The bucket of this ApiOzoneS3GatewayInfo.
        :type: str
        """

        self._bucket = bucket

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiOzoneS3GatewayInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
