# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiLicense(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner': 'str',
        'uuid': 'str',
        'expiration': 'str',
        'features': 'list[ApiLicenseFeature]',
        'deactivation_date': 'str',
        'start_date': 'str'
    }

    attribute_map = {
        'owner': 'owner',
        'uuid': 'uuid',
        'expiration': 'expiration',
        'features': 'features',
        'deactivation_date': 'deactivationDate',
        'start_date': 'startDate'
    }

    def __init__(self, owner=None, uuid=None, expiration=None, features=None, deactivation_date=None, start_date=None):
        """
        ApiLicense - a model defined in Swagger
        """

        self._owner = None
        self._uuid = None
        self._expiration = None
        self._features = None
        self._deactivation_date = None
        self._start_date = None

        if owner is not None:
          self.owner = owner
        if uuid is not None:
          self.uuid = uuid
        if expiration is not None:
          self.expiration = expiration
        if features is not None:
          self.features = features
        if deactivation_date is not None:
          self.deactivation_date = deactivation_date
        if start_date is not None:
          self.start_date = start_date

    @property
    def owner(self):
        """
        Gets the owner of this ApiLicense.
        The owner (organization name) of the license.

        :return: The owner of this ApiLicense.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this ApiLicense.
        The owner (organization name) of the license.

        :param owner: The owner of this ApiLicense.
        :type: str
        """

        self._owner = owner

    @property
    def uuid(self):
        """
        Gets the uuid of this ApiLicense.
        A UUID of this license.

        :return: The uuid of this ApiLicense.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """
        Sets the uuid of this ApiLicense.
        A UUID of this license.

        :param uuid: The uuid of this ApiLicense.
        :type: str
        """

        self._uuid = uuid

    @property
    def expiration(self):
        """
        Gets the expiration of this ApiLicense.
        The expiration date.

        :return: The expiration of this ApiLicense.
        :rtype: str
        """
        return self._expiration

    @expiration.setter
    def expiration(self, expiration):
        """
        Sets the expiration of this ApiLicense.
        The expiration date.

        :param expiration: The expiration of this ApiLicense.
        :type: str
        """

        self._expiration = expiration

    @property
    def features(self):
        """
        Gets the features of this ApiLicense.
        Returns the list of available features as per the license

        :return: The features of this ApiLicense.
        :rtype: list[ApiLicenseFeature]
        """
        return self._features

    @features.setter
    def features(self, features):
        """
        Sets the features of this ApiLicense.
        Returns the list of available features as per the license

        :param features: The features of this ApiLicense.
        :type: list[ApiLicenseFeature]
        """

        self._features = features

    @property
    def deactivation_date(self):
        """
        Gets the deactivation_date of this ApiLicense.
        The deactivation date.

        :return: The deactivation_date of this ApiLicense.
        :rtype: str
        """
        return self._deactivation_date

    @deactivation_date.setter
    def deactivation_date(self, deactivation_date):
        """
        Sets the deactivation_date of this ApiLicense.
        The deactivation date.

        :param deactivation_date: The deactivation_date of this ApiLicense.
        :type: str
        """

        self._deactivation_date = deactivation_date

    @property
    def start_date(self):
        """
        Gets the start_date of this ApiLicense.
        The start date.

        :return: The start_date of this ApiLicense.
        :rtype: str
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this ApiLicense.
        The start date.

        :param start_date: The start_date of this ApiLicense.
        :type: str
        """

        self._start_date = start_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiLicense):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
