# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiImpalaUtilization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'total_queries': 'float',
        'successful_queries': 'float',
        'oom_queries': 'float',
        'time_out_queries': 'float',
        'rejected_queries': 'float',
        'successful_queries_percentage': 'float',
        'oom_queries_percentage': 'float',
        'time_out_queries_percentage': 'float',
        'rejected_queries_percentage': 'float',
        'avg_wait_time_in_queue': 'float',
        'peak_allocation_timestamp_ms': 'int',
        'max_allocated_memory': 'float',
        'max_allocated_memory_percentage': 'float',
        'utilized_at_max_allocated': 'float',
        'utilized_at_max_allocated_percentage': 'float',
        'peak_usage_timestamp_ms': 'int',
        'max_utilized_memory': 'float',
        'max_utilized_memory_percentage': 'float',
        'allocated_at_max_utilized': 'float',
        'allocated_at_max_utilized_percentage': 'float',
        'distribution_utilized_by_impala_daemon': 'ApiImpalaUtilizationHistogram',
        'distribution_allocated_by_impala_daemon': 'ApiImpalaUtilizationHistogram',
        'tenant_utilizations': 'ApiImpalaTenantUtilizationList',
        'error_message': 'str'
    }

    attribute_map = {
        'total_queries': 'totalQueries',
        'successful_queries': 'successfulQueries',
        'oom_queries': 'oomQueries',
        'time_out_queries': 'timeOutQueries',
        'rejected_queries': 'rejectedQueries',
        'successful_queries_percentage': 'successfulQueriesPercentage',
        'oom_queries_percentage': 'oomQueriesPercentage',
        'time_out_queries_percentage': 'timeOutQueriesPercentage',
        'rejected_queries_percentage': 'rejectedQueriesPercentage',
        'avg_wait_time_in_queue': 'avgWaitTimeInQueue',
        'peak_allocation_timestamp_ms': 'peakAllocationTimestampMS',
        'max_allocated_memory': 'maxAllocatedMemory',
        'max_allocated_memory_percentage': 'maxAllocatedMemoryPercentage',
        'utilized_at_max_allocated': 'utilizedAtMaxAllocated',
        'utilized_at_max_allocated_percentage': 'utilizedAtMaxAllocatedPercentage',
        'peak_usage_timestamp_ms': 'peakUsageTimestampMS',
        'max_utilized_memory': 'maxUtilizedMemory',
        'max_utilized_memory_percentage': 'maxUtilizedMemoryPercentage',
        'allocated_at_max_utilized': 'allocatedAtMaxUtilized',
        'allocated_at_max_utilized_percentage': 'allocatedAtMaxUtilizedPercentage',
        'distribution_utilized_by_impala_daemon': 'distributionUtilizedByImpalaDaemon',
        'distribution_allocated_by_impala_daemon': 'distributionAllocatedByImpalaDaemon',
        'tenant_utilizations': 'tenantUtilizations',
        'error_message': 'errorMessage'
    }

    def __init__(self, total_queries=None, successful_queries=None, oom_queries=None, time_out_queries=None, rejected_queries=None, successful_queries_percentage=None, oom_queries_percentage=None, time_out_queries_percentage=None, rejected_queries_percentage=None, avg_wait_time_in_queue=None, peak_allocation_timestamp_ms=None, max_allocated_memory=None, max_allocated_memory_percentage=None, utilized_at_max_allocated=None, utilized_at_max_allocated_percentage=None, peak_usage_timestamp_ms=None, max_utilized_memory=None, max_utilized_memory_percentage=None, allocated_at_max_utilized=None, allocated_at_max_utilized_percentage=None, distribution_utilized_by_impala_daemon=None, distribution_allocated_by_impala_daemon=None, tenant_utilizations=None, error_message=None):
        """
        ApiImpalaUtilization - a model defined in Swagger
        """

        self._total_queries = None
        self._successful_queries = None
        self._oom_queries = None
        self._time_out_queries = None
        self._rejected_queries = None
        self._successful_queries_percentage = None
        self._oom_queries_percentage = None
        self._time_out_queries_percentage = None
        self._rejected_queries_percentage = None
        self._avg_wait_time_in_queue = None
        self._peak_allocation_timestamp_ms = None
        self._max_allocated_memory = None
        self._max_allocated_memory_percentage = None
        self._utilized_at_max_allocated = None
        self._utilized_at_max_allocated_percentage = None
        self._peak_usage_timestamp_ms = None
        self._max_utilized_memory = None
        self._max_utilized_memory_percentage = None
        self._allocated_at_max_utilized = None
        self._allocated_at_max_utilized_percentage = None
        self._distribution_utilized_by_impala_daemon = None
        self._distribution_allocated_by_impala_daemon = None
        self._tenant_utilizations = None
        self._error_message = None

        if total_queries is not None:
          self.total_queries = total_queries
        if successful_queries is not None:
          self.successful_queries = successful_queries
        if oom_queries is not None:
          self.oom_queries = oom_queries
        if time_out_queries is not None:
          self.time_out_queries = time_out_queries
        if rejected_queries is not None:
          self.rejected_queries = rejected_queries
        if successful_queries_percentage is not None:
          self.successful_queries_percentage = successful_queries_percentage
        if oom_queries_percentage is not None:
          self.oom_queries_percentage = oom_queries_percentage
        if time_out_queries_percentage is not None:
          self.time_out_queries_percentage = time_out_queries_percentage
        if rejected_queries_percentage is not None:
          self.rejected_queries_percentage = rejected_queries_percentage
        if avg_wait_time_in_queue is not None:
          self.avg_wait_time_in_queue = avg_wait_time_in_queue
        if peak_allocation_timestamp_ms is not None:
          self.peak_allocation_timestamp_ms = peak_allocation_timestamp_ms
        if max_allocated_memory is not None:
          self.max_allocated_memory = max_allocated_memory
        if max_allocated_memory_percentage is not None:
          self.max_allocated_memory_percentage = max_allocated_memory_percentage
        if utilized_at_max_allocated is not None:
          self.utilized_at_max_allocated = utilized_at_max_allocated
        if utilized_at_max_allocated_percentage is not None:
          self.utilized_at_max_allocated_percentage = utilized_at_max_allocated_percentage
        if peak_usage_timestamp_ms is not None:
          self.peak_usage_timestamp_ms = peak_usage_timestamp_ms
        if max_utilized_memory is not None:
          self.max_utilized_memory = max_utilized_memory
        if max_utilized_memory_percentage is not None:
          self.max_utilized_memory_percentage = max_utilized_memory_percentage
        if allocated_at_max_utilized is not None:
          self.allocated_at_max_utilized = allocated_at_max_utilized
        if allocated_at_max_utilized_percentage is not None:
          self.allocated_at_max_utilized_percentage = allocated_at_max_utilized_percentage
        if distribution_utilized_by_impala_daemon is not None:
          self.distribution_utilized_by_impala_daemon = distribution_utilized_by_impala_daemon
        if distribution_allocated_by_impala_daemon is not None:
          self.distribution_allocated_by_impala_daemon = distribution_allocated_by_impala_daemon
        if tenant_utilizations is not None:
          self.tenant_utilizations = tenant_utilizations
        if error_message is not None:
          self.error_message = error_message

    @property
    def total_queries(self):
        """
        Gets the total_queries of this ApiImpalaUtilization.
        Total number of queries submitted to Impala.

        :return: The total_queries of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._total_queries

    @total_queries.setter
    def total_queries(self, total_queries):
        """
        Sets the total_queries of this ApiImpalaUtilization.
        Total number of queries submitted to Impala.

        :param total_queries: The total_queries of this ApiImpalaUtilization.
        :type: float
        """

        self._total_queries = total_queries

    @property
    def successful_queries(self):
        """
        Gets the successful_queries of this ApiImpalaUtilization.
        Number of queries that finished successfully.

        :return: The successful_queries of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._successful_queries

    @successful_queries.setter
    def successful_queries(self, successful_queries):
        """
        Sets the successful_queries of this ApiImpalaUtilization.
        Number of queries that finished successfully.

        :param successful_queries: The successful_queries of this ApiImpalaUtilization.
        :type: float
        """

        self._successful_queries = successful_queries

    @property
    def oom_queries(self):
        """
        Gets the oom_queries of this ApiImpalaUtilization.
        Number of queries that failed due to insufficient memory.

        :return: The oom_queries of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._oom_queries

    @oom_queries.setter
    def oom_queries(self, oom_queries):
        """
        Sets the oom_queries of this ApiImpalaUtilization.
        Number of queries that failed due to insufficient memory.

        :param oom_queries: The oom_queries of this ApiImpalaUtilization.
        :type: float
        """

        self._oom_queries = oom_queries

    @property
    def time_out_queries(self):
        """
        Gets the time_out_queries of this ApiImpalaUtilization.
        Number of queries that timed out while waiting for resources in a pool.

        :return: The time_out_queries of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._time_out_queries

    @time_out_queries.setter
    def time_out_queries(self, time_out_queries):
        """
        Sets the time_out_queries of this ApiImpalaUtilization.
        Number of queries that timed out while waiting for resources in a pool.

        :param time_out_queries: The time_out_queries of this ApiImpalaUtilization.
        :type: float
        """

        self._time_out_queries = time_out_queries

    @property
    def rejected_queries(self):
        """
        Gets the rejected_queries of this ApiImpalaUtilization.
        Number of queries that were rejected by Impala because the pool was full.

        :return: The rejected_queries of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._rejected_queries

    @rejected_queries.setter
    def rejected_queries(self, rejected_queries):
        """
        Sets the rejected_queries of this ApiImpalaUtilization.
        Number of queries that were rejected by Impala because the pool was full.

        :param rejected_queries: The rejected_queries of this ApiImpalaUtilization.
        :type: float
        """

        self._rejected_queries = rejected_queries

    @property
    def successful_queries_percentage(self):
        """
        Gets the successful_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that finished successfully.

        :return: The successful_queries_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._successful_queries_percentage

    @successful_queries_percentage.setter
    def successful_queries_percentage(self, successful_queries_percentage):
        """
        Sets the successful_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that finished successfully.

        :param successful_queries_percentage: The successful_queries_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._successful_queries_percentage = successful_queries_percentage

    @property
    def oom_queries_percentage(self):
        """
        Gets the oom_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that failed due to insufficient memory.

        :return: The oom_queries_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._oom_queries_percentage

    @oom_queries_percentage.setter
    def oom_queries_percentage(self, oom_queries_percentage):
        """
        Sets the oom_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that failed due to insufficient memory.

        :param oom_queries_percentage: The oom_queries_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._oom_queries_percentage = oom_queries_percentage

    @property
    def time_out_queries_percentage(self):
        """
        Gets the time_out_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that timed out while waiting for resources in a pool.

        :return: The time_out_queries_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._time_out_queries_percentage

    @time_out_queries_percentage.setter
    def time_out_queries_percentage(self, time_out_queries_percentage):
        """
        Sets the time_out_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that timed out while waiting for resources in a pool.

        :param time_out_queries_percentage: The time_out_queries_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._time_out_queries_percentage = time_out_queries_percentage

    @property
    def rejected_queries_percentage(self):
        """
        Gets the rejected_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that were rejected by Impala because the pool was full.

        :return: The rejected_queries_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._rejected_queries_percentage

    @rejected_queries_percentage.setter
    def rejected_queries_percentage(self, rejected_queries_percentage):
        """
        Sets the rejected_queries_percentage of this ApiImpalaUtilization.
        Percentage of queries that were rejected by Impala because the pool was full.

        :param rejected_queries_percentage: The rejected_queries_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._rejected_queries_percentage = rejected_queries_percentage

    @property
    def avg_wait_time_in_queue(self):
        """
        Gets the avg_wait_time_in_queue of this ApiImpalaUtilization.
        Average time, in milliseconds, spent by a query in an Impala pool while waiting for resources.

        :return: The avg_wait_time_in_queue of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._avg_wait_time_in_queue

    @avg_wait_time_in_queue.setter
    def avg_wait_time_in_queue(self, avg_wait_time_in_queue):
        """
        Sets the avg_wait_time_in_queue of this ApiImpalaUtilization.
        Average time, in milliseconds, spent by a query in an Impala pool while waiting for resources.

        :param avg_wait_time_in_queue: The avg_wait_time_in_queue of this ApiImpalaUtilization.
        :type: float
        """

        self._avg_wait_time_in_queue = avg_wait_time_in_queue

    @property
    def peak_allocation_timestamp_ms(self):
        """
        Gets the peak_allocation_timestamp_ms of this ApiImpalaUtilization.
        The time when Impala reserved the maximum amount of memory for queries.

        :return: The peak_allocation_timestamp_ms of this ApiImpalaUtilization.
        :rtype: int
        """
        return self._peak_allocation_timestamp_ms

    @peak_allocation_timestamp_ms.setter
    def peak_allocation_timestamp_ms(self, peak_allocation_timestamp_ms):
        """
        Sets the peak_allocation_timestamp_ms of this ApiImpalaUtilization.
        The time when Impala reserved the maximum amount of memory for queries.

        :param peak_allocation_timestamp_ms: The peak_allocation_timestamp_ms of this ApiImpalaUtilization.
        :type: int
        """

        self._peak_allocation_timestamp_ms = peak_allocation_timestamp_ms

    @property
    def max_allocated_memory(self):
        """
        Gets the max_allocated_memory of this ApiImpalaUtilization.
        The maximum memory (in bytes) that was reserved by Impala for executing queries.

        :return: The max_allocated_memory of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._max_allocated_memory

    @max_allocated_memory.setter
    def max_allocated_memory(self, max_allocated_memory):
        """
        Sets the max_allocated_memory of this ApiImpalaUtilization.
        The maximum memory (in bytes) that was reserved by Impala for executing queries.

        :param max_allocated_memory: The max_allocated_memory of this ApiImpalaUtilization.
        :type: float
        """

        self._max_allocated_memory = max_allocated_memory

    @property
    def max_allocated_memory_percentage(self):
        """
        Gets the max_allocated_memory_percentage of this ApiImpalaUtilization.
        The maximum percentage of memory that was reserved by Impala for executing queries.

        :return: The max_allocated_memory_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._max_allocated_memory_percentage

    @max_allocated_memory_percentage.setter
    def max_allocated_memory_percentage(self, max_allocated_memory_percentage):
        """
        Sets the max_allocated_memory_percentage of this ApiImpalaUtilization.
        The maximum percentage of memory that was reserved by Impala for executing queries.

        :param max_allocated_memory_percentage: The max_allocated_memory_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._max_allocated_memory_percentage = max_allocated_memory_percentage

    @property
    def utilized_at_max_allocated(self):
        """
        Gets the utilized_at_max_allocated of this ApiImpalaUtilization.
        The amount of memory (in bytes) used by Impala for running queries at the time when maximum memory was reserved.

        :return: The utilized_at_max_allocated of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._utilized_at_max_allocated

    @utilized_at_max_allocated.setter
    def utilized_at_max_allocated(self, utilized_at_max_allocated):
        """
        Sets the utilized_at_max_allocated of this ApiImpalaUtilization.
        The amount of memory (in bytes) used by Impala for running queries at the time when maximum memory was reserved.

        :param utilized_at_max_allocated: The utilized_at_max_allocated of this ApiImpalaUtilization.
        :type: float
        """

        self._utilized_at_max_allocated = utilized_at_max_allocated

    @property
    def utilized_at_max_allocated_percentage(self):
        """
        Gets the utilized_at_max_allocated_percentage of this ApiImpalaUtilization.
        The percentage of memory used by Impala for running queries at the time when maximum memory was reserved.

        :return: The utilized_at_max_allocated_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._utilized_at_max_allocated_percentage

    @utilized_at_max_allocated_percentage.setter
    def utilized_at_max_allocated_percentage(self, utilized_at_max_allocated_percentage):
        """
        Sets the utilized_at_max_allocated_percentage of this ApiImpalaUtilization.
        The percentage of memory used by Impala for running queries at the time when maximum memory was reserved.

        :param utilized_at_max_allocated_percentage: The utilized_at_max_allocated_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._utilized_at_max_allocated_percentage = utilized_at_max_allocated_percentage

    @property
    def peak_usage_timestamp_ms(self):
        """
        Gets the peak_usage_timestamp_ms of this ApiImpalaUtilization.
        The time when Impala used the maximum amount of memory for queries.

        :return: The peak_usage_timestamp_ms of this ApiImpalaUtilization.
        :rtype: int
        """
        return self._peak_usage_timestamp_ms

    @peak_usage_timestamp_ms.setter
    def peak_usage_timestamp_ms(self, peak_usage_timestamp_ms):
        """
        Sets the peak_usage_timestamp_ms of this ApiImpalaUtilization.
        The time when Impala used the maximum amount of memory for queries.

        :param peak_usage_timestamp_ms: The peak_usage_timestamp_ms of this ApiImpalaUtilization.
        :type: int
        """

        self._peak_usage_timestamp_ms = peak_usage_timestamp_ms

    @property
    def max_utilized_memory(self):
        """
        Gets the max_utilized_memory of this ApiImpalaUtilization.
        The maximum memory (in bytes) that was used by Impala for executing queries.

        :return: The max_utilized_memory of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._max_utilized_memory

    @max_utilized_memory.setter
    def max_utilized_memory(self, max_utilized_memory):
        """
        Sets the max_utilized_memory of this ApiImpalaUtilization.
        The maximum memory (in bytes) that was used by Impala for executing queries.

        :param max_utilized_memory: The max_utilized_memory of this ApiImpalaUtilization.
        :type: float
        """

        self._max_utilized_memory = max_utilized_memory

    @property
    def max_utilized_memory_percentage(self):
        """
        Gets the max_utilized_memory_percentage of this ApiImpalaUtilization.
        The maximum percentage of memory that was used by Impala for executing queries.

        :return: The max_utilized_memory_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._max_utilized_memory_percentage

    @max_utilized_memory_percentage.setter
    def max_utilized_memory_percentage(self, max_utilized_memory_percentage):
        """
        Sets the max_utilized_memory_percentage of this ApiImpalaUtilization.
        The maximum percentage of memory that was used by Impala for executing queries.

        :param max_utilized_memory_percentage: The max_utilized_memory_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._max_utilized_memory_percentage = max_utilized_memory_percentage

    @property
    def allocated_at_max_utilized(self):
        """
        Gets the allocated_at_max_utilized of this ApiImpalaUtilization.
        The amount of memory (in bytes) reserved by Impala at the time when it was using the maximum memory for executing queries.

        :return: The allocated_at_max_utilized of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._allocated_at_max_utilized

    @allocated_at_max_utilized.setter
    def allocated_at_max_utilized(self, allocated_at_max_utilized):
        """
        Sets the allocated_at_max_utilized of this ApiImpalaUtilization.
        The amount of memory (in bytes) reserved by Impala at the time when it was using the maximum memory for executing queries.

        :param allocated_at_max_utilized: The allocated_at_max_utilized of this ApiImpalaUtilization.
        :type: float
        """

        self._allocated_at_max_utilized = allocated_at_max_utilized

    @property
    def allocated_at_max_utilized_percentage(self):
        """
        Gets the allocated_at_max_utilized_percentage of this ApiImpalaUtilization.
        The percentage of memory reserved by Impala at the time when it was using the maximum memory for executing queries.

        :return: The allocated_at_max_utilized_percentage of this ApiImpalaUtilization.
        :rtype: float
        """
        return self._allocated_at_max_utilized_percentage

    @allocated_at_max_utilized_percentage.setter
    def allocated_at_max_utilized_percentage(self, allocated_at_max_utilized_percentage):
        """
        Sets the allocated_at_max_utilized_percentage of this ApiImpalaUtilization.
        The percentage of memory reserved by Impala at the time when it was using the maximum memory for executing queries.

        :param allocated_at_max_utilized_percentage: The allocated_at_max_utilized_percentage of this ApiImpalaUtilization.
        :type: float
        """

        self._allocated_at_max_utilized_percentage = allocated_at_max_utilized_percentage

    @property
    def distribution_utilized_by_impala_daemon(self):
        """
        Gets the distribution_utilized_by_impala_daemon of this ApiImpalaUtilization.
        Distribution of memory used per Impala daemon for executing queries at the time Impala used the maximum memory.

        :return: The distribution_utilized_by_impala_daemon of this ApiImpalaUtilization.
        :rtype: ApiImpalaUtilizationHistogram
        """
        return self._distribution_utilized_by_impala_daemon

    @distribution_utilized_by_impala_daemon.setter
    def distribution_utilized_by_impala_daemon(self, distribution_utilized_by_impala_daemon):
        """
        Sets the distribution_utilized_by_impala_daemon of this ApiImpalaUtilization.
        Distribution of memory used per Impala daemon for executing queries at the time Impala used the maximum memory.

        :param distribution_utilized_by_impala_daemon: The distribution_utilized_by_impala_daemon of this ApiImpalaUtilization.
        :type: ApiImpalaUtilizationHistogram
        """

        self._distribution_utilized_by_impala_daemon = distribution_utilized_by_impala_daemon

    @property
    def distribution_allocated_by_impala_daemon(self):
        """
        Gets the distribution_allocated_by_impala_daemon of this ApiImpalaUtilization.
        Distribution of memory reserved per Impala daemon for executing queries at the time Impala used the maximum memory.

        :return: The distribution_allocated_by_impala_daemon of this ApiImpalaUtilization.
        :rtype: ApiImpalaUtilizationHistogram
        """
        return self._distribution_allocated_by_impala_daemon

    @distribution_allocated_by_impala_daemon.setter
    def distribution_allocated_by_impala_daemon(self, distribution_allocated_by_impala_daemon):
        """
        Sets the distribution_allocated_by_impala_daemon of this ApiImpalaUtilization.
        Distribution of memory reserved per Impala daemon for executing queries at the time Impala used the maximum memory.

        :param distribution_allocated_by_impala_daemon: The distribution_allocated_by_impala_daemon of this ApiImpalaUtilization.
        :type: ApiImpalaUtilizationHistogram
        """

        self._distribution_allocated_by_impala_daemon = distribution_allocated_by_impala_daemon

    @property
    def tenant_utilizations(self):
        """
        Gets the tenant_utilizations of this ApiImpalaUtilization.
        A list of tenant utilization reports.

        :return: The tenant_utilizations of this ApiImpalaUtilization.
        :rtype: ApiImpalaTenantUtilizationList
        """
        return self._tenant_utilizations

    @tenant_utilizations.setter
    def tenant_utilizations(self, tenant_utilizations):
        """
        Sets the tenant_utilizations of this ApiImpalaUtilization.
        A list of tenant utilization reports.

        :param tenant_utilizations: The tenant_utilizations of this ApiImpalaUtilization.
        :type: ApiImpalaTenantUtilizationList
        """

        self._tenant_utilizations = tenant_utilizations

    @property
    def error_message(self):
        """
        Gets the error_message of this ApiImpalaUtilization.
        error message of utilization report.

        :return: The error_message of this ApiImpalaUtilization.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this ApiImpalaUtilization.
        error message of utilization report.

        :param error_message: The error_message of this ApiImpalaUtilization.
        :type: str
        """

        self._error_message = error_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiImpalaUtilization):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
