# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiImpalaTenantUtilization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'tenant_name': 'str',
        'total_queries': 'float',
        'successful_queries': 'float',
        'oom_queries': 'float',
        'time_out_queries': 'float',
        'rejected_queries': 'float',
        'avg_wait_time_in_queue': 'float',
        'peak_allocation_timestamp_ms': 'int',
        'max_allocated_memory': 'float',
        'max_allocated_memory_percentage': 'float',
        'utilized_at_max_allocated': 'float',
        'utilized_at_max_allocated_percentage': 'float',
        'peak_usage_timestamp_ms': 'int',
        'max_utilized_memory': 'float',
        'max_utilized_memory_percentage': 'float',
        'allocated_at_max_utilized': 'float',
        'allocated_at_max_utilized_percentage': 'float',
        'distribution_utilized_by_impala_daemon': 'ApiImpalaUtilizationHistogram',
        'distribution_allocated_by_impala_daemon': 'ApiImpalaUtilizationHistogram',
        'avg_spilled_memory': 'float',
        'max_spilled_memory': 'float'
    }

    attribute_map = {
        'tenant_name': 'tenantName',
        'total_queries': 'totalQueries',
        'successful_queries': 'successfulQueries',
        'oom_queries': 'oomQueries',
        'time_out_queries': 'timeOutQueries',
        'rejected_queries': 'rejectedQueries',
        'avg_wait_time_in_queue': 'avgWaitTimeInQueue',
        'peak_allocation_timestamp_ms': 'peakAllocationTimestampMS',
        'max_allocated_memory': 'maxAllocatedMemory',
        'max_allocated_memory_percentage': 'maxAllocatedMemoryPercentage',
        'utilized_at_max_allocated': 'utilizedAtMaxAllocated',
        'utilized_at_max_allocated_percentage': 'utilizedAtMaxAllocatedPercentage',
        'peak_usage_timestamp_ms': 'peakUsageTimestampMS',
        'max_utilized_memory': 'maxUtilizedMemory',
        'max_utilized_memory_percentage': 'maxUtilizedMemoryPercentage',
        'allocated_at_max_utilized': 'allocatedAtMaxUtilized',
        'allocated_at_max_utilized_percentage': 'allocatedAtMaxUtilizedPercentage',
        'distribution_utilized_by_impala_daemon': 'distributionUtilizedByImpalaDaemon',
        'distribution_allocated_by_impala_daemon': 'distributionAllocatedByImpalaDaemon',
        'avg_spilled_memory': 'avgSpilledMemory',
        'max_spilled_memory': 'maxSpilledMemory'
    }

    def __init__(self, tenant_name=None, total_queries=None, successful_queries=None, oom_queries=None, time_out_queries=None, rejected_queries=None, avg_wait_time_in_queue=None, peak_allocation_timestamp_ms=None, max_allocated_memory=None, max_allocated_memory_percentage=None, utilized_at_max_allocated=None, utilized_at_max_allocated_percentage=None, peak_usage_timestamp_ms=None, max_utilized_memory=None, max_utilized_memory_percentage=None, allocated_at_max_utilized=None, allocated_at_max_utilized_percentage=None, distribution_utilized_by_impala_daemon=None, distribution_allocated_by_impala_daemon=None, avg_spilled_memory=None, max_spilled_memory=None):
        """
        ApiImpalaTenantUtilization - a model defined in Swagger
        """

        self._tenant_name = None
        self._total_queries = None
        self._successful_queries = None
        self._oom_queries = None
        self._time_out_queries = None
        self._rejected_queries = None
        self._avg_wait_time_in_queue = None
        self._peak_allocation_timestamp_ms = None
        self._max_allocated_memory = None
        self._max_allocated_memory_percentage = None
        self._utilized_at_max_allocated = None
        self._utilized_at_max_allocated_percentage = None
        self._peak_usage_timestamp_ms = None
        self._max_utilized_memory = None
        self._max_utilized_memory_percentage = None
        self._allocated_at_max_utilized = None
        self._allocated_at_max_utilized_percentage = None
        self._distribution_utilized_by_impala_daemon = None
        self._distribution_allocated_by_impala_daemon = None
        self._avg_spilled_memory = None
        self._max_spilled_memory = None

        if tenant_name is not None:
          self.tenant_name = tenant_name
        if total_queries is not None:
          self.total_queries = total_queries
        if successful_queries is not None:
          self.successful_queries = successful_queries
        if oom_queries is not None:
          self.oom_queries = oom_queries
        if time_out_queries is not None:
          self.time_out_queries = time_out_queries
        if rejected_queries is not None:
          self.rejected_queries = rejected_queries
        if avg_wait_time_in_queue is not None:
          self.avg_wait_time_in_queue = avg_wait_time_in_queue
        if peak_allocation_timestamp_ms is not None:
          self.peak_allocation_timestamp_ms = peak_allocation_timestamp_ms
        if max_allocated_memory is not None:
          self.max_allocated_memory = max_allocated_memory
        if max_allocated_memory_percentage is not None:
          self.max_allocated_memory_percentage = max_allocated_memory_percentage
        if utilized_at_max_allocated is not None:
          self.utilized_at_max_allocated = utilized_at_max_allocated
        if utilized_at_max_allocated_percentage is not None:
          self.utilized_at_max_allocated_percentage = utilized_at_max_allocated_percentage
        if peak_usage_timestamp_ms is not None:
          self.peak_usage_timestamp_ms = peak_usage_timestamp_ms
        if max_utilized_memory is not None:
          self.max_utilized_memory = max_utilized_memory
        if max_utilized_memory_percentage is not None:
          self.max_utilized_memory_percentage = max_utilized_memory_percentage
        if allocated_at_max_utilized is not None:
          self.allocated_at_max_utilized = allocated_at_max_utilized
        if allocated_at_max_utilized_percentage is not None:
          self.allocated_at_max_utilized_percentage = allocated_at_max_utilized_percentage
        if distribution_utilized_by_impala_daemon is not None:
          self.distribution_utilized_by_impala_daemon = distribution_utilized_by_impala_daemon
        if distribution_allocated_by_impala_daemon is not None:
          self.distribution_allocated_by_impala_daemon = distribution_allocated_by_impala_daemon
        if avg_spilled_memory is not None:
          self.avg_spilled_memory = avg_spilled_memory
        if max_spilled_memory is not None:
          self.max_spilled_memory = max_spilled_memory

    @property
    def tenant_name(self):
        """
        Gets the tenant_name of this ApiImpalaTenantUtilization.
        Name of the tenant.

        :return: The tenant_name of this ApiImpalaTenantUtilization.
        :rtype: str
        """
        return self._tenant_name

    @tenant_name.setter
    def tenant_name(self, tenant_name):
        """
        Sets the tenant_name of this ApiImpalaTenantUtilization.
        Name of the tenant.

        :param tenant_name: The tenant_name of this ApiImpalaTenantUtilization.
        :type: str
        """

        self._tenant_name = tenant_name

    @property
    def total_queries(self):
        """
        Gets the total_queries of this ApiImpalaTenantUtilization.
        Total number of queries submitted to Impala.

        :return: The total_queries of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._total_queries

    @total_queries.setter
    def total_queries(self, total_queries):
        """
        Sets the total_queries of this ApiImpalaTenantUtilization.
        Total number of queries submitted to Impala.

        :param total_queries: The total_queries of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._total_queries = total_queries

    @property
    def successful_queries(self):
        """
        Gets the successful_queries of this ApiImpalaTenantUtilization.
        Number of queries that finished successfully.

        :return: The successful_queries of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._successful_queries

    @successful_queries.setter
    def successful_queries(self, successful_queries):
        """
        Sets the successful_queries of this ApiImpalaTenantUtilization.
        Number of queries that finished successfully.

        :param successful_queries: The successful_queries of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._successful_queries = successful_queries

    @property
    def oom_queries(self):
        """
        Gets the oom_queries of this ApiImpalaTenantUtilization.
        Number of queries that failed due to insufficient memory.

        :return: The oom_queries of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._oom_queries

    @oom_queries.setter
    def oom_queries(self, oom_queries):
        """
        Sets the oom_queries of this ApiImpalaTenantUtilization.
        Number of queries that failed due to insufficient memory.

        :param oom_queries: The oom_queries of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._oom_queries = oom_queries

    @property
    def time_out_queries(self):
        """
        Gets the time_out_queries of this ApiImpalaTenantUtilization.
        Number of queries that timed out while waiting for resources in a pool.

        :return: The time_out_queries of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._time_out_queries

    @time_out_queries.setter
    def time_out_queries(self, time_out_queries):
        """
        Sets the time_out_queries of this ApiImpalaTenantUtilization.
        Number of queries that timed out while waiting for resources in a pool.

        :param time_out_queries: The time_out_queries of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._time_out_queries = time_out_queries

    @property
    def rejected_queries(self):
        """
        Gets the rejected_queries of this ApiImpalaTenantUtilization.
        Number of queries that were rejected by Impala because the pool was full.

        :return: The rejected_queries of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._rejected_queries

    @rejected_queries.setter
    def rejected_queries(self, rejected_queries):
        """
        Sets the rejected_queries of this ApiImpalaTenantUtilization.
        Number of queries that were rejected by Impala because the pool was full.

        :param rejected_queries: The rejected_queries of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._rejected_queries = rejected_queries

    @property
    def avg_wait_time_in_queue(self):
        """
        Gets the avg_wait_time_in_queue of this ApiImpalaTenantUtilization.
        Average time, in milliseconds, spent by a query in an Impala pool while waiting for resources.

        :return: The avg_wait_time_in_queue of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._avg_wait_time_in_queue

    @avg_wait_time_in_queue.setter
    def avg_wait_time_in_queue(self, avg_wait_time_in_queue):
        """
        Sets the avg_wait_time_in_queue of this ApiImpalaTenantUtilization.
        Average time, in milliseconds, spent by a query in an Impala pool while waiting for resources.

        :param avg_wait_time_in_queue: The avg_wait_time_in_queue of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._avg_wait_time_in_queue = avg_wait_time_in_queue

    @property
    def peak_allocation_timestamp_ms(self):
        """
        Gets the peak_allocation_timestamp_ms of this ApiImpalaTenantUtilization.
        The time when Impala reserved the maximum amount of memory for queries.

        :return: The peak_allocation_timestamp_ms of this ApiImpalaTenantUtilization.
        :rtype: int
        """
        return self._peak_allocation_timestamp_ms

    @peak_allocation_timestamp_ms.setter
    def peak_allocation_timestamp_ms(self, peak_allocation_timestamp_ms):
        """
        Sets the peak_allocation_timestamp_ms of this ApiImpalaTenantUtilization.
        The time when Impala reserved the maximum amount of memory for queries.

        :param peak_allocation_timestamp_ms: The peak_allocation_timestamp_ms of this ApiImpalaTenantUtilization.
        :type: int
        """

        self._peak_allocation_timestamp_ms = peak_allocation_timestamp_ms

    @property
    def max_allocated_memory(self):
        """
        Gets the max_allocated_memory of this ApiImpalaTenantUtilization.
        The maximum memory (in bytes) that was reserved by Impala for executing queries.

        :return: The max_allocated_memory of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._max_allocated_memory

    @max_allocated_memory.setter
    def max_allocated_memory(self, max_allocated_memory):
        """
        Sets the max_allocated_memory of this ApiImpalaTenantUtilization.
        The maximum memory (in bytes) that was reserved by Impala for executing queries.

        :param max_allocated_memory: The max_allocated_memory of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._max_allocated_memory = max_allocated_memory

    @property
    def max_allocated_memory_percentage(self):
        """
        Gets the max_allocated_memory_percentage of this ApiImpalaTenantUtilization.
        The maximum percentage of memory that was reserved by Impala for executing queries.

        :return: The max_allocated_memory_percentage of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._max_allocated_memory_percentage

    @max_allocated_memory_percentage.setter
    def max_allocated_memory_percentage(self, max_allocated_memory_percentage):
        """
        Sets the max_allocated_memory_percentage of this ApiImpalaTenantUtilization.
        The maximum percentage of memory that was reserved by Impala for executing queries.

        :param max_allocated_memory_percentage: The max_allocated_memory_percentage of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._max_allocated_memory_percentage = max_allocated_memory_percentage

    @property
    def utilized_at_max_allocated(self):
        """
        Gets the utilized_at_max_allocated of this ApiImpalaTenantUtilization.
        The amount of memory (in bytes) used by Impala for running queries at the time when maximum memory was reserved.

        :return: The utilized_at_max_allocated of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._utilized_at_max_allocated

    @utilized_at_max_allocated.setter
    def utilized_at_max_allocated(self, utilized_at_max_allocated):
        """
        Sets the utilized_at_max_allocated of this ApiImpalaTenantUtilization.
        The amount of memory (in bytes) used by Impala for running queries at the time when maximum memory was reserved.

        :param utilized_at_max_allocated: The utilized_at_max_allocated of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._utilized_at_max_allocated = utilized_at_max_allocated

    @property
    def utilized_at_max_allocated_percentage(self):
        """
        Gets the utilized_at_max_allocated_percentage of this ApiImpalaTenantUtilization.
        The percentage of memory used by Impala for running queries at the time when maximum memory was reserved.

        :return: The utilized_at_max_allocated_percentage of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._utilized_at_max_allocated_percentage

    @utilized_at_max_allocated_percentage.setter
    def utilized_at_max_allocated_percentage(self, utilized_at_max_allocated_percentage):
        """
        Sets the utilized_at_max_allocated_percentage of this ApiImpalaTenantUtilization.
        The percentage of memory used by Impala for running queries at the time when maximum memory was reserved.

        :param utilized_at_max_allocated_percentage: The utilized_at_max_allocated_percentage of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._utilized_at_max_allocated_percentage = utilized_at_max_allocated_percentage

    @property
    def peak_usage_timestamp_ms(self):
        """
        Gets the peak_usage_timestamp_ms of this ApiImpalaTenantUtilization.
        The time when Impala used the maximum amount of memory for queries.

        :return: The peak_usage_timestamp_ms of this ApiImpalaTenantUtilization.
        :rtype: int
        """
        return self._peak_usage_timestamp_ms

    @peak_usage_timestamp_ms.setter
    def peak_usage_timestamp_ms(self, peak_usage_timestamp_ms):
        """
        Sets the peak_usage_timestamp_ms of this ApiImpalaTenantUtilization.
        The time when Impala used the maximum amount of memory for queries.

        :param peak_usage_timestamp_ms: The peak_usage_timestamp_ms of this ApiImpalaTenantUtilization.
        :type: int
        """

        self._peak_usage_timestamp_ms = peak_usage_timestamp_ms

    @property
    def max_utilized_memory(self):
        """
        Gets the max_utilized_memory of this ApiImpalaTenantUtilization.
        The maximum memory (in bytes) that was used by Impala for executing queries.

        :return: The max_utilized_memory of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._max_utilized_memory

    @max_utilized_memory.setter
    def max_utilized_memory(self, max_utilized_memory):
        """
        Sets the max_utilized_memory of this ApiImpalaTenantUtilization.
        The maximum memory (in bytes) that was used by Impala for executing queries.

        :param max_utilized_memory: The max_utilized_memory of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._max_utilized_memory = max_utilized_memory

    @property
    def max_utilized_memory_percentage(self):
        """
        Gets the max_utilized_memory_percentage of this ApiImpalaTenantUtilization.
        The maximum percentage of memory that was used by Impala for executing queries.

        :return: The max_utilized_memory_percentage of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._max_utilized_memory_percentage

    @max_utilized_memory_percentage.setter
    def max_utilized_memory_percentage(self, max_utilized_memory_percentage):
        """
        Sets the max_utilized_memory_percentage of this ApiImpalaTenantUtilization.
        The maximum percentage of memory that was used by Impala for executing queries.

        :param max_utilized_memory_percentage: The max_utilized_memory_percentage of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._max_utilized_memory_percentage = max_utilized_memory_percentage

    @property
    def allocated_at_max_utilized(self):
        """
        Gets the allocated_at_max_utilized of this ApiImpalaTenantUtilization.
        The amount of memory (in bytes) reserved by Impala at the time when it was using the maximum memory for executing queries.

        :return: The allocated_at_max_utilized of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._allocated_at_max_utilized

    @allocated_at_max_utilized.setter
    def allocated_at_max_utilized(self, allocated_at_max_utilized):
        """
        Sets the allocated_at_max_utilized of this ApiImpalaTenantUtilization.
        The amount of memory (in bytes) reserved by Impala at the time when it was using the maximum memory for executing queries.

        :param allocated_at_max_utilized: The allocated_at_max_utilized of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._allocated_at_max_utilized = allocated_at_max_utilized

    @property
    def allocated_at_max_utilized_percentage(self):
        """
        Gets the allocated_at_max_utilized_percentage of this ApiImpalaTenantUtilization.
        The percentage of memory reserved by Impala at the time when it was using the maximum memory for executing queries.

        :return: The allocated_at_max_utilized_percentage of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._allocated_at_max_utilized_percentage

    @allocated_at_max_utilized_percentage.setter
    def allocated_at_max_utilized_percentage(self, allocated_at_max_utilized_percentage):
        """
        Sets the allocated_at_max_utilized_percentage of this ApiImpalaTenantUtilization.
        The percentage of memory reserved by Impala at the time when it was using the maximum memory for executing queries.

        :param allocated_at_max_utilized_percentage: The allocated_at_max_utilized_percentage of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._allocated_at_max_utilized_percentage = allocated_at_max_utilized_percentage

    @property
    def distribution_utilized_by_impala_daemon(self):
        """
        Gets the distribution_utilized_by_impala_daemon of this ApiImpalaTenantUtilization.
        Distribution of memory used per Impala daemon for executing queries at the time Impala used the maximum memory.

        :return: The distribution_utilized_by_impala_daemon of this ApiImpalaTenantUtilization.
        :rtype: ApiImpalaUtilizationHistogram
        """
        return self._distribution_utilized_by_impala_daemon

    @distribution_utilized_by_impala_daemon.setter
    def distribution_utilized_by_impala_daemon(self, distribution_utilized_by_impala_daemon):
        """
        Sets the distribution_utilized_by_impala_daemon of this ApiImpalaTenantUtilization.
        Distribution of memory used per Impala daemon for executing queries at the time Impala used the maximum memory.

        :param distribution_utilized_by_impala_daemon: The distribution_utilized_by_impala_daemon of this ApiImpalaTenantUtilization.
        :type: ApiImpalaUtilizationHistogram
        """

        self._distribution_utilized_by_impala_daemon = distribution_utilized_by_impala_daemon

    @property
    def distribution_allocated_by_impala_daemon(self):
        """
        Gets the distribution_allocated_by_impala_daemon of this ApiImpalaTenantUtilization.
        Distribution of memory reserved per Impala daemon for executing queries at the time Impala used the maximum memory.

        :return: The distribution_allocated_by_impala_daemon of this ApiImpalaTenantUtilization.
        :rtype: ApiImpalaUtilizationHistogram
        """
        return self._distribution_allocated_by_impala_daemon

    @distribution_allocated_by_impala_daemon.setter
    def distribution_allocated_by_impala_daemon(self, distribution_allocated_by_impala_daemon):
        """
        Sets the distribution_allocated_by_impala_daemon of this ApiImpalaTenantUtilization.
        Distribution of memory reserved per Impala daemon for executing queries at the time Impala used the maximum memory.

        :param distribution_allocated_by_impala_daemon: The distribution_allocated_by_impala_daemon of this ApiImpalaTenantUtilization.
        :type: ApiImpalaUtilizationHistogram
        """

        self._distribution_allocated_by_impala_daemon = distribution_allocated_by_impala_daemon

    @property
    def avg_spilled_memory(self):
        """
        Gets the avg_spilled_memory of this ApiImpalaTenantUtilization.
        Average spill per query.

        :return: The avg_spilled_memory of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._avg_spilled_memory

    @avg_spilled_memory.setter
    def avg_spilled_memory(self, avg_spilled_memory):
        """
        Sets the avg_spilled_memory of this ApiImpalaTenantUtilization.
        Average spill per query.

        :param avg_spilled_memory: The avg_spilled_memory of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._avg_spilled_memory = avg_spilled_memory

    @property
    def max_spilled_memory(self):
        """
        Gets the max_spilled_memory of this ApiImpalaTenantUtilization.
        Maximum spill per query.

        :return: The max_spilled_memory of this ApiImpalaTenantUtilization.
        :rtype: float
        """
        return self._max_spilled_memory

    @max_spilled_memory.setter
    def max_spilled_memory(self, max_spilled_memory):
        """
        Sets the max_spilled_memory of this ApiImpalaTenantUtilization.
        Maximum spill per query.

        :param max_spilled_memory: The max_spilled_memory of this ApiImpalaTenantUtilization.
        :type: float
        """

        self._max_spilled_memory = max_spilled_memory

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiImpalaTenantUtilization):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
