# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiImpalaQueryAttribute(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'type': 'str',
        'display_name': 'str',
        'supports_histograms': 'bool',
        'description': 'str'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'display_name': 'displayName',
        'supports_histograms': 'supportsHistograms',
        'description': 'description'
    }

    def __init__(self, name=None, type=None, display_name=None, supports_histograms=None, description=None):
        """
        ApiImpalaQueryAttribute - a model defined in Swagger
        """

        self._name = None
        self._type = None
        self._display_name = None
        self._supports_histograms = None
        self._description = None

        if name is not None:
          self.name = name
        if type is not None:
          self.type = type
        if display_name is not None:
          self.display_name = display_name
        if supports_histograms is not None:
          self.supports_histograms = supports_histograms
        if description is not None:
          self.description = description

    @property
    def name(self):
        """
        Gets the name of this ApiImpalaQueryAttribute.
        The name of the attribute. This name can be used in filters, for example 'user' could be used in the filter 'user = root'.

        :return: The name of this ApiImpalaQueryAttribute.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiImpalaQueryAttribute.
        The name of the attribute. This name can be used in filters, for example 'user' could be used in the filter 'user = root'.

        :param name: The name of this ApiImpalaQueryAttribute.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this ApiImpalaQueryAttribute.
        The type of the attribute. Valid types are STRING, NUMBER, BOOLEAN, BYTES, MILLISECONDS, BYTES_PER_SECOND, BYTE_SECONDS.

        :return: The type of this ApiImpalaQueryAttribute.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ApiImpalaQueryAttribute.
        The type of the attribute. Valid types are STRING, NUMBER, BOOLEAN, BYTES, MILLISECONDS, BYTES_PER_SECOND, BYTE_SECONDS.

        :param type: The type of this ApiImpalaQueryAttribute.
        :type: str
        """

        self._type = type

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiImpalaQueryAttribute.
        The display name for the attribute.

        :return: The display_name of this ApiImpalaQueryAttribute.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiImpalaQueryAttribute.
        The display name for the attribute.

        :param display_name: The display_name of this ApiImpalaQueryAttribute.
        :type: str
        """

        self._display_name = display_name

    @property
    def supports_histograms(self):
        """
        Gets the supports_histograms of this ApiImpalaQueryAttribute.
        Whether the Service Monitor can generate a histogram of the distribution of the attribute across queries.

        :return: The supports_histograms of this ApiImpalaQueryAttribute.
        :rtype: bool
        """
        return self._supports_histograms

    @supports_histograms.setter
    def supports_histograms(self, supports_histograms):
        """
        Sets the supports_histograms of this ApiImpalaQueryAttribute.
        Whether the Service Monitor can generate a histogram of the distribution of the attribute across queries.

        :param supports_histograms: The supports_histograms of this ApiImpalaQueryAttribute.
        :type: bool
        """

        self._supports_histograms = supports_histograms

    @property
    def description(self):
        """
        Gets the description of this ApiImpalaQueryAttribute.
        The description of the attribute.

        :return: The description of this ApiImpalaQueryAttribute.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApiImpalaQueryAttribute.
        The description of the attribute.

        :param description: The description of this ApiImpalaQueryAttribute.
        :type: str
        """

        self._description = description

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiImpalaQueryAttribute):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
