# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHostCertInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'hostname': 'str',
        'certificate': 'str',
        'key': 'str',
        'subject_alt_names': 'list[str]'
    }

    attribute_map = {
        'hostname': 'hostname',
        'certificate': 'certificate',
        'key': 'key',
        'subject_alt_names': 'subjectAltNames'
    }

    def __init__(self, hostname=None, certificate=None, key=None, subject_alt_names=None):
        """
        ApiHostCertInfo - a model defined in Swagger
        """

        self._hostname = None
        self._certificate = None
        self._key = None
        self._subject_alt_names = None

        if hostname is not None:
          self.hostname = hostname
        if certificate is not None:
          self.certificate = certificate
        if key is not None:
          self.key = key
        if subject_alt_names is not None:
          self.subject_alt_names = subject_alt_names

    @property
    def hostname(self):
        """
        Gets the hostname of this ApiHostCertInfo.
        The FQDN of a host in the deployment.

        :return: The hostname of this ApiHostCertInfo.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this ApiHostCertInfo.
        The FQDN of a host in the deployment.

        :param hostname: The hostname of this ApiHostCertInfo.
        :type: str
        """

        self._hostname = hostname

    @property
    def certificate(self):
        """
        Gets the certificate of this ApiHostCertInfo.
        The certificate for this host in PEM format.

        :return: The certificate of this ApiHostCertInfo.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """
        Sets the certificate of this ApiHostCertInfo.
        The certificate for this host in PEM format.

        :param certificate: The certificate of this ApiHostCertInfo.
        :type: str
        """

        self._certificate = certificate

    @property
    def key(self):
        """
        Gets the key of this ApiHostCertInfo.
        The private key for this host in PEM format.

        :return: The key of this ApiHostCertInfo.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this ApiHostCertInfo.
        The private key for this host in PEM format.

        :param key: The key of this ApiHostCertInfo.
        :type: str
        """

        self._key = key

    @property
    def subject_alt_names(self):
        """
        Gets the subject_alt_names of this ApiHostCertInfo.
        A list of alt names for a host.

        :return: The subject_alt_names of this ApiHostCertInfo.
        :rtype: list[str]
        """
        return self._subject_alt_names

    @subject_alt_names.setter
    def subject_alt_names(self, subject_alt_names):
        """
        Sets the subject_alt_names of this ApiHostCertInfo.
        A list of alt names for a host.

        :param subject_alt_names: The subject_alt_names of this ApiHostCertInfo.
        :type: list[str]
        """

        self._subject_alt_names = subject_alt_names

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHostCertInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
