# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHdfsUsageReport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_update_time': 'str',
        'items': 'list[ApiHdfsUsageReportRow]'
    }

    attribute_map = {
        'last_update_time': 'lastUpdateTime',
        'items': 'items'
    }

    def __init__(self, last_update_time=None, items=None):
        """
        ApiHdfsUsageReport - a model defined in Swagger
        """

        self._last_update_time = None
        self._items = None

        if last_update_time is not None:
          self.last_update_time = last_update_time
        if items is not None:
          self.items = items

    @property
    def last_update_time(self):
        """
        Gets the last_update_time of this ApiHdfsUsageReport.
        The time when HDFS usage info was last collected. No information beyond this time can be provided.

        :return: The last_update_time of this ApiHdfsUsageReport.
        :rtype: str
        """
        return self._last_update_time

    @last_update_time.setter
    def last_update_time(self, last_update_time):
        """
        Sets the last_update_time of this ApiHdfsUsageReport.
        The time when HDFS usage info was last collected. No information beyond this time can be provided.

        :param last_update_time: The last_update_time of this ApiHdfsUsageReport.
        :type: str
        """

        self._last_update_time = last_update_time

    @property
    def items(self):
        """
        Gets the items of this ApiHdfsUsageReport.
        A list of per-user usage information at the requested time granularity.

        :return: The items of this ApiHdfsUsageReport.
        :rtype: list[ApiHdfsUsageReportRow]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ApiHdfsUsageReport.
        A list of per-user usage information at the requested time granularity.

        :param items: The items of this ApiHdfsUsageReport.
        :type: list[ApiHdfsUsageReportRow]
        """

        self._items = items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHdfsUsageReport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
