# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHdfsHaArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'active_name': 'str',
        'active_shared_edits_path': 'str',
        'stand_by_name': 'str',
        'stand_by_shared_edits_path': 'str',
        'nameservice': 'str',
        'start_dependent_services': 'bool',
        'deploy_client_configs': 'bool',
        'enable_quorum_storage': 'bool'
    }

    attribute_map = {
        'active_name': 'activeName',
        'active_shared_edits_path': 'activeSharedEditsPath',
        'stand_by_name': 'standByName',
        'stand_by_shared_edits_path': 'standBySharedEditsPath',
        'nameservice': 'nameservice',
        'start_dependent_services': 'startDependentServices',
        'deploy_client_configs': 'deployClientConfigs',
        'enable_quorum_storage': 'enableQuorumStorage'
    }

    def __init__(self, active_name=None, active_shared_edits_path=None, stand_by_name=None, stand_by_shared_edits_path=None, nameservice=None, start_dependent_services=None, deploy_client_configs=None, enable_quorum_storage=None):
        """
        ApiHdfsHaArguments - a model defined in Swagger
        """

        self._active_name = None
        self._active_shared_edits_path = None
        self._stand_by_name = None
        self._stand_by_shared_edits_path = None
        self._nameservice = None
        self._start_dependent_services = None
        self._deploy_client_configs = None
        self._enable_quorum_storage = None

        if active_name is not None:
          self.active_name = active_name
        if active_shared_edits_path is not None:
          self.active_shared_edits_path = active_shared_edits_path
        if stand_by_name is not None:
          self.stand_by_name = stand_by_name
        if stand_by_shared_edits_path is not None:
          self.stand_by_shared_edits_path = stand_by_shared_edits_path
        if nameservice is not None:
          self.nameservice = nameservice
        if start_dependent_services is not None:
          self.start_dependent_services = start_dependent_services
        if deploy_client_configs is not None:
          self.deploy_client_configs = deploy_client_configs
        if enable_quorum_storage is not None:
          self.enable_quorum_storage = enable_quorum_storage

    @property
    def active_name(self):
        """
        Gets the active_name of this ApiHdfsHaArguments.
        Name of the active NameNode.

        :return: The active_name of this ApiHdfsHaArguments.
        :rtype: str
        """
        return self._active_name

    @active_name.setter
    def active_name(self, active_name):
        """
        Sets the active_name of this ApiHdfsHaArguments.
        Name of the active NameNode.

        :param active_name: The active_name of this ApiHdfsHaArguments.
        :type: str
        """

        self._active_name = active_name

    @property
    def active_shared_edits_path(self):
        """
        Gets the active_shared_edits_path of this ApiHdfsHaArguments.
        Path to the shared edits directory on the active NameNode's host. Ignored if Quorum-based Storage is being enabled.

        :return: The active_shared_edits_path of this ApiHdfsHaArguments.
        :rtype: str
        """
        return self._active_shared_edits_path

    @active_shared_edits_path.setter
    def active_shared_edits_path(self, active_shared_edits_path):
        """
        Sets the active_shared_edits_path of this ApiHdfsHaArguments.
        Path to the shared edits directory on the active NameNode's host. Ignored if Quorum-based Storage is being enabled.

        :param active_shared_edits_path: The active_shared_edits_path of this ApiHdfsHaArguments.
        :type: str
        """

        self._active_shared_edits_path = active_shared_edits_path

    @property
    def stand_by_name(self):
        """
        Gets the stand_by_name of this ApiHdfsHaArguments.
        Name of the stand-by Namenode.

        :return: The stand_by_name of this ApiHdfsHaArguments.
        :rtype: str
        """
        return self._stand_by_name

    @stand_by_name.setter
    def stand_by_name(self, stand_by_name):
        """
        Sets the stand_by_name of this ApiHdfsHaArguments.
        Name of the stand-by Namenode.

        :param stand_by_name: The stand_by_name of this ApiHdfsHaArguments.
        :type: str
        """

        self._stand_by_name = stand_by_name

    @property
    def stand_by_shared_edits_path(self):
        """
        Gets the stand_by_shared_edits_path of this ApiHdfsHaArguments.
        Path to the shared edits directory on the stand-by NameNode's host. Ignored if Quorum-based Storage is being enabled.

        :return: The stand_by_shared_edits_path of this ApiHdfsHaArguments.
        :rtype: str
        """
        return self._stand_by_shared_edits_path

    @stand_by_shared_edits_path.setter
    def stand_by_shared_edits_path(self, stand_by_shared_edits_path):
        """
        Sets the stand_by_shared_edits_path of this ApiHdfsHaArguments.
        Path to the shared edits directory on the stand-by NameNode's host. Ignored if Quorum-based Storage is being enabled.

        :param stand_by_shared_edits_path: The stand_by_shared_edits_path of this ApiHdfsHaArguments.
        :type: str
        """

        self._stand_by_shared_edits_path = stand_by_shared_edits_path

    @property
    def nameservice(self):
        """
        Gets the nameservice of this ApiHdfsHaArguments.
        Nameservice that identifies the HA pair.

        :return: The nameservice of this ApiHdfsHaArguments.
        :rtype: str
        """
        return self._nameservice

    @nameservice.setter
    def nameservice(self, nameservice):
        """
        Sets the nameservice of this ApiHdfsHaArguments.
        Nameservice that identifies the HA pair.

        :param nameservice: The nameservice of this ApiHdfsHaArguments.
        :type: str
        """

        self._nameservice = nameservice

    @property
    def start_dependent_services(self):
        """
        Gets the start_dependent_services of this ApiHdfsHaArguments.
        Whether to re-start dependent services. Defaults to true.

        :return: The start_dependent_services of this ApiHdfsHaArguments.
        :rtype: bool
        """
        return self._start_dependent_services

    @start_dependent_services.setter
    def start_dependent_services(self, start_dependent_services):
        """
        Sets the start_dependent_services of this ApiHdfsHaArguments.
        Whether to re-start dependent services. Defaults to true.

        :param start_dependent_services: The start_dependent_services of this ApiHdfsHaArguments.
        :type: bool
        """

        self._start_dependent_services = start_dependent_services

    @property
    def deploy_client_configs(self):
        """
        Gets the deploy_client_configs of this ApiHdfsHaArguments.
        Whether to re-deploy client configurations. Defaults to true.

        :return: The deploy_client_configs of this ApiHdfsHaArguments.
        :rtype: bool
        """
        return self._deploy_client_configs

    @deploy_client_configs.setter
    def deploy_client_configs(self, deploy_client_configs):
        """
        Sets the deploy_client_configs of this ApiHdfsHaArguments.
        Whether to re-deploy client configurations. Defaults to true.

        :param deploy_client_configs: The deploy_client_configs of this ApiHdfsHaArguments.
        :type: bool
        """

        self._deploy_client_configs = deploy_client_configs

    @property
    def enable_quorum_storage(self):
        """
        Gets the enable_quorum_storage of this ApiHdfsHaArguments.
        This parameter has been deprecated as of CM 5.0, where HA is only supported using Quorum-based Storage. <p> Whether to enable Quorum-based Storage.  Enabling Quorum-based Storage requires a minimum of three and an odd number of JournalNodes to be created and configured before enabling HDFS HA. <p> Available since API v2.

        :return: The enable_quorum_storage of this ApiHdfsHaArguments.
        :rtype: bool
        """
        return self._enable_quorum_storage

    @enable_quorum_storage.setter
    def enable_quorum_storage(self, enable_quorum_storage):
        """
        Sets the enable_quorum_storage of this ApiHdfsHaArguments.
        This parameter has been deprecated as of CM 5.0, where HA is only supported using Quorum-based Storage. <p> Whether to enable Quorum-based Storage.  Enabling Quorum-based Storage requires a minimum of three and an odd number of JournalNodes to be created and configured before enabling HDFS HA. <p> Available since API v2.

        :param enable_quorum_storage: The enable_quorum_storage of this ApiHdfsHaArguments.
        :type: bool
        """

        self._enable_quorum_storage = enable_quorum_storage

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHdfsHaArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
