# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHBaseReplicationArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source_h_base_service': 'ApiServiceRef',
        'peer_state': 'HBasePeerState',
        'hbase_cluster_key': 'str',
        'end_point_class_name': 'str',
        'tables': 'list[HBaseTableArgs]',
        'replication_properties': 'dict(str, str)',
        'source_account': 'str',
        'source_scheduler_pool': 'str',
        'num_mappers': 'int'
    }

    attribute_map = {
        'source_h_base_service': 'sourceHBaseService',
        'peer_state': 'peerState',
        'hbase_cluster_key': 'hbaseClusterKey',
        'end_point_class_name': 'endPointClassName',
        'tables': 'tables',
        'replication_properties': 'replicationProperties',
        'source_account': 'sourceAccount',
        'source_scheduler_pool': 'sourceSchedulerPool',
        'num_mappers': 'numMappers'
    }

    def __init__(self, source_h_base_service=None, peer_state=None, hbase_cluster_key=None, end_point_class_name=None, tables=None, replication_properties=None, source_account=None, source_scheduler_pool=None, num_mappers=None):
        """
        ApiHBaseReplicationArguments - a model defined in Swagger
        """

        self._source_h_base_service = None
        self._peer_state = None
        self._hbase_cluster_key = None
        self._end_point_class_name = None
        self._tables = None
        self._replication_properties = None
        self._source_account = None
        self._source_scheduler_pool = None
        self._num_mappers = None

        if source_h_base_service is not None:
          self.source_h_base_service = source_h_base_service
        if peer_state is not None:
          self.peer_state = peer_state
        if hbase_cluster_key is not None:
          self.hbase_cluster_key = hbase_cluster_key
        if end_point_class_name is not None:
          self.end_point_class_name = end_point_class_name
        if tables is not None:
          self.tables = tables
        if replication_properties is not None:
          self.replication_properties = replication_properties
        if source_account is not None:
          self.source_account = source_account
        if source_scheduler_pool is not None:
          self.source_scheduler_pool = source_scheduler_pool
        if num_mappers is not None:
          self.num_mappers = num_mappers

    @property
    def source_h_base_service(self):
        """
        Gets the source_h_base_service of this ApiHBaseReplicationArguments.
        

        :return: The source_h_base_service of this ApiHBaseReplicationArguments.
        :rtype: ApiServiceRef
        """
        return self._source_h_base_service

    @source_h_base_service.setter
    def source_h_base_service(self, source_h_base_service):
        """
        Sets the source_h_base_service of this ApiHBaseReplicationArguments.
        

        :param source_h_base_service: The source_h_base_service of this ApiHBaseReplicationArguments.
        :type: ApiServiceRef
        """

        self._source_h_base_service = source_h_base_service

    @property
    def peer_state(self):
        """
        Gets the peer_state of this ApiHBaseReplicationArguments.
        

        :return: The peer_state of this ApiHBaseReplicationArguments.
        :rtype: HBasePeerState
        """
        return self._peer_state

    @peer_state.setter
    def peer_state(self, peer_state):
        """
        Sets the peer_state of this ApiHBaseReplicationArguments.
        

        :param peer_state: The peer_state of this ApiHBaseReplicationArguments.
        :type: HBasePeerState
        """

        self._peer_state = peer_state

    @property
    def hbase_cluster_key(self):
        """
        Gets the hbase_cluster_key of this ApiHBaseReplicationArguments.
        

        :return: The hbase_cluster_key of this ApiHBaseReplicationArguments.
        :rtype: str
        """
        return self._hbase_cluster_key

    @hbase_cluster_key.setter
    def hbase_cluster_key(self, hbase_cluster_key):
        """
        Sets the hbase_cluster_key of this ApiHBaseReplicationArguments.
        

        :param hbase_cluster_key: The hbase_cluster_key of this ApiHBaseReplicationArguments.
        :type: str
        """

        self._hbase_cluster_key = hbase_cluster_key

    @property
    def end_point_class_name(self):
        """
        Gets the end_point_class_name of this ApiHBaseReplicationArguments.
        

        :return: The end_point_class_name of this ApiHBaseReplicationArguments.
        :rtype: str
        """
        return self._end_point_class_name

    @end_point_class_name.setter
    def end_point_class_name(self, end_point_class_name):
        """
        Sets the end_point_class_name of this ApiHBaseReplicationArguments.
        

        :param end_point_class_name: The end_point_class_name of this ApiHBaseReplicationArguments.
        :type: str
        """

        self._end_point_class_name = end_point_class_name

    @property
    def tables(self):
        """
        Gets the tables of this ApiHBaseReplicationArguments.
        

        :return: The tables of this ApiHBaseReplicationArguments.
        :rtype: list[HBaseTableArgs]
        """
        return self._tables

    @tables.setter
    def tables(self, tables):
        """
        Sets the tables of this ApiHBaseReplicationArguments.
        

        :param tables: The tables of this ApiHBaseReplicationArguments.
        :type: list[HBaseTableArgs]
        """

        self._tables = tables

    @property
    def replication_properties(self):
        """
        Gets the replication_properties of this ApiHBaseReplicationArguments.
        

        :return: The replication_properties of this ApiHBaseReplicationArguments.
        :rtype: dict(str, str)
        """
        return self._replication_properties

    @replication_properties.setter
    def replication_properties(self, replication_properties):
        """
        Sets the replication_properties of this ApiHBaseReplicationArguments.
        

        :param replication_properties: The replication_properties of this ApiHBaseReplicationArguments.
        :type: dict(str, str)
        """

        self._replication_properties = replication_properties

    @property
    def source_account(self):
        """
        Gets the source_account of this ApiHBaseReplicationArguments.
        

        :return: The source_account of this ApiHBaseReplicationArguments.
        :rtype: str
        """
        return self._source_account

    @source_account.setter
    def source_account(self, source_account):
        """
        Sets the source_account of this ApiHBaseReplicationArguments.
        

        :param source_account: The source_account of this ApiHBaseReplicationArguments.
        :type: str
        """

        self._source_account = source_account

    @property
    def source_scheduler_pool(self):
        """
        Gets the source_scheduler_pool of this ApiHBaseReplicationArguments.
        

        :return: The source_scheduler_pool of this ApiHBaseReplicationArguments.
        :rtype: str
        """
        return self._source_scheduler_pool

    @source_scheduler_pool.setter
    def source_scheduler_pool(self, source_scheduler_pool):
        """
        Sets the source_scheduler_pool of this ApiHBaseReplicationArguments.
        

        :param source_scheduler_pool: The source_scheduler_pool of this ApiHBaseReplicationArguments.
        :type: str
        """

        self._source_scheduler_pool = source_scheduler_pool

    @property
    def num_mappers(self):
        """
        Gets the num_mappers of this ApiHBaseReplicationArguments.
        

        :return: The num_mappers of this ApiHBaseReplicationArguments.
        :rtype: int
        """
        return self._num_mappers

    @num_mappers.setter
    def num_mappers(self, num_mappers):
        """
        Sets the num_mappers of this ApiHBaseReplicationArguments.
        

        :param num_mappers: The num_mappers of this ApiHBaseReplicationArguments.
        :type: int
        """

        self._num_mappers = num_mappers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHBaseReplicationArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
