# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiGenerateCopyDockerArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'remote_repo_url': 'str',
        'docker_registry': 'str',
        'control_plane_uuid': 'str'
    }

    attribute_map = {
        'remote_repo_url': 'remoteRepoUrl',
        'docker_registry': 'dockerRegistry',
        'control_plane_uuid': 'controlPlaneUuid'
    }

    def __init__(self, remote_repo_url=None, docker_registry=None, control_plane_uuid=None):
        """
        ApiGenerateCopyDockerArgs - a model defined in Swagger
        """

        self._remote_repo_url = None
        self._docker_registry = None
        self._control_plane_uuid = None

        if remote_repo_url is not None:
          self.remote_repo_url = remote_repo_url
        if docker_registry is not None:
          self.docker_registry = docker_registry
        if control_plane_uuid is not None:
          self.control_plane_uuid = control_plane_uuid

    @property
    def remote_repo_url(self):
        """
        Gets the remote_repo_url of this ApiGenerateCopyDockerArgs.
        The url of the remote repository where the private cloud artifacts to install are hosted

        :return: The remote_repo_url of this ApiGenerateCopyDockerArgs.
        :rtype: str
        """
        return self._remote_repo_url

    @remote_repo_url.setter
    def remote_repo_url(self, remote_repo_url):
        """
        Sets the remote_repo_url of this ApiGenerateCopyDockerArgs.
        The url of the remote repository where the private cloud artifacts to install are hosted

        :param remote_repo_url: The remote_repo_url of this ApiGenerateCopyDockerArgs.
        :type: str
        """

        self._remote_repo_url = remote_repo_url

    @property
    def docker_registry(self):
        """
        Gets the docker_registry of this ApiGenerateCopyDockerArgs.
        The url of the Docker Registry where images required for install will be copied to

        :return: The docker_registry of this ApiGenerateCopyDockerArgs.
        :rtype: str
        """
        return self._docker_registry

    @docker_registry.setter
    def docker_registry(self, docker_registry):
        """
        Sets the docker_registry of this ApiGenerateCopyDockerArgs.
        The url of the Docker Registry where images required for install will be copied to

        :param docker_registry: The docker_registry of this ApiGenerateCopyDockerArgs.
        :type: str
        """

        self._docker_registry = docker_registry

    @property
    def control_plane_uuid(self):
        """
        Gets the control_plane_uuid of this ApiGenerateCopyDockerArgs.
        Optional. The uuid of the control plane, if copying docker images for an upgrade

        :return: The control_plane_uuid of this ApiGenerateCopyDockerArgs.
        :rtype: str
        """
        return self._control_plane_uuid

    @control_plane_uuid.setter
    def control_plane_uuid(self, control_plane_uuid):
        """
        Sets the control_plane_uuid of this ApiGenerateCopyDockerArgs.
        Optional. The uuid of the control plane, if copying docker images for an upgrade

        :param control_plane_uuid: The control_plane_uuid of this ApiGenerateCopyDockerArgs.
        :type: str
        """

        self._control_plane_uuid = control_plane_uuid

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiGenerateCopyDockerArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
