# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiGenerateCmcaArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ssh_port': 'int',
        'user_name': 'str',
        'password': 'str',
        'private_key': 'str',
        'passphrase': 'str',
        'location': 'str',
        'custom_ca': 'bool',
        'interpret_as_filenames': 'bool',
        'cm_host_cert': 'str',
        'cm_host_key': 'str',
        'ca_cert': 'str',
        'keystore_passwd': 'str',
        'truststore_passwd': 'str',
        'trusted_ca_certs': 'str',
        'additional_arguments': 'list[str]',
        'host_certs': 'list[ApiHostCertInfo]',
        'configure_all_services': 'bool'
    }

    attribute_map = {
        'ssh_port': 'sshPort',
        'user_name': 'userName',
        'password': 'password',
        'private_key': 'privateKey',
        'passphrase': 'passphrase',
        'location': 'location',
        'custom_ca': 'customCA',
        'interpret_as_filenames': 'interpretAsFilenames',
        'cm_host_cert': 'cmHostCert',
        'cm_host_key': 'cmHostKey',
        'ca_cert': 'caCert',
        'keystore_passwd': 'keystorePasswd',
        'truststore_passwd': 'truststorePasswd',
        'trusted_ca_certs': 'trustedCaCerts',
        'additional_arguments': 'additionalArguments',
        'host_certs': 'hostCerts',
        'configure_all_services': 'configureAllServices'
    }

    def __init__(self, ssh_port=None, user_name=None, password=None, private_key=None, passphrase=None, location=None, custom_ca=None, interpret_as_filenames=None, cm_host_cert=None, cm_host_key=None, ca_cert=None, keystore_passwd=None, truststore_passwd=None, trusted_ca_certs=None, additional_arguments=None, host_certs=None, configure_all_services=None):
        """
        ApiGenerateCmcaArguments - a model defined in Swagger
        """

        self._ssh_port = None
        self._user_name = None
        self._password = None
        self._private_key = None
        self._passphrase = None
        self._location = None
        self._custom_ca = None
        self._interpret_as_filenames = None
        self._cm_host_cert = None
        self._cm_host_key = None
        self._ca_cert = None
        self._keystore_passwd = None
        self._truststore_passwd = None
        self._trusted_ca_certs = None
        self._additional_arguments = None
        self._host_certs = None
        self._configure_all_services = None

        if ssh_port is not None:
          self.ssh_port = ssh_port
        if user_name is not None:
          self.user_name = user_name
        if password is not None:
          self.password = password
        if private_key is not None:
          self.private_key = private_key
        if passphrase is not None:
          self.passphrase = passphrase
        if location is not None:
          self.location = location
        if custom_ca is not None:
          self.custom_ca = custom_ca
        if interpret_as_filenames is not None:
          self.interpret_as_filenames = interpret_as_filenames
        if cm_host_cert is not None:
          self.cm_host_cert = cm_host_cert
        if cm_host_key is not None:
          self.cm_host_key = cm_host_key
        if ca_cert is not None:
          self.ca_cert = ca_cert
        if keystore_passwd is not None:
          self.keystore_passwd = keystore_passwd
        if truststore_passwd is not None:
          self.truststore_passwd = truststore_passwd
        if trusted_ca_certs is not None:
          self.trusted_ca_certs = trusted_ca_certs
        if additional_arguments is not None:
          self.additional_arguments = additional_arguments
        if host_certs is not None:
          self.host_certs = host_certs
        if configure_all_services is not None:
          self.configure_all_services = configure_all_services

    @property
    def ssh_port(self):
        """
        Gets the ssh_port of this ApiGenerateCmcaArguments.
        SSH port. If unset, defaults to 22.

        :return: The ssh_port of this ApiGenerateCmcaArguments.
        :rtype: int
        """
        return self._ssh_port

    @ssh_port.setter
    def ssh_port(self, ssh_port):
        """
        Sets the ssh_port of this ApiGenerateCmcaArguments.
        SSH port. If unset, defaults to 22.

        :param ssh_port: The ssh_port of this ApiGenerateCmcaArguments.
        :type: int
        """

        self._ssh_port = ssh_port

    @property
    def user_name(self):
        """
        Gets the user_name of this ApiGenerateCmcaArguments.
        The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.

        :return: The user_name of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this ApiGenerateCmcaArguments.
        The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.

        :param user_name: The user_name of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._user_name = user_name

    @property
    def password(self):
        """
        Gets the password of this ApiGenerateCmcaArguments.
        The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.

        :return: The password of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this ApiGenerateCmcaArguments.
        The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.

        :param password: The password of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._password = password

    @property
    def private_key(self):
        """
        Gets the private_key of this ApiGenerateCmcaArguments.
        The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>

        :return: The private_key of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._private_key

    @private_key.setter
    def private_key(self, private_key):
        """
        Sets the private_key of this ApiGenerateCmcaArguments.
        The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>

        :param private_key: The private_key of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._private_key = private_key

    @property
    def passphrase(self):
        """
        Gets the passphrase of this ApiGenerateCmcaArguments.
        The passphrase associated with the private key used to authenticate with the hosts (optional).

        :return: The passphrase of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._passphrase

    @passphrase.setter
    def passphrase(self, passphrase):
        """
        Sets the passphrase of this ApiGenerateCmcaArguments.
        The passphrase associated with the private key used to authenticate with the hosts (optional).

        :param passphrase: The passphrase of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._passphrase = passphrase

    @property
    def location(self):
        """
        Gets the location of this ApiGenerateCmcaArguments.
        The location on disk to store the CMCA directory. If there is already a CMCA created there, it will be backed up, and a new one will be created in its place.

        :return: The location of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this ApiGenerateCmcaArguments.
        The location on disk to store the CMCA directory. If there is already a CMCA created there, it will be backed up, and a new one will be created in its place.

        :param location: The location of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._location = location

    @property
    def custom_ca(self):
        """
        Gets the custom_ca of this ApiGenerateCmcaArguments.
        Whether to generate an internal CMCA (false) or use user-provided certificates (true).  When set to true (user-provided certificates), the following other arguments must be given: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd

        :return: The custom_ca of this ApiGenerateCmcaArguments.
        :rtype: bool
        """
        return self._custom_ca

    @custom_ca.setter
    def custom_ca(self, custom_ca):
        """
        Sets the custom_ca of this ApiGenerateCmcaArguments.
        Whether to generate an internal CMCA (false) or use user-provided certificates (true).  When set to true (user-provided certificates), the following other arguments must be given: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd

        :param custom_ca: The custom_ca of this ApiGenerateCmcaArguments.
        :type: bool
        """

        self._custom_ca = custom_ca

    @property
    def interpret_as_filenames(self):
        """
        Gets the interpret_as_filenames of this ApiGenerateCmcaArguments.
        Whether the following arguments are interpreted as filenames local to the Cloudera Manager host (true, default) or as the actual data for that argument: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd * trustedCaCerts * hostCerts.hostCert * hostCerts.hostKey  If HTTPS has not been enabled on the Cloudera Manager Admin Console and API, we *strongly* recommend that you pass the arguments as filenames local to the Cloudera Manager host (i.e. set to true) to avoid leaking sensitive information over the wire in plaintext.

        :return: The interpret_as_filenames of this ApiGenerateCmcaArguments.
        :rtype: bool
        """
        return self._interpret_as_filenames

    @interpret_as_filenames.setter
    def interpret_as_filenames(self, interpret_as_filenames):
        """
        Sets the interpret_as_filenames of this ApiGenerateCmcaArguments.
        Whether the following arguments are interpreted as filenames local to the Cloudera Manager host (true, default) or as the actual data for that argument: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd * trustedCaCerts * hostCerts.hostCert * hostCerts.hostKey  If HTTPS has not been enabled on the Cloudera Manager Admin Console and API, we *strongly* recommend that you pass the arguments as filenames local to the Cloudera Manager host (i.e. set to true) to avoid leaking sensitive information over the wire in plaintext.

        :param interpret_as_filenames: The interpret_as_filenames of this ApiGenerateCmcaArguments.
        :type: bool
        """

        self._interpret_as_filenames = interpret_as_filenames

    @property
    def cm_host_cert(self):
        """
        Gets the cm_host_cert of this ApiGenerateCmcaArguments.
        The certificate for the CM host in PEM format. Only used if customCA == true.

        :return: The cm_host_cert of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._cm_host_cert

    @cm_host_cert.setter
    def cm_host_cert(self, cm_host_cert):
        """
        Sets the cm_host_cert of this ApiGenerateCmcaArguments.
        The certificate for the CM host in PEM format. Only used if customCA == true.

        :param cm_host_cert: The cm_host_cert of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._cm_host_cert = cm_host_cert

    @property
    def cm_host_key(self):
        """
        Gets the cm_host_key of this ApiGenerateCmcaArguments.
        The private key for the CM host in PEM format. Only used if customCA == true.

        :return: The cm_host_key of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._cm_host_key

    @cm_host_key.setter
    def cm_host_key(self, cm_host_key):
        """
        Sets the cm_host_key of this ApiGenerateCmcaArguments.
        The private key for the CM host in PEM format. Only used if customCA == true.

        :param cm_host_key: The cm_host_key of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._cm_host_key = cm_host_key

    @property
    def ca_cert(self):
        """
        Gets the ca_cert of this ApiGenerateCmcaArguments.
        The certificate for the user-provided certificate authority in PEM format. Only used if customCA == true.

        :return: The ca_cert of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._ca_cert

    @ca_cert.setter
    def ca_cert(self, ca_cert):
        """
        Sets the ca_cert of this ApiGenerateCmcaArguments.
        The certificate for the user-provided certificate authority in PEM format. Only used if customCA == true.

        :param ca_cert: The ca_cert of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._ca_cert = ca_cert

    @property
    def keystore_passwd(self):
        """
        Gets the keystore_passwd of this ApiGenerateCmcaArguments.
        The password used for all Auto-TLS keystores. Only used if customCA == true.

        :return: The keystore_passwd of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._keystore_passwd

    @keystore_passwd.setter
    def keystore_passwd(self, keystore_passwd):
        """
        Sets the keystore_passwd of this ApiGenerateCmcaArguments.
        The password used for all Auto-TLS keystores. Only used if customCA == true.

        :param keystore_passwd: The keystore_passwd of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._keystore_passwd = keystore_passwd

    @property
    def truststore_passwd(self):
        """
        Gets the truststore_passwd of this ApiGenerateCmcaArguments.
        The password used for all Auto-TLS truststores. Only used if customCA == true.

        :return: The truststore_passwd of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._truststore_passwd

    @truststore_passwd.setter
    def truststore_passwd(self, truststore_passwd):
        """
        Sets the truststore_passwd of this ApiGenerateCmcaArguments.
        The password used for all Auto-TLS truststores. Only used if customCA == true.

        :param truststore_passwd: The truststore_passwd of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._truststore_passwd = truststore_passwd

    @property
    def trusted_ca_certs(self):
        """
        Gets the trusted_ca_certs of this ApiGenerateCmcaArguments.
        A list of CA certificates that will be imported into the Auto-TLS truststore and distributed to all hosts.

        :return: The trusted_ca_certs of this ApiGenerateCmcaArguments.
        :rtype: str
        """
        return self._trusted_ca_certs

    @trusted_ca_certs.setter
    def trusted_ca_certs(self, trusted_ca_certs):
        """
        Sets the trusted_ca_certs of this ApiGenerateCmcaArguments.
        A list of CA certificates that will be imported into the Auto-TLS truststore and distributed to all hosts.

        :param trusted_ca_certs: The trusted_ca_certs of this ApiGenerateCmcaArguments.
        :type: str
        """

        self._trusted_ca_certs = trusted_ca_certs

    @property
    def additional_arguments(self):
        """
        Gets the additional_arguments of this ApiGenerateCmcaArguments.
        A list of additional arguments that can be passed to the certificate manager

        :return: The additional_arguments of this ApiGenerateCmcaArguments.
        :rtype: list[str]
        """
        return self._additional_arguments

    @additional_arguments.setter
    def additional_arguments(self, additional_arguments):
        """
        Sets the additional_arguments of this ApiGenerateCmcaArguments.
        A list of additional arguments that can be passed to the certificate manager

        :param additional_arguments: The additional_arguments of this ApiGenerateCmcaArguments.
        :type: list[str]
        """

        self._additional_arguments = additional_arguments

    @property
    def host_certs(self):
        """
        Gets the host_certs of this ApiGenerateCmcaArguments.
        A list of HostCertInfo objects, which associate a hostname with the corresponding certificate and private key. Only used if customCA == true.

        :return: The host_certs of this ApiGenerateCmcaArguments.
        :rtype: list[ApiHostCertInfo]
        """
        return self._host_certs

    @host_certs.setter
    def host_certs(self, host_certs):
        """
        Sets the host_certs of this ApiGenerateCmcaArguments.
        A list of HostCertInfo objects, which associate a hostname with the corresponding certificate and private key. Only used if customCA == true.

        :param host_certs: The host_certs of this ApiGenerateCmcaArguments.
        :type: list[ApiHostCertInfo]
        """

        self._host_certs = host_certs

    @property
    def configure_all_services(self):
        """
        Gets the configure_all_services of this ApiGenerateCmcaArguments.
        Whether to configure all existing services to use Auto-TLS. Defaults to false.  If false, only MGMT services will be configured to use Auto-TLS. Use the cluster-level ConfigureAutoTlsServices command to configure Auto-TLS services for a single cluster only.  All future services will be configured to use Auto-TLS regardless of this setting.

        :return: The configure_all_services of this ApiGenerateCmcaArguments.
        :rtype: bool
        """
        return self._configure_all_services

    @configure_all_services.setter
    def configure_all_services(self, configure_all_services):
        """
        Sets the configure_all_services of this ApiGenerateCmcaArguments.
        Whether to configure all existing services to use Auto-TLS. Defaults to false.  If false, only MGMT services will be configured to use Auto-TLS. Use the cluster-level ConfigureAutoTlsServices command to configure Auto-TLS services for a single cluster only.  All future services will be configured to use Auto-TLS regardless of this setting.

        :param configure_all_services: The configure_all_services of this ApiGenerateCmcaArguments.
        :type: bool
        """

        self._configure_all_services = configure_all_services

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiGenerateCmcaArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
