# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiEnableJtHaArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'new_jt_host_id': 'str',
        'force_init_z_node': 'bool',
        'zk_service_name': 'str',
        'new_jt_role_name': 'str',
        'fc1_role_name': 'str',
        'fc2_role_name': 'str',
        'logical_name': 'str'
    }

    attribute_map = {
        'new_jt_host_id': 'newJtHostId',
        'force_init_z_node': 'forceInitZNode',
        'zk_service_name': 'zkServiceName',
        'new_jt_role_name': 'newJtRoleName',
        'fc1_role_name': 'fc1RoleName',
        'fc2_role_name': 'fc2RoleName',
        'logical_name': 'logicalName'
    }

    def __init__(self, new_jt_host_id=None, force_init_z_node=None, zk_service_name=None, new_jt_role_name=None, fc1_role_name=None, fc2_role_name=None, logical_name=None):
        """
        ApiEnableJtHaArguments - a model defined in Swagger
        """

        self._new_jt_host_id = None
        self._force_init_z_node = None
        self._zk_service_name = None
        self._new_jt_role_name = None
        self._fc1_role_name = None
        self._fc2_role_name = None
        self._logical_name = None

        if new_jt_host_id is not None:
          self.new_jt_host_id = new_jt_host_id
        if force_init_z_node is not None:
          self.force_init_z_node = force_init_z_node
        if zk_service_name is not None:
          self.zk_service_name = zk_service_name
        if new_jt_role_name is not None:
          self.new_jt_role_name = new_jt_role_name
        if fc1_role_name is not None:
          self.fc1_role_name = fc1_role_name
        if fc2_role_name is not None:
          self.fc2_role_name = fc2_role_name
        if logical_name is not None:
          self.logical_name = logical_name

    @property
    def new_jt_host_id(self):
        """
        Gets the new_jt_host_id of this ApiEnableJtHaArguments.
        Id of host on which second JobTracker role will be added.

        :return: The new_jt_host_id of this ApiEnableJtHaArguments.
        :rtype: str
        """
        return self._new_jt_host_id

    @new_jt_host_id.setter
    def new_jt_host_id(self, new_jt_host_id):
        """
        Sets the new_jt_host_id of this ApiEnableJtHaArguments.
        Id of host on which second JobTracker role will be added.

        :param new_jt_host_id: The new_jt_host_id of this ApiEnableJtHaArguments.
        :type: str
        """

        self._new_jt_host_id = new_jt_host_id

    @property
    def force_init_z_node(self):
        """
        Gets the force_init_z_node of this ApiEnableJtHaArguments.
        Initialize the ZNode even if it already exists. This can happen if JobTracker HA was enabled before and then disabled. Disable operation doesn't delete this ZNode. Defaults to true.

        :return: The force_init_z_node of this ApiEnableJtHaArguments.
        :rtype: bool
        """
        return self._force_init_z_node

    @force_init_z_node.setter
    def force_init_z_node(self, force_init_z_node):
        """
        Sets the force_init_z_node of this ApiEnableJtHaArguments.
        Initialize the ZNode even if it already exists. This can happen if JobTracker HA was enabled before and then disabled. Disable operation doesn't delete this ZNode. Defaults to true.

        :param force_init_z_node: The force_init_z_node of this ApiEnableJtHaArguments.
        :type: bool
        """

        self._force_init_z_node = force_init_z_node

    @property
    def zk_service_name(self):
        """
        Gets the zk_service_name of this ApiEnableJtHaArguments.
        Name of the ZooKeeper service that will be used for auto-failover. This is an optional parameter if the MapReduce to ZooKeeper dependency is already set in CM.

        :return: The zk_service_name of this ApiEnableJtHaArguments.
        :rtype: str
        """
        return self._zk_service_name

    @zk_service_name.setter
    def zk_service_name(self, zk_service_name):
        """
        Sets the zk_service_name of this ApiEnableJtHaArguments.
        Name of the ZooKeeper service that will be used for auto-failover. This is an optional parameter if the MapReduce to ZooKeeper dependency is already set in CM.

        :param zk_service_name: The zk_service_name of this ApiEnableJtHaArguments.
        :type: str
        """

        self._zk_service_name = zk_service_name

    @property
    def new_jt_role_name(self):
        """
        Gets the new_jt_role_name of this ApiEnableJtHaArguments.
        Name of the second JobTracker role to be created (Optional)

        :return: The new_jt_role_name of this ApiEnableJtHaArguments.
        :rtype: str
        """
        return self._new_jt_role_name

    @new_jt_role_name.setter
    def new_jt_role_name(self, new_jt_role_name):
        """
        Sets the new_jt_role_name of this ApiEnableJtHaArguments.
        Name of the second JobTracker role to be created (Optional)

        :param new_jt_role_name: The new_jt_role_name of this ApiEnableJtHaArguments.
        :type: str
        """

        self._new_jt_role_name = new_jt_role_name

    @property
    def fc1_role_name(self):
        """
        Gets the fc1_role_name of this ApiEnableJtHaArguments.
        Name of first Failover Controller role to be created. This is the Failover Controller co-located with the current JobTracker (Optional)

        :return: The fc1_role_name of this ApiEnableJtHaArguments.
        :rtype: str
        """
        return self._fc1_role_name

    @fc1_role_name.setter
    def fc1_role_name(self, fc1_role_name):
        """
        Sets the fc1_role_name of this ApiEnableJtHaArguments.
        Name of first Failover Controller role to be created. This is the Failover Controller co-located with the current JobTracker (Optional)

        :param fc1_role_name: The fc1_role_name of this ApiEnableJtHaArguments.
        :type: str
        """

        self._fc1_role_name = fc1_role_name

    @property
    def fc2_role_name(self):
        """
        Gets the fc2_role_name of this ApiEnableJtHaArguments.
        Name of second Failover Controller role to be created. This is the Failover Controller co-located with the new JobTracker (Optional)

        :return: The fc2_role_name of this ApiEnableJtHaArguments.
        :rtype: str
        """
        return self._fc2_role_name

    @fc2_role_name.setter
    def fc2_role_name(self, fc2_role_name):
        """
        Sets the fc2_role_name of this ApiEnableJtHaArguments.
        Name of second Failover Controller role to be created. This is the Failover Controller co-located with the new JobTracker (Optional)

        :param fc2_role_name: The fc2_role_name of this ApiEnableJtHaArguments.
        :type: str
        """

        self._fc2_role_name = fc2_role_name

    @property
    def logical_name(self):
        """
        Gets the logical_name of this ApiEnableJtHaArguments.
        Logical name of the JobTracker pair. If value is not provided, \"logicaljt\" is used as the default. The name can contain only alphanumeric characters and \"-\". <p> Available since API v8.

        :return: The logical_name of this ApiEnableJtHaArguments.
        :rtype: str
        """
        return self._logical_name

    @logical_name.setter
    def logical_name(self, logical_name):
        """
        Sets the logical_name of this ApiEnableJtHaArguments.
        Logical name of the JobTracker pair. If value is not provided, \"logicaljt\" is used as the default. The name can contain only alphanumeric characters and \"-\". <p> Available since API v8.

        :param logical_name: The logical_name of this ApiEnableJtHaArguments.
        :type: str
        """

        self._logical_name = logical_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiEnableJtHaArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
