# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiClustersPerfInspectorArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source_cluster': 'str',
        'target_cluster': 'str',
        'ping_args': 'ApiPerfInspectorPingArgs',
        'bandwidth_args': 'ApiPerfInspectorBandwidthArgs',
        'policy_type': 'PerfInspectorPolicyType'
    }

    attribute_map = {
        'source_cluster': 'sourceCluster',
        'target_cluster': 'targetCluster',
        'ping_args': 'pingArgs',
        'bandwidth_args': 'bandwidthArgs',
        'policy_type': 'policyType'
    }

    def __init__(self, source_cluster=None, target_cluster=None, ping_args=None, bandwidth_args=None, policy_type=None):
        """
        ApiClustersPerfInspectorArgs - a model defined in Swagger
        """

        self._source_cluster = None
        self._target_cluster = None
        self._ping_args = None
        self._bandwidth_args = None
        self._policy_type = None

        if source_cluster is not None:
          self.source_cluster = source_cluster
        if target_cluster is not None:
          self.target_cluster = target_cluster
        if ping_args is not None:
          self.ping_args = ping_args
        if bandwidth_args is not None:
          self.bandwidth_args = bandwidth_args
        if policy_type is not None:
          self.policy_type = policy_type

    @property
    def source_cluster(self):
        """
        Gets the source_cluster of this ApiClustersPerfInspectorArgs.
        Required name of the source cluster to run network diagnostics test.

        :return: The source_cluster of this ApiClustersPerfInspectorArgs.
        :rtype: str
        """
        return self._source_cluster

    @source_cluster.setter
    def source_cluster(self, source_cluster):
        """
        Sets the source_cluster of this ApiClustersPerfInspectorArgs.
        Required name of the source cluster to run network diagnostics test.

        :param source_cluster: The source_cluster of this ApiClustersPerfInspectorArgs.
        :type: str
        """

        self._source_cluster = source_cluster

    @property
    def target_cluster(self):
        """
        Gets the target_cluster of this ApiClustersPerfInspectorArgs.
        Required name of the target cluster to run network diagnostics test.

        :return: The target_cluster of this ApiClustersPerfInspectorArgs.
        :rtype: str
        """
        return self._target_cluster

    @target_cluster.setter
    def target_cluster(self, target_cluster):
        """
        Sets the target_cluster of this ApiClustersPerfInspectorArgs.
        Required name of the target cluster to run network diagnostics test.

        :param target_cluster: The target_cluster of this ApiClustersPerfInspectorArgs.
        :type: str
        """

        self._target_cluster = target_cluster

    @property
    def ping_args(self):
        """
        Gets the ping_args of this ApiClustersPerfInspectorArgs.
        Optional ping request arguments. If not specified, default arguments will be used for ping test.

        :return: The ping_args of this ApiClustersPerfInspectorArgs.
        :rtype: ApiPerfInspectorPingArgs
        """
        return self._ping_args

    @ping_args.setter
    def ping_args(self, ping_args):
        """
        Sets the ping_args of this ApiClustersPerfInspectorArgs.
        Optional ping request arguments. If not specified, default arguments will be used for ping test.

        :param ping_args: The ping_args of this ApiClustersPerfInspectorArgs.
        :type: ApiPerfInspectorPingArgs
        """

        self._ping_args = ping_args

    @property
    def bandwidth_args(self):
        """
        Gets the bandwidth_args of this ApiClustersPerfInspectorArgs.
        Optional bandwidth test request arguments. If not specified, default arguments will be used for bandwidth test. Applicable since version v32.

        :return: The bandwidth_args of this ApiClustersPerfInspectorArgs.
        :rtype: ApiPerfInspectorBandwidthArgs
        """
        return self._bandwidth_args

    @bandwidth_args.setter
    def bandwidth_args(self, bandwidth_args):
        """
        Sets the bandwidth_args of this ApiClustersPerfInspectorArgs.
        Optional bandwidth test request arguments. If not specified, default arguments will be used for bandwidth test. Applicable since version v32.

        :param bandwidth_args: The bandwidth_args of this ApiClustersPerfInspectorArgs.
        :type: ApiPerfInspectorBandwidthArgs
        """

        self._bandwidth_args = bandwidth_args

    @property
    def policy_type(self):
        """
        Gets the policy_type of this ApiClustersPerfInspectorArgs.
        Optional type of performance diagnostics to run. If not specified, defaults to FULL policy type. Applicable since version v32.

        :return: The policy_type of this ApiClustersPerfInspectorArgs.
        :rtype: PerfInspectorPolicyType
        """
        return self._policy_type

    @policy_type.setter
    def policy_type(self, policy_type):
        """
        Sets the policy_type of this ApiClustersPerfInspectorArgs.
        Optional type of performance diagnostics to run. If not specified, defaults to FULL policy type. Applicable since version v32.

        :param policy_type: The policy_type of this ApiClustersPerfInspectorArgs.
        :type: PerfInspectorPolicyType
        """

        self._policy_type = policy_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiClustersPerfInspectorArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
