# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiAuthRole(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'display_name': 'str',
        'name': 'str',
        'clusters': 'list[ApiClusterRef]',
        'users': 'list[ApiUser2Ref]',
        'external_user_mappings': 'list[ApiExternalUserMappingRef]',
        'base_role': 'ApiAuthRoleRef',
        'uuid': 'str',
        'is_custom': 'bool'
    }

    attribute_map = {
        'display_name': 'displayName',
        'name': 'name',
        'clusters': 'clusters',
        'users': 'users',
        'external_user_mappings': 'externalUserMappings',
        'base_role': 'baseRole',
        'uuid': 'uuid',
        'is_custom': 'isCustom'
    }

    def __init__(self, display_name=None, name=None, clusters=None, users=None, external_user_mappings=None, base_role=None, uuid=None, is_custom=None):
        """
        ApiAuthRole - a model defined in Swagger
        """

        self._display_name = None
        self._name = None
        self._clusters = None
        self._users = None
        self._external_user_mappings = None
        self._base_role = None
        self._uuid = None
        self._is_custom = None

        if display_name is not None:
          self.display_name = display_name
        if name is not None:
          self.name = name
        if clusters is not None:
          self.clusters = clusters
        if users is not None:
          self.users = users
        if external_user_mappings is not None:
          self.external_user_mappings = external_user_mappings
        if base_role is not None:
          self.base_role = base_role
        if uuid is not None:
          self.uuid = uuid
        if is_custom is not None:
          self.is_custom = is_custom

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiAuthRole.
        

        :return: The display_name of this ApiAuthRole.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiAuthRole.
        

        :param display_name: The display_name of this ApiAuthRole.
        :type: str
        """

        self._display_name = display_name

    @property
    def name(self):
        """
        Gets the name of this ApiAuthRole.
        

        :return: The name of this ApiAuthRole.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiAuthRole.
        

        :param name: The name of this ApiAuthRole.
        :type: str
        """

        self._name = name

    @property
    def clusters(self):
        """
        Gets the clusters of this ApiAuthRole.
        

        :return: The clusters of this ApiAuthRole.
        :rtype: list[ApiClusterRef]
        """
        return self._clusters

    @clusters.setter
    def clusters(self, clusters):
        """
        Sets the clusters of this ApiAuthRole.
        

        :param clusters: The clusters of this ApiAuthRole.
        :type: list[ApiClusterRef]
        """

        self._clusters = clusters

    @property
    def users(self):
        """
        Gets the users of this ApiAuthRole.
        

        :return: The users of this ApiAuthRole.
        :rtype: list[ApiUser2Ref]
        """
        return self._users

    @users.setter
    def users(self, users):
        """
        Sets the users of this ApiAuthRole.
        

        :param users: The users of this ApiAuthRole.
        :type: list[ApiUser2Ref]
        """

        self._users = users

    @property
    def external_user_mappings(self):
        """
        Gets the external_user_mappings of this ApiAuthRole.
        

        :return: The external_user_mappings of this ApiAuthRole.
        :rtype: list[ApiExternalUserMappingRef]
        """
        return self._external_user_mappings

    @external_user_mappings.setter
    def external_user_mappings(self, external_user_mappings):
        """
        Sets the external_user_mappings of this ApiAuthRole.
        

        :param external_user_mappings: The external_user_mappings of this ApiAuthRole.
        :type: list[ApiExternalUserMappingRef]
        """

        self._external_user_mappings = external_user_mappings

    @property
    def base_role(self):
        """
        Gets the base_role of this ApiAuthRole.
        A role this user possesses. In Cloudera Enterprise Datahub Edition, possible values are: <ul> <li><b>ROLE_ADMIN</b></li> <li><b>ROLE_USER</b></li> <li><b>ROLE_LIMITED</b>: Added in Cloudera Manager 5.0</li> <li><b>ROLE_OPERATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CONFIGURATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CLUSTER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_BDR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_NAVIGATOR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_USER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_KEY_ADMIN</b>: Added in Cloudera Manager 5.5</li> </ul> An empty role implies ROLE_USER. <p>

        :return: The base_role of this ApiAuthRole.
        :rtype: ApiAuthRoleRef
        """
        return self._base_role

    @base_role.setter
    def base_role(self, base_role):
        """
        Sets the base_role of this ApiAuthRole.
        A role this user possesses. In Cloudera Enterprise Datahub Edition, possible values are: <ul> <li><b>ROLE_ADMIN</b></li> <li><b>ROLE_USER</b></li> <li><b>ROLE_LIMITED</b>: Added in Cloudera Manager 5.0</li> <li><b>ROLE_OPERATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CONFIGURATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CLUSTER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_BDR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_NAVIGATOR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_USER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_KEY_ADMIN</b>: Added in Cloudera Manager 5.5</li> </ul> An empty role implies ROLE_USER. <p>

        :param base_role: The base_role of this ApiAuthRole.
        :type: ApiAuthRoleRef
        """

        self._base_role = base_role

    @property
    def uuid(self):
        """
        Gets the uuid of this ApiAuthRole.
        Readonly. The UUID of the authRole. <p>

        :return: The uuid of this ApiAuthRole.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """
        Sets the uuid of this ApiAuthRole.
        Readonly. The UUID of the authRole. <p>

        :param uuid: The uuid of this ApiAuthRole.
        :type: str
        """

        self._uuid = uuid

    @property
    def is_custom(self):
        """
        Gets the is_custom of this ApiAuthRole.
        

        :return: The is_custom of this ApiAuthRole.
        :rtype: bool
        """
        return self._is_custom

    @is_custom.setter
    def is_custom(self, is_custom):
        """
        Sets the is_custom of this ApiAuthRole.
        

        :param is_custom: The is_custom of this ApiAuthRole.
        :type: bool
        """

        self._is_custom = is_custom

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiAuthRole):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
