# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiActivity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'type': 'ApiActivityType',
        'parent': 'str',
        'start_time': 'str',
        'finish_time': 'str',
        'id': 'str',
        'status': 'ApiActivityStatus',
        'user': 'str',
        'group': 'str',
        'input_dir': 'str',
        'output_dir': 'str',
        'mapper': 'str',
        'combiner': 'str',
        'reducer': 'str',
        'queue_name': 'str',
        'scheduler_priority': 'str'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'parent': 'parent',
        'start_time': 'startTime',
        'finish_time': 'finishTime',
        'id': 'id',
        'status': 'status',
        'user': 'user',
        'group': 'group',
        'input_dir': 'inputDir',
        'output_dir': 'outputDir',
        'mapper': 'mapper',
        'combiner': 'combiner',
        'reducer': 'reducer',
        'queue_name': 'queueName',
        'scheduler_priority': 'schedulerPriority'
    }

    def __init__(self, name=None, type=None, parent=None, start_time=None, finish_time=None, id=None, status=None, user=None, group=None, input_dir=None, output_dir=None, mapper=None, combiner=None, reducer=None, queue_name=None, scheduler_priority=None):
        """
        ApiActivity - a model defined in Swagger
        """

        self._name = None
        self._type = None
        self._parent = None
        self._start_time = None
        self._finish_time = None
        self._id = None
        self._status = None
        self._user = None
        self._group = None
        self._input_dir = None
        self._output_dir = None
        self._mapper = None
        self._combiner = None
        self._reducer = None
        self._queue_name = None
        self._scheduler_priority = None

        if name is not None:
          self.name = name
        if type is not None:
          self.type = type
        if parent is not None:
          self.parent = parent
        if start_time is not None:
          self.start_time = start_time
        if finish_time is not None:
          self.finish_time = finish_time
        if id is not None:
          self.id = id
        if status is not None:
          self.status = status
        if user is not None:
          self.user = user
        if group is not None:
          self.group = group
        if input_dir is not None:
          self.input_dir = input_dir
        if output_dir is not None:
          self.output_dir = output_dir
        if mapper is not None:
          self.mapper = mapper
        if combiner is not None:
          self.combiner = combiner
        if reducer is not None:
          self.reducer = reducer
        if queue_name is not None:
          self.queue_name = queue_name
        if scheduler_priority is not None:
          self.scheduler_priority = scheduler_priority

    @property
    def name(self):
        """
        Gets the name of this ApiActivity.
        Activity name.

        :return: The name of this ApiActivity.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiActivity.
        Activity name.

        :param name: The name of this ApiActivity.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this ApiActivity.
        Activity type. Whether it's an MR job, a Pig job, a Hive query, etc.

        :return: The type of this ApiActivity.
        :rtype: ApiActivityType
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ApiActivity.
        Activity type. Whether it's an MR job, a Pig job, a Hive query, etc.

        :param type: The type of this ApiActivity.
        :type: ApiActivityType
        """

        self._type = type

    @property
    def parent(self):
        """
        Gets the parent of this ApiActivity.
        The name of the parent activity.

        :return: The parent of this ApiActivity.
        :rtype: str
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """
        Sets the parent of this ApiActivity.
        The name of the parent activity.

        :param parent: The parent of this ApiActivity.
        :type: str
        """

        self._parent = parent

    @property
    def start_time(self):
        """
        Gets the start_time of this ApiActivity.
        The start time of this activity.

        :return: The start_time of this ApiActivity.
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this ApiActivity.
        The start time of this activity.

        :param start_time: The start_time of this ApiActivity.
        :type: str
        """

        self._start_time = start_time

    @property
    def finish_time(self):
        """
        Gets the finish_time of this ApiActivity.
        The finish time of this activity.

        :return: The finish_time of this ApiActivity.
        :rtype: str
        """
        return self._finish_time

    @finish_time.setter
    def finish_time(self, finish_time):
        """
        Sets the finish_time of this ApiActivity.
        The finish time of this activity.

        :param finish_time: The finish_time of this ApiActivity.
        :type: str
        """

        self._finish_time = finish_time

    @property
    def id(self):
        """
        Gets the id of this ApiActivity.
        Activity id, which is unique within a MapReduce service.

        :return: The id of this ApiActivity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ApiActivity.
        Activity id, which is unique within a MapReduce service.

        :param id: The id of this ApiActivity.
        :type: str
        """

        self._id = id

    @property
    def status(self):
        """
        Gets the status of this ApiActivity.
        Activity status.

        :return: The status of this ApiActivity.
        :rtype: ApiActivityStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ApiActivity.
        Activity status.

        :param status: The status of this ApiActivity.
        :type: ApiActivityStatus
        """

        self._status = status

    @property
    def user(self):
        """
        Gets the user of this ApiActivity.
        The user who submitted this activity.

        :return: The user of this ApiActivity.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this ApiActivity.
        The user who submitted this activity.

        :param user: The user of this ApiActivity.
        :type: str
        """

        self._user = user

    @property
    def group(self):
        """
        Gets the group of this ApiActivity.
        The user-group of this activity.

        :return: The group of this ApiActivity.
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """
        Sets the group of this ApiActivity.
        The user-group of this activity.

        :param group: The group of this ApiActivity.
        :type: str
        """

        self._group = group

    @property
    def input_dir(self):
        """
        Gets the input_dir of this ApiActivity.
        The input data directory of the activity. An HDFS url.

        :return: The input_dir of this ApiActivity.
        :rtype: str
        """
        return self._input_dir

    @input_dir.setter
    def input_dir(self, input_dir):
        """
        Sets the input_dir of this ApiActivity.
        The input data directory of the activity. An HDFS url.

        :param input_dir: The input_dir of this ApiActivity.
        :type: str
        """

        self._input_dir = input_dir

    @property
    def output_dir(self):
        """
        Gets the output_dir of this ApiActivity.
        The output result directory of the activity. An HDFS url.

        :return: The output_dir of this ApiActivity.
        :rtype: str
        """
        return self._output_dir

    @output_dir.setter
    def output_dir(self, output_dir):
        """
        Sets the output_dir of this ApiActivity.
        The output result directory of the activity. An HDFS url.

        :param output_dir: The output_dir of this ApiActivity.
        :type: str
        """

        self._output_dir = output_dir

    @property
    def mapper(self):
        """
        Gets the mapper of this ApiActivity.
        The mapper class.

        :return: The mapper of this ApiActivity.
        :rtype: str
        """
        return self._mapper

    @mapper.setter
    def mapper(self, mapper):
        """
        Sets the mapper of this ApiActivity.
        The mapper class.

        :param mapper: The mapper of this ApiActivity.
        :type: str
        """

        self._mapper = mapper

    @property
    def combiner(self):
        """
        Gets the combiner of this ApiActivity.
        The combiner class.

        :return: The combiner of this ApiActivity.
        :rtype: str
        """
        return self._combiner

    @combiner.setter
    def combiner(self, combiner):
        """
        Sets the combiner of this ApiActivity.
        The combiner class.

        :param combiner: The combiner of this ApiActivity.
        :type: str
        """

        self._combiner = combiner

    @property
    def reducer(self):
        """
        Gets the reducer of this ApiActivity.
        The reducer class.

        :return: The reducer of this ApiActivity.
        :rtype: str
        """
        return self._reducer

    @reducer.setter
    def reducer(self, reducer):
        """
        Sets the reducer of this ApiActivity.
        The reducer class.

        :param reducer: The reducer of this ApiActivity.
        :type: str
        """

        self._reducer = reducer

    @property
    def queue_name(self):
        """
        Gets the queue_name of this ApiActivity.
        The scheduler queue this activity is in.

        :return: The queue_name of this ApiActivity.
        :rtype: str
        """
        return self._queue_name

    @queue_name.setter
    def queue_name(self, queue_name):
        """
        Sets the queue_name of this ApiActivity.
        The scheduler queue this activity is in.

        :param queue_name: The queue_name of this ApiActivity.
        :type: str
        """

        self._queue_name = queue_name

    @property
    def scheduler_priority(self):
        """
        Gets the scheduler_priority of this ApiActivity.
        The scheduler priority of this activity.

        :return: The scheduler_priority of this ApiActivity.
        :rtype: str
        """
        return self._scheduler_priority

    @scheduler_priority.setter
    def scheduler_priority(self, scheduler_priority):
        """
        Sets the scheduler_priority of this ApiActivity.
        The scheduler priority of this activity.

        :param scheduler_priority: The scheduler_priority of this ApiActivity.
        :type: str
        """

        self._scheduler_priority = scheduler_priority

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiActivity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
