# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class TagsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_tags(self, **kwargs):
        """
        Current CM entities and their tags.
        Current CM entities and their tags. Tag names beginning with the prefix <code>_cldr_</code> (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tags(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: Number of tags to search for. Maximum value for limit is 1000.
        :param int offset: Starting index of the list
        :return: ApiTagToEntitiesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_tags_with_http_info(**kwargs)
        else:
            (data) = self.get_tags_with_http_info(**kwargs)
            return data

    def get_tags_with_http_info(self, **kwargs):
        """
        Current CM entities and their tags.
        Current CM entities and their tags. Tag names beginning with the prefix <code>_cldr_</code> (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tags_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: Number of tags to search for. Maximum value for limit is 1000.
        :param int offset: Starting index of the list
        :return: ApiTagToEntitiesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tags" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/tags', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiTagToEntitiesList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_tags_by_name(self, tag_name, **kwargs):
        """
        Get Entities given the Tag name, grouped by entity type.
        Get Entities given the Tag name, grouped by entity type.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags_by_name(tag_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str tag_name: Name of the tag (required)
        :param int limit: Number of entries to search for. Maximum value for limit is 1000.
        :param int offset: Starting index of the list
        :return: ApiTagToEntitiesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_tags_by_name_with_http_info(tag_name, **kwargs)
        else:
            (data) = self.read_tags_by_name_with_http_info(tag_name, **kwargs)
            return data

    def read_tags_by_name_with_http_info(self, tag_name, **kwargs):
        """
        Get Entities given the Tag name, grouped by entity type.
        Get Entities given the Tag name, grouped by entity type.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags_by_name_with_http_info(tag_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str tag_name: Name of the tag (required)
        :param int limit: Number of entries to search for. Maximum value for limit is 1000.
        :param int offset: Starting index of the list
        :return: ApiTagToEntitiesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tag_name', 'limit', 'offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_tags_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in params) or (params['tag_name'] is None):
            raise ValueError("Missing the required parameter `tag_name` when calling `read_tags_by_name`")


        collection_formats = {}

        path_params = {}
        if 'tag_name' in params:
            path_params['tagName'] = params['tag_name']

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/tags/{tagName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiTagToEntitiesList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
