# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class NameservicesResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_metrics(self, cluster_name, nameservice, service_name, **kwargs):
        """
        Fetch metric readings for a particular nameservice.
        Fetch metric readings for a particular nameservice. <p> By default, this call will look up all metrics available. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available, even if no readings are available in the requested window.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics(cluster_name, nameservice, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str nameservice: The nameservice. (required)
        :param str service_name: The service name. (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_metrics_with_http_info(cluster_name, nameservice, service_name, **kwargs)
        else:
            (data) = self.get_metrics_with_http_info(cluster_name, nameservice, service_name, **kwargs)
            return data

    def get_metrics_with_http_info(self, cluster_name, nameservice, service_name, **kwargs):
        """
        Fetch metric readings for a particular nameservice.
        Fetch metric readings for a particular nameservice. <p> By default, this call will look up all metrics available. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available, even if no readings are available in the requested window.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics_with_http_info(cluster_name, nameservice, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str nameservice: The nameservice. (required)
        :param str service_name: The service name. (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'nameservice', 'service_name', '_from', 'metrics', 'to', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_metrics`")
        # verify the required parameter 'nameservice' is set
        if ('nameservice' not in params) or (params['nameservice'] is None):
            raise ValueError("Missing the required parameter `nameservice` when calling `get_metrics`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_metrics`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'nameservice' in params:
            path_params['nameservice'] = params['nameservice']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))
            collection_formats['metrics'] = 'multi'
        if 'to' in params:
            query_params.append(('to', params['to']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/nameservices/{nameservice}/metrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiMetricList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_nameservices(self, cluster_name, service_name, **kwargs):
        """
        List the nameservices of an HDFS service.
        List the nameservices of an HDFS service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_nameservices(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiNameserviceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_nameservices_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.list_nameservices_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def list_nameservices_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        List the nameservices of an HDFS service.
        List the nameservices of an HDFS service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_nameservices_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiNameserviceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_nameservices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_nameservices`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `list_nameservices`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/nameservices', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiNameserviceList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_nameservice(self, cluster_name, nameservice, service_name, **kwargs):
        """
        Retrieve information about a nameservice.
        Retrieve information about a nameservice.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_nameservice(cluster_name, nameservice, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str nameservice: The nameservice to retrieve. (required)
        :param str service_name: The service name. (required)
        :param str view: The view to materialize. Defaults to 'full'.
        :return: ApiNameservice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_nameservice_with_http_info(cluster_name, nameservice, service_name, **kwargs)
        else:
            (data) = self.read_nameservice_with_http_info(cluster_name, nameservice, service_name, **kwargs)
            return data

    def read_nameservice_with_http_info(self, cluster_name, nameservice, service_name, **kwargs):
        """
        Retrieve information about a nameservice.
        Retrieve information about a nameservice.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_nameservice_with_http_info(cluster_name, nameservice, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str nameservice: The nameservice to retrieve. (required)
        :param str service_name: The service name. (required)
        :param str view: The view to materialize. Defaults to 'full'.
        :return: ApiNameservice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'nameservice', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_nameservice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_nameservice`")
        # verify the required parameter 'nameservice' is set
        if ('nameservice' not in params) or (params['nameservice'] is None):
            raise ValueError("Missing the required parameter `nameservice` when calling `read_nameservice`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_nameservice`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'nameservice' in params:
            path_params['nameservice'] = params['nameservice']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/nameservices/{nameservice}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiNameservice',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
