# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ControlPlanesResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def generate_copy_docker(self, **kwargs):
        """
        Launches the Generate Copy Docker Script Command.
        Launches the Generate Copy Docker Script Command
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_copy_docker(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiGenerateCopyDockerArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.generate_copy_docker_with_http_info(**kwargs)
        else:
            (data) = self.generate_copy_docker_with_http_info(**kwargs)
            return data

    def generate_copy_docker_with_http_info(self, **kwargs):
        """
        Launches the Generate Copy Docker Script Command.
        Launches the Generate Copy Docker Script Command
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_copy_docker_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiGenerateCopyDockerArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_copy_docker" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/commands/generateCopyDocker', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def generate_external_vault_setup(self, **kwargs):
        """
        Launches the Generate Vault Setup Command command.
        Launches the Generate Vault Setup Command command
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_external_vault_setup(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiGenerateExternalVaultSetupArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.generate_external_vault_setup_with_http_info(**kwargs)
        else:
            (data) = self.generate_external_vault_setup_with_http_info(**kwargs)
            return data

    def generate_external_vault_setup_with_http_info(self, **kwargs):
        """
        Launches the Generate Vault Setup Command command.
        Launches the Generate Vault Setup Command command
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_external_vault_setup_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiGenerateExternalVaultSetupArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_external_vault_setup" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/commands/generateExternalVaultSetup', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_control_planes(self, **kwargs):
        """
        Current Control Planes.
        Current Control Planes
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_control_planes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiControlPlaneList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_control_planes_with_http_info(**kwargs)
        else:
            (data) = self.get_control_planes_with_http_info(**kwargs)
            return data

    def get_control_planes_with_http_info(self, **kwargs):
        """
        Current Control Planes.
        Current Control Planes
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_control_planes_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiControlPlaneList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_control_planes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiControlPlaneList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_experience_cluster(self, control_plane_uuid, **kwargs):
        """
        The Experience cluster this control plane is associated with, if any.
        The Experience cluster this control plane is associated with, if any
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_experience_cluster(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_experience_cluster_with_http_info(control_plane_uuid, **kwargs)
        else:
            (data) = self.get_experience_cluster_with_http_info(control_plane_uuid, **kwargs)
            return data

    def get_experience_cluster_with_http_info(self, control_plane_uuid, **kwargs):
        """
        The Experience cluster this control plane is associated with, if any.
        The Experience cluster this control plane is associated with, if any
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_experience_cluster_with_http_info(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['control_plane_uuid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_experience_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'control_plane_uuid' is set
        if ('control_plane_uuid' not in params) or (params['control_plane_uuid'] is None):
            raise ValueError("Missing the required parameter `control_plane_uuid` when calling `get_experience_cluster`")


        collection_formats = {}

        path_params = {}
        if 'control_plane_uuid' in params:
            path_params['controlPlaneUuid'] = params['control_plane_uuid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/{controlPlaneUuid}/getExperienceCluster', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCluster',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_log_content(self, command_id, **kwargs):
        """
        Fetches the log content for the specific command.
        Fetches the log content for the specific command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_log_content(command_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int command_id: the command id (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_log_content_with_http_info(command_id, **kwargs)
        else:
            (data) = self.get_log_content_with_http_info(command_id, **kwargs)
            return data

    def get_log_content_with_http_info(self, command_id, **kwargs):
        """
        Fetches the log content for the specific command.
        Fetches the log content for the specific command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_log_content_with_http_info(command_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int command_id: the command id (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['command_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_log_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'command_id' is set
        if ('command_id' not in params) or (params['command_id'] is None):
            raise ValueError("Missing the required parameter `command_id` when calling `get_log_content`")


        collection_formats = {}

        path_params = {}
        if 'command_id' in params:
            path_params['commandId'] = params['command_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/fetchResources/{commandId}/logContent', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_manifest_json(self, **kwargs):
        """
        Fetches the manifest.
        Fetches the manifest.json under the specified remote repo.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_manifest_json(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiRemoteRepoUrl body: the remote repo url.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_manifest_json_with_http_info(**kwargs)
        else:
            (data) = self.get_manifest_json_with_http_info(**kwargs)
            return data

    def get_manifest_json_with_http_info(self, **kwargs):
        """
        Fetches the manifest.
        Fetches the manifest.json under the specified remote repo.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_manifest_json_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiRemoteRepoUrl body: the remote repo url.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_manifest_json" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/fetchResources/manifest.json', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def install_control_plane(self, **kwargs):
        """
        Launches the install control plane command.
        Launches the install control plane command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_control_plane(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiInstallControlPlaneArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.install_control_plane_with_http_info(**kwargs)
        else:
            (data) = self.install_control_plane_with_http_info(**kwargs)
            return data

    def install_control_plane_with_http_info(self, **kwargs):
        """
        Launches the install control plane command.
        Launches the install control plane command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_control_plane_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiInstallControlPlaneArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_control_plane" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/commands/installControlPlane', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def install_embedded_control_plane(self, **kwargs):
        """
        Brings up a control plane on embedded kubernetes.
        Brings up a control plane on embedded kubernetes. At its core, this command launches the FirstRun command on the Experience cluster
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_embedded_control_plane(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiInstallEmbeddedControlPlaneArgs body: The arguments for Ek8s control plane installation
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.install_embedded_control_plane_with_http_info(**kwargs)
        else:
            (data) = self.install_embedded_control_plane_with_http_info(**kwargs)
            return data

    def install_embedded_control_plane_with_http_info(self, **kwargs):
        """
        Brings up a control plane on embedded kubernetes.
        Brings up a control plane on embedded kubernetes. At its core, this command launches the FirstRun command on the Experience cluster
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_embedded_control_plane_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiInstallEmbeddedControlPlaneArgs body: The arguments for Ek8s control plane installation
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_embedded_control_plane" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/commands/installEmbeddedControlPlane', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_control_plane_by_uuid(self, control_plane_uuid, **kwargs):
        """
        The control plane with the given id.
        The control plane with the given id
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_control_plane_by_uuid(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :return: ApiControlPlane
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_control_plane_by_uuid_with_http_info(control_plane_uuid, **kwargs)
        else:
            (data) = self.read_control_plane_by_uuid_with_http_info(control_plane_uuid, **kwargs)
            return data

    def read_control_plane_by_uuid_with_http_info(self, control_plane_uuid, **kwargs):
        """
        The control plane with the given id.
        The control plane with the given id
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_control_plane_by_uuid_with_http_info(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :return: ApiControlPlane
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['control_plane_uuid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_control_plane_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'control_plane_uuid' is set
        if ('control_plane_uuid' not in params) or (params['control_plane_uuid'] is None):
            raise ValueError("Missing the required parameter `control_plane_uuid` when calling `read_control_plane_by_uuid`")


        collection_formats = {}

        path_params = {}
        if 'control_plane_uuid' in params:
            path_params['controlPlaneUuid'] = params['control_plane_uuid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/{controlPlaneUuid}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiControlPlane',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def uninstall_control_plane(self, control_plane_uuid, **kwargs):
        """
        Launches Uninstall Command on the control plane with the given uuid.
        Launches Uninstall Command on the control plane with the given uuid
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.uninstall_control_plane(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :param ApiUninstallControlPlaneArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.uninstall_control_plane_with_http_info(control_plane_uuid, **kwargs)
        else:
            (data) = self.uninstall_control_plane_with_http_info(control_plane_uuid, **kwargs)
            return data

    def uninstall_control_plane_with_http_info(self, control_plane_uuid, **kwargs):
        """
        Launches Uninstall Command on the control plane with the given uuid.
        Launches Uninstall Command on the control plane with the given uuid
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.uninstall_control_plane_with_http_info(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :param ApiUninstallControlPlaneArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['control_plane_uuid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method uninstall_control_plane" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'control_plane_uuid' is set
        if ('control_plane_uuid' not in params) or (params['control_plane_uuid'] is None):
            raise ValueError("Missing the required parameter `control_plane_uuid` when calling `uninstall_control_plane`")


        collection_formats = {}

        path_params = {}
        if 'control_plane_uuid' in params:
            path_params['controlPlaneUuid'] = params['control_plane_uuid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/{controlPlaneUuid}/commands/uninstallControlPlane', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_values_yaml(self, control_plane_uuid, **kwargs):
        """
        Launches update the values.
        Launches update the values.yaml from the control plane with the given uuid This updates the content of values.yaml.merged in the CM database.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_values_yaml(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :param ApiUpdateControlPlaneValuesYamlArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_values_yaml_with_http_info(control_plane_uuid, **kwargs)
        else:
            (data) = self.update_values_yaml_with_http_info(control_plane_uuid, **kwargs)
            return data

    def update_values_yaml_with_http_info(self, control_plane_uuid, **kwargs):
        """
        Launches update the values.
        Launches update the values.yaml from the control plane with the given uuid This updates the content of values.yaml.merged in the CM database.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_values_yaml_with_http_info(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :param ApiUpdateControlPlaneValuesYamlArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['control_plane_uuid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_values_yaml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'control_plane_uuid' is set
        if ('control_plane_uuid' not in params) or (params['control_plane_uuid'] is None):
            raise ValueError("Missing the required parameter `control_plane_uuid` when calling `update_values_yaml`")


        collection_formats = {}

        path_params = {}
        if 'control_plane_uuid' in params:
            path_params['controlPlaneUuid'] = params['control_plane_uuid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/{controlPlaneUuid}/commands/updateControlPlaneValuesYaml', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def upgrade_control_plane(self, control_plane_uuid, **kwargs):
        """
        Launches the Upgrade Command on the control plane with the given uuid.
        Launches the Upgrade Command on the control plane with the given uuid
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_control_plane(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :param ApiUpgradeControlPlaneArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.upgrade_control_plane_with_http_info(control_plane_uuid, **kwargs)
        else:
            (data) = self.upgrade_control_plane_with_http_info(control_plane_uuid, **kwargs)
            return data

    def upgrade_control_plane_with_http_info(self, control_plane_uuid, **kwargs):
        """
        Launches the Upgrade Command on the control plane with the given uuid.
        Launches the Upgrade Command on the control plane with the given uuid
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_control_plane_with_http_info(control_plane_uuid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str control_plane_uuid: The universally unique id of the control plane (required)
        :param ApiUpgradeControlPlaneArgs body: Arguments for the Command
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['control_plane_uuid', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upgrade_control_plane" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'control_plane_uuid' is set
        if ('control_plane_uuid' not in params) or (params['control_plane_uuid'] is None):
            raise ValueError("Missing the required parameter `control_plane_uuid` when calling `upgrade_control_plane`")


        collection_formats = {}

        path_params = {}
        if 'control_plane_uuid' in params:
            path_params['controlPlaneUuid'] = params['control_plane_uuid']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/{controlPlaneUuid}/commands/upgradeControlPlane', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def upgrade_embedded_control_plane(self, **kwargs):
        """
        Upgrade an experience cluster, including upgrading the control plane running on embedded kubernetes.
        Upgrade an experience cluster, including upgrading the control plane running on embedded kubernetes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_embedded_control_plane(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiUpgradeEmbeddedControlPlaneArgs body: The arguments for Ek8s control plane upgrade
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.upgrade_embedded_control_plane_with_http_info(**kwargs)
        else:
            (data) = self.upgrade_embedded_control_plane_with_http_info(**kwargs)
            return data

    def upgrade_embedded_control_plane_with_http_info(self, **kwargs):
        """
        Upgrade an experience cluster, including upgrading the control plane running on embedded kubernetes.
        Upgrade an experience cluster, including upgrading the control plane running on embedded kubernetes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_embedded_control_plane_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiUpgradeEmbeddedControlPlaneArgs body: The arguments for Ek8s control plane upgrade
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upgrade_embedded_control_plane" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/controlPlanes/commands/upgradeEmbeddedControlPlane', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
