# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.5.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AuthServiceRolesResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_roles(self, **kwargs):
        """
        Create new roles in the Authentication Services.
        Create new roles in the Authentication Services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_roles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiRoleList body: Roles to create.
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_roles_with_http_info(**kwargs)
        else:
            (data) = self.create_roles_with_http_info(**kwargs)
            return data

    def create_roles_with_http_info(self, **kwargs):
        """
        Create new roles in the Authentication Services.
        Create new roles in the Authentication Services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_roles_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiRoleList body: Roles to create.
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_roles" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_role(self, role_name, **kwargs):
        """
        Delete a role from the Authentication Services.
        Delete a role from the Authentication Services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_role(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_role_with_http_info(role_name, **kwargs)
        else:
            (data) = self.delete_role_with_http_info(role_name, **kwargs)
            return data

    def delete_role_with_http_info(self, role_name, **kwargs):
        """
        Delete a role from the Authentication Services.
        Delete a role from the Authentication Services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_role_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `delete_role`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRole',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enter_maintenance_mode(self, role_name, **kwargs):
        """
        Put the Authentication Service role into maintenance mode.
        Put the Authentication Service role into maintenance mode.This is a synchronous command. The result is known immediately upon return.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enter_maintenance_mode_with_http_info(role_name, **kwargs)
        else:
            (data) = self.enter_maintenance_mode_with_http_info(role_name, **kwargs)
            return data

    def enter_maintenance_mode_with_http_info(self, role_name, **kwargs):
        """
        Put the Authentication Service role into maintenance mode.
        Put the Authentication Service role into maintenance mode.This is a synchronous command. The result is known immediately upon return.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enter_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `enter_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/commands/enterMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def exit_maintenance_mode(self, role_name, **kwargs):
        """
        Take the Authentication Service role out of maintenance mode.
        Take the Authentication Service role out of maintenance mode. This is a synchronous command. The result is known immediately upon return.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.exit_maintenance_mode_with_http_info(role_name, **kwargs)
        else:
            (data) = self.exit_maintenance_mode_with_http_info(role_name, **kwargs)
            return data

    def exit_maintenance_mode_with_http_info(self, role_name, **kwargs):
        """
        Take the Authentication Service role out of maintenance mode.
        Take the Authentication Service role out of maintenance mode. This is a synchronous command. The result is known immediately upon return.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exit_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `exit_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/commands/exitMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_full_log(self, role_name, **kwargs):
        """
        Retrieves the log file for the role's main process.
        Retrieves the log file for the role's main process. <p> If the role is not started, this will be the log file associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_full_log(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch logs from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_full_log_with_http_info(role_name, **kwargs)
        else:
            (data) = self.get_full_log_with_http_info(role_name, **kwargs)
            return data

    def get_full_log_with_http_info(self, role_name, **kwargs):
        """
        Retrieves the log file for the role's main process.
        Retrieves the log file for the role's main process. <p> If the role is not started, this will be the log file associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_full_log_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch logs from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_full_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_full_log`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/logs/full', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_stacks_log(self, role_name, **kwargs):
        """
        Retrieves the stacks log file, if any, for the role's main process.
        Retrieves the stacks log file, if any, for the role's main process. Note that not all roles support periodic stacks collection.  The log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_log(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch stacks logs from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_stacks_log_with_http_info(role_name, **kwargs)
        else:
            (data) = self.get_stacks_log_with_http_info(role_name, **kwargs)
            return data

    def get_stacks_log_with_http_info(self, role_name, **kwargs):
        """
        Retrieves the stacks log file, if any, for the role's main process.
        Retrieves the stacks log file, if any, for the role's main process. Note that not all roles support periodic stacks collection.  The log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_log_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch stacks logs from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stacks_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_stacks_log`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/logs/stacks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_stacks_logs_bundle(self, role_name, **kwargs):
        """
        Download a zip-compressed archive of role stacks logs.
        Download a zip-compressed archive of role stacks logs. Note that not all roles support periodic stacks collection.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_logs_bundle(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch the stacks logs bundle from. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_stacks_logs_bundle_with_http_info(role_name, **kwargs)
        else:
            (data) = self.get_stacks_logs_bundle_with_http_info(role_name, **kwargs)
            return data

    def get_stacks_logs_bundle_with_http_info(self, role_name, **kwargs):
        """
        Download a zip-compressed archive of role stacks logs.
        Download a zip-compressed archive of role stacks logs. Note that not all roles support periodic stacks collection.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stacks_logs_bundle_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch the stacks logs bundle from. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stacks_logs_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_stacks_logs_bundle`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/logs/stacksBundle', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_standard_error(self, role_name, **kwargs):
        """
        Retrieves the role's standard error output.
        Retrieves the role's standard error output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_error(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch stderr from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_standard_error_with_http_info(role_name, **kwargs)
        else:
            (data) = self.get_standard_error_with_http_info(role_name, **kwargs)
            return data

    def get_standard_error_with_http_info(self, role_name, **kwargs):
        """
        Retrieves the role's standard error output.
        Retrieves the role's standard error output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_error_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch stderr from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standard_error" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_standard_error`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/logs/stderr', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_standard_output(self, role_name, **kwargs):
        """
        Retrieves the role's standard output.
        Retrieves the role's standard output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_output(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch stdout from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_standard_output_with_http_info(role_name, **kwargs)
        else:
            (data) = self.get_standard_output_with_http_info(role_name, **kwargs)
            return data

    def get_standard_output_with_http_info(self, role_name, **kwargs):
        """
        Retrieves the role's standard output.
        Retrieves the role's standard output. <p> If the role is not started, this will be the output associated with the last time the role was run. <p> Log files are returned as plain text (type \"text/plain\").
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_standard_output_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to fetch stdout from. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_standard_output" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `get_standard_output`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/logs/stdout', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_active_commands(self, role_name, **kwargs):
        """
        List active role commands.
        List active role commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_active_commands_with_http_info(role_name, **kwargs)
        else:
            (data) = self.list_active_commands_with_http_info(role_name, **kwargs)
            return data

    def list_active_commands_with_http_info(self, role_name, **kwargs):
        """
        List active role commands.
        List active role commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_commands" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `list_active_commands`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/commands', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommandList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_role(self, role_name, **kwargs):
        """
        Retrieve detailed information about a Authentication Services role.
        Retrieve detailed information about a Authentication Services role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_role_with_http_info(role_name, **kwargs)
        else:
            (data) = self.read_role_with_http_info(role_name, **kwargs)
            return data

    def read_role_with_http_info(self, role_name, **kwargs):
        """
        Retrieve detailed information about a Authentication Services role.
        Retrieve detailed information about a Authentication Services role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role name. (required)
        :return: ApiRole
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `read_role`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRole',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_role_config(self, role_name, **kwargs):
        """
        Retrieve the configuration of a specific Authentication Services role.
        Retrieve the configuration of a specific Authentication Services role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to look up. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_role_config_with_http_info(role_name, **kwargs)
        else:
            (data) = self.read_role_config_with_http_info(role_name, **kwargs)
            return data

    def read_role_config_with_http_info(self, role_name, **kwargs):
        """
        Retrieve the configuration of a specific Authentication Services role.
        Retrieve the configuration of a specific Authentication Services role.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_role_config_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to look up. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_role_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `read_role_config`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/config', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_roles(self, **kwargs):
        """
        List all roles of the Authentication Services.
        List all roles of the Authentication Services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_roles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_roles_with_http_info(**kwargs)
        else:
            (data) = self.read_roles_with_http_info(**kwargs)
            return data

    def read_roles_with_http_info(self, **kwargs):
        """
        List all roles of the Authentication Services.
        List all roles of the Authentication Services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_roles_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiRoleList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_roles" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_role_config(self, role_name, **kwargs):
        """
        Update the configuration of a Authentication Services role.
        Update the configuration of a Authentication Services role. <p> If a value is set in the given configuration, it will be added to the role's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_role_config(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to modify. (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Configuration changes.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_role_config_with_http_info(role_name, **kwargs)
        else:
            (data) = self.update_role_config_with_http_info(role_name, **kwargs)
            return data

    def update_role_config_with_http_info(self, role_name, **kwargs):
        """
        Update the configuration of a Authentication Services role.
        Update the configuration of a Authentication Services role. <p> If a value is set in the given configuration, it will be added to the role's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_role_config_with_http_info(role_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str role_name: The role to modify. (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Configuration changes.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_name', 'message', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_name' is set
        if ('role_name' not in params) or (params['role_name'] is None):
            raise ValueError("Missing the required parameter `role_name` when calling `update_role_config`")


        collection_formats = {}

        path_params = {}
        if 'role_name' in params:
            path_params['roleName'] = params['role_name']

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/authService/roles/{roleName}/config', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
