# cm-client
<h1>Cloudera Manager API v45</h1>       <p>Introduced in Cloudera Manager 7.5.4</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 7.5.4
- Package version: 45.0.4
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cm_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cm_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import cm_client
from cm_client.rest import ApiException
from pprint import pprint

# Configure HTTP basic authorization: basic
cm_client.configuration.username = 'YOUR_USERNAME'
cm_client.configuration.password = 'YOUR_PASSWORD'
# create an instance of the API class
api_instance = cm_client.ActivitiesResourceApi()
activity_id = 'activity_id_example' # str | The name of the activity.
cluster_name = 'cluster_name_example' # str | The name of the cluster.
service_name = 'service_name_example' # str | The name of the service.
_from = '_from_example' # str | Start of the period to query. (optional)
metrics = ['metrics_example'] # list[str] | Filter for which metrics to query. (optional)
to = 'now' # str | End of the period to query. (optional) (default to now)
view = 'summary' # str | The view of the data to materialize, either \"summary\" or \"full\". (optional) (default to summary)

try:
    # Fetch metric readings for a particular activity.
    api_response = api_instance.get_metrics(activity_id, cluster_name, service_name, _from=_from, metrics=metrics, to=to, view=view)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ActivitiesResourceApi->get_metrics: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/api/v45*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesResourceApi* | [**get_metrics**](docs/ActivitiesResourceApi.md#get_metrics) | **GET** /clusters/{clusterName}/services/{serviceName}/activities/{activityId}/metrics | Fetch metric readings for a particular activity.
*ActivitiesResourceApi* | [**read_activities**](docs/ActivitiesResourceApi.md#read_activities) | **GET** /clusters/{clusterName}/services/{serviceName}/activities | Read all activities in the system.
*ActivitiesResourceApi* | [**read_activity**](docs/ActivitiesResourceApi.md#read_activity) | **GET** /clusters/{clusterName}/services/{serviceName}/activities/{activityId} | Returns a specific activity in the system.
*ActivitiesResourceApi* | [**read_child_activities**](docs/ActivitiesResourceApi.md#read_child_activities) | **GET** /clusters/{clusterName}/services/{serviceName}/activities/{activityId}/children | Returns the child activities.
*ActivitiesResourceApi* | [**read_similar_activities**](docs/ActivitiesResourceApi.md#read_similar_activities) | **GET** /clusters/{clusterName}/services/{serviceName}/activities/{activityId}/similar | Returns a list of similar activities.
*AllHostsResourceApi* | [**read_config**](docs/AllHostsResourceApi.md#read_config) | **GET** /cm/allHosts/config | Retrieve the default configuration for all hosts.
*AllHostsResourceApi* | [**update_config**](docs/AllHostsResourceApi.md#update_config) | **PUT** /cm/allHosts/config | Update the default configuration values for all hosts.
*AuditsResourceApi* | [**read_audits**](docs/AuditsResourceApi.md#read_audits) | **GET** /audits | Fetch audit events from Cloudera Manager (CM) and CM managed services like HDFS, HBase, Impala, Hive, and Sentry.
*AuditsResourceApi* | [**stream_audits**](docs/AuditsResourceApi.md#stream_audits) | **GET** /audits/stream | 
*AuthRoleMetadatasResourceApi* | [**read_auth_roles_metadata**](docs/AuthRoleMetadatasResourceApi.md#read_auth_roles_metadata) | **GET** /authRoleMetadatas | Returns a list of the auth roles&#39; metadata for the built-in roles.
*AuthRolesResourceApi* | [**create_auth_roles**](docs/AuthRolesResourceApi.md#create_auth_roles) | **POST** /authRoles | Creates a list of auth roles.
*AuthRolesResourceApi* | [**delete_auth_role**](docs/AuthRolesResourceApi.md#delete_auth_role) | **DELETE** /authRoles/{uuid} | Deletes an auth role from the system.
*AuthRolesResourceApi* | [**read_auth_role**](docs/AuthRolesResourceApi.md#read_auth_role) | **GET** /authRoles/{uuid} | Returns detailed information about an auth role.
*AuthRolesResourceApi* | [**read_auth_roles**](docs/AuthRolesResourceApi.md#read_auth_roles) | **GET** /authRoles | Returns a list of the auth roles configured in the system.
*AuthRolesResourceApi* | [**read_auth_roles_metadata**](docs/AuthRolesResourceApi.md#read_auth_roles_metadata) | **GET** /authRoles/metadata | Returns a list of the auth roles&#39; metadata for the built-in roles.
*AuthRolesResourceApi* | [**update_auth_role**](docs/AuthRolesResourceApi.md#update_auth_role) | **PUT** /authRoles/{uuid} | Updates the given auth role&#39;s information.
*AuthServiceResourceApi* | [**auto_assign_roles**](docs/AuthServiceResourceApi.md#auto_assign_roles) | **PUT** /cm/authService/autoAssignRoles | Automatically assign roles to hosts and create the roles for the Authentication Service.
*AuthServiceResourceApi* | [**auto_configure**](docs/AuthServiceResourceApi.md#auto_configure) | **PUT** /cm/authService/autoConfigure | Automatically configures roles of the Authentication Service.
*AuthServiceResourceApi* | [**delete**](docs/AuthServiceResourceApi.md#delete) | **DELETE** /cm/authService | Delete the Authentication Service.
*AuthServiceResourceApi* | [**enter_maintenance_mode**](docs/AuthServiceResourceApi.md#enter_maintenance_mode) | **POST** /cm/authService/commands/enterMaintenanceMode | Put the Authentication Service into maintenance mode.
*AuthServiceResourceApi* | [**exit_maintenance_mode**](docs/AuthServiceResourceApi.md#exit_maintenance_mode) | **POST** /cm/authService/commands/exitMaintenanceMode | Take the Authentication Service out of maintenance mode.
*AuthServiceResourceApi* | [**list_active_commands**](docs/AuthServiceResourceApi.md#list_active_commands) | **GET** /cm/authService/commands | List active Authentication Service commands.
*AuthServiceResourceApi* | [**list_role_types**](docs/AuthServiceResourceApi.md#list_role_types) | **GET** /cm/authService/roleTypes | List the supported role types for the Authentication Service.
*AuthServiceResourceApi* | [**read_service**](docs/AuthServiceResourceApi.md#read_service) | **GET** /cm/authService | Retrieve information about the Authentication Services.
*AuthServiceResourceApi* | [**read_service_config**](docs/AuthServiceResourceApi.md#read_service_config) | **GET** /cm/authService/config | 
*AuthServiceResourceApi* | [**restart_command**](docs/AuthServiceResourceApi.md#restart_command) | **POST** /cm/authService/commands/restart | Restart the Authentication Service.
*AuthServiceResourceApi* | [**setup**](docs/AuthServiceResourceApi.md#setup) | **PUT** /cm/authService | Setup the Authentication Service.
*AuthServiceResourceApi* | [**start_command**](docs/AuthServiceResourceApi.md#start_command) | **POST** /cm/authService/commands/start | Start the Authentication Service.
*AuthServiceResourceApi* | [**stop_command**](docs/AuthServiceResourceApi.md#stop_command) | **POST** /cm/authService/commands/stop | Stop the Authentication Service.
*AuthServiceResourceApi* | [**update_service_config**](docs/AuthServiceResourceApi.md#update_service_config) | **PUT** /cm/authService/config | 
*AuthServiceRoleCommandsResourceApi* | [**restart_command**](docs/AuthServiceRoleCommandsResourceApi.md#restart_command) | **POST** /cm/authService/roleCommands/restart | Restart a set of Authentication Service roles.
*AuthServiceRoleCommandsResourceApi* | [**start_command**](docs/AuthServiceRoleCommandsResourceApi.md#start_command) | **POST** /cm/authService/roleCommands/start | Start a set of Authentication Service roles.
*AuthServiceRoleCommandsResourceApi* | [**stop_command**](docs/AuthServiceRoleCommandsResourceApi.md#stop_command) | **POST** /cm/authService/roleCommands/stop | Stop a set of Authentication Service roles.
*AuthServiceRoleConfigGroupsResourceApi* | [**read_config**](docs/AuthServiceRoleConfigGroupsResourceApi.md#read_config) | **GET** /cm/authService/roleConfigGroups/{roleConfigGroupName}/config | Returns the current revision of the config for the specified role config group in the Authentication Service.
*AuthServiceRoleConfigGroupsResourceApi* | [**read_role_config_group**](docs/AuthServiceRoleConfigGroupsResourceApi.md#read_role_config_group) | **GET** /cm/authService/roleConfigGroups/{roleConfigGroupName} | Returns the information for a given role config group in the Authentication Service.
*AuthServiceRoleConfigGroupsResourceApi* | [**read_role_config_groups**](docs/AuthServiceRoleConfigGroupsResourceApi.md#read_role_config_groups) | **GET** /cm/authService/roleConfigGroups | Returns the information for all role config groups in the Authentication Service.
*AuthServiceRoleConfigGroupsResourceApi* | [**read_roles**](docs/AuthServiceRoleConfigGroupsResourceApi.md#read_roles) | **GET** /cm/authService/roleConfigGroups/{roleConfigGroupName}/roles | Returns all roles in the given role config group in the Authentication Service.
*AuthServiceRoleConfigGroupsResourceApi* | [**update_config**](docs/AuthServiceRoleConfigGroupsResourceApi.md#update_config) | **PUT** /cm/authService/roleConfigGroups/{roleConfigGroupName}/config | Updates the config for the given role config group in the Authentication Service.
*AuthServiceRoleConfigGroupsResourceApi* | [**update_role_config_group**](docs/AuthServiceRoleConfigGroupsResourceApi.md#update_role_config_group) | **PUT** /cm/authService/roleConfigGroups/{roleConfigGroupName} | Updates an existing role config group in the Authentication Service.
*AuthServiceRolesResourceApi* | [**create_roles**](docs/AuthServiceRolesResourceApi.md#create_roles) | **POST** /cm/authService/roles | Create new roles in the Authentication Services.
*AuthServiceRolesResourceApi* | [**delete_role**](docs/AuthServiceRolesResourceApi.md#delete_role) | **DELETE** /cm/authService/roles/{roleName} | Delete a role from the Authentication Services.
*AuthServiceRolesResourceApi* | [**enter_maintenance_mode**](docs/AuthServiceRolesResourceApi.md#enter_maintenance_mode) | **POST** /cm/authService/roles/{roleName}/commands/enterMaintenanceMode | Put the Authentication Service role into maintenance mode.
*AuthServiceRolesResourceApi* | [**exit_maintenance_mode**](docs/AuthServiceRolesResourceApi.md#exit_maintenance_mode) | **POST** /cm/authService/roles/{roleName}/commands/exitMaintenanceMode | Take the Authentication Service role out of maintenance mode.
*AuthServiceRolesResourceApi* | [**get_full_log**](docs/AuthServiceRolesResourceApi.md#get_full_log) | **GET** /cm/authService/roles/{roleName}/logs/full | Retrieves the log file for the role&#39;s main process.
*AuthServiceRolesResourceApi* | [**get_stacks_log**](docs/AuthServiceRolesResourceApi.md#get_stacks_log) | **GET** /cm/authService/roles/{roleName}/logs/stacks | Retrieves the stacks log file, if any, for the role&#39;s main process.
*AuthServiceRolesResourceApi* | [**get_stacks_logs_bundle**](docs/AuthServiceRolesResourceApi.md#get_stacks_logs_bundle) | **GET** /cm/authService/roles/{roleName}/logs/stacksBundle | Download a zip-compressed archive of role stacks logs.
*AuthServiceRolesResourceApi* | [**get_standard_error**](docs/AuthServiceRolesResourceApi.md#get_standard_error) | **GET** /cm/authService/roles/{roleName}/logs/stderr | Retrieves the role&#39;s standard error output.
*AuthServiceRolesResourceApi* | [**get_standard_output**](docs/AuthServiceRolesResourceApi.md#get_standard_output) | **GET** /cm/authService/roles/{roleName}/logs/stdout | Retrieves the role&#39;s standard output.
*AuthServiceRolesResourceApi* | [**list_active_commands**](docs/AuthServiceRolesResourceApi.md#list_active_commands) | **GET** /cm/authService/roles/{roleName}/commands | List active role commands.
*AuthServiceRolesResourceApi* | [**read_role**](docs/AuthServiceRolesResourceApi.md#read_role) | **GET** /cm/authService/roles/{roleName} | Retrieve detailed information about a Authentication Services role.
*AuthServiceRolesResourceApi* | [**read_role_config**](docs/AuthServiceRolesResourceApi.md#read_role_config) | **GET** /cm/authService/roles/{roleName}/config | Retrieve the configuration of a specific Authentication Services role.
*AuthServiceRolesResourceApi* | [**read_roles**](docs/AuthServiceRolesResourceApi.md#read_roles) | **GET** /cm/authService/roles | List all roles of the Authentication Services.
*AuthServiceRolesResourceApi* | [**update_role_config**](docs/AuthServiceRolesResourceApi.md#update_role_config) | **PUT** /cm/authService/roles/{roleName}/config | Update the configuration of a Authentication Services role.
*BatchResourceApi* | [**execute**](docs/BatchResourceApi.md#execute) | **POST** /batch | Executes a batch of API requests in one database transaction.
*CdpResourceApi* | [**create_environment_command**](docs/CdpResourceApi.md#create_environment_command) | **POST** /cdp/createEnvironment | Create an environment in ECS.
*CdpResourceApi* | [**get_remote_context**](docs/CdpResourceApi.md#get_remote_context) | **GET** /cdp/remoteContext/byContext/{dataContextName} | Get a JSON for creating a remote data context in a Workload cluster.
*CdpResourceApi* | [**get_remote_context_by_cluster**](docs/CdpResourceApi.md#get_remote_context_by_cluster) | **GET** /cdp/remoteContext/byCluster/{clusterName} | Get a JSON for creating a remote data context in a Workload cluster.
*CdpResourceApi* | [**post_remote_context**](docs/CdpResourceApi.md#post_remote_context) | **POST** /cdp/remoteContext | Create or update the remote data context in the Workload cluster.
*CertManagerResourceApi* | [**generate_certificate**](docs/CertManagerResourceApi.md#generate_certificate) | **POST** /certs/generateCertificate | Exchange a cert request token for a certificate.
*CertManagerResourceApi* | [**get_truststore**](docs/CertManagerResourceApi.md#get_truststore) | **GET** /certs/truststore | Gets the Auto-TLS truststore contents.
*CertManagerResourceApi* | [**get_truststore_password**](docs/CertManagerResourceApi.md#get_truststore_password) | **GET** /certs/truststorePassword | Gets the configured CM truststore password.
*ClouderaManagerResourceApi* | [**add_custom_certs**](docs/ClouderaManagerResourceApi.md#add_custom_certs) | **POST** /cm/commands/addCustomCerts | Add custom certificates to the Auto-TLS certificate database.
*ClouderaManagerResourceApi* | [**begin_trial**](docs/ClouderaManagerResourceApi.md#begin_trial) | **POST** /cm/trial/begin | Begin trial license.
*ClouderaManagerResourceApi* | [**clusters_perf_inspector_command**](docs/ClouderaManagerResourceApi.md#clusters_perf_inspector_command) | **POST** /cm/commands/clustersPerfInspector | Run performance diagnostics test against specified clusters in ApiClustersPerfInspectorArgs  User must be Full Administrator or Global Cluster Administrator.
*ClouderaManagerResourceApi* | [**collect_diagnostic_data_command**](docs/ClouderaManagerResourceApi.md#collect_diagnostic_data_command) | **POST** /cm/commands/collectDiagnosticData | Collect diagnostic data from hosts managed by Cloudera Manager.
*ClouderaManagerResourceApi* | [**delete_credentials_command**](docs/ClouderaManagerResourceApi.md#delete_credentials_command) | **POST** /cm/commands/deleteCredentials | Delete existing Kerberos credentials.
*ClouderaManagerResourceApi* | [**end_trial**](docs/ClouderaManagerResourceApi.md#end_trial) | **POST** /cm/trial/end | End trial license.
*ClouderaManagerResourceApi* | [**generate_cmca**](docs/ClouderaManagerResourceApi.md#generate_cmca) | **POST** /cm/commands/generateCmca | Generate a CMCA.
*ClouderaManagerResourceApi* | [**generate_credentials_adhoc**](docs/ClouderaManagerResourceApi.md#generate_credentials_adhoc) | **POST** /cm/commands/generateCredentialsAdhoc | Generate missing Kerberos credentials, optionally accepting a list of ad-hoc credentials to generate as well.
*ClouderaManagerResourceApi* | [**generate_credentials_command**](docs/ClouderaManagerResourceApi.md#generate_credentials_command) | **POST** /cm/commands/generateCredentials | Generate missing Kerberos credentials.
*ClouderaManagerResourceApi* | [**get_config**](docs/ClouderaManagerResourceApi.md#get_config) | **GET** /cm/config | Retrieve the Cloudera Manager settings.
*ClouderaManagerResourceApi* | [**get_deployment2**](docs/ClouderaManagerResourceApi.md#get_deployment2) | **GET** /cm/deployment | Retrieve full description of the entire Cloudera Manager deployment including all hosts, clusters, services, roles, users, settings, etc.
*ClouderaManagerResourceApi* | [**get_kerberos_info**](docs/ClouderaManagerResourceApi.md#get_kerberos_info) | **GET** /cm/kerberosInfo | Provides Cloudera Manager Kerberos information.
*ClouderaManagerResourceApi* | [**get_kerberos_principals**](docs/ClouderaManagerResourceApi.md#get_kerberos_principals) | **GET** /cm/kerberosPrincipals | Returns the Kerberos principals needed by the services being managed by Cloudera Manager.
*ClouderaManagerResourceApi* | [**get_krb5_conf**](docs/ClouderaManagerResourceApi.md#get_krb5_conf) | **GET** /cm/krb5conf | Retrieves krb5.
*ClouderaManagerResourceApi* | [**get_licensed_feature_usage**](docs/ClouderaManagerResourceApi.md#get_licensed_feature_usage) | **GET** /cm/licensedFeatureUsage | Retrieve a summary of licensed feature usage.
*ClouderaManagerResourceApi* | [**get_log**](docs/ClouderaManagerResourceApi.md#get_log) | **GET** /cm/log | Returns the entire contents of the Cloudera Manager log file.
*ClouderaManagerResourceApi* | [**get_scm_db_info**](docs/ClouderaManagerResourceApi.md#get_scm_db_info) | **GET** /cm/scmDbInfo | Provides Cloudera Manager server&#39;s database information.
*ClouderaManagerResourceApi* | [**get_shutdown_readiness**](docs/ClouderaManagerResourceApi.md#get_shutdown_readiness) | **GET** /cm/shutdownReadiness | Retrieve Cloudera Manager&#39;s readiness for shutdown and destroy.
*ClouderaManagerResourceApi* | [**get_version**](docs/ClouderaManagerResourceApi.md#get_version) | **GET** /cm/version | Provides version information of Cloudera Manager itself.
*ClouderaManagerResourceApi* | [**host_install_command**](docs/ClouderaManagerResourceApi.md#host_install_command) | **POST** /cm/commands/hostInstall | Perform installation on a set of hosts.
*ClouderaManagerResourceApi* | [**hosts_decommission_command**](docs/ClouderaManagerResourceApi.md#hosts_decommission_command) | **POST** /cm/commands/hostsDecommission | Decommission the given hosts.
*ClouderaManagerResourceApi* | [**hosts_offline_or_decommission_command**](docs/ClouderaManagerResourceApi.md#hosts_offline_or_decommission_command) | **POST** /cm/commands/hostsOfflineOrDecommission | Decommission the given hosts.
*ClouderaManagerResourceApi* | [**hosts_perf_inspector_command**](docs/ClouderaManagerResourceApi.md#hosts_perf_inspector_command) | **POST** /cm/commands/hostsPerfInspector | Run performance diagnostics test against specified hosts in ApiHostsPerfInspectorArgs  User must be Full Administrator or Global Cluster Administrator.
*ClouderaManagerResourceApi* | [**hosts_recommission_and_exit_maintenance_mode_command**](docs/ClouderaManagerResourceApi.md#hosts_recommission_and_exit_maintenance_mode_command) | **POST** /cm/commands/hostsRecommissionAndExitMaintenanceMode | Recommission and exit maintenance on the given hosts.
*ClouderaManagerResourceApi* | [**hosts_recommission_command**](docs/ClouderaManagerResourceApi.md#hosts_recommission_command) | **POST** /cm/commands/hostsRecommission | Recommission the given hosts.
*ClouderaManagerResourceApi* | [**hosts_recommission_with_start_command**](docs/ClouderaManagerResourceApi.md#hosts_recommission_with_start_command) | **POST** /cm/commands/hostsRecommissionWithStart | Recommission the given hosts.
*ClouderaManagerResourceApi* | [**hosts_start_roles_command**](docs/ClouderaManagerResourceApi.md#hosts_start_roles_command) | **POST** /cm/commands/hostsStartRoles | Start all the roles on the given hosts.
*ClouderaManagerResourceApi* | [**import_admin_credentials**](docs/ClouderaManagerResourceApi.md#import_admin_credentials) | **POST** /cm/commands/importAdminCredentials | Imports the KDC Account Manager credentials needed by Cloudera Manager to create kerberos principals needed by CDH services.
*ClouderaManagerResourceApi* | [**import_cluster_template**](docs/ClouderaManagerResourceApi.md#import_cluster_template) | **POST** /cm/importClusterTemplate | Create cluster as per the given cluster template.
*ClouderaManagerResourceApi* | [**import_kerberos_principal**](docs/ClouderaManagerResourceApi.md#import_kerberos_principal) | **POST** /cm/commands/importKerberosPrincipal | Imports the Kerberos credentials for the specified principal which can then be used to add to a role&#39;s keytab by running Generate Credentials command.
*ClouderaManagerResourceApi* | [**inspect_hosts_command**](docs/ClouderaManagerResourceApi.md#inspect_hosts_command) | **POST** /cm/commands/inspectHosts | Runs the host inspector on the configured hosts.
*ClouderaManagerResourceApi* | [**list_active_commands**](docs/ClouderaManagerResourceApi.md#list_active_commands) | **GET** /cm/commands | List active global commands.
*ClouderaManagerResourceApi* | [**migrate_cmca_to_db**](docs/ClouderaManagerResourceApi.md#migrate_cmca_to_db) | **POST** /cm/commands/migrateCmcaToDb | Migrate CMCA to the DB.
*ClouderaManagerResourceApi* | [**read_instance**](docs/ClouderaManagerResourceApi.md#read_instance) | **GET** /cm/instances/{cmServerId} | Retrieves the CM server information.
*ClouderaManagerResourceApi* | [**read_instances**](docs/ClouderaManagerResourceApi.md#read_instances) | **GET** /cm/instances | Retrieves all CM server information.
*ClouderaManagerResourceApi* | [**read_license**](docs/ClouderaManagerResourceApi.md#read_license) | **GET** /cm/license | Retrieve information about the Cloudera Manager license.
*ClouderaManagerResourceApi* | [**refresh_parcel_repos**](docs/ClouderaManagerResourceApi.md#refresh_parcel_repos) | **POST** /cm/commands/refreshParcelRepos | .
*ClouderaManagerResourceApi* | [**retrieve_keytab**](docs/ClouderaManagerResourceApi.md#retrieve_keytab) | **POST** /cm/retrieveKeytab | Retrieves a keytab for a list of principals.
*ClouderaManagerResourceApi* | [**test_external_authentication**](docs/ClouderaManagerResourceApi.md#test_external_authentication) | **POST** /cm/commands/testExternalAuthentication | Launches a command to test the currently configured external authentication.
*ClouderaManagerResourceApi* | [**update_config**](docs/ClouderaManagerResourceApi.md#update_config) | **PUT** /cm/config | Update the Cloudera Manager settings.
*ClouderaManagerResourceApi* | [**update_deployment2**](docs/ClouderaManagerResourceApi.md#update_deployment2) | **PUT** /cm/deployment | Apply the supplied deployment description to the system.
*ClouderaManagerResourceApi* | [**update_license**](docs/ClouderaManagerResourceApi.md#update_license) | **POST** /cm/license | Updates the Cloudera Manager license.
*ClustersResourceApi* | [**add_hosts**](docs/ClustersResourceApi.md#add_hosts) | **POST** /clusters/{clusterName}/hosts | 
*ClustersResourceApi* | [**add_tags**](docs/ClustersResourceApi.md#add_tags) | **PUT** /clusters/{clusterName}/tags | Attach tags to the cluster.
*ClustersResourceApi* | [**auto_assign_roles**](docs/ClustersResourceApi.md#auto_assign_roles) | **PUT** /clusters/{clusterName}/autoAssignRoles | Automatically assign roles to hosts and create the roles for all the services in a cluster.
*ClustersResourceApi* | [**auto_configure**](docs/ClustersResourceApi.md#auto_configure) | **PUT** /clusters/{clusterName}/autoConfigure | Automatically configures roles and services in a cluster.
*ClustersResourceApi* | [**configure_auto_tls_services_command**](docs/ClustersResourceApi.md#configure_auto_tls_services_command) | **POST** /clusters/{clusterName}/commands/configureAutoTlsServices | Configures all services in a cluster to use Auto-TLS.
*ClustersResourceApi* | [**configure_for_kerberos**](docs/ClustersResourceApi.md#configure_for_kerberos) | **POST** /clusters/{clusterName}/commands/configureForKerberos | Command to configure the cluster to use Kerberos for authentication.
*ClustersResourceApi* | [**create_clusters**](docs/ClustersResourceApi.md#create_clusters) | **POST** /clusters | Creates a collection of clusters.
*ClustersResourceApi* | [**delete_cluster**](docs/ClustersResourceApi.md#delete_cluster) | **DELETE** /clusters/{clusterName} | Deletes a cluster.
*ClustersResourceApi* | [**delete_cluster_credentials_command**](docs/ClustersResourceApi.md#delete_cluster_credentials_command) | **POST** /clusters/{clusterName}/commands/deleteCredentials | Delete existing Kerberos credentials for the cluster.
*ClustersResourceApi* | [**delete_tags**](docs/ClustersResourceApi.md#delete_tags) | **DELETE** /clusters/{clusterName}/tags | Remove the tags associated with the cluster.
*ClustersResourceApi* | [**deploy_client_config**](docs/ClustersResourceApi.md#deploy_client_config) | **POST** /clusters/{clusterName}/commands/deployClientConfig | Deploy the cluster-wide client configuration.
*ClustersResourceApi* | [**deploy_client_configs_and_refresh**](docs/ClustersResourceApi.md#deploy_client_configs_and_refresh) | **POST** /clusters/{clusterName}/commands/deployClientConfigsAndRefresh | Performs a command with the 2 steps - deploy cc - cluster refresh  This orchestration is needed for the staleness wizard, so it can invoke a single command at wizard finish.
*ClustersResourceApi* | [**deploy_cluster_client_config**](docs/ClustersResourceApi.md#deploy_cluster_client_config) | **POST** /clusters/{clusterName}/commands/deployClusterClientConfig | Deploy the Cluster&#39;s Kerberos client configuration.
*ClustersResourceApi* | [**disable_tls**](docs/ClustersResourceApi.md#disable_tls) | **POST** /clusters/{clusterName}/commands/disableTls | Disables TLS settings on a cluster.
*ClustersResourceApi* | [**enter_maintenance_mode**](docs/ClustersResourceApi.md#enter_maintenance_mode) | **POST** /clusters/{clusterName}/commands/enterMaintenanceMode | Put the cluster into maintenance mode.
*ClustersResourceApi* | [**exit_maintenance_mode**](docs/ClustersResourceApi.md#exit_maintenance_mode) | **POST** /clusters/{clusterName}/commands/exitMaintenanceMode | Take the cluster out of maintenance mode.
*ClustersResourceApi* | [**expire_logs**](docs/ClustersResourceApi.md#expire_logs) | **POST** /clusters/{clusterName}/commands/expireLogs | Remove backup and disaster related log files in hdfs.
*ClustersResourceApi* | [**export**](docs/ClustersResourceApi.md#export) | **GET** /clusters/{clusterName}/export | Export the cluster template for the given cluster.
*ClustersResourceApi* | [**first_run**](docs/ClustersResourceApi.md#first_run) | **POST** /clusters/{clusterName}/commands/firstRun | Prepare and start services in a cluster.
*ClustersResourceApi* | [**get_client_config**](docs/ClustersResourceApi.md#get_client_config) | **GET** /clusters/{clusterName}/clientConfig | Download a zip-compressed archive of the client configuration, of a specific cluster.
*ClustersResourceApi* | [**get_kerberos_info**](docs/ClustersResourceApi.md#get_kerberos_info) | **GET** /clusters/{clusterName}/kerberosInfo | Provides Cluster Kerberos information.
*ClustersResourceApi* | [**get_ozone_s3_gateway_info**](docs/ClustersResourceApi.md#get_ozone_s3_gateway_info) | **POST** /clusters/{clusterName}/getOzoneS3GatewayInfo | Returns the REST url for the Ozone S3 Gateway, as well as the AWS credentials needed to access the S3 endpoint.
*ClustersResourceApi* | [**get_utilization_report**](docs/ClustersResourceApi.md#get_utilization_report) | **GET** /clusters/{clusterName}/utilization | Provides the resource utilization of the entire cluster as well as the resource utilization per tenant.
*ClustersResourceApi* | [**inspect_hosts_command**](docs/ClustersResourceApi.md#inspect_hosts_command) | **POST** /clusters/{clusterName}/commands/inspectHosts | Runs the host inspector on the configured hosts in the specified cluster.
*ClustersResourceApi* | [**is_tls_enabled**](docs/ClustersResourceApi.md#is_tls_enabled) | **GET** /clusters/{clusterName}/isTlsEnabled | Returns whether a cluster has any TLS settings enabled.
*ClustersResourceApi* | [**list_active_commands**](docs/ClustersResourceApi.md#list_active_commands) | **GET** /clusters/{clusterName}/commands | List active cluster commands.
*ClustersResourceApi* | [**list_dfs_services**](docs/ClustersResourceApi.md#list_dfs_services) | **GET** /clusters/{clusterName}/dfsServices | List the services that can provide distributed file system (DFS) capabilities in this cluster.
*ClustersResourceApi* | [**list_hosts**](docs/ClustersResourceApi.md#list_hosts) | **GET** /clusters/{clusterName}/hosts | Returns hosts in the system filtered by optional host configuration parameters, if specified.
*ClustersResourceApi* | [**list_service_types**](docs/ClustersResourceApi.md#list_service_types) | **GET** /clusters/{clusterName}/serviceTypes | List the supported service types for a cluster.
*ClustersResourceApi* | [**list_upgrade_domains**](docs/ClustersResourceApi.md#list_upgrade_domains) | **GET** /clusters/{clusterName}/upgradeDomains | Returns the Upgrade Domains associated with the cluster and the host names that belong to each Upgrade Domain.
*ClustersResourceApi* | [**perf_inspector_command**](docs/ClustersResourceApi.md#perf_inspector_command) | **POST** /clusters/{clusterName}/commands/perfInspector | Run cluster performance diagnostics test.
*ClustersResourceApi* | [**pools_refresh**](docs/ClustersResourceApi.md#pools_refresh) | **POST** /clusters/{clusterName}/commands/poolsRefresh | Updates all refreshable configuration files for services with Dynamic Resource Pools.
*ClustersResourceApi* | [**post_cloudera_runtime_upgrade**](docs/ClustersResourceApi.md#post_cloudera_runtime_upgrade) | **POST** /clusters/{clusterName}/commands/postClouderaRuntimeUpgrade | Post Cloudera Runtime upgrade API.
*ClustersResourceApi* | [**pre_upgrade_check_command**](docs/ClustersResourceApi.md#pre_upgrade_check_command) | **POST** /clusters/{clusterName}/commands/preUpgradeCheck | Run cluster pre-upgrade check(s) when upgrading from specified version of CDH to the other.
*ClustersResourceApi* | [**read_cluster**](docs/ClustersResourceApi.md#read_cluster) | **GET** /clusters/{clusterName} | Reads information about a cluster.
*ClustersResourceApi* | [**read_clusters**](docs/ClustersResourceApi.md#read_clusters) | **GET** /clusters | List all known clusters.
*ClustersResourceApi* | [**read_tags**](docs/ClustersResourceApi.md#read_tags) | **GET** /clusters/{clusterName}/tags | Returns the tags associated with this cluster.
*ClustersResourceApi* | [**refresh**](docs/ClustersResourceApi.md#refresh) | **POST** /clusters/{clusterName}/commands/refresh | Updates all refreshable configuration files in the cluster.
*ClustersResourceApi* | [**remove_all_hosts**](docs/ClustersResourceApi.md#remove_all_hosts) | **DELETE** /clusters/{clusterName}/hosts | 
*ClustersResourceApi* | [**remove_host**](docs/ClustersResourceApi.md#remove_host) | **DELETE** /clusters/{clusterName}/hosts/{hostId} | 
*ClustersResourceApi* | [**restart_command**](docs/ClustersResourceApi.md#restart_command) | **POST** /clusters/{clusterName}/commands/restart | Restart all services in the cluster.
*ClustersResourceApi* | [**rolling_restart**](docs/ClustersResourceApi.md#rolling_restart) | **POST** /clusters/{clusterName}/commands/rollingRestart | Command to do a \&quot;best-effort\&quot; rolling restart of the given cluster, i.
*ClustersResourceApi* | [**rolling_upgrade**](docs/ClustersResourceApi.md#rolling_upgrade) | **POST** /clusters/{clusterName}/commands/rollingUpgrade | Command to do a rolling upgrade of specific services in the given cluster  This command does not handle any services that don&#39;t support rolling upgrades.
*ClustersResourceApi* | [**start_command**](docs/ClustersResourceApi.md#start_command) | **POST** /clusters/{clusterName}/commands/start | Start all services in the cluster.
*ClustersResourceApi* | [**stop_command**](docs/ClustersResourceApi.md#stop_command) | **POST** /clusters/{clusterName}/commands/stop | Stop all services in the cluster.
*ClustersResourceApi* | [**tear_down_workload_cluster**](docs/ClustersResourceApi.md#tear_down_workload_cluster) | **POST** /clusters/{clusterName}/commands/tearDownWorkload/{workloadClusterName} | Tear Down Workload cluster.
*ClustersResourceApi* | [**update_cluster**](docs/ClustersResourceApi.md#update_cluster) | **PUT** /clusters/{clusterName} | Update an existing cluster.
*ClustersResourceApi* | [**upgrade_cdh_command**](docs/ClustersResourceApi.md#upgrade_cdh_command) | **POST** /clusters/{clusterName}/commands/upgradeCdh | Perform CDH upgrade to the specified version.
*ClustersResourceApi* | [**upgrade_services_command**](docs/ClustersResourceApi.md#upgrade_services_command) | **POST** /clusters/{clusterName}/commands/upgradeServices | Upgrades the services in the cluster to the CDH5 version.
*CmPeersResourceApi* | [**create_peer**](docs/CmPeersResourceApi.md#create_peer) | **POST** /cm/peers | Create a new Cloudera Manager peer.
*CmPeersResourceApi* | [**delete_peer**](docs/CmPeersResourceApi.md#delete_peer) | **DELETE** /cm/peers/{peerName} | Delete Cloudera Manager peer.
*CmPeersResourceApi* | [**list_peers**](docs/CmPeersResourceApi.md#list_peers) | **GET** /cm/peers | Retrieves all configured Cloudera Manager peers.
*CmPeersResourceApi* | [**read_peer**](docs/CmPeersResourceApi.md#read_peer) | **GET** /cm/peers/{peerName} | Fetch information about an existing Cloudera Manager peer.
*CmPeersResourceApi* | [**test_peer**](docs/CmPeersResourceApi.md#test_peer) | **POST** /cm/peers/{peerName}/commands/test | Test the connectivity of a peer.
*CmPeersResourceApi* | [**update_peer**](docs/CmPeersResourceApi.md#update_peer) | **PUT** /cm/peers/{peerName} | Update information for a Cloudera Manager peer.
*CommandsResourceApi* | [**abort_command**](docs/CommandsResourceApi.md#abort_command) | **POST** /commands/{commandId}/abort | Abort a running command.
*CommandsResourceApi* | [**get_standard_error**](docs/CommandsResourceApi.md#get_standard_error) | **GET** /commands/{commandId}/logs/stderr | Download a zip-compressed archive of standard error outputs for the command&#39;s one-off processes.
*CommandsResourceApi* | [**get_standard_output**](docs/CommandsResourceApi.md#get_standard_output) | **GET** /commands/{commandId}/logs/stdout | Download a zip-compressed archive of standard outputs for the command&#39;s one-off processes.
*CommandsResourceApi* | [**read_command**](docs/CommandsResourceApi.md#read_command) | **GET** /commands/{commandId} | Retrieve detailed information on an asynchronous command.
*CommandsResourceApi* | [**retry**](docs/CommandsResourceApi.md#retry) | **POST** /commands/{commandId}/retry | Try to rerun a command.
*ControlPlanesResourceApi* | [**generate_copy_docker**](docs/ControlPlanesResourceApi.md#generate_copy_docker) | **POST** /controlPlanes/commands/generateCopyDocker | Launches the Generate Copy Docker Script Command.
*ControlPlanesResourceApi* | [**generate_external_vault_setup**](docs/ControlPlanesResourceApi.md#generate_external_vault_setup) | **POST** /controlPlanes/commands/generateExternalVaultSetup | Launches the Generate Vault Setup Command command.
*ControlPlanesResourceApi* | [**get_control_planes**](docs/ControlPlanesResourceApi.md#get_control_planes) | **GET** /controlPlanes | Current Control Planes.
*ControlPlanesResourceApi* | [**get_experience_cluster**](docs/ControlPlanesResourceApi.md#get_experience_cluster) | **GET** /controlPlanes/{controlPlaneUuid}/getExperienceCluster | The Experience cluster this control plane is associated with, if any.
*ControlPlanesResourceApi* | [**get_log_content**](docs/ControlPlanesResourceApi.md#get_log_content) | **POST** /controlPlanes/fetchResources/{commandId}/logContent | Fetches the log content for the specific command.
*ControlPlanesResourceApi* | [**get_manifest_json**](docs/ControlPlanesResourceApi.md#get_manifest_json) | **POST** /controlPlanes/fetchResources/manifest.json | Fetches the manifest.
*ControlPlanesResourceApi* | [**install_control_plane**](docs/ControlPlanesResourceApi.md#install_control_plane) | **POST** /controlPlanes/commands/installControlPlane | Launches the install control plane command.
*ControlPlanesResourceApi* | [**install_embedded_control_plane**](docs/ControlPlanesResourceApi.md#install_embedded_control_plane) | **POST** /controlPlanes/commands/installEmbeddedControlPlane | Brings up a control plane on embedded kubernetes.
*ControlPlanesResourceApi* | [**read_control_plane_by_uuid**](docs/ControlPlanesResourceApi.md#read_control_plane_by_uuid) | **GET** /controlPlanes/{controlPlaneUuid} | The control plane with the given id.
*ControlPlanesResourceApi* | [**uninstall_control_plane**](docs/ControlPlanesResourceApi.md#uninstall_control_plane) | **POST** /controlPlanes/{controlPlaneUuid}/commands/uninstallControlPlane | Launches Uninstall Command on the control plane with the given uuid.
*ControlPlanesResourceApi* | [**update_values_yaml**](docs/ControlPlanesResourceApi.md#update_values_yaml) | **POST** /controlPlanes/{controlPlaneUuid}/commands/updateControlPlaneValuesYaml | Launches update the values.
*ControlPlanesResourceApi* | [**upgrade_control_plane**](docs/ControlPlanesResourceApi.md#upgrade_control_plane) | **POST** /controlPlanes/{controlPlaneUuid}/commands/upgradeControlPlane | Launches the Upgrade Command on the control plane with the given uuid.
*ControlPlanesResourceApi* | [**upgrade_embedded_control_plane**](docs/ControlPlanesResourceApi.md#upgrade_embedded_control_plane) | **POST** /controlPlanes/commands/upgradeEmbeddedControlPlane | Upgrade an experience cluster, including upgrading the control plane running on embedded kubernetes.
*CspResourceApi* | [**upload_csp_cert**](docs/CspResourceApi.md#upload_csp_cert) | **PUT** /csp/uploadCspCert | Upload CA certificates, client certificates and client key for Credential Storage Provider.
*DashboardsResourceApi* | [**create_dashboards**](docs/DashboardsResourceApi.md#create_dashboards) | **POST** /timeseries/dashboards | Creates the list of dashboards.
*DashboardsResourceApi* | [**delete_dashboard**](docs/DashboardsResourceApi.md#delete_dashboard) | **DELETE** /timeseries/dashboards/{dashboardName} | Deletes a dashboard.
*DashboardsResourceApi* | [**get_dashboard**](docs/DashboardsResourceApi.md#get_dashboard) | **GET** /timeseries/dashboards/{dashboardName} | Returns a dashboard definition for the specified name.
*DashboardsResourceApi* | [**get_dashboards**](docs/DashboardsResourceApi.md#get_dashboards) | **GET** /timeseries/dashboards | Returns the list of all user-customized dashboards.
*DataContextsResourceApi* | [**create_data_context**](docs/DataContextsResourceApi.md#create_data_context) | **POST** /dataContexts | Create a datacontext.
*DataContextsResourceApi* | [**delete_data_context**](docs/DataContextsResourceApi.md#delete_data_context) | **DELETE** /dataContexts/{dataContextName} | Delete a datacontext.
*DataContextsResourceApi* | [**read_data_context**](docs/DataContextsResourceApi.md#read_data_context) | **GET** /dataContexts/{dataContextName} | Reads information about a datacontext.
*DataContextsResourceApi* | [**read_data_contexts**](docs/DataContextsResourceApi.md#read_data_contexts) | **GET** /dataContexts | Get all the datacontexts.
*EventsResourceApi* | [**read_event**](docs/EventsResourceApi.md#read_event) | **GET** /events/{eventId} | Returns a specific event in the system.
*EventsResourceApi* | [**read_events**](docs/EventsResourceApi.md#read_events) | **GET** /events | Allows you to query events in the system.
*ExternalAccountsResourceApi* | [**create_account**](docs/ExternalAccountsResourceApi.md#create_account) | **POST** /externalAccounts/create | Create a new external account.
*ExternalAccountsResourceApi* | [**delete_account**](docs/ExternalAccountsResourceApi.md#delete_account) | **DELETE** /externalAccounts/delete/{name} | Delete an external account, specifying its name.
*ExternalAccountsResourceApi* | [**external_account_command_by_name**](docs/ExternalAccountsResourceApi.md#external_account_command_by_name) | **POST** /externalAccounts/account/{name}/commands/{commandName} | Executes a command on the external account specified by name.
*ExternalAccountsResourceApi* | [**get_supported_categories**](docs/ExternalAccountsResourceApi.md#get_supported_categories) | **GET** /externalAccounts/supportedCategories | List of external account categories supported by this Cloudera Manager.
*ExternalAccountsResourceApi* | [**get_supported_types**](docs/ExternalAccountsResourceApi.md#get_supported_types) | **GET** /externalAccounts/supportedTypes/{categoryName} | List of external account types supported by this Cloudera Manager by category.
*ExternalAccountsResourceApi* | [**list_external_account_commands**](docs/ExternalAccountsResourceApi.md#list_external_account_commands) | **GET** /externalAccounts/typeInfo/{typeName}/commandsByName | Lists all the commands that can be executed by name on the provided external account type.
*ExternalAccountsResourceApi* | [**read_account**](docs/ExternalAccountsResourceApi.md#read_account) | **GET** /externalAccounts/account/{name} | Get a single external account by account name.
*ExternalAccountsResourceApi* | [**read_account_by_display_name**](docs/ExternalAccountsResourceApi.md#read_account_by_display_name) | **GET** /externalAccounts/accountByDisplayName/{displayName} | Get a single external account by display name.
*ExternalAccountsResourceApi* | [**read_accounts**](docs/ExternalAccountsResourceApi.md#read_accounts) | **GET** /externalAccounts/type/{typeName} | Get a list of external accounts for a specific account type.
*ExternalAccountsResourceApi* | [**read_config**](docs/ExternalAccountsResourceApi.md#read_config) | **GET** /externalAccounts/account/{name}/config | Get configs of external account for the given account name.
*ExternalAccountsResourceApi* | [**update_account**](docs/ExternalAccountsResourceApi.md#update_account) | **PUT** /externalAccounts/update | Update an external account.
*ExternalAccountsResourceApi* | [**update_config**](docs/ExternalAccountsResourceApi.md#update_config) | **PUT** /externalAccounts/account/{name}/config | Upadate configs of external account for the given account name.
*ExternalUserMappingsResourceApi* | [**create_external_user_mappings**](docs/ExternalUserMappingsResourceApi.md#create_external_user_mappings) | **POST** /externalUserMappings | Creates a list of external user mappings.
*ExternalUserMappingsResourceApi* | [**delete_external_user_mapping**](docs/ExternalUserMappingsResourceApi.md#delete_external_user_mapping) | **DELETE** /externalUserMappings/{uuid} | Deletes an external user mapping from the system.
*ExternalUserMappingsResourceApi* | [**read_external_user_mapping**](docs/ExternalUserMappingsResourceApi.md#read_external_user_mapping) | **GET** /externalUserMappings/{uuid} | Returns detailed information about an external user mapping.
*ExternalUserMappingsResourceApi* | [**read_external_user_mappings**](docs/ExternalUserMappingsResourceApi.md#read_external_user_mappings) | **GET** /externalUserMappings | Returns a list of the external user mappings configured in the system.
*ExternalUserMappingsResourceApi* | [**update_external_user_mapping**](docs/ExternalUserMappingsResourceApi.md#update_external_user_mapping) | **PUT** /externalUserMappings/{uuid} | Updates the given external user mapping&#39;s information.
*HostTemplatesResourceApi* | [**apply_host_template**](docs/HostTemplatesResourceApi.md#apply_host_template) | **POST** /clusters/{clusterName}/hostTemplates/{hostTemplateName}/commands/applyHostTemplate | Applies a host template to a collection of hosts.
*HostTemplatesResourceApi* | [**create_host_templates**](docs/HostTemplatesResourceApi.md#create_host_templates) | **POST** /clusters/{clusterName}/hostTemplates | Creates new host templates.
*HostTemplatesResourceApi* | [**delete_host_template**](docs/HostTemplatesResourceApi.md#delete_host_template) | **DELETE** /clusters/{clusterName}/hostTemplates/{hostTemplateName} | Deletes a host template.
*HostTemplatesResourceApi* | [**read_host_template**](docs/HostTemplatesResourceApi.md#read_host_template) | **GET** /clusters/{clusterName}/hostTemplates/{hostTemplateName} | Retrieves information about a host template.
*HostTemplatesResourceApi* | [**read_host_templates**](docs/HostTemplatesResourceApi.md#read_host_templates) | **GET** /clusters/{clusterName}/hostTemplates | Lists all host templates in a cluster.
*HostTemplatesResourceApi* | [**update_host_template**](docs/HostTemplatesResourceApi.md#update_host_template) | **PUT** /clusters/{clusterName}/hostTemplates/{hostTemplateName} | Updates an existing host template.
*HostsResourceApi* | [**add_tags**](docs/HostsResourceApi.md#add_tags) | **PUT** /hosts/{hostname}/tags | Attach tags to the host.
*HostsResourceApi* | [**create_hosts**](docs/HostsResourceApi.md#create_hosts) | **POST** /hosts | .
*HostsResourceApi* | [**delete_all_hosts**](docs/HostsResourceApi.md#delete_all_hosts) | **DELETE** /hosts | Delete all hosts in the system.
*HostsResourceApi* | [**delete_host**](docs/HostsResourceApi.md#delete_host) | **DELETE** /hosts/{hostId} | Delete a host from the system.
*HostsResourceApi* | [**delete_tags**](docs/HostsResourceApi.md#delete_tags) | **DELETE** /hosts/{hostname}/tags | Remove the tags associated with the host.
*HostsResourceApi* | [**enter_maintenance_mode**](docs/HostsResourceApi.md#enter_maintenance_mode) | **POST** /hosts/{hostId}/commands/enterMaintenanceMode | Put the host into maintenance mode.
*HostsResourceApi* | [**exit_maintenance_mode**](docs/HostsResourceApi.md#exit_maintenance_mode) | **POST** /hosts/{hostId}/commands/exitMaintenanceMode | Take the host out of maintenance mode.
*HostsResourceApi* | [**generate_host_certs**](docs/HostsResourceApi.md#generate_host_certs) | **POST** /hosts/{hostId}/commands/generateHostCerts | Generates (or regenerates) a key and certificate for this host if Auto-TLS is enabled.
*HostsResourceApi* | [**get_host_components**](docs/HostsResourceApi.md#get_host_components) | **GET** /hosts/{hostId}/components | Returns the list of Component details on the requested host.
*HostsResourceApi* | [**get_metrics**](docs/HostsResourceApi.md#get_metrics) | **GET** /hosts/{hostId}/metrics | Fetch metric readings for a host.
*HostsResourceApi* | [**migrate_roles**](docs/HostsResourceApi.md#migrate_roles) | **POST** /hosts/{hostId}/commands/migrateRoles | Migrate roles to a different host.
*HostsResourceApi* | [**read_host**](docs/HostsResourceApi.md#read_host) | **GET** /hosts/{hostId} | Returns a specific Host in the system.
*HostsResourceApi* | [**read_host_config**](docs/HostsResourceApi.md#read_host_config) | **GET** /hosts/{hostId}/config | Retrieves the configuration of a specific host.
*HostsResourceApi* | [**read_hosts**](docs/HostsResourceApi.md#read_hosts) | **GET** /hosts | Returns hosts in the system filtered by optional host configuration parameters, if specified.
*HostsResourceApi* | [**read_tags**](docs/HostsResourceApi.md#read_tags) | **GET** /hosts/{hostname}/tags | Returns the tags associated with this host.
*HostsResourceApi* | [**remove_hosts_from_cluster**](docs/HostsResourceApi.md#remove_hosts_from_cluster) | **POST** /hosts/removeHostsFromCluster | Decommissions and deletes all non management roles from the list of hosts and removes the hosts from the cluster.
*HostsResourceApi* | [**reset_host_id**](docs/HostsResourceApi.md#reset_host_id) | **POST** /hosts/{hostId}/commands/resetHostId | Forces agent on specified host to switch to reporting a different host id.
*HostsResourceApi* | [**update_host**](docs/HostsResourceApi.md#update_host) | **PUT** /hosts/{hostId} | .
*HostsResourceApi* | [**update_host_config**](docs/HostsResourceApi.md#update_host_config) | **PUT** /hosts/{hostId}/config | Updates the host configuration with the given values.
*ImpalaQueriesResourceApi* | [**cancel_impala_query**](docs/ImpalaQueriesResourceApi.md#cancel_impala_query) | **POST** /clusters/{clusterName}/services/{serviceName}/impalaQueries/{queryId}/cancel | Cancels an Impala Query.
*ImpalaQueriesResourceApi* | [**get_impala_queries**](docs/ImpalaQueriesResourceApi.md#get_impala_queries) | **GET** /clusters/{clusterName}/services/{serviceName}/impalaQueries | Returns a list of queries that satisfy the filter.
*ImpalaQueriesResourceApi* | [**get_impala_query_attributes**](docs/ImpalaQueriesResourceApi.md#get_impala_query_attributes) | **GET** /clusters/{clusterName}/services/{serviceName}/impalaQueries/attributes | Returns the list of all attributes that the Service Monitor can associate with Impala queries.
*ImpalaQueriesResourceApi* | [**get_query_details**](docs/ImpalaQueriesResourceApi.md#get_query_details) | **GET** /clusters/{clusterName}/services/{serviceName}/impalaQueries/{queryId} | Returns details about the query.
*MgmtRoleCommandsResourceApi* | [**jmap_dump**](docs/MgmtRoleCommandsResourceApi.md#jmap_dump) | **POST** /cm/service/roleCommands/jmapDump | Run the jmapDump diagnostic command.
*MgmtRoleCommandsResourceApi* | [**jmap_histo**](docs/MgmtRoleCommandsResourceApi.md#jmap_histo) | **POST** /cm/service/roleCommands/jmapHisto | Run the jmapHisto diagnostic command.
*MgmtRoleCommandsResourceApi* | [**jstack**](docs/MgmtRoleCommandsResourceApi.md#jstack) | **POST** /cm/service/roleCommands/jstack | Run the jstack diagnostic command.
*MgmtRoleCommandsResourceApi* | [**lsof**](docs/MgmtRoleCommandsResourceApi.md#lsof) | **POST** /cm/service/roleCommands/lsof | Run the lsof diagnostic command.
*MgmtRoleCommandsResourceApi* | [**restart_command**](docs/MgmtRoleCommandsResourceApi.md#restart_command) | **POST** /cm/service/roleCommands/restart | Restart a set of Cloudera Management Services roles.
*MgmtRoleCommandsResourceApi* | [**start_command**](docs/MgmtRoleCommandsResourceApi.md#start_command) | **POST** /cm/service/roleCommands/start | Start a set of Cloudera Management Services roles.
*MgmtRoleCommandsResourceApi* | [**stop_command**](docs/MgmtRoleCommandsResourceApi.md#stop_command) | **POST** /cm/service/roleCommands/stop | Stop a set of Cloudera Management Services roles.
*MgmtRoleConfigGroupsResourceApi* | [**read_config**](docs/MgmtRoleConfigGroupsResourceApi.md#read_config) | **GET** /cm/service/roleConfigGroups/{roleConfigGroupName}/config | Returns the current revision of the config for the specified role config group in the Cloudera Management Services.
*MgmtRoleConfigGroupsResourceApi* | [**read_role_config_group**](docs/MgmtRoleConfigGroupsResourceApi.md#read_role_config_group) | **GET** /cm/service/roleConfigGroups/{roleConfigGroupName} | Returns the information for a given role config group in the Cloudera Management Services.
*MgmtRoleConfigGroupsResourceApi* | [**read_role_config_groups**](docs/MgmtRoleConfigGroupsResourceApi.md#read_role_config_groups) | **GET** /cm/service/roleConfigGroups | Returns the information for all role config groups in the Cloudera Management Services.
*MgmtRoleConfigGroupsResourceApi* | [**read_roles**](docs/MgmtRoleConfigGroupsResourceApi.md#read_roles) | **GET** /cm/service/roleConfigGroups/{roleConfigGroupName}/roles | Returns all roles in the given role config group in the Cloudera Management Services.
*MgmtRoleConfigGroupsResourceApi* | [**update_config**](docs/MgmtRoleConfigGroupsResourceApi.md#update_config) | **PUT** /cm/service/roleConfigGroups/{roleConfigGroupName}/config | Updates the config for the given role config group in the Cloudera Management Services.
*MgmtRoleConfigGroupsResourceApi* | [**update_role_config_group**](docs/MgmtRoleConfigGroupsResourceApi.md#update_role_config_group) | **PUT** /cm/service/roleConfigGroups/{roleConfigGroupName} | Updates an existing role config group in the Cloudera Management Services.
*MgmtRolesResourceApi* | [**create_roles**](docs/MgmtRolesResourceApi.md#create_roles) | **POST** /cm/service/roles | Create new roles in the Cloudera Management Services.
*MgmtRolesResourceApi* | [**delete_role**](docs/MgmtRolesResourceApi.md#delete_role) | **DELETE** /cm/service/roles/{roleName} | Delete a role from the Cloudera Management Services.
*MgmtRolesResourceApi* | [**enter_maintenance_mode**](docs/MgmtRolesResourceApi.md#enter_maintenance_mode) | **POST** /cm/service/roles/{roleName}/commands/enterMaintenanceMode | Put the Cloudera Management Service role into maintenance mode.
*MgmtRolesResourceApi* | [**exit_maintenance_mode**](docs/MgmtRolesResourceApi.md#exit_maintenance_mode) | **POST** /cm/service/roles/{roleName}/commands/exitMaintenanceMode | Take the Cloudera Management Service role out of maintenance mode.
*MgmtRolesResourceApi* | [**get_full_log**](docs/MgmtRolesResourceApi.md#get_full_log) | **GET** /cm/service/roles/{roleName}/logs/full | Retrieves the log file for the role&#39;s main process.
*MgmtRolesResourceApi* | [**get_stacks_log**](docs/MgmtRolesResourceApi.md#get_stacks_log) | **GET** /cm/service/roles/{roleName}/logs/stacks | Retrieves the stacks log file, if any, for the role&#39;s main process.
*MgmtRolesResourceApi* | [**get_stacks_logs_bundle**](docs/MgmtRolesResourceApi.md#get_stacks_logs_bundle) | **GET** /cm/service/roles/{roleName}/logs/stacksBundle | Download a zip-compressed archive of role stacks logs.
*MgmtRolesResourceApi* | [**get_standard_error**](docs/MgmtRolesResourceApi.md#get_standard_error) | **GET** /cm/service/roles/{roleName}/logs/stderr | Retrieves the role&#39;s standard error output.
*MgmtRolesResourceApi* | [**get_standard_output**](docs/MgmtRolesResourceApi.md#get_standard_output) | **GET** /cm/service/roles/{roleName}/logs/stdout | Retrieves the role&#39;s standard output.
*MgmtRolesResourceApi* | [**list_active_commands**](docs/MgmtRolesResourceApi.md#list_active_commands) | **GET** /cm/service/roles/{roleName}/commands | List active role commands.
*MgmtRolesResourceApi* | [**read_role**](docs/MgmtRolesResourceApi.md#read_role) | **GET** /cm/service/roles/{roleName} | Retrieve detailed information about a Cloudera Management Services role.
*MgmtRolesResourceApi* | [**read_role_config**](docs/MgmtRolesResourceApi.md#read_role_config) | **GET** /cm/service/roles/{roleName}/config | Retrieve the configuration of a specific Cloudera Management Services role.
*MgmtRolesResourceApi* | [**read_roles**](docs/MgmtRolesResourceApi.md#read_roles) | **GET** /cm/service/roles | List all roles of the Cloudera Management Services.
*MgmtRolesResourceApi* | [**update_role_config**](docs/MgmtRolesResourceApi.md#update_role_config) | **PUT** /cm/service/roles/{roleName}/config | Update the configuration of a Cloudera Management Services role.
*MgmtServiceResourceApi* | [**auto_assign_roles**](docs/MgmtServiceResourceApi.md#auto_assign_roles) | **PUT** /cm/service/autoAssignRoles | Automatically assign roles to hosts and create the roles for the Cloudera Management Service.
*MgmtServiceResourceApi* | [**auto_configure**](docs/MgmtServiceResourceApi.md#auto_configure) | **PUT** /cm/service/autoConfigure | Automatically configures roles of the Cloudera Management Service.
*MgmtServiceResourceApi* | [**delete_cms**](docs/MgmtServiceResourceApi.md#delete_cms) | **DELETE** /cm/service | Delete the Cloudera Management Services.
*MgmtServiceResourceApi* | [**enter_maintenance_mode**](docs/MgmtServiceResourceApi.md#enter_maintenance_mode) | **POST** /cm/service/commands/enterMaintenanceMode | Put Cloudera Management Service into maintenance mode.
*MgmtServiceResourceApi* | [**exit_maintenance_mode**](docs/MgmtServiceResourceApi.md#exit_maintenance_mode) | **POST** /cm/service/commands/exitMaintenanceMode | Take Cloudera Management Service out of maintenance mode.
*MgmtServiceResourceApi* | [**list_active_commands**](docs/MgmtServiceResourceApi.md#list_active_commands) | **GET** /cm/service/commands | List active Cloudera Management Services commands.
*MgmtServiceResourceApi* | [**list_role_types**](docs/MgmtServiceResourceApi.md#list_role_types) | **GET** /cm/service/roleTypes | List the supported role types for the Cloudera Management Services.
*MgmtServiceResourceApi* | [**read_service**](docs/MgmtServiceResourceApi.md#read_service) | **GET** /cm/service | Retrieve information about the Cloudera Management Services.
*MgmtServiceResourceApi* | [**read_service_config**](docs/MgmtServiceResourceApi.md#read_service_config) | **GET** /cm/service/config | Retrieve the configuration of the Cloudera Management Services.
*MgmtServiceResourceApi* | [**restart_command**](docs/MgmtServiceResourceApi.md#restart_command) | **POST** /cm/service/commands/restart | Restart the Cloudera Management Services.
*MgmtServiceResourceApi* | [**setup_cms**](docs/MgmtServiceResourceApi.md#setup_cms) | **PUT** /cm/service | Setup the Cloudera Management Services.
*MgmtServiceResourceApi* | [**start_command**](docs/MgmtServiceResourceApi.md#start_command) | **POST** /cm/service/commands/start | Start the Cloudera Management Services.
*MgmtServiceResourceApi* | [**stop_command**](docs/MgmtServiceResourceApi.md#stop_command) | **POST** /cm/service/commands/stop | Stop the Cloudera Management Services.
*MgmtServiceResourceApi* | [**update_service_config**](docs/MgmtServiceResourceApi.md#update_service_config) | **PUT** /cm/service/config | Update the Cloudera Management Services configuration.
*NameservicesResourceApi* | [**get_metrics**](docs/NameservicesResourceApi.md#get_metrics) | **GET** /clusters/{clusterName}/services/{serviceName}/nameservices/{nameservice}/metrics | Fetch metric readings for a particular nameservice.
*NameservicesResourceApi* | [**list_nameservices**](docs/NameservicesResourceApi.md#list_nameservices) | **GET** /clusters/{clusterName}/services/{serviceName}/nameservices | List the nameservices of an HDFS service.
*NameservicesResourceApi* | [**read_nameservice**](docs/NameservicesResourceApi.md#read_nameservice) | **GET** /clusters/{clusterName}/services/{serviceName}/nameservices/{nameservice} | Retrieve information about a nameservice.
*ParcelResourceApi* | [**activate_command**](docs/ParcelResourceApi.md#activate_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/activate | A synchronous command that activates the parcel on the cluster.
*ParcelResourceApi* | [**cancel_distribution_command**](docs/ParcelResourceApi.md#cancel_distribution_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/cancelDistribution | A synchronous command that cancels the parcel distribution.
*ParcelResourceApi* | [**cancel_download_command**](docs/ParcelResourceApi.md#cancel_download_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/cancelDownload | A synchronous command that cancels the parcel download.
*ParcelResourceApi* | [**deactivate_command**](docs/ParcelResourceApi.md#deactivate_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/deactivate | A synchronous command that deactivates the parcel on the cluster.
*ParcelResourceApi* | [**read_parcel**](docs/ParcelResourceApi.md#read_parcel) | **GET** /clusters/{clusterName}/parcels/products/{product}/versions/{version} | Retrieves detailed information about a parcel.
*ParcelResourceApi* | [**remove_download_command**](docs/ParcelResourceApi.md#remove_download_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/removeDownload | A synchronous command that removes the downloaded parcel.
*ParcelResourceApi* | [**start_distribution_command**](docs/ParcelResourceApi.md#start_distribution_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/startDistribution | A synchronous command that starts the distribution of the parcel to the cluster.
*ParcelResourceApi* | [**start_download_command**](docs/ParcelResourceApi.md#start_download_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/startDownload | A synchronous command that starts the parcel download.
*ParcelResourceApi* | [**start_removal_of_distribution_command**](docs/ParcelResourceApi.md#start_removal_of_distribution_command) | **POST** /clusters/{clusterName}/parcels/products/{product}/versions/{version}/commands/startRemovalOfDistribution | A synchronous command that removes the distribution from the hosts in the cluster.
*ParcelsResourceApi* | [**get_parcel_usage**](docs/ParcelsResourceApi.md#get_parcel_usage) | **GET** /clusters/{clusterName}/parcels/usage | Retrieve details parcel usage information for the cluster.
*ParcelsResourceApi* | [**read_parcels**](docs/ParcelsResourceApi.md#read_parcels) | **GET** /clusters/{clusterName}/parcels | Lists all parcels that the cluster has access to.
*ProcessResourceApi* | [**get_config_file**](docs/ProcessResourceApi.md#get_config_file) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/process/configFiles/{configFileName} | Returns the contents of the specified config file.
*ProcessResourceApi* | [**get_process**](docs/ProcessResourceApi.md#get_process) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/process | 
*ReplicationsResourceApi* | [**collect_diagnostic_data**](docs/ReplicationsResourceApi.md#collect_diagnostic_data) | **POST** /clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/collectDiagnosticData | Collect diagnostic data for a schedule, optionally for a subset of commands on that schedule, matched by schedule ID.
*ReplicationsResourceApi* | [**create_schedules**](docs/ReplicationsResourceApi.md#create_schedules) | **POST** /clusters/{clusterName}/services/{serviceName}/replications | Creates one or more replication schedules.
*ReplicationsResourceApi* | [**delete_all_schedules**](docs/ReplicationsResourceApi.md#delete_all_schedules) | **DELETE** /clusters/{clusterName}/services/{serviceName}/replications | Deletes all existing replication schedules.
*ReplicationsResourceApi* | [**delete_schedule**](docs/ReplicationsResourceApi.md#delete_schedule) | **DELETE** /clusters/{clusterName}/services/{serviceName}/replications/{scheduleId} | Deletes an existing replication schedule.
*ReplicationsResourceApi* | [**get_replication_state**](docs/ReplicationsResourceApi.md#get_replication_state) | **GET** /clusters/{clusterName}/services/{serviceName}/replications/replicationState | returns the replication state.
*ReplicationsResourceApi* | [**read_history**](docs/ReplicationsResourceApi.md#read_history) | **GET** /clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/history | Returns a list of commands triggered by a schedule.
*ReplicationsResourceApi* | [**read_schedule**](docs/ReplicationsResourceApi.md#read_schedule) | **GET** /clusters/{clusterName}/services/{serviceName}/replications/{scheduleId} | Returns information for a specific replication schedule.
*ReplicationsResourceApi* | [**read_schedules**](docs/ReplicationsResourceApi.md#read_schedules) | **GET** /clusters/{clusterName}/services/{serviceName}/replications | Returns information for all replication schedules.
*ReplicationsResourceApi* | [**reschedule_hive3_replication_metrics_getter**](docs/ReplicationsResourceApi.md#reschedule_hive3_replication_metrics_getter) | **POST** /clusters/{clusterName}/services/{serviceName}/replications/rescheduleHive3ReplicationMetricsGetter | Set the Hive3 Replication Metrics Getter next start time.
*ReplicationsResourceApi* | [**run_copy_listing**](docs/ReplicationsResourceApi.md#run_copy_listing) | **POST** /clusters/{clusterName}/services/{serviceName}/replications/hdfsCopyListing | Run the hdfs copy listing command.
*ReplicationsResourceApi* | [**run_h_base_replication_security_tool**](docs/ReplicationsResourceApi.md#run_h_base_replication_security_tool) | **POST** /clusters/{clusterName}/services/{serviceName}/replications/hbaseReplicationSecurityTool | Run the hbase replication security tool.
*ReplicationsResourceApi* | [**run_hive_replication_query**](docs/ReplicationsResourceApi.md#run_hive_replication_query) | **POST** /clusters/{clusterName}/services/{serviceName}/replications/hiveReplicationQuery | Execute a hive replication query on local HS2 service instance.
*ReplicationsResourceApi* | [**run_schedule**](docs/ReplicationsResourceApi.md#run_schedule) | **POST** /clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/run | Run the schedule immediately.
*ReplicationsResourceApi* | [**update_schedule**](docs/ReplicationsResourceApi.md#update_schedule) | **PUT** /clusters/{clusterName}/services/{serviceName}/replications/{scheduleId} | Updates an existing replication schedule.
*RoleCommandsResourceApi* | [**format_command**](docs/RoleCommandsResourceApi.md#format_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsFormat | Format HDFS NameNodes.
*RoleCommandsResourceApi* | [**hdfs_bootstrap_stand_by_command**](docs/RoleCommandsResourceApi.md#hdfs_bootstrap_stand_by_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsBootstrapStandBy | Bootstrap HDFS stand-by NameNodes.
*RoleCommandsResourceApi* | [**hdfs_enter_safemode**](docs/RoleCommandsResourceApi.md#hdfs_enter_safemode) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsEnterSafemode | Enter safemode for namenodes.
*RoleCommandsResourceApi* | [**hdfs_finalize_metadata_upgrade**](docs/RoleCommandsResourceApi.md#hdfs_finalize_metadata_upgrade) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsFinalizeMetadataUpgrade | Finalize HDFS NameNode metadata upgrade.
*RoleCommandsResourceApi* | [**hdfs_initialize_auto_failover_command**](docs/RoleCommandsResourceApi.md#hdfs_initialize_auto_failover_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsInitializeAutoFailover | Initialize HDFS HA failover controller metadata.
*RoleCommandsResourceApi* | [**hdfs_initialize_shared_dir_command**](docs/RoleCommandsResourceApi.md#hdfs_initialize_shared_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsInitializeSharedDir | Initialize HDFS NameNodes&#39; shared edit directory.
*RoleCommandsResourceApi* | [**hdfs_leave_safemode**](docs/RoleCommandsResourceApi.md#hdfs_leave_safemode) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsLeaveSafemode | Leave safemode for namenodes.
*RoleCommandsResourceApi* | [**hdfs_save_namespace**](docs/RoleCommandsResourceApi.md#hdfs_save_namespace) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hdfsSaveNamespace | Save namespace for namenodes.
*RoleCommandsResourceApi* | [**jmap_dump**](docs/RoleCommandsResourceApi.md#jmap_dump) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/jmapDump | Run the jmapDump diagnostic command.
*RoleCommandsResourceApi* | [**jmap_histo**](docs/RoleCommandsResourceApi.md#jmap_histo) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/jmapHisto | Run the jmapHisto diagnostic command.
*RoleCommandsResourceApi* | [**jstack**](docs/RoleCommandsResourceApi.md#jstack) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/jstack | Run the jstack diagnostic command.
*RoleCommandsResourceApi* | [**lsof**](docs/RoleCommandsResourceApi.md#lsof) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/lsof | Run the lsof diagnostic command.
*RoleCommandsResourceApi* | [**refresh_command**](docs/RoleCommandsResourceApi.md#refresh_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/refresh | Refresh a role&#39;s data.
*RoleCommandsResourceApi* | [**restart_command**](docs/RoleCommandsResourceApi.md#restart_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/restart | Restart a set of role instances.
*RoleCommandsResourceApi* | [**role_command_by_name**](docs/RoleCommandsResourceApi.md#role_command_by_name) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/{commandName} | Execute a role command by name.
*RoleCommandsResourceApi* | [**start_command**](docs/RoleCommandsResourceApi.md#start_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/start | Start a set of role instances.
*RoleCommandsResourceApi* | [**stop_command**](docs/RoleCommandsResourceApi.md#stop_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/stop | Stop a set of role instances.
*RoleCommandsResourceApi* | [**sync_hue_db_command**](docs/RoleCommandsResourceApi.md#sync_hue_db_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/hueSyncDb | Create / update the Hue database schema.
*RoleCommandsResourceApi* | [**zoo_keeper_cleanup_command**](docs/RoleCommandsResourceApi.md#zoo_keeper_cleanup_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/zooKeeperCleanup | Cleanup a list of ZooKeeper server roles.
*RoleCommandsResourceApi* | [**zoo_keeper_init_command**](docs/RoleCommandsResourceApi.md#zoo_keeper_init_command) | **POST** /clusters/{clusterName}/services/{serviceName}/roleCommands/zooKeeperInit | Initialize a list of ZooKeeper server roles.
*RoleConfigGroupsResourceApi* | [**create_role_config_groups**](docs/RoleConfigGroupsResourceApi.md#create_role_config_groups) | **POST** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups | Creates new role config groups.
*RoleConfigGroupsResourceApi* | [**delete_role_config_group**](docs/RoleConfigGroupsResourceApi.md#delete_role_config_group) | **DELETE** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName} | Deletes a role config group.
*RoleConfigGroupsResourceApi* | [**move_roles**](docs/RoleConfigGroupsResourceApi.md#move_roles) | **PUT** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/roles | Moves roles to the specified role config group.
*RoleConfigGroupsResourceApi* | [**move_roles_to_base_group**](docs/RoleConfigGroupsResourceApi.md#move_roles_to_base_group) | **PUT** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/roles | Moves roles to the base role config group.
*RoleConfigGroupsResourceApi* | [**read_config**](docs/RoleConfigGroupsResourceApi.md#read_config) | **GET** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/config | Returns the current revision of the config for the specified role config group.
*RoleConfigGroupsResourceApi* | [**read_role_config_group**](docs/RoleConfigGroupsResourceApi.md#read_role_config_group) | **GET** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName} | Returns the information for a role config group.
*RoleConfigGroupsResourceApi* | [**read_role_config_groups**](docs/RoleConfigGroupsResourceApi.md#read_role_config_groups) | **GET** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups | Returns the information for all role config groups for a given cluster and service.
*RoleConfigGroupsResourceApi* | [**read_roles**](docs/RoleConfigGroupsResourceApi.md#read_roles) | **GET** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/roles | Returns all roles in the given role config group.
*RoleConfigGroupsResourceApi* | [**update_config**](docs/RoleConfigGroupsResourceApi.md#update_config) | **PUT** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/config | Updates the config for the given role config group.
*RoleConfigGroupsResourceApi* | [**update_role_config_group**](docs/RoleConfigGroupsResourceApi.md#update_role_config_group) | **PUT** /clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName} | Updates an existing role config group.
*RolesResourceApi* | [**add_tags**](docs/RolesResourceApi.md#add_tags) | **PUT** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/tags | Attach tags to the role.
*RolesResourceApi* | [**bulk_delete_roles**](docs/RolesResourceApi.md#bulk_delete_roles) | **POST** /clusters/{clusterName}/services/{serviceName}/roles/bulkDelete | Bulk delete roles in a particular service by name.
*RolesResourceApi* | [**create_roles**](docs/RolesResourceApi.md#create_roles) | **POST** /clusters/{clusterName}/services/{serviceName}/roles | Create new roles in a given service.
*RolesResourceApi* | [**delete_role**](docs/RolesResourceApi.md#delete_role) | **DELETE** /clusters/{clusterName}/services/{serviceName}/roles/{roleName} | Deletes a role from a given service.
*RolesResourceApi* | [**delete_tags**](docs/RolesResourceApi.md#delete_tags) | **DELETE** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/tags | Remove the tags associated with the role.
*RolesResourceApi* | [**enter_maintenance_mode**](docs/RolesResourceApi.md#enter_maintenance_mode) | **POST** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands/enterMaintenanceMode | Put the role into maintenance mode.
*RolesResourceApi* | [**exit_maintenance_mode**](docs/RolesResourceApi.md#exit_maintenance_mode) | **POST** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands/exitMaintenanceMode | Take the role out of maintenance mode.
*RolesResourceApi* | [**get_full_log**](docs/RolesResourceApi.md#get_full_log) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/full | Retrieves the log file for the role&#39;s main process.
*RolesResourceApi* | [**get_metrics**](docs/RolesResourceApi.md#get_metrics) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/metrics | Fetch metric readings for a particular role.
*RolesResourceApi* | [**get_stacks_log**](docs/RolesResourceApi.md#get_stacks_log) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stacks | Retrieves the stacks log file, if any, for the role&#39;s main process.
*RolesResourceApi* | [**get_stacks_logs_bundle**](docs/RolesResourceApi.md#get_stacks_logs_bundle) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stacksBundle | Download a zip-compressed archive of role stacks logs.
*RolesResourceApi* | [**get_standard_error**](docs/RolesResourceApi.md#get_standard_error) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stderr | Retrieves the role&#39;s standard error output.
*RolesResourceApi* | [**get_standard_output**](docs/RolesResourceApi.md#get_standard_output) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/logs/stdout | Retrieves the role&#39;s standard output.
*RolesResourceApi* | [**impala_diagnostics**](docs/RolesResourceApi.md#impala_diagnostics) | **POST** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands/impalaDiagnostics | Collects diagnostics data for an Impala role.
*RolesResourceApi* | [**list_active_commands**](docs/RolesResourceApi.md#list_active_commands) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commands | List active role commands.
*RolesResourceApi* | [**list_commands**](docs/RolesResourceApi.md#list_commands) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/commandsByName | Lists all the commands that can be executed by name on the provided role.
*RolesResourceApi* | [**read_role**](docs/RolesResourceApi.md#read_role) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName} | Retrieves detailed information about a role.
*RolesResourceApi* | [**read_role_config**](docs/RolesResourceApi.md#read_role_config) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/config | Retrieves the configuration of a specific role.
*RolesResourceApi* | [**read_roles**](docs/RolesResourceApi.md#read_roles) | **GET** /clusters/{clusterName}/services/{serviceName}/roles | Lists all roles of a given service.
*RolesResourceApi* | [**read_tags**](docs/RolesResourceApi.md#read_tags) | **GET** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/tags | Returns the tags associated with this role.
*RolesResourceApi* | [**update_role_config**](docs/RolesResourceApi.md#update_role_config) | **PUT** /clusters/{clusterName}/services/{serviceName}/roles/{roleName}/config | Updates the role configuration with the given values.
*ServicesResourceApi* | [**add_tags**](docs/ServicesResourceApi.md#add_tags) | **PUT** /clusters/{clusterName}/services/{serviceName}/tags | Attach tags to the service.
*ServicesResourceApi* | [**collect_yarn_application_diagnostics**](docs/ServicesResourceApi.md#collect_yarn_application_diagnostics) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/yarnApplicationDiagnosticsCollection | Collect the Diagnostics data for Yarn applications.
*ServicesResourceApi* | [**copy_hdfs_file**](docs/ServicesResourceApi.md#copy_hdfs_file) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/copyHdfsFile | Copies source HDFS file to destination cluster HDFS.
*ServicesResourceApi* | [**create_beeswax_warehouse_command**](docs/ServicesResourceApi.md#create_beeswax_warehouse_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hueCreateHiveWarehouse | Create the Beeswax role&#39;s Hive warehouse directory, on Hue services.
*ServicesResourceApi* | [**create_h_base_root_command**](docs/ServicesResourceApi.md#create_h_base_root_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseCreateRoot | Creates the root directory of an HBase service.
*ServicesResourceApi* | [**create_hdfs_file**](docs/ServicesResourceApi.md#create_hdfs_file) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/createHdfsFile | 
*ServicesResourceApi* | [**create_hive_user_dir_command**](docs/ServicesResourceApi.md#create_hive_user_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveCreateHiveUserDir | Create the Hive user directory.
*ServicesResourceApi* | [**create_hive_warehouse_command**](docs/ServicesResourceApi.md#create_hive_warehouse_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveCreateHiveWarehouse | Create the Hive warehouse directory, on Hive services.
*ServicesResourceApi* | [**create_hive_warehouse_external_command**](docs/ServicesResourceApi.md#create_hive_warehouse_external_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveCreateHiveWarehouseExternal | Create the Hive warehouse external directory for Private Cloud.
*ServicesResourceApi* | [**create_impala_user_dir_command**](docs/ServicesResourceApi.md#create_impala_user_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/impalaCreateUserDir | Create the Impala user directory.
*ServicesResourceApi* | [**create_oozie_db**](docs/ServicesResourceApi.md#create_oozie_db) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/createOozieDb | Creates the Oozie Database Schema in the configured database.
*ServicesResourceApi* | [**create_services**](docs/ServicesResourceApi.md#create_services) | **POST** /clusters/{clusterName}/services | Creates a list of services.
*ServicesResourceApi* | [**create_solr_hdfs_home_dir_command**](docs/ServicesResourceApi.md#create_solr_hdfs_home_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/createSolrHdfsHomeDir | Creates the home directory of a Solr service in HDFS.
*ServicesResourceApi* | [**create_sqoop_user_dir_command**](docs/ServicesResourceApi.md#create_sqoop_user_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/createSqoopUserDir | Creates the user directory of a Sqoop service in HDFS.
*ServicesResourceApi* | [**create_yarn_cm_container_usage_input_dir_command**](docs/ServicesResourceApi.md#create_yarn_cm_container_usage_input_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/yarnCreateCmContainerUsageInputDirCommand | Creates the HDFS directory where YARN container usage metrics are stored by NodeManagers for CM to read and aggregate into app usage metrics.
*ServicesResourceApi* | [**create_yarn_job_history_dir_command**](docs/ServicesResourceApi.md#create_yarn_job_history_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/yarnCreateJobHistoryDirCommand | Create the Yarn job history directory.
*ServicesResourceApi* | [**create_yarn_node_manager_remote_app_log_dir_command**](docs/ServicesResourceApi.md#create_yarn_node_manager_remote_app_log_dir_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/yarnNodeManagerRemoteAppLogDirCommand | Create the Yarn NodeManager remote application log directory.
*ServicesResourceApi* | [**decommission_command**](docs/ServicesResourceApi.md#decommission_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/decommission | Decommission roles of a service.
*ServicesResourceApi* | [**delete_service**](docs/ServicesResourceApi.md#delete_service) | **DELETE** /clusters/{clusterName}/services/{serviceName} | Deletes a service from the system.
*ServicesResourceApi* | [**delete_tags**](docs/ServicesResourceApi.md#delete_tags) | **DELETE** /clusters/{clusterName}/services/{serviceName}/tags | Remove the tags associated with the service.
*ServicesResourceApi* | [**deploy_client_config_command**](docs/ServicesResourceApi.md#deploy_client_config_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/deployClientConfig | Deploy a service&#39;s client configuration.
*ServicesResourceApi* | [**disable_jt_ha_command**](docs/ServicesResourceApi.md#disable_jt_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/disableJtHa | Disable high availability (HA) for JobTracker.
*ServicesResourceApi* | [**disable_llama_ha_command**](docs/ServicesResourceApi.md#disable_llama_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/impalaDisableLlamaHa | Not Supported.
*ServicesResourceApi* | [**disable_llama_rm_command**](docs/ServicesResourceApi.md#disable_llama_rm_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/impalaDisableLlamaRm | Not Supported.
*ServicesResourceApi* | [**disable_oozie_ha_command**](docs/ServicesResourceApi.md#disable_oozie_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/oozieDisableHa | Disable high availability (HA) for Oozie.
*ServicesResourceApi* | [**disable_rm_ha_command**](docs/ServicesResourceApi.md#disable_rm_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/disableRmHa | Disable high availability (HA) for ResourceManager.
*ServicesResourceApi* | [**disable_sentry_ha_command**](docs/ServicesResourceApi.md#disable_sentry_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/disableSentryHa | Disable high availability (HA) for Sentry service.
*ServicesResourceApi* | [**enable_jt_ha_command**](docs/ServicesResourceApi.md#enable_jt_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/enableJtHa | Enable high availability (HA) for a JobTracker.
*ServicesResourceApi* | [**enable_llama_ha_command**](docs/ServicesResourceApi.md#enable_llama_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/impalaEnableLlamaHa | Not Supported.
*ServicesResourceApi* | [**enable_llama_rm_command**](docs/ServicesResourceApi.md#enable_llama_rm_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/impalaEnableLlamaRm | Not Supported.
*ServicesResourceApi* | [**enable_oozie_ha_command**](docs/ServicesResourceApi.md#enable_oozie_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/oozieEnableHa | Enable high availability (HA) for Oozie service.
*ServicesResourceApi* | [**enable_rm_ha_command**](docs/ServicesResourceApi.md#enable_rm_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/enableRmHa | Enable high availability (HA) for a YARN ResourceManager.
*ServicesResourceApi* | [**enable_sentry_ha_command**](docs/ServicesResourceApi.md#enable_sentry_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/enableSentryHa | Enable high availability (HA) for Sentry service.
*ServicesResourceApi* | [**enter_maintenance_mode**](docs/ServicesResourceApi.md#enter_maintenance_mode) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/enterMaintenanceMode | Put the service into maintenance mode.
*ServicesResourceApi* | [**exit_maintenance_mode**](docs/ServicesResourceApi.md#exit_maintenance_mode) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/exitMaintenanceMode | Take the service out of maintenance mode.
*ServicesResourceApi* | [**export_sentry_permissions_command**](docs/ServicesResourceApi.md#export_sentry_permissions_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/exportSentryPermissions | Export Sentry Permissions.
*ServicesResourceApi* | [**first_run**](docs/ServicesResourceApi.md#first_run) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/firstRun | Prepare and start a service.
*ServicesResourceApi* | [**get_client_config**](docs/ServicesResourceApi.md#get_client_config) | **GET** /clusters/{clusterName}/services/{serviceName}/clientConfig | Download a zip-compressed archive of the client configuration, of a specific service.
*ServicesResourceApi* | [**get_hdfs_usage_report**](docs/ServicesResourceApi.md#get_hdfs_usage_report) | **GET** /clusters/{clusterName}/services/{serviceName}/reports/hdfsUsageReport | Fetch the HDFS usage report.
*ServicesResourceApi* | [**get_impala_utilization**](docs/ServicesResourceApi.md#get_impala_utilization) | **GET** /clusters/{clusterName}/services/{serviceName}/impalaUtilization | Provides the resource utilization of the Impala service as well as the resource utilization per tenant.
*ServicesResourceApi* | [**get_metrics**](docs/ServicesResourceApi.md#get_metrics) | **GET** /clusters/{clusterName}/services/{serviceName}/metrics | Fetch metric readings for a particular service.
*ServicesResourceApi* | [**get_mr_usage_report**](docs/ServicesResourceApi.md#get_mr_usage_report) | **GET** /clusters/{clusterName}/services/{serviceName}/reports/mrUsageReport | Fetch the MR usage report.
*ServicesResourceApi* | [**get_yarn_utilization**](docs/ServicesResourceApi.md#get_yarn_utilization) | **GET** /clusters/{clusterName}/services/{serviceName}/yarnUtilization | Provides the resource utilization of the yarn service as well as the resource utilization per tenant.
*ServicesResourceApi* | [**hbase_replication_create_user_directory**](docs/ServicesResourceApi.md#hbase_replication_create_user_directory) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseCreateUserDirectory | Create the HBase user directory (usually /user/hbase).
*ServicesResourceApi* | [**hbase_replication_first_time_setup_automatic**](docs/ServicesResourceApi.md#hbase_replication_first_time_setup_automatic) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationFirstTimeSetupAutomatic | Starts an automatic HBase replication first time setup.
*ServicesResourceApi* | [**hbase_replication_first_time_setup_force_ready**](docs/ServicesResourceApi.md#hbase_replication_first_time_setup_force_ready) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationFirstTimeSetupForceReady | Force sets the HBase replication first time setup status to be READY for the given source and target.
*ServicesResourceApi* | [**hbase_replication_first_time_setup_manual**](docs/ServicesResourceApi.md#hbase_replication_first_time_setup_manual) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationFirstTimeSetupManual | Starts a manual HBase replication first time setup.
*ServicesResourceApi* | [**hbase_replication_first_time_setup_manual_continue**](docs/ServicesResourceApi.md#hbase_replication_first_time_setup_manual_continue) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationFirstTimeSetupManualContinue | Should be called after #hbaseReplicationFirstTimeSetupManual(String, ApiHBaseReplicationSetupCommandArgs) to finish the manual HBase replication first time setup.
*ServicesResourceApi* | [**hbase_replication_first_time_setup_reset**](docs/ServicesResourceApi.md#hbase_replication_first_time_setup_reset) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationFirstTimeSetupReset | Resets/removes the HBase replication first time setup status for the given source and target.
*ServicesResourceApi* | [**hbase_replication_first_time_setup_status**](docs/ServicesResourceApi.md#hbase_replication_first_time_setup_status) | **GET** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationFirstTimeSetupStatus | 
*ServicesResourceApi* | [**hbase_replication_setup**](docs/ServicesResourceApi.md#hbase_replication_setup) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationSetup | Perform one time setup for HBase replication.
*ServicesResourceApi* | [**hbase_replication_setup_admin**](docs/ServicesResourceApi.md#hbase_replication_setup_admin) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseReplicationSetupAdmin | 
*ServicesResourceApi* | [**hbase_shell_command**](docs/ServicesResourceApi.md#hbase_shell_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseShellCommand | Execute a hbase shell command.
*ServicesResourceApi* | [**hbase_upgrade_command**](docs/ServicesResourceApi.md#hbase_upgrade_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hbaseUpgrade | Upgrade HBase data in HDFS and ZooKeeper as part of upgrade from CDH4 to CDH5.
*ServicesResourceApi* | [**hdfs_create_tmp_dir**](docs/ServicesResourceApi.md#hdfs_create_tmp_dir) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsCreateTmpDir | Creates a tmp directory on the HDFS filesystem.
*ServicesResourceApi* | [**hdfs_disable_auto_failover_command**](docs/ServicesResourceApi.md#hdfs_disable_auto_failover_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsDisableAutoFailover | Disable auto-failover for a highly available HDFS nameservice.
*ServicesResourceApi* | [**hdfs_disable_ha_command**](docs/ServicesResourceApi.md#hdfs_disable_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsDisableHa | Disable high availability (HA) for an HDFS NameNode.
*ServicesResourceApi* | [**hdfs_disable_nn_ha_command**](docs/ServicesResourceApi.md#hdfs_disable_nn_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsDisableNnHa | Disable High Availability (HA) with Automatic Failover for an HDFS NameNode.
*ServicesResourceApi* | [**hdfs_enable_auto_failover_command**](docs/ServicesResourceApi.md#hdfs_enable_auto_failover_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsEnableAutoFailover | Enable auto-failover for an HDFS nameservice.
*ServicesResourceApi* | [**hdfs_enable_ha_command**](docs/ServicesResourceApi.md#hdfs_enable_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsEnableHa | Enable high availability (HA) for an HDFS NameNode.
*ServicesResourceApi* | [**hdfs_enable_nn_ha_command**](docs/ServicesResourceApi.md#hdfs_enable_nn_ha_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsEnableNnHa | Enable High Availability (HA) with Automatic Failover for an HDFS NameNode.
*ServicesResourceApi* | [**hdfs_failover_command**](docs/ServicesResourceApi.md#hdfs_failover_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsFailover | Initiate a failover in an HDFS HA NameNode pair.
*ServicesResourceApi* | [**hdfs_finalize_rolling_upgrade**](docs/ServicesResourceApi.md#hdfs_finalize_rolling_upgrade) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsFinalizeRollingUpgrade | Finalizes the rolling upgrade for HDFS by updating the NameNode metadata permanently to the next version.
*ServicesResourceApi* | [**hdfs_roll_edits_command**](docs/ServicesResourceApi.md#hdfs_roll_edits_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsRollEdits | Roll the edits of an HDFS NameNode or Nameservice.
*ServicesResourceApi* | [**hdfs_upgrade_metadata_command**](docs/ServicesResourceApi.md#hdfs_upgrade_metadata_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hdfsUpgradeMetadata | Upgrade HDFS Metadata as part of a major version upgrade.
*ServicesResourceApi* | [**hive_create_metastore_database_command**](docs/ServicesResourceApi.md#hive_create_metastore_database_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveCreateMetastoreDatabase | Create the Hive Metastore Database.
*ServicesResourceApi* | [**hive_create_metastore_database_tables_command**](docs/ServicesResourceApi.md#hive_create_metastore_database_tables_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveCreateMetastoreDatabaseTables | Create the Hive Metastore Database tables.
*ServicesResourceApi* | [**hive_update_metastore_namenodes_command**](docs/ServicesResourceApi.md#hive_update_metastore_namenodes_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveUpdateMetastoreNamenodes | Update Hive Metastore to point to a NameNode&#39;s Nameservice name instead of hostname.
*ServicesResourceApi* | [**hive_upgrade_metastore_command**](docs/ServicesResourceApi.md#hive_upgrade_metastore_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveUpgradeMetastore | Upgrade Hive Metastore as part of a major version upgrade.
*ServicesResourceApi* | [**hive_validate_metastore_schema_command**](docs/ServicesResourceApi.md#hive_validate_metastore_schema_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hiveValidateMetastoreSchema | Validate the Hive Metastore Schema.
*ServicesResourceApi* | [**hue_dump_db_command**](docs/ServicesResourceApi.md#hue_dump_db_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hueDumpDb | Runs Hue&#39;s dumpdata command.
*ServicesResourceApi* | [**hue_load_db_command**](docs/ServicesResourceApi.md#hue_load_db_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hueLoadDb | Runs Hue&#39;s loaddata command.
*ServicesResourceApi* | [**hue_sync_db_command**](docs/ServicesResourceApi.md#hue_sync_db_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/hueSyncDb | Runs Hue&#39;s syncdb command.
*ServicesResourceApi* | [**impala_create_catalog_database_command**](docs/ServicesResourceApi.md#impala_create_catalog_database_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/impalaCreateCatalogDatabase | .
*ServicesResourceApi* | [**impala_create_catalog_database_tables_command**](docs/ServicesResourceApi.md#impala_create_catalog_database_tables_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/impalaCreateCatalogDatabaseTables | .
*ServicesResourceApi* | [**import_mr_configs_into_yarn**](docs/ServicesResourceApi.md#import_mr_configs_into_yarn) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/importMrConfigsIntoYarn | Import MapReduce configuration into Yarn, overwriting Yarn configuration.
*ServicesResourceApi* | [**init_solr_command**](docs/ServicesResourceApi.md#init_solr_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/initSolr | Initializes the Solr service in Zookeeper.
*ServicesResourceApi* | [**install_mr_framework_jars**](docs/ServicesResourceApi.md#install_mr_framework_jars) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/installMrFrameworkJars | Creates an HDFS directory to hold the MapReduce2 framework JARs (if necessary), and uploads the framework JARs to it.
*ServicesResourceApi* | [**install_oozie_share_lib**](docs/ServicesResourceApi.md#install_oozie_share_lib) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/installOozieShareLib | Creates directory for Oozie user in HDFS and installs the ShareLib in it.
*ServicesResourceApi* | [**ks_migrate_to_sentry**](docs/ServicesResourceApi.md#ks_migrate_to_sentry) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/migrateToSentry | Migrates the HBase Indexer policy-based permissions to Sentry, by invoking the SentryConfigToolIndexer.
*ServicesResourceApi* | [**list_active_commands**](docs/ServicesResourceApi.md#list_active_commands) | **GET** /clusters/{clusterName}/services/{serviceName}/commands | List active service commands.
*ServicesResourceApi* | [**list_role_types**](docs/ServicesResourceApi.md#list_role_types) | **GET** /clusters/{clusterName}/services/{serviceName}/roleTypes | List the supported role types for a service.
*ServicesResourceApi* | [**list_service_commands**](docs/ServicesResourceApi.md#list_service_commands) | **GET** /clusters/{clusterName}/services/{serviceName}/commandsByName | Lists all the commands that can be executed by name on the provided service.
*ServicesResourceApi* | [**offline_command**](docs/ServicesResourceApi.md#offline_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/offline | Offline roles of a service.
*ServicesResourceApi* | [**oozie_create_embedded_database_command**](docs/ServicesResourceApi.md#oozie_create_embedded_database_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/oozieCreateEmbeddedDatabase | Create the Oozie Server Database.
*ServicesResourceApi* | [**oozie_dump_database_command**](docs/ServicesResourceApi.md#oozie_dump_database_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/oozieDumpDatabase | Dump the Oozie Server Database.
*ServicesResourceApi* | [**oozie_load_database_command**](docs/ServicesResourceApi.md#oozie_load_database_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/oozieLoadDatabase | Load the Oozie Server Database from dump.
*ServicesResourceApi* | [**oozie_upgrade_db_command**](docs/ServicesResourceApi.md#oozie_upgrade_db_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/oozieUpgradeDb | Upgrade Oozie Database schema as part of a major version upgrade.
*ServicesResourceApi* | [**read_service**](docs/ServicesResourceApi.md#read_service) | **GET** /clusters/{clusterName}/services/{serviceName} | Retrieves details information about a service.
*ServicesResourceApi* | [**read_service_config**](docs/ServicesResourceApi.md#read_service_config) | **GET** /clusters/{clusterName}/services/{serviceName}/config | Retrieves the configuration of a specific service.
*ServicesResourceApi* | [**read_services**](docs/ServicesResourceApi.md#read_services) | **GET** /clusters/{clusterName}/services | Lists all services registered in the cluster.
*ServicesResourceApi* | [**read_tags**](docs/ServicesResourceApi.md#read_tags) | **GET** /clusters/{clusterName}/services/{serviceName}/tags | Returns the tags associated with this service.
*ServicesResourceApi* | [**recommission_command**](docs/ServicesResourceApi.md#recommission_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/recommission | Recommission roles of a service.
*ServicesResourceApi* | [**recommission_with_start_command**](docs/ServicesResourceApi.md#recommission_with_start_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/recommissionWithStart | Start and recommission roles of a service.
*ServicesResourceApi* | [**restart_command**](docs/ServicesResourceApi.md#restart_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/restart | Restart the service.
*ServicesResourceApi* | [**rolling_restart**](docs/ServicesResourceApi.md#rolling_restart) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/rollingRestart | Command to run rolling restart of roles in a service.
*ServicesResourceApi* | [**sentry_create_database_command**](docs/ServicesResourceApi.md#sentry_create_database_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/sentryCreateDatabase | Create the Sentry Server Database.
*ServicesResourceApi* | [**sentry_create_database_tables_command**](docs/ServicesResourceApi.md#sentry_create_database_tables_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/sentryCreateDatabaseTables | Create the Sentry Server Database tables.
*ServicesResourceApi* | [**sentry_upgrade_database_tables_command**](docs/ServicesResourceApi.md#sentry_upgrade_database_tables_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/sentryUpgradeDatabaseTables | Upgrade the Sentry Server Database tables.
*ServicesResourceApi* | [**service_command_by_name**](docs/ServicesResourceApi.md#service_command_by_name) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/{commandName} | Executes a command on the service specified by name.
*ServicesResourceApi* | [**solr_bootstrap_collections_command**](docs/ServicesResourceApi.md#solr_bootstrap_collections_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/solrBootstrapCollections | Bootstraps Solr Collections after the CDH upgrade.
*ServicesResourceApi* | [**solr_bootstrap_config_command**](docs/ServicesResourceApi.md#solr_bootstrap_config_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/solrBootstrapConfig | Bootstraps Solr config during the CDH upgrade.
*ServicesResourceApi* | [**solr_config_backup_command**](docs/ServicesResourceApi.md#solr_config_backup_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/solrConfigBackup | Backs up Solr configuration metadata before CDH upgrade.
*ServicesResourceApi* | [**solr_migrate_sentry_privileges_command**](docs/ServicesResourceApi.md#solr_migrate_sentry_privileges_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/solrMigrateSentryPrivilegesCommand | Migrates Sentry privileges to new model compatible to support more granular permissions if Solr is configured with a Sentry service.
*ServicesResourceApi* | [**solr_reinitialize_state_for_upgrade_command**](docs/ServicesResourceApi.md#solr_reinitialize_state_for_upgrade_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/solrReinitializeStateForUpgrade | Reinitializes the Solr state by clearing the Solr HDFS data directory, the Solr data directory, and the Zookeeper state.
*ServicesResourceApi* | [**solr_validate_metadata_command**](docs/ServicesResourceApi.md#solr_validate_metadata_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/solrValidateMetadata | Validates Solr metadata and configurations.
*ServicesResourceApi* | [**sqoop_create_database_tables_command**](docs/ServicesResourceApi.md#sqoop_create_database_tables_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/sqoopCreateDatabaseTables | Create the Sqoop2 Server Database tables.
*ServicesResourceApi* | [**sqoop_upgrade_db_command**](docs/ServicesResourceApi.md#sqoop_upgrade_db_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/sqoopUpgradeDb | Upgrade Sqoop Database schema as part of a major version upgrade.
*ServicesResourceApi* | [**start_command**](docs/ServicesResourceApi.md#start_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/start | Start the service.
*ServicesResourceApi* | [**stop_command**](docs/ServicesResourceApi.md#stop_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/stop | Stop the service.
*ServicesResourceApi* | [**switch_to_mr2**](docs/ServicesResourceApi.md#switch_to_mr2) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/switchToMr2 | Change the cluster to use MR2 instead of MR1.
*ServicesResourceApi* | [**update_service**](docs/ServicesResourceApi.md#update_service) | **PUT** /clusters/{clusterName}/services/{serviceName} | Updates service information.
*ServicesResourceApi* | [**update_service_config**](docs/ServicesResourceApi.md#update_service_config) | **PUT** /clusters/{clusterName}/services/{serviceName}/config | Updates the service configuration with the given values.
*ServicesResourceApi* | [**yarn_format_state_store**](docs/ServicesResourceApi.md#yarn_format_state_store) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/yarnFormatStateStore | Formats the state store in ZooKeeper used for Resource Manager High Availability.
*ServicesResourceApi* | [**zoo_keeper_cleanup_command**](docs/ServicesResourceApi.md#zoo_keeper_cleanup_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/zooKeeperCleanup | Clean up all running server instances of a ZooKeeper service.
*ServicesResourceApi* | [**zoo_keeper_init_command**](docs/ServicesResourceApi.md#zoo_keeper_init_command) | **POST** /clusters/{clusterName}/services/{serviceName}/commands/zooKeeperInit | Initializes all the server instances of a ZooKeeper service.
*SnapshotsResourceApi* | [**adhoc_snapshot**](docs/SnapshotsResourceApi.md#adhoc_snapshot) | **POST** /clusters/{clusterName}/services/{serviceName}/snapshots | Creates one or more snapshot policies.
*SnapshotsResourceApi* | [**create_policies**](docs/SnapshotsResourceApi.md#create_policies) | **POST** /clusters/{clusterName}/services/{serviceName}/snapshots/policies | Creates one or more snapshot policies.
*SnapshotsResourceApi* | [**delete_policy**](docs/SnapshotsResourceApi.md#delete_policy) | **DELETE** /clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName} | Deletes an existing snapshot policy.
*SnapshotsResourceApi* | [**read_history**](docs/SnapshotsResourceApi.md#read_history) | **GET** /clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName}/history | Returns a list of commands triggered by a snapshot policy.
*SnapshotsResourceApi* | [**read_policies**](docs/SnapshotsResourceApi.md#read_policies) | **GET** /clusters/{clusterName}/services/{serviceName}/snapshots/policies | Returns information for all snapshot policies.
*SnapshotsResourceApi* | [**read_policy**](docs/SnapshotsResourceApi.md#read_policy) | **GET** /clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName} | Returns information for a specific snapshot policy.
*SnapshotsResourceApi* | [**update_policy**](docs/SnapshotsResourceApi.md#update_policy) | **PUT** /clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName} | Updates an existing snapshot policy.
*TagsResourceApi* | [**get_tags**](docs/TagsResourceApi.md#get_tags) | **GET** /tags | Current CM entities and their tags.
*TagsResourceApi* | [**read_tags_by_name**](docs/TagsResourceApi.md#read_tags_by_name) | **GET** /tags/{tagName} | Get Entities given the Tag name, grouped by entity type.
*TimeSeriesResourceApi* | [**get_entity_type_attributes**](docs/TimeSeriesResourceApi.md#get_entity_type_attributes) | **GET** /timeseries/entityTypeAttributes | Retrieve all metric entity type attributes monitored by Cloudera Manager.
*TimeSeriesResourceApi* | [**get_entity_types**](docs/TimeSeriesResourceApi.md#get_entity_types) | **GET** /timeseries/entityTypes | Retrieve all metric entity types monitored by Cloudera Manager.
*TimeSeriesResourceApi* | [**get_metric_schema**](docs/TimeSeriesResourceApi.md#get_metric_schema) | **GET** /timeseries/schema | Retrieve schema for all metrics.
*TimeSeriesResourceApi* | [**query_time_series**](docs/TimeSeriesResourceApi.md#query_time_series) | **GET** /timeseries | Retrieve time-series data from the Cloudera Manager (CM) time-series data store using a tsquery.
*TimeSeriesResourceApi* | [**query_time_series_0**](docs/TimeSeriesResourceApi.md#query_time_series_0) | **POST** /timeseries | Retrieve time-series data from the Cloudera Manager (CM) time-series data store accepting HTTP POST request.
*ToolsResourceApi* | [**echo**](docs/ToolsResourceApi.md#echo) | **GET** /tools/echo | Echoes the provided message back to the caller.
*ToolsResourceApi* | [**echo_error**](docs/ToolsResourceApi.md#echo_error) | **GET** /tools/echoError | Throws an error containing the given input message.
*UsersResourceApi* | [**create_users2**](docs/UsersResourceApi.md#create_users2) | **POST** /users | Creates a list of users.
*UsersResourceApi* | [**delete_user2**](docs/UsersResourceApi.md#delete_user2) | **DELETE** /users/{userName} | Deletes a user from the system.
*UsersResourceApi* | [**expire_sessions**](docs/UsersResourceApi.md#expire_sessions) | **POST** /users/expireSessions/{userName} | Expires the sessions associated with interactive authenticated user in Cloudera Manager.
*UsersResourceApi* | [**get_sessions**](docs/UsersResourceApi.md#get_sessions) | **GET** /users/sessions | Return a list of the sessions associated with interactive authenticated users in Cloudera Manager.
*UsersResourceApi* | [**read_user2**](docs/UsersResourceApi.md#read_user2) | **GET** /users/{userName} | Returns detailed information about a user.
*UsersResourceApi* | [**read_users2**](docs/UsersResourceApi.md#read_users2) | **GET** /users | Returns a list of the user names configured in the system.
*UsersResourceApi* | [**update_user2**](docs/UsersResourceApi.md#update_user2) | **PUT** /users/{userName} | Updates the given user&#39;s information.
*WatchedDirResourceApi* | [**add_watched_directory**](docs/WatchedDirResourceApi.md#add_watched_directory) | **POST** /clusters/{clusterName}/services/{serviceName}/watcheddir | Adds a directory to the watching list.
*WatchedDirResourceApi* | [**list_watched_directories**](docs/WatchedDirResourceApi.md#list_watched_directories) | **GET** /clusters/{clusterName}/services/{serviceName}/watcheddir | Lists all the watched directories.
*WatchedDirResourceApi* | [**remove_watched_directory**](docs/WatchedDirResourceApi.md#remove_watched_directory) | **DELETE** /clusters/{clusterName}/services/{serviceName}/watcheddir/{directoryPath} | Removes a directory from the watching list.
*YarnApplicationsResourceApi* | [**get_yarn_application_attributes**](docs/YarnApplicationsResourceApi.md#get_yarn_application_attributes) | **GET** /clusters/{clusterName}/services/{serviceName}/yarnApplications/attributes | Returns the list of all attributes that the Service Monitor can associate with YARN applications.
*YarnApplicationsResourceApi* | [**get_yarn_applications**](docs/YarnApplicationsResourceApi.md#get_yarn_applications) | **GET** /clusters/{clusterName}/services/{serviceName}/yarnApplications | Returns a list of applications that satisfy the filter.
*YarnApplicationsResourceApi* | [**kill_yarn_application**](docs/YarnApplicationsResourceApi.md#kill_yarn_application) | **POST** /clusters/{clusterName}/services/{serviceName}/yarnApplications/{applicationId}/kill | Kills an YARN Application.


## Documentation For Models

 - [ApiActivity](docs/ApiActivity.md)
 - [ApiActivityStatus](docs/ApiActivityStatus.md)
 - [ApiActivityType](docs/ApiActivityType.md)
 - [ApiAddCustomCertsArguments](docs/ApiAddCustomCertsArguments.md)
 - [ApiAdhocHBaseSnapshot](docs/ApiAdhocHBaseSnapshot.md)
 - [ApiAdhocSnapshot](docs/ApiAdhocSnapshot.md)
 - [ApiAudit](docs/ApiAudit.md)
 - [ApiAuthRole](docs/ApiAuthRole.md)
 - [ApiAuthRoleAuthority](docs/ApiAuthRoleAuthority.md)
 - [ApiAuthRoleMetadata](docs/ApiAuthRoleMetadata.md)
 - [ApiAuthRoleRef](docs/ApiAuthRoleRef.md)
 - [ApiBatchRequestElement](docs/ApiBatchRequestElement.md)
 - [ApiBatchResponseElement](docs/ApiBatchResponseElement.md)
 - [ApiCdhUpgradeArgs](docs/ApiCdhUpgradeArgs.md)
 - [ApiCertificateRequest](docs/ApiCertificateRequest.md)
 - [ApiCluster](docs/ApiCluster.md)
 - [ApiClusterPerfInspectorArgs](docs/ApiClusterPerfInspectorArgs.md)
 - [ApiClusterRef](docs/ApiClusterRef.md)
 - [ApiClusterTemplate](docs/ApiClusterTemplate.md)
 - [ApiClusterTemplateClusterSpec](docs/ApiClusterTemplateClusterSpec.md)
 - [ApiClusterTemplateConfig](docs/ApiClusterTemplateConfig.md)
 - [ApiClusterTemplateHostInfo](docs/ApiClusterTemplateHostInfo.md)
 - [ApiClusterTemplateHostTemplate](docs/ApiClusterTemplateHostTemplate.md)
 - [ApiClusterTemplateInstantiator](docs/ApiClusterTemplateInstantiator.md)
 - [ApiClusterTemplateRole](docs/ApiClusterTemplateRole.md)
 - [ApiClusterTemplateRoleConfigGroup](docs/ApiClusterTemplateRoleConfigGroup.md)
 - [ApiClusterTemplateRoleConfigGroupInfo](docs/ApiClusterTemplateRoleConfigGroupInfo.md)
 - [ApiClusterTemplateService](docs/ApiClusterTemplateService.md)
 - [ApiClusterTemplateVariable](docs/ApiClusterTemplateVariable.md)
 - [ApiClusterUtilization](docs/ApiClusterUtilization.md)
 - [ApiClusterVersion](docs/ApiClusterVersion.md)
 - [ApiClustersPerfInspectorArgs](docs/ApiClustersPerfInspectorArgs.md)
 - [ApiCmPeer](docs/ApiCmPeer.md)
 - [ApiCmPeerType](docs/ApiCmPeerType.md)
 - [ApiCmServer](docs/ApiCmServer.md)
 - [ApiCollectDiagnosticDataArguments](docs/ApiCollectDiagnosticDataArguments.md)
 - [ApiCommand](docs/ApiCommand.md)
 - [ApiCommandMetadata](docs/ApiCommandMetadata.md)
 - [ApiCommissionState](docs/ApiCommissionState.md)
 - [ApiComponentInfo](docs/ApiComponentInfo.md)
 - [ApiConfig](docs/ApiConfig.md)
 - [ApiConfigStalenessStatus](docs/ApiConfigStalenessStatus.md)
 - [ApiConfigureForKerberosArguments](docs/ApiConfigureForKerberosArguments.md)
 - [ApiControlPlane](docs/ApiControlPlane.md)
 - [ApiCreateEnvironment](docs/ApiCreateEnvironment.md)
 - [ApiCspArguments](docs/ApiCspArguments.md)
 - [ApiDashboard](docs/ApiDashboard.md)
 - [ApiDataContext](docs/ApiDataContext.md)
 - [ApiDataContextRef](docs/ApiDataContextRef.md)
 - [ApiDeployment](docs/ApiDeployment.md)
 - [ApiDeployment2](docs/ApiDeployment2.md)
 - [ApiDisableJtHaArguments](docs/ApiDisableJtHaArguments.md)
 - [ApiDisableLlamaHaArguments](docs/ApiDisableLlamaHaArguments.md)
 - [ApiDisableNnHaArguments](docs/ApiDisableNnHaArguments.md)
 - [ApiDisableOozieHaArguments](docs/ApiDisableOozieHaArguments.md)
 - [ApiDisableRmHaArguments](docs/ApiDisableRmHaArguments.md)
 - [ApiDisableSentryHaArgs](docs/ApiDisableSentryHaArgs.md)
 - [ApiEcho](docs/ApiEcho.md)
 - [ApiEnableJtHaArguments](docs/ApiEnableJtHaArguments.md)
 - [ApiEnableLlamaHaArguments](docs/ApiEnableLlamaHaArguments.md)
 - [ApiEnableLlamaRmArguments](docs/ApiEnableLlamaRmArguments.md)
 - [ApiEnableNnHaArguments](docs/ApiEnableNnHaArguments.md)
 - [ApiEnableOozieHaArguments](docs/ApiEnableOozieHaArguments.md)
 - [ApiEnableRmHaArguments](docs/ApiEnableRmHaArguments.md)
 - [ApiEnableSentryHaArgs](docs/ApiEnableSentryHaArgs.md)
 - [ApiEndPoint](docs/ApiEndPoint.md)
 - [ApiEndPointHost](docs/ApiEndPointHost.md)
 - [ApiEntityStatus](docs/ApiEntityStatus.md)
 - [ApiEntityTag](docs/ApiEntityTag.md)
 - [ApiEntityType](docs/ApiEntityType.md)
 - [ApiEvent](docs/ApiEvent.md)
 - [ApiEventAttribute](docs/ApiEventAttribute.md)
 - [ApiEventCategory](docs/ApiEventCategory.md)
 - [ApiEventSeverity](docs/ApiEventSeverity.md)
 - [ApiExternalAccount](docs/ApiExternalAccount.md)
 - [ApiExternalAccountCategory](docs/ApiExternalAccountCategory.md)
 - [ApiExternalAccountType](docs/ApiExternalAccountType.md)
 - [ApiExternalUserMapping](docs/ApiExternalUserMapping.md)
 - [ApiExternalUserMappingRef](docs/ApiExternalUserMappingRef.md)
 - [ApiExternalUserMappingType](docs/ApiExternalUserMappingType.md)
 - [ApiGenerateCopyDockerArgs](docs/ApiGenerateCopyDockerArgs.md)
 - [ApiGenerateExternalVaultSetupArgs](docs/ApiGenerateExternalVaultSetupArgs.md)
 - [ApiHBaseReplicationArguments](docs/ApiHBaseReplicationArguments.md)
 - [ApiHBaseReplicationInfo](docs/ApiHBaseReplicationInfo.md)
 - [ApiHBaseReplicationSecurityTool](docs/ApiHBaseReplicationSecurityTool.md)
 - [ApiHBaseReplicationSetupCommandArgs](docs/ApiHBaseReplicationSetupCommandArgs.md)
 - [ApiHBaseReplicationSetupStatus](docs/ApiHBaseReplicationSetupStatus.md)
 - [ApiHBaseShellCommand](docs/ApiHBaseShellCommand.md)
 - [ApiHBaseSnapshot](docs/ApiHBaseSnapshot.md)
 - [ApiHBaseSnapshotError](docs/ApiHBaseSnapshotError.md)
 - [ApiHBaseSnapshotPolicyArguments](docs/ApiHBaseSnapshotPolicyArguments.md)
 - [ApiHBaseSnapshotResult](docs/ApiHBaseSnapshotResult.md)
 - [ApiHdfsDisableHaArguments](docs/ApiHdfsDisableHaArguments.md)
 - [ApiHdfsFailoverArguments](docs/ApiHdfsFailoverArguments.md)
 - [ApiHdfsHaArguments](docs/ApiHdfsHaArguments.md)
 - [ApiHdfsReplicationArguments](docs/ApiHdfsReplicationArguments.md)
 - [ApiHdfsReplicationCounter](docs/ApiHdfsReplicationCounter.md)
 - [ApiHdfsReplicationResult](docs/ApiHdfsReplicationResult.md)
 - [ApiHdfsSnapshot](docs/ApiHdfsSnapshot.md)
 - [ApiHdfsSnapshotError](docs/ApiHdfsSnapshotError.md)
 - [ApiHdfsSnapshotPolicyArguments](docs/ApiHdfsSnapshotPolicyArguments.md)
 - [ApiHdfsSnapshotResult](docs/ApiHdfsSnapshotResult.md)
 - [ApiHdfsUsageReportRow](docs/ApiHdfsUsageReportRow.md)
 - [ApiHealthCheck](docs/ApiHealthCheck.md)
 - [ApiHealthSummary](docs/ApiHealthSummary.md)
 - [ApiHive3ReplicationArguments](docs/ApiHive3ReplicationArguments.md)
 - [ApiHive3ReplicationMetric](docs/ApiHive3ReplicationMetric.md)
 - [ApiHive3ReplicationMetricsMetadata](docs/ApiHive3ReplicationMetricsMetadata.md)
 - [ApiHive3ReplicationMetricsProgress](docs/ApiHive3ReplicationMetricsProgress.md)
 - [ApiHive3ReplicationMetricsResultRow](docs/ApiHive3ReplicationMetricsResultRow.md)
 - [ApiHive3ReplicationMetricsStage](docs/ApiHive3ReplicationMetricsStage.md)
 - [ApiHive3ReplicationMetricsStatus](docs/ApiHive3ReplicationMetricsStatus.md)
 - [ApiHive3ReplicationQueryResultRow](docs/ApiHive3ReplicationQueryResultRow.md)
 - [ApiHive3ReplicationScheduledExecutionsResultRow](docs/ApiHive3ReplicationScheduledExecutionsResultRow.md)
 - [ApiHive3ReplicationScheduledQueriesResultRow](docs/ApiHive3ReplicationScheduledQueriesResultRow.md)
 - [ApiHiveOnTezReplicationResult](docs/ApiHiveOnTezReplicationResult.md)
 - [ApiHiveReplicationArguments](docs/ApiHiveReplicationArguments.md)
 - [ApiHiveReplicationError](docs/ApiHiveReplicationError.md)
 - [ApiHiveReplicationResult](docs/ApiHiveReplicationResult.md)
 - [ApiHiveTable](docs/ApiHiveTable.md)
 - [ApiHiveUDF](docs/ApiHiveUDF.md)
 - [ApiHost](docs/ApiHost.md)
 - [ApiHostCertInfo](docs/ApiHostCertInfo.md)
 - [ApiHostInstallArguments](docs/ApiHostInstallArguments.md)
 - [ApiHostRef](docs/ApiHostRef.md)
 - [ApiHostTemplate](docs/ApiHostTemplate.md)
 - [ApiHostsPerfInspectorArgs](docs/ApiHostsPerfInspectorArgs.md)
 - [ApiHostsToRemoveArgs](docs/ApiHostsToRemoveArgs.md)
 - [ApiImpalaCancelResponse](docs/ApiImpalaCancelResponse.md)
 - [ApiImpalaQuery](docs/ApiImpalaQuery.md)
 - [ApiImpalaQueryAttribute](docs/ApiImpalaQueryAttribute.md)
 - [ApiImpalaQueryDetailsResponse](docs/ApiImpalaQueryDetailsResponse.md)
 - [ApiImpalaQueryResponse](docs/ApiImpalaQueryResponse.md)
 - [ApiImpalaRoleDiagnosticsArgs](docs/ApiImpalaRoleDiagnosticsArgs.md)
 - [ApiImpalaTenantUtilization](docs/ApiImpalaTenantUtilization.md)
 - [ApiImpalaUDF](docs/ApiImpalaUDF.md)
 - [ApiImpalaUtilization](docs/ApiImpalaUtilization.md)
 - [ApiImpalaUtilizationHistogram](docs/ApiImpalaUtilizationHistogram.md)
 - [ApiImpalaUtilizationHistogramBin](docs/ApiImpalaUtilizationHistogramBin.md)
 - [ApiInstallControlPlaneArgs](docs/ApiInstallControlPlaneArgs.md)
 - [ApiInstallEmbeddedControlPlaneArgs](docs/ApiInstallEmbeddedControlPlaneArgs.md)
 - [ApiJournalNodeArguments](docs/ApiJournalNodeArguments.md)
 - [ApiKerberosInfo](docs/ApiKerberosInfo.md)
 - [ApiLicense](docs/ApiLicense.md)
 - [ApiLicenseFeature](docs/ApiLicenseFeature.md)
 - [ApiLicensedFeatureUsage](docs/ApiLicensedFeatureUsage.md)
 - [ApiListBase](docs/ApiListBase.md)
 - [ApiMapEntry](docs/ApiMapEntry.md)
 - [ApiMapEntryOfHostNameList](docs/ApiMapEntryOfHostNameList.md)
 - [ApiMetric](docs/ApiMetric.md)
 - [ApiMetricData](docs/ApiMetricData.md)
 - [ApiMetricSchema](docs/ApiMetricSchema.md)
 - [ApiMigrateRolesArguments](docs/ApiMigrateRolesArguments.md)
 - [ApiMr2AppInformation](docs/ApiMr2AppInformation.md)
 - [ApiMrUsageReportRow](docs/ApiMrUsageReportRow.md)
 - [ApiNameservice](docs/ApiNameservice.md)
 - [ApiOsDistribution](docs/ApiOsDistribution.md)
 - [ApiOsDistributionType](docs/ApiOsDistributionType.md)
 - [ApiOzoneS3GatewayInfo](docs/ApiOzoneS3GatewayInfo.md)
 - [ApiParcel](docs/ApiParcel.md)
 - [ApiParcelRef](docs/ApiParcelRef.md)
 - [ApiParcelState](docs/ApiParcelState.md)
 - [ApiParcelUsage](docs/ApiParcelUsage.md)
 - [ApiParcelUsageHost](docs/ApiParcelUsageHost.md)
 - [ApiParcelUsageParcel](docs/ApiParcelUsageParcel.md)
 - [ApiParcelUsageRack](docs/ApiParcelUsageRack.md)
 - [ApiParcelUsageRole](docs/ApiParcelUsageRole.md)
 - [ApiPerfInspectorBandwidthArgs](docs/ApiPerfInspectorBandwidthArgs.md)
 - [ApiPerfInspectorPingArgs](docs/ApiPerfInspectorPingArgs.md)
 - [ApiProcess](docs/ApiProcess.md)
 - [ApiProductVersion](docs/ApiProductVersion.md)
 - [ApiRemoteDataContext](docs/ApiRemoteDataContext.md)
 - [ApiRemoteRepoUrl](docs/ApiRemoteRepoUrl.md)
 - [ApiReplicationDiagnosticsCollectionArgs](docs/ApiReplicationDiagnosticsCollectionArgs.md)
 - [ApiReplicationState](docs/ApiReplicationState.md)
 - [ApiRestartClusterArgs](docs/ApiRestartClusterArgs.md)
 - [ApiRole](docs/ApiRole.md)
 - [ApiRoleConfigGroup](docs/ApiRoleConfigGroup.md)
 - [ApiRoleConfigGroupRef](docs/ApiRoleConfigGroupRef.md)
 - [ApiRoleRef](docs/ApiRoleRef.md)
 - [ApiRoleState](docs/ApiRoleState.md)
 - [ApiRolesToInclude](docs/ApiRolesToInclude.md)
 - [ApiRollEditsArgs](docs/ApiRollEditsArgs.md)
 - [ApiRollingRestartArgs](docs/ApiRollingRestartArgs.md)
 - [ApiRollingRestartClusterArgs](docs/ApiRollingRestartClusterArgs.md)
 - [ApiRollingUpgradeClusterArgs](docs/ApiRollingUpgradeClusterArgs.md)
 - [ApiRollingUpgradeServicesArgs](docs/ApiRollingUpgradeServicesArgs.md)
 - [ApiSchedule](docs/ApiSchedule.md)
 - [ApiScheduleInterval](docs/ApiScheduleInterval.md)
 - [ApiScmDbInfo](docs/ApiScmDbInfo.md)
 - [ApiService](docs/ApiService.md)
 - [ApiServiceRef](docs/ApiServiceRef.md)
 - [ApiServiceState](docs/ApiServiceState.md)
 - [ApiShutdownReadiness](docs/ApiShutdownReadiness.md)
 - [ApiSimpleRollingRestartClusterArgs](docs/ApiSimpleRollingRestartClusterArgs.md)
 - [ApiSnapshotPolicy](docs/ApiSnapshotPolicy.md)
 - [ApiTagToEntities](docs/ApiTagToEntities.md)
 - [ApiTenantUtilization](docs/ApiTenantUtilization.md)
 - [ApiTestCmExternalAuthArguments](docs/ApiTestCmExternalAuthArguments.md)
 - [ApiTimeSeries](docs/ApiTimeSeries.md)
 - [ApiTimeSeriesAggregateStatistics](docs/ApiTimeSeriesAggregateStatistics.md)
 - [ApiTimeSeriesCrossEntityMetadata](docs/ApiTimeSeriesCrossEntityMetadata.md)
 - [ApiTimeSeriesData](docs/ApiTimeSeriesData.md)
 - [ApiTimeSeriesEntityAttribute](docs/ApiTimeSeriesEntityAttribute.md)
 - [ApiTimeSeriesEntityType](docs/ApiTimeSeriesEntityType.md)
 - [ApiTimeSeriesMetadata](docs/ApiTimeSeriesMetadata.md)
 - [ApiTimeSeriesRequest](docs/ApiTimeSeriesRequest.md)
 - [ApiTimeSeriesResponse](docs/ApiTimeSeriesResponse.md)
 - [ApiUninstallControlPlaneArgs](docs/ApiUninstallControlPlaneArgs.md)
 - [ApiUpdateControlPlaneValuesYamlArgs](docs/ApiUpdateControlPlaneValuesYamlArgs.md)
 - [ApiUpgradeControlPlaneArgs](docs/ApiUpgradeControlPlaneArgs.md)
 - [ApiUpgradeEmbeddedControlPlaneArgs](docs/ApiUpgradeEmbeddedControlPlaneArgs.md)
 - [ApiUser](docs/ApiUser.md)
 - [ApiUser2](docs/ApiUser2.md)
 - [ApiUser2Ref](docs/ApiUser2Ref.md)
 - [ApiUserSession](docs/ApiUserSession.md)
 - [ApiVersionInfo](docs/ApiVersionInfo.md)
 - [ApiWatchedDir](docs/ApiWatchedDir.md)
 - [ApiYarnApplication](docs/ApiYarnApplication.md)
 - [ApiYarnApplicationAttribute](docs/ApiYarnApplicationAttribute.md)
 - [ApiYarnApplicationDiagnosticsCollectionArgs](docs/ApiYarnApplicationDiagnosticsCollectionArgs.md)
 - [ApiYarnApplicationResponse](docs/ApiYarnApplicationResponse.md)
 - [ApiYarnKillResponse](docs/ApiYarnKillResponse.md)
 - [ApiYarnTenantUtilization](docs/ApiYarnTenantUtilization.md)
 - [ApiYarnUtilization](docs/ApiYarnUtilization.md)
 - [BaseApiSshCmdArguments](docs/BaseApiSshCmdArguments.md)
 - [HBasePeerState](docs/HBasePeerState.md)
 - [HBaseTableArgs](docs/HBaseTableArgs.md)
 - [HTTPMethod](docs/HTTPMethod.md)
 - [HaStatus](docs/HaStatus.md)
 - [Origin](docs/Origin.md)
 - [PerfInspectorPolicyType](docs/PerfInspectorPolicyType.md)
 - [PolicyStatus](docs/PolicyStatus.md)
 - [ReplicationOption](docs/ReplicationOption.md)
 - [ReplicationStrategy](docs/ReplicationStrategy.md)
 - [ReplicationType](docs/ReplicationType.md)
 - [ScmDbType](docs/ScmDbType.md)
 - [ShutdownReadinessState](docs/ShutdownReadinessState.md)
 - [Status](docs/Status.md)
 - [Storage](docs/Storage.md)
 - [StreamingOutput](docs/StreamingOutput.md)
 - [SubStatus](docs/SubStatus.md)
 - [ValidationState](docs/ValidationState.md)
 - [ZooKeeperServerMode](docs/ZooKeeperServerMode.md)
 - [ApiActivityList](docs/ApiActivityList.md)
 - [ApiAuditList](docs/ApiAuditList.md)
 - [ApiAuthRoleList](docs/ApiAuthRoleList.md)
 - [ApiAuthRoleMetadataList](docs/ApiAuthRoleMetadataList.md)
 - [ApiBatchRequest](docs/ApiBatchRequest.md)
 - [ApiBatchResponse](docs/ApiBatchResponse.md)
 - [ApiClusterList](docs/ApiClusterList.md)
 - [ApiClusterNameList](docs/ApiClusterNameList.md)
 - [ApiCmPeerList](docs/ApiCmPeerList.md)
 - [ApiCmServerList](docs/ApiCmServerList.md)
 - [ApiCommandList](docs/ApiCommandList.md)
 - [ApiCommandMetadataList](docs/ApiCommandMetadataList.md)
 - [ApiConfigList](docs/ApiConfigList.md)
 - [ApiControlPlaneList](docs/ApiControlPlaneList.md)
 - [ApiDashboardList](docs/ApiDashboardList.md)
 - [ApiDataContextList](docs/ApiDataContextList.md)
 - [ApiEventQueryResult](docs/ApiEventQueryResult.md)
 - [ApiExternalAccountCategoryList](docs/ApiExternalAccountCategoryList.md)
 - [ApiExternalAccountList](docs/ApiExternalAccountList.md)
 - [ApiExternalAccountTypeList](docs/ApiExternalAccountTypeList.md)
 - [ApiExternalUserMappingList](docs/ApiExternalUserMappingList.md)
 - [ApiGenerateCmcaArguments](docs/ApiGenerateCmcaArguments.md)
 - [ApiGenerateHostCertsArguments](docs/ApiGenerateHostCertsArguments.md)
 - [ApiHdfsCloudReplicationArguments](docs/ApiHdfsCloudReplicationArguments.md)
 - [ApiHdfsUpgradeDomainList](docs/ApiHdfsUpgradeDomainList.md)
 - [ApiHdfsUsageReport](docs/ApiHdfsUsageReport.md)
 - [ApiHive3ReplicationQueryResult](docs/ApiHive3ReplicationQueryResult.md)
 - [ApiHiveCloudReplicationArguments](docs/ApiHiveCloudReplicationArguments.md)
 - [ApiHostList](docs/ApiHostList.md)
 - [ApiHostNameList](docs/ApiHostNameList.md)
 - [ApiHostRefList](docs/ApiHostRefList.md)
 - [ApiHostTemplateList](docs/ApiHostTemplateList.md)
 - [ApiImpalaQueryAttributeList](docs/ApiImpalaQueryAttributeList.md)
 - [ApiImpalaTenantUtilizationList](docs/ApiImpalaTenantUtilizationList.md)
 - [ApiImpalaUtilizationHistogramBinList](docs/ApiImpalaUtilizationHistogramBinList.md)
 - [ApiMetricList](docs/ApiMetricList.md)
 - [ApiMetricSchemaList](docs/ApiMetricSchemaList.md)
 - [ApiMrUsageReport](docs/ApiMrUsageReport.md)
 - [ApiNameserviceList](docs/ApiNameserviceList.md)
 - [ApiParcelList](docs/ApiParcelList.md)
 - [ApiPrincipalList](docs/ApiPrincipalList.md)
 - [ApiReplicationCommand](docs/ApiReplicationCommand.md)
 - [ApiReplicationCommandList](docs/ApiReplicationCommandList.md)
 - [ApiReplicationSchedule](docs/ApiReplicationSchedule.md)
 - [ApiReplicationScheduleList](docs/ApiReplicationScheduleList.md)
 - [ApiRoleConfigGroupList](docs/ApiRoleConfigGroupList.md)
 - [ApiRoleList](docs/ApiRoleList.md)
 - [ApiRoleNameList](docs/ApiRoleNameList.md)
 - [ApiRoleTypeList](docs/ApiRoleTypeList.md)
 - [ApiServiceList](docs/ApiServiceList.md)
 - [ApiServiceTypeList](docs/ApiServiceTypeList.md)
 - [ApiSnapshotCommand](docs/ApiSnapshotCommand.md)
 - [ApiSnapshotCommandList](docs/ApiSnapshotCommandList.md)
 - [ApiSnapshotPolicyList](docs/ApiSnapshotPolicyList.md)
 - [ApiTagToEntitiesList](docs/ApiTagToEntitiesList.md)
 - [ApiTenantUtilizationList](docs/ApiTenantUtilizationList.md)
 - [ApiTimeSeriesEntityAttributeList](docs/ApiTimeSeriesEntityAttributeList.md)
 - [ApiTimeSeriesEntityTypeList](docs/ApiTimeSeriesEntityTypeList.md)
 - [ApiTimeSeriesResponseList](docs/ApiTimeSeriesResponseList.md)
 - [ApiUser2List](docs/ApiUser2List.md)
 - [ApiUserList](docs/ApiUserList.md)
 - [ApiUserSessionList](docs/ApiUserSessionList.md)
 - [ApiWatchedDirList](docs/ApiWatchedDirList.md)
 - [ApiYarnApplicationAttributeList](docs/ApiYarnApplicationAttributeList.md)
 - [ApiYarnTenantUtilizationList](docs/ApiYarnTenantUtilizationList.md)
 - [ApiBulkCommandList](docs/ApiBulkCommandList.md)
 - [ApiRoleTypeConfig](docs/ApiRoleTypeConfig.md)
 - [ApiServiceConfig](docs/ApiServiceConfig.md)


## Documentation For Authorization


## basic

- **Type**: HTTP basic authentication


## Author



