"""User-facing functions."""
import numpy as np
from impyrial.utils import check_units
from impyrial.length.core import (
    UNITS,
    inches_to_feet,
    inches_to_yards
)



def convert_unit(x, from_unit, to_unit):
    """Convert from one length unit to another.
    
    Parameters
    ----------
    x : array_like
        Lengths to convert 
    from_unit : {'in', 'ft', 'yd}
        Unit of the input lengths 'x'
    to_unit : {'in', 'ft', 'yd'}
        Unit of the returned lengths
        
    Returns
    -------
    ndarray
        An array of converted lengths with the same shape as 'x'. If 'x' is a
        0-d array, then a scalar is returned.
    """
    
    # check if units are valid length units
    check_units(from_unit, to_unit, UNITS)
    
    # convert length to inches
    if from_unit == "in":
        inches = x
    elif from_unit == "ft":
        inches = inches_to_feet(x, reverse=True)
    elif from_unit == "yd":
        inches = inches_to_yards(x, reverse=True)
        
    # convert inches to desired units
    if to_unit == "in":
        value = inches
    elif to_unit == "ft":
        value = inches_to_feet(inches)
    elif to_unit == "yd":
        value = inches_to_yards(inches)

    return value
