# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2020-03-13 04:31


import course_access_groups.validators
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('course_overviews', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('organizations', '0009_merge_20181113_1517_appsembler'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseAccessGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=32)),
                ('description', models.CharField(blank=True, default='', help_text='An optional description about this group.', max_length=255)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='organizations.Organization')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupCourse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='group_course', to='course_overviews.CourseOverview')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='course_access_groups.CourseAccessGroup')),
            ],
        ),
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('automatic', models.BooleanField(default=False, help_text='If created by MembershipRule')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='course_access_groups.CourseAccessGroup')),
                ('user', models.OneToOneField(help_text='Learner. A learner can only be enrolled in a single Course Access Group.', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MembershipRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(help_text='A description for this assignment rule.', max_length=255)),
                ('domain', models.CharField(db_index=True, help_text='The learner email domain e.g. "example.com".', max_length=255, validators=[course_access_groups.validators.validate_domain])),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='course_access_groups.CourseAccessGroup')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PublicCourse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('course', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='course_overviews.CourseOverview')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterUniqueTogether(
            name='groupcourse',
            unique_together=set([('course', 'group')]),
        ),
    ]
