# PSyclone GOcean Example 1

**Authors:** A. R. Porter, S. Siso and A. B. G. Chalk, STFC Daresbury Lab

These scripts and this version of PSyclone work with version 1.0 of GOcean.

In order to use PSyclone you must first install it, ideally with pip.
See `../../../README.md` for more details.

PSyclone can be run in the directory containing this file by 
executing, e.g.

```sh
python ./runme.py
``` 

Examine the runme*.py scripts themselves for further details or see the
Makefile.


## OpenMP tasking transformation script

The OpenMP tasking transformation is provided in the form of a PSyclone
transformation script (`openmp_taskloop_trans.py`). This can be run
using the PSyclone command:

```sh
psyclone -nodm -s ./openmp_taskloop_trans.py -api gocean1.0 shallow_alg.f90
```

## OpenCL PSyclone script

The OpenCL transformation is provided with a PSyclone transformation script
(`opencl_transformation.py`). This can be run using the PSyclone command:

```sh
psyclone -s ./opencl_transformation.py -api gocean1.0 shallow_alg.f90
```


## Licence

-----------------------------------------------------------------------------

BSD 3-Clause License

Copyright (c) 2017-2021, Science and Technology Facilities Council.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

------------------------------------------------------------------------------
