"""Models to construct xmla responses with Spyne."""


from spyne import ComplexModel, Integer, Unicode, XmlAttribute

# NOTE : I didn't respect python naming convention here
# because we need to create the xmla response (generated by spyne)
# with the same variable names, so xmla requests from excel can be reached.


class Tuple:
    """Tuple description (used by spyne)."""

    def __init__(
        self,
        Hierarchy,
        UName,
        Caption,
        LName,
        LNum,
        DisplayInfo,
        PARENT_UNIQUE_NAME,
        HIERARCHY_UNIQUE_NAME,
        Value,
    ):
        self.hierarchy = Hierarchy
        self.uname = UName
        self.caption = Caption
        self.lname = LName
        self.lnum = LNum
        self.display_info = DisplayInfo
        self.parent_unique_name = PARENT_UNIQUE_NAME
        self.hierarchy_unique_name = HIERARCHY_UNIQUE_NAME
        self.value = Value

    def __str__(self):
        return f"""
        Hierarchy : {self.hierarchy}
        UName : {self.uname}
        Caption : {self.caption}
        LName : {self.lname}
        LNum : {self.lnum}
        DisplayInfo : {self.display_info}
        PARENT_UNIQUE_NAME : {self.parent_unique_name}
        HIERARCHY_UNIQUE_NAME : {self.hierarchy_unique_name}
        Value : {self.value}
        """


class Property(ComplexModel):
    """Property description (used by spyne)."""

    __namespace__ = "urn:schemas-microsoft-com:xml-analysis"
    _type_info = {
        "LocaleIdentifier": Unicode,
        "Format": Unicode,
        "Catalog": Unicode,
        "Content": Unicode,
        "DataSourceInfo": Unicode,
        "Password": Unicode,
        "StateSupport": Unicode,
        "Timeout": Unicode,
        "ProviderVersion": Unicode,
        "BASE_CUBE_NAME": Unicode,
        "AxisFormat": Unicode,
        "BeginRange": Unicode,
        "EndRange": Unicode,
        "MDXSupport": Unicode,
        "ProviderName": Unicode,
        "UserName": Unicode,
    }


class Restriction(ComplexModel):
    """Restriction description (used by spyne)."""

    __namespace__ = "urn:schemas-microsoft-com:xml-analysis"
    _type_info = {
        "CATALOG_NAME": Unicode,
        "SCHEMA_NAME": Unicode,
        "CUBE_NAME": Unicode,
        "MEMBER_UNIQUE_NAME": Unicode,
        "DIMENSION_UNIQUE_NAME": Unicode,
        "HIERARCHY_UNIQUE_NAME": Unicode,
        "LEVEL_UNIQUE_NAME": Unicode,
        "TREE_OP": Integer,
        "PropertyName": Unicode,
        "SchemaName": Unicode,
        "HIERARCHY_VISIBILITY": Integer,
        "MEASURE_VISIBILITY": Integer,
        "PROPERTY_TYPE": Integer,
    }


class Session(ComplexModel):
    """Session description (used by spyne)."""

    __namespace__ = "urn:schemas-microsoft-com:xml-analysis"
    SessionId = XmlAttribute(Unicode)


class Restrictionlist(ComplexModel):
    """Restriction description (used by spyne)."""

    __namespace__ = "urn:schemas-microsoft-com:xml-analysis"
    __type_name__ = "Restrictions"
    RestrictionList = Restriction


class Propertieslist(ComplexModel):
    """Properties description (used by spyne)."""

    __namespace__ = "urn:schemas-microsoft-com:xml-analysis"
    __type_name__ = "Properties"
    PropertyList = Property


class Command(ComplexModel):
    """Command description (used by spyne)."""

    _type_info = {"Statement": Unicode}


class ExecuteRequest(ComplexModel):
    """Execute description (used by spyne)."""

    Command = Command
    Properties = Propertieslist


class DiscoverRequest(ComplexModel):
    """Discover description (used by spyne)."""

    RequestType = Unicode
    Restrictions = Restrictionlist
    Properties = Propertieslist
