#!/usr/bin/env python3

# +------------------------+			   
# | Created with Sailboat  |			   
# |			                   |			   
# | Do not edit this file  |			   
# | directly. Instead  	   |			   
# | you should edit the	   |			   
# | `sailboat.toml` file.  |			   
# +------------------------+	

import setuptools

try:
  with open("README.md", "r") as fh:
	  long_description = fh.read()
except:
	long_description = "# Adicity\nA fixed-arity high level functional programming language engine.\n### Contributors\n- Cole Wilson\n### Contact\n<cole@colewilson.xyz> "

options = {
	"name":"adicity",
	"version":"0.5.0",
	"scripts":[],
	"entry_points":{'console_scripts': ['adicity=adicity.adicity:main']},
	"author":"Cole Wilson",
	"author_email":"cole@colewilson.xyz",
	"description":"A fixed-arity high level functional programming language engine.",
	"long_description":long_description,
	"long_description_content_type":"text/markdown",
	"url":"https://github.com/cole-wilson/adicity",
	"packages":setuptools.find_packages(),
	"install_requires":['main', 'arrays', 'debugger', 'colorama', 'eel', 'typing', 'parse', 'errors', 'datetime', 'logging'],
	"classifiers":["Programming Language :: Python :: 3"],
	"python_requires":'>=3.6',
	"package_data":{"": ['*.p', '*.txt'],},
	"license":"none",
	"keywords":'',
}

custom_options = {}

if __name__=="__main__":
	setuptools.setup(**custom_options,**options)