# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdiEmsWebApiV2DtoProfileProfileResults(Model):
    """Encapsulates all the profile results for a flight.

    All required parameters must be populated in order to send to Azure.

    :param profile_version: Required. The integer version of the profile that
     was processed to generate the results,
     corresponding to an index in the array of version history entries for the
     profile
    :type profile_version: int
    :param parameter_filtering: Required. Indicates whether automatic
     parameter filtering was enabled when the profile was processed
    :type parameter_filtering: bool
    :param measurements: Required. The top-level, non-event-based, measurement
     results
    :type measurements:
     list[~emsapi.models.AdiEmsWebApiV2DtoProfileProfileResultValue]
    :param timepoints: Required. The top-level, non-event-based, timepoint
     results
    :type timepoints:
     list[~emsapi.models.AdiEmsWebApiV2DtoProfileProfileResultValue]
    :param events: Required. The event results detected in the flight
    :type events:
     list[~emsapi.models.AdiEmsWebApiV2DtoProfileProfileResultsEventRecord]
    :param processing_information: Required. The processing information of the
     flight
    :type processing_information:
     ~emsapi.models.AdiEmsWebApiV2DtoProfileProcessingInformation
    """

    _validation = {
        'profile_version': {'required': True},
        'parameter_filtering': {'required': True},
        'measurements': {'required': True},
        'timepoints': {'required': True},
        'events': {'required': True},
        'processing_information': {'required': True},
    }

    _attribute_map = {
        'profile_version': {'key': 'profileVersion', 'type': 'int'},
        'parameter_filtering': {'key': 'parameterFiltering', 'type': 'bool'},
        'measurements': {'key': 'measurements', 'type': '[AdiEmsWebApiV2DtoProfileProfileResultValue]'},
        'timepoints': {'key': 'timepoints', 'type': '[AdiEmsWebApiV2DtoProfileProfileResultValue]'},
        'events': {'key': 'events', 'type': '[AdiEmsWebApiV2DtoProfileProfileResultsEventRecord]'},
        'processing_information': {'key': 'processingInformation', 'type': 'AdiEmsWebApiV2DtoProfileProcessingInformation'},
    }

    def __init__(self, **kwargs):
        super(AdiEmsWebApiV2DtoProfileProfileResults, self).__init__(**kwargs)
        self.profile_version = kwargs.get('profile_version', None)
        self.parameter_filtering = kwargs.get('parameter_filtering', None)
        self.measurements = kwargs.get('measurements', None)
        self.timepoints = kwargs.get('timepoints', None)
        self.events = kwargs.get('events', None)
        self.processing_information = kwargs.get('processing_information', None)
