# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.exceptions import HttpOperationError
from .operations.analytic_operations import AnalyticOperations
from .operations.analytic_set_operations import AnalyticSetOperations
from .operations.asset_operations import AssetOperations
from .operations.database_operations import DatabaseOperations
from .operations.ems_profile_operations import EmsProfileOperations
from .operations.ems_system_operations import EmsSystemOperations
from .operations.html_documentation_operations import HtmlDocumentationOperations
from .operations.navigation_operations import NavigationOperations
from .operations.parameter_set_operations import ParameterSetOperations
from .operations.profile_operations import ProfileOperations
from .operations.tableau_operations import TableauOperations
from .operations.trajectory_operations import TrajectoryOperations
from .operations.transfer_operations import TransferOperations
from .operations.upload_operations import UploadOperations
from .operations.weather_operations import WeatherOperations
from . import models


class emsapiConfiguration(Configuration):
    """Configuration for emsapi
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if not base_url:
            base_url = 'https://ems.efoqa.com:443/api'

        super(emsapiConfiguration, self).__init__(base_url)

        self.add_user_agent('emsapi/{}'.format(VERSION))

        self.credentials = credentials


class emsapi(SDKClient):
    """The second version of the REST-based API for accessing EMS data

    :ivar config: Configuration for client.
    :vartype config: emsapiConfiguration

    :ivar analytic: Analytic operations
    :vartype analytic: emsapi.operations.AnalyticOperations
    :ivar analytic_set: AnalyticSet operations
    :vartype analytic_set: emsapi.operations.AnalyticSetOperations
    :ivar asset: Asset operations
    :vartype asset: emsapi.operations.AssetOperations
    :ivar database: Database operations
    :vartype database: emsapi.operations.DatabaseOperations
    :ivar ems_profile: EmsProfile operations
    :vartype ems_profile: emsapi.operations.EmsProfileOperations
    :ivar ems_system: EmsSystem operations
    :vartype ems_system: emsapi.operations.EmsSystemOperations
    :ivar html_documentation: HtmlDocumentation operations
    :vartype html_documentation: emsapi.operations.HtmlDocumentationOperations
    :ivar navigation: Navigation operations
    :vartype navigation: emsapi.operations.NavigationOperations
    :ivar parameter_set: ParameterSet operations
    :vartype parameter_set: emsapi.operations.ParameterSetOperations
    :ivar profile: Profile operations
    :vartype profile: emsapi.operations.ProfileOperations
    :ivar tableau: Tableau operations
    :vartype tableau: emsapi.operations.TableauOperations
    :ivar trajectory: Trajectory operations
    :vartype trajectory: emsapi.operations.TrajectoryOperations
    :ivar transfer: Transfer operations
    :vartype transfer: emsapi.operations.TransferOperations
    :ivar upload: Upload operations
    :vartype upload: emsapi.operations.UploadOperations
    :ivar weather: Weather operations
    :vartype weather: emsapi.operations.WeatherOperations

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        self.config = emsapiConfiguration(credentials, base_url)
        super(emsapi, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v2'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.analytic = AnalyticOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.analytic_set = AnalyticSetOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.asset = AssetOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.database = DatabaseOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.ems_profile = EmsProfileOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.ems_system = EmsSystemOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.html_documentation = HtmlDocumentationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.navigation = NavigationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.parameter_set = ParameterSetOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.profile = ProfileOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.tableau = TableauOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.trajectory = TrajectoryOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.transfer = TransferOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.upload = UploadOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.weather = WeatherOperations(
            self._client, self.config, self._serialize, self._deserialize)

    @staticmethod
    def create(username, password, url='https://ems.efoqa.com/api'):
        """Creates a new instance of EMS API client. This client will automatically manage 
        API tokens for the given username/password.
        
        :param username: The username to use for authentication.
        :type username: str
        :param password: The password to use for authentication.
        :type password: str
        :param url: The EMS API endpoint to connect to (default: {'https://ems.efoqa.com/api'})
        :type url: str
        """
        from .extensions import EmsApiTokenAuthentication
        session = EmsApiTokenAuthentication(username, password, url)
        return emsapi(session, url)

    def find_ems_system_id(self, name):
        """Finds the EMS system id for the given name.
        
        :param name: The EMS system name to search for.
        :type name: str
        """
        from .extensions import EmsSystemHelper
        return EmsSystemHelper.find_id(self, name)

    def is_error(self, response):
        """Returns True if the response represents an error"""
        from .extensions import ErrorHelper
        return ErrorHelper.is_error(response)

    def get_error_message(self, response):
        """Returns the error message if there was an error in the request, or None otherwise"""
        from .extensions import ErrorHelper
        return ErrorHelper.get_error_message(response)
