# mypy-boto3-lambda

[![PyPI - mypy-boto3-lambda](https://img.shields.io/pypi/v/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Lambda 1.14.36](https://boto3.amazonaws.com/v1/documentation/api/1.14.36/reference/services/lambda.html#Lambda) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Lambda` service.

```bash
python -m pip install boto3-stubs[lambda]
```

## How to use

### Client annotations

`LambdaClient` provides annotations for `boto3.client("lambda")`.

```python
import boto3

from mypy_boto3_lambda import LambdaClient
from mypy_boto3_lambda.paginator import (
    ListAliasesPaginator,
    ListEventSourceMappingsPaginator,
    ListFunctionEventInvokeConfigsPaginator,
    ListFunctionsPaginator,
    ListLayersPaginator,
    ListLayerVersionsPaginator,
    ListProvisionedConcurrencyConfigsPaginator,
    ListVersionsByFunctionPaginator,
)
from mypy_boto3_lambda.type_defs import AccountLimitTypeDef, ...
from mypy_boto3_lambda.waiter import (
    FunctionActiveWaiter,
    FunctionExistsWaiter,
    FunctionUpdatedWaiter,
)

client: LambdaClient = boto3.client("lambda")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LambdaClient = session.client("lambda")
```

### Paginators annotations

`mypy_boto3_lambda.paginator` module contains type annotations for all paginators.

```python

client: LambdaClient = boto3.client("lambda")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_event_source_mappings_paginator: ListEventSourceMappingsPaginator = client.get_paginator("list_event_source_mappings")
list_function_event_invoke_configs_paginator: ListFunctionEventInvokeConfigsPaginator = client.get_paginator("list_function_event_invoke_configs")
list_functions_paginator: ListFunctionsPaginator = client.get_paginator("list_functions")
list_layer_versions_paginator: ListLayerVersionsPaginator = client.get_paginator("list_layer_versions")
list_layers_paginator: ListLayersPaginator = client.get_paginator("list_layers")
list_provisioned_concurrency_configs_paginator: ListProvisionedConcurrencyConfigsPaginator = client.get_paginator("list_provisioned_concurrency_configs")
list_versions_by_function_paginator: ListVersionsByFunctionPaginator = client.get_paginator("list_versions_by_function")
```


### Waiters annotations

`mypy_boto3_lambda.waiter` module contains type annotations for all waiters.

```python

client: LambdaClient = boto3.client("lambda")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
function_active_waiter: FunctionActiveWaiter = client.get_waiter("function_active")
function_exists_waiter: FunctionExistsWaiter = client.get_waiter("function_exists")
function_updated_waiter: FunctionUpdatedWaiter = client.get_waiter("function_updated")
```





### Typed dictionations

`mypy_boto3_lambda.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AccountLimitTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_lambda` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("lambda")

session_client = boto3.Session().client("lambda")
```
