"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnumType = exports.UnionType = exports.InputType = exports.ObjectType = exports.InterfaceType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const private_1 = require("./private");
const schema_field_1 = require("./schema-field");
/**
 * Interface Types are abstract types that includes a certain set of fields
 * that other types must include if they implement the interface.
 *
 */
class InterfaceType {
    constructor(name, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_IntermediateTypeOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.name = name;
        this.definition = props.definition;
        this.directives = props.directives;
    }
    /**
     * Create a GraphQL Type representing this Intermediate Type
     *
     * @param options the options to configure this attribute
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options === null || options === void 0 ? void 0 : options.isList,
            isRequired: options === null || options === void 0 ? void 0 : options.isRequired,
            isRequiredList: options === null || options === void 0 ? void 0 : options.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this object type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'interface',
            name: this.name,
            directives: this.directives,
            fields: Object.keys(this.definition).map((key) => {
                const field = this.definition[key];
                return `${key}${field.argsToString()}: ${field.toString()}${field.directivesToString(this.modes)}`;
            }),
            modes: this.modes,
        });
    }
    /**
     * Add a field to this Interface Type.
     *
     * Interface Types must have both fieldName and field options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (!options.fieldName || !options.field) {
            throw new Error('Interface Types must have both fieldName and field options.');
        }
        this.definition[options.fieldName] = options.field;
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.InterfaceType = InterfaceType;
_a = JSII_RTTI_SYMBOL_1;
InterfaceType[_a] = { fqn: "@aws-cdk/aws-appsync.InterfaceType", version: "1.159.0" };
/**
 * Object Types are types declared by you.
 *
 */
class ObjectType extends InterfaceType {
    constructor(name, props) {
        var _f, _g;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_ObjectTypeOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const options = {
            definition: (_g = (_f = props.interfaceTypes) === null || _f === void 0 ? void 0 : _f.reduce((def, interfaceType) => {
                return Object.assign({}, def, interfaceType.definition);
            }, props.definition)) !== null && _g !== void 0 ? _g : props.definition,
            directives: props.directives,
        };
        super(name, options);
        this.interfaceTypes = props.interfaceTypes;
        this.resolvers = [];
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        // If the resolvers have been generated, skip the bind
        if (this.resolvers && this.resolvers.length > 0) {
            return this;
        }
        Object.keys(this.definition).forEach((fieldName) => {
            const field = this.definition[fieldName];
            if (field instanceof schema_field_1.ResolvableField) {
                if (!this.resolvers)
                    this.resolvers = [];
                this.resolvers.push(this.generateResolver(api, fieldName, field.fieldOptions));
            }
        });
        return this;
    }
    /**
     * Add a field to this Object Type.
     *
     * Object Types must have both fieldName and field options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (!options.fieldName || !options.field) {
            throw new Error('Object Types must have both fieldName and field options.');
        }
        this.definition[options.fieldName] = options.field;
    }
    /**
     * Generate the string of this object type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'type',
            name: this.name,
            interfaceTypes: this.interfaceTypes,
            directives: this.directives,
            fields: Object.keys(this.definition).map((key) => {
                const field = this.definition[key];
                return `${key}${field.argsToString()}: ${field.toString()}${field.directivesToString(this.modes)}`;
            }),
            modes: this.modes,
        });
    }
    /**
     * Generate the resolvers linked to this Object Type
     */
    generateResolver(api, fieldName, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_IGraphqlApi(api);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_ResolvableFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.generateResolver);
            }
            throw error;
        }
        return api.createResolver({
            typeName: this.name,
            fieldName: fieldName,
            dataSource: options === null || options === void 0 ? void 0 : options.dataSource,
            pipelineConfig: options === null || options === void 0 ? void 0 : options.pipelineConfig,
            requestMappingTemplate: options === null || options === void 0 ? void 0 : options.requestMappingTemplate,
            responseMappingTemplate: options === null || options === void 0 ? void 0 : options.responseMappingTemplate,
        });
    }
}
exports.ObjectType = ObjectType;
_b = JSII_RTTI_SYMBOL_1;
ObjectType[_b] = { fqn: "@aws-cdk/aws-appsync.ObjectType", version: "1.159.0" };
/**
 * Input Types are abstract types that define complex objects.
 * They are used in arguments to represent
 *
 */
class InputType {
    constructor(name, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_IntermediateTypeOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.name = name;
        this.definition = props.definition;
    }
    /**
     * Create a GraphQL Type representing this Input Type
     *
     * @param options the options to configure this attribute
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options === null || options === void 0 ? void 0 : options.isList,
            isRequired: options === null || options === void 0 ? void 0 : options.isRequired,
            isRequiredList: options === null || options === void 0 ? void 0 : options.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this input type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'input',
            name: this.name,
            fields: Object.keys(this.definition).map((key) => `${key}${this.definition[key].argsToString()}: ${this.definition[key].toString()}`),
            modes: this.modes,
        });
    }
    /**
     * Add a field to this Input Type.
     *
     * Input Types must have both fieldName and field options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (!options.fieldName || !options.field) {
            throw new Error('Input Types must have both fieldName and field options.');
        }
        this.definition[options.fieldName] = options.field;
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.InputType = InputType;
_c = JSII_RTTI_SYMBOL_1;
InputType[_c] = { fqn: "@aws-cdk/aws-appsync.InputType", version: "1.159.0" };
/**
 * Union Types are abstract types that are similar to Interface Types,
 * but they cannot to specify any common fields between types.
 *
 * Note that fields of a union type need to be object types. In other words,
 * you can't create a union type out of interfaces, other unions, or inputs.
 *
 */
class UnionType {
    constructor(name, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_UnionTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.name = name;
        this.definition = {};
        options.definition.map((def) => this.addField({ field: def.attribute() }));
    }
    /**
     * Create a GraphQL Type representing this Union Type
     *
     * @param options the options to configure this attribute
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options === null || options === void 0 ? void 0 : options.isList,
            isRequired: options === null || options === void 0 ? void 0 : options.isRequired,
            isRequiredList: options === null || options === void 0 ? void 0 : options.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this Union type
     */
    toString() {
        // Return a string that appends all Object Types for this Union Type
        // i.e. 'union Example = example1 | example2'
        return Object.values(this.definition).reduce((acc, field) => `${acc} ${field.toString()} |`, `union ${this.name} =`).slice(0, -2);
    }
    /**
     * Add a field to this Union Type
     *
     * Input Types must have field options and the IField must be an Object Type.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (options.fieldName) {
            throw new Error('Union Types cannot be configured with the fieldName option. Use the field option instead.');
        }
        if (!options.field) {
            throw new Error('Union Types must be configured with the field option.');
        }
        if (options.field && !(options.field.intermediateType instanceof ObjectType)) {
            throw new Error('Fields for Union Types must be Object Types.');
        }
        this.definition[options.field.toString()] = options.field;
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.UnionType = UnionType;
_d = JSII_RTTI_SYMBOL_1;
UnionType[_d] = { fqn: "@aws-cdk/aws-appsync.UnionType", version: "1.159.0" };
/**
 * Enum Types are abstract types that includes a set of fields
 * that represent the strings this type can create.
 *
 */
class EnumType {
    constructor(name, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_EnumTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.name = name;
        this.definition = {};
        options.definition.map((fieldName) => this.addField({ fieldName }));
    }
    /**
     * Create an GraphQL Type representing this Enum Type
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options === null || options === void 0 ? void 0 : options.isList,
            isRequired: options === null || options === void 0 ? void 0 : options.isRequired,
            isRequiredList: options === null || options === void 0 ? void 0 : options.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this enum type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'enum',
            name: this.name,
            fields: Object.keys(this.definition),
            modes: this.modes,
        });
    }
    /**
     * Add a field to this Enum Type
     *
     * To add a field to this Enum Type, you must only configure
     * addField with the fieldName options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (options.field) {
            throw new Error('Enum Type fields consist of strings. Use the fieldName option instead of the field option.');
        }
        if (!options.fieldName) {
            throw new Error('When adding a field to an Enum Type, you must configure the fieldName option.');
        }
        if (options.fieldName.indexOf(' ') > -1) {
            throw new Error(`Enum Type values cannot have whitespace. Received: ${options.fieldName}`);
        }
        this.definition[options.fieldName] = schema_field_1.GraphqlType.string();
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.EnumType = EnumType;
_e = JSII_RTTI_SYMBOL_1;
EnumType[_e] = { fqn: "@aws-cdk/aws-appsync.EnumType", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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