from .python_util import execute
from .credential import gopass_password_from_path, gopass_field_from_path
from .devops_build import DevopsBuild


def add_aws_rds_pg_mixin_config(config, rds_host_name, db_name,
                                rds_resolve_dns=False,
                                db_port=5432):
    config.update({'AwsRdsPgMixin':
                   {'rds_host_name': rds_host_name,
                    'db_name': db_name,
                    'rds_resolve_dns': rds_resolve_dns,
                    'db_port': db_port,
                    }})
    return config


class AwsRdsPgMixin(DevopsBuild):

    def __init__(self, project, config):
        super().__init__(project, config)
        aws_rds_pg_mixin_config = config['AwsRdsPgMixin']
        print(aws_rds_pg_mixin_config)
        self.rds_host_name = aws_rds_pg_mixin_config['rds_host_name']
        print(self)
        # self.rds_resolve_dns = add_aws_rds_pg_mixin_config['rds_resolve_dns']
        # self.db_name = add_aws_rds_pg_mixin_config['db_name']
        # self.db_port = add_aws_rds_pg_mixin_config['db_port']

    def execute_pg_rds_sql(self, user, password, sql):
        if self.rds_resolve_dns:
            host_cmd = "dig " + self.rds_host_name + " | head -n1"
            host = execute(host_cmd, shell=True)
        else:
            host = self.rds_host_name

        cmd = "PGUSER=" + user + " PGPASSWORD=" + password + \
            " psql --dbname=" + self.db_name + " --host=" + host + " --port=" + self.db_port + \
            " --set=sslmode=require -Atc \"" + sql + "\""
        result = execute(cmd, shell=True)
        print("PSQL: ", host, result.rstrip())
        return result

    def alter_db_user_password(self, gopass_path):
        user_name = gopass_field_from_path(
            self.gopass_stage() + gopass_path, 'user')
        user_old_password = gopass_field_from_path(
            self.gopass_stage() + gopass_path, 'old-password')
        user_new_password = gopass_password_from_path(
            self.gopass_stage() + gopass_path)

        self.execute_pg_rds_sql(user_name, user_old_password,
                                "ALTER ROLE " + user_name + " WITH PASSWORD '" + user_new_password + "';")
        print("password changed for : ", self.gopass_stage(), user_name)

    def add_new_user(self, gopass_path_superuser, gopass_path_new_user, group_role):
        superuser_name = gopass_field_from_path(
            self.gopass_stage() + gopass_path_superuser, 'user')
        superuser_password = gopass_password_from_path(
            self.gopass_stage() + gopass_path_superuser)
        new_user_name = gopass_field_from_path(
            self.gopass_stage() + gopass_path_new_user, 'user')
        new_user_password = gopass_password_from_path(
            self.gopass_stage() + gopass_path_new_user)

        self.execute_pg_rds_sql(superuser_name, superuser_password,
                                "CREATE ROLE " + new_user_name + " WITH LOGIN INHERIT PASSWORD '" + new_user_password + "';" +
                                "GRANT " + group_role + " TO " + new_user_name + ";")
        print("create user for : ", self.gopass_stage(), new_user_name)

    def deactivate_user(self, gopass_path_superuser, to_remove_user_name):
        superuser_name = gopass_field_from_path(
            self.gopass_stage() + gopass_path_superuser, 'user')
        superuser_password = gopass_password_from_path(
            self.gopass_stage() + gopass_path_superuser)

        owned_by_wrong_user = self.execute_pg_rds_sql(superuser_name, superuser_password,
                                                      "SELECT count(*) FROM pg_class c, pg_user u WHERE c.relowner = u.usesysid " +
                                                      "and u.usename='" + to_remove_user_name + "';")
        if int(owned_by_wrong_user) > 0:
            raise AssertionError(
                "There are still objects owned by the user to be deleted.")

        connections = self.execute_pg_rds_sql(superuser_name, superuser_password,
                                              "SELECT count(*) FROM pg_stat_activity WHERE application_name = " +
                                              "'PostgreSQL JDBC Driver' AND usename = '" + to_remove_user_name + "';")
        if int(connections) > 0:
            raise AssertionError("User is still connected.")

        self.execute_pg_rds_sql(superuser_name, superuser_password,
                                "ALTER ROLE '" + to_remove_user_name + "' WITH NOLOGIN NOCREATEROLE;")
