/*
 * Decompiled with CFR 0.152.
 */
package variables;

import interfaces.Observers;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import propagation.Propagation;
import sets.LinkedSet;
import sets.SetDense;
import utility.Kit;
import variables.Variable;

public interface Domain
extends LinkedSet {
    public static final int TAG_RANGE = Integer.MAX_VALUE;
    public static final int TAG_SYMBOLS = 0x7FFFFFFE;
    public static final List<int[]> domainTypes;

    public static boolean similarDomains(Domain[] doms1, Domain[] doms2) {
        return doms1.length == doms2.length && IntStream.range(0, doms1.length).allMatch(i -> doms1[i].typeIdentifier() == doms2[i].typeIdentifier());
    }

    public static int typeIdentifierFor(int ... values) {
        int j = IntStream.range(0, domainTypes.size()).filter(i -> Arrays.equals(values, domainTypes.get(i))).findFirst().orElse(-1);
        if (j != -1) {
            return j;
        }
        domainTypes.add(values);
        return domainTypes.size() - 1;
    }

    public static void setMarks(Variable[] variables) {
        for (Variable x : variables) {
            x.dom.setMark();
        }
    }

    public static void restoreAtMarks(Variable[] variables) {
        for (Variable x : variables) {
            x.dom.restoreAtMark();
        }
    }

    public static void setMarks(Variable[] variables, int level) {
        for (Variable x : variables) {
            x.dom.setMark(level);
        }
    }

    public static void restoreAtMarks(Variable[] variables, int level) {
        for (Variable x : variables) {
            x.dom.restoreAtMark(level);
        }
    }

    public static int nRemovedValues(Variable[] variables) {
        int cnt = 0;
        for (Variable x : variables) {
            cnt += x.dom.nRemoved();
        }
        return cnt;
    }

    public static BigInteger nValidTuples(Domain[] doms, boolean initSize) {
        BigInteger prod = BigInteger.ONE;
        for (Domain dom : doms) {
            prod = prod.multiply(BigInteger.valueOf(initSize ? (long)dom.initSize() : (long)dom.size()));
        }
        return prod;
    }

    public static long nTuplesFor(Domain[] doms, int ignoredPosition, boolean initiSize) {
        if (!1.$assertionsDisabled && !Stream.of(doms).noneMatch(dom -> dom.size() == 0)) {
            throw new AssertionError();
        }
        long l = 1L;
        for (int i = 0; i < doms.length; ++i) {
            int size;
            if (i == ignoredPosition) continue;
            int n = size = initiSize ? doms[i].initSize() : doms[i].size();
            if (l > Long.MAX_VALUE / (long)size) {
                return -1L;
            }
            l *= (long)size;
        }
        return l;
    }

    public static long nValidTuplesBoundedAtMaxValueFor(Domain ... doms) {
        long l = Domain.nTuplesFor(doms, -1, false);
        return l == -1L ? Long.MAX_VALUE : l;
    }

    public static long nValidTuplesBoundedAtMaxValueFor(Variable ... vars) {
        return Domain.nValidTuplesBoundedAtMaxValueFor((Domain[])Stream.of(vars).map(x -> x.dom).toArray(Domain[]::new));
    }

    public static long nValidTuplesBoundedAtMaxValueFor(Domain[] doms, int ignoredPosition) {
        long l = Domain.nTuplesFor(doms, ignoredPosition, false);
        return l == -1L ? Long.MAX_VALUE : l;
    }

    default public boolean areInitValuesExactly(Range range) {
        return this.initSize() == range.length() && IntStream.range(0, this.initSize()).allMatch(a -> this.toVal(a) == range.start + a);
    }

    default public boolean areInitValuesSubsetOf(int[] values) {
        return this.initSize() <= values.length && IntStream.range(0, this.initSize()).allMatch(a -> Kit.isPresent(this.toVal(a), values));
    }

    default public boolean areInitValuesSubsetOf(Range range) {
        Kit.control(range.step == 1);
        return this.initSize() <= range.length() && IntStream.range(0, this.initSize()).allMatch(a -> range.start <= this.toVal(a) && this.toVal(a) < range.stop);
    }

    public Variable var();

    public int typeIdentifier();

    public Propagation propagation();

    public void setPropagation(Propagation var1);

    public boolean indexesMatchValues();

    default public String typeName() {
        return "D" + this.typeIdentifier();
    }

    public int toIdx(int var1);

    public int toVal(int var1);

    default public int toPresentIdx(int v) {
        int a = this.toIdx(v);
        return a < 0 || !this.present(a) ? -1 : a;
    }

    default public boolean presentValue(int v) {
        int a = this.toIdx(v);
        return a >= 0 && this.present(a);
    }

    default public boolean onlyContains(int a) {
        return this.size() == 1 && this.present(a);
    }

    default public boolean onlyContainsValue(int v) {
        return this.size() == 1 && v == this.toVal(this.first());
    }

    default public int unique() {
        if (!1.$assertionsDisabled && this.size() != 1) {
            throw new AssertionError((Object)("Current size = " + this.size()));
        }
        return this.first();
    }

    default public int random() {
        if (!1.$assertionsDisabled && this.size() <= 0) {
            throw new AssertionError();
        }
        int k = this.propagation().solver.head.random.nextInt(this.size());
        if (k < this.size() / 2) {
            int a = this.first();
            for (int cnt = k - 1; cnt >= 0; --cnt) {
                a = this.next(a);
            }
            return a;
        }
        int a = this.last();
        for (int cnt = this.size() - k - 2; cnt >= 0; --cnt) {
            a = this.prev(a);
        }
        return a;
    }

    default public int firstValue() {
        return this.toVal(this.first());
    }

    default public int lastValue() {
        return this.toVal(this.last());
    }

    default public int uniqueValue() {
        return this.toVal(this.unique());
    }

    default public int intervalValue() {
        return this.toVal(this.last()) - this.toVal(this.first());
    }

    default public boolean is01() {
        return this.initSize() == 2 && this.toVal(0) == 0 && this.toVal(1) == 1;
    }

    default public int firstCommonValueWith(Domain dom) {
        int a = this.first();
        while (a != -1) {
            int va = this.toVal(a);
            if (dom.presentValue(va)) {
                return va;
            }
            a = this.next(a);
        }
        return Integer.MAX_VALUE;
    }

    default public void removeAtConstructionTime(int a) {
        Kit.control(this.var().problem.solver == null, () -> "Must be called before the solver being built.");
        this.remove(a, 0);
        ++this.var().problem.nValuesRemoved;
        ++this.var().problem.features.nValuesRemovedAtConstructionTime;
    }

    default public void removeAtConstructionTime(Predicate<Integer> p) {
        int a = this.first();
        while (a != -1) {
            if (p.test(a)) {
                this.removeAtConstructionTime(a);
            }
            a = this.next(a);
        }
    }

    default public void removeValueAtConstructionTime(int v) {
        this.removeAtConstructionTime(this.toIdx(v));
    }

    default public void removeValuesAtConstructionTime(Predicate<Integer> p) {
        int a = this.first();
        while (a != -1) {
            if (p.test(this.toVal(a))) {
                this.removeAtConstructionTime(a);
            }
            a = this.next(a);
        }
    }

    default public boolean afterElementaryCalls(int sizeBefore) {
        return this.size() == sizeBefore ? true : (this.size() == 0 ? this.fail() : this.propagation().handleReductionSafely(this.var()));
    }

    default public void removeElementary(int a) {
        Variable x = this.var();
        if (!(1.$assertionsDisabled || !x.assigned() && this.present(a))) {
            throw new AssertionError((Object)(x + " " + x.assigned() + " " + this.present(a)));
        }
        int depth = this.propagation().solver.stackVariable(x);
        this.remove(a, depth);
        for (Observers.ObserverDomainReduction observer : x.problem.observersDomainReduction) {
            observer.afterRemoval(x, a);
        }
        ++x.problem.nValuesRemoved;
    }

    default public boolean remove(int a) {
        if (!1.$assertionsDisabled && !this.present(a)) {
            throw new AssertionError();
        }
        if (this.size() == 1) {
            return this.fail();
        }
        this.removeElementary(a);
        return this.propagation().handleReductionSafely(this.var());
    }

    default public boolean removeIfPresent(int a) {
        return !this.present(a) || this.remove(a);
    }

    default public void removeSafely(int a) {
        if (!(1.$assertionsDisabled || this.present(a) && this.size() > 1)) {
            throw new AssertionError((Object)(this.present(a) + " " + this.size()));
        }
        this.removeElementary(a);
        this.propagation().handleReductionSafely(this.var());
    }

    default public boolean remove(boolean[] flags, int nRemovals) {
        if (!(1.$assertionsDisabled || 0 < nRemovals && nRemovals <= this.size() && flags.length == this.initSize() && IntStream.range(0, this.initSize()).filter(a -> this.present(a) && !flags[a]).count() == (long)nRemovals)) {
            throw new AssertionError();
        }
        if (this.size() == nRemovals) {
            return this.fail();
        }
        int cnt = 0;
        int a2 = this.first();
        while (cnt < nRemovals) {
            if (!flags[a2]) {
                this.removeElementary(a2);
                ++cnt;
            }
            a2 = this.next(a2);
        }
        return this.propagation().handleReductionSafely(this.var());
    }

    default public boolean remove(SetDense idxs, boolean testPresence) {
        if (testPresence) {
            if (this.size() == 1) {
                for (int i2 = idxs.limit; i2 >= 0; --i2) {
                    if (!this.present(idxs.dense[i2])) continue;
                    return this.fail();
                }
                return true;
            }
            int sizeBefore = this.size();
            for (int i3 = idxs.limit; i3 >= 0; --i3) {
                if (!this.present(idxs.dense[i3])) continue;
                this.removeElementary(idxs.dense[i3]);
            }
            return this.afterElementaryCalls(sizeBefore);
        }
        if (!1.$assertionsDisabled && !IntStream.range(0, idxs.size()).allMatch(i -> this.present(idxs.dense[i]))) {
            throw new AssertionError();
        }
        if (idxs.size() == 0) {
            return true;
        }
        if (this.size() == idxs.size()) {
            return this.fail();
        }
        for (int i4 = idxs.limit; i4 >= 0; --i4) {
            this.removeElementary(idxs.dense[i4]);
        }
        return this.propagation().handleReductionSafely(this.var());
    }

    default public boolean remove(SetDense idxs) {
        return this.remove(idxs, false);
    }

    default public int reduceToElementary(int a) {
        if (!1.$assertionsDisabled && !this.present(a)) {
            throw new AssertionError((Object)(a + " is not present"));
        }
        if (this.size() == 1) {
            return 0;
        }
        Variable x = this.var();
        int depth = this.propagation().solver.stackVariable(x);
        int nRemovals = this.reduceTo(a, depth);
        for (Observers.ObserverDomainReduction observer : x.problem.observersDomainReduction) {
            observer.afterRemovals(x, nRemovals);
        }
        x.problem.nValuesRemoved += nRemovals;
        if (!(1.$assertionsDisabled || nRemovals >= 0 && this.size() == 1)) {
            throw new AssertionError((Object)("nRemovals: " + nRemovals + " size:" + this.size()));
        }
        return nRemovals;
    }

    default public boolean reduceTo(int a) {
        return !this.present(a) ? this.fail() : this.reduceToElementary(a) == 0 || this.propagation().handleReductionSafely(this.var());
    }

    default public boolean reduceToValue(int v) {
        int a = this.toPresentIdx(v);
        return a == -1 ? this.fail() : this.reduceToElementary(a) == 0 || this.propagation().handleReductionSafely(this.var());
    }

    default public boolean fail() {
        return this.propagation().handleReduction(this.var(), 0);
    }

    default public boolean removeValue(int v) {
        int a = this.toPresentIdx(v);
        if (!1.$assertionsDisabled && a == -1) {
            throw new AssertionError();
        }
        return this.remove(a);
    }

    default public boolean removeValueIfPresent(int v) {
        int a = this.toPresentIdx(v);
        return a == -1 || this.remove(a);
    }

    default public boolean removeValuesIfPresent(int v, int w) {
        return this.removeValueIfPresent(v) && this.removeValueIfPresent(w);
    }

    default public boolean removeValuesLT(int limit) {
        return this.removeValuesLE(limit != Integer.MIN_VALUE ? limit - 1 : limit);
    }

    default public boolean removeValuesLE(int limit) {
        if (this.lastValue() <= limit) {
            return this.fail();
        }
        int sizeBefore = this.size();
        int a = this.first();
        while (a != -1 && this.toVal(a) <= limit) {
            this.removeElementary(a);
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesGE(int limit) {
        if (this.firstValue() >= limit) {
            return this.fail();
        }
        int sizeBefore = this.size();
        int a = this.last();
        while (a != -1 && this.toVal(a) >= limit) {
            this.removeElementary(a);
            a = this.prev(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesGT(int limit) {
        return this.removeValuesGE(limit != Integer.MAX_VALUE ? limit + 1 : limit);
    }

    default public boolean removeValuesLT(long limit) {
        if (!1.$assertionsDisabled && limit == Long.MIN_VALUE) {
            throw new AssertionError();
        }
        return this.removeValuesLE(--limit <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (limit >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)limit));
    }

    default public boolean removeValuesGT(long limit) {
        if (!1.$assertionsDisabled && limit == Long.MAX_VALUE) {
            throw new AssertionError();
        }
        return this.removeValuesGE(++limit <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (limit >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)limit));
    }

    default public boolean removeValues(Types.TypeOperatorRel type, long limit, int coeff) {
        if (!(1.$assertionsDisabled || coeff != 0 && limit != Long.MIN_VALUE && limit != Long.MAX_VALUE)) {
            throw new AssertionError();
        }
        if (type == Types.TypeOperatorRel.LT) {
            type = Types.TypeOperatorRel.LE;
            --limit;
        } else if (type == Types.TypeOperatorRel.GT) {
            type = Types.TypeOperatorRel.GE;
            ++limit;
        }
        if (coeff < 0) {
            coeff = -coeff;
            type = type.arithmeticInversion();
            limit = -limit;
        }
        long newLimit = Math.abs(limit) / (long)coeff * (long)(limit < 0L ? -1 : 1);
        if (limit > 0L && type == Types.TypeOperatorRel.GE && limit % (long)coeff != 0L) {
            ++newLimit;
        }
        if (limit < 0L && type == Types.TypeOperatorRel.LE && -limit % (long)coeff != 0L) {
            --newLimit;
        }
        return type == Types.TypeOperatorRel.LE ? this.removeValuesLE(Kit.trunc(newLimit)) : this.removeValuesGE(Kit.trunc(newLimit));
    }

    default public boolean removeValuesModIn(Domain dom, int coeff) {
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return !dom.presentValue(this.firstValue() % coeff) || this.fail();
        }
        int a = this.first();
        while (a != -1) {
            if (dom.presentValue(this.toVal(a) % coeff)) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesAtDistanceGT(int k, Domain dom) {
        int sizeBefore = this.size();
        boolean overk = k * 2 < dom.size();
        int a = this.first();
        while (a != -1) {
            block8: {
                int va = this.toVal(a);
                if (!dom.presentValue(va)) {
                    if (overk) {
                        for (int i = 1; i <= k; ++i) {
                            if (!dom.presentValue(va + k) && !dom.presentValue(va - k)) {
                                continue;
                            }
                            break block8;
                        }
                    } else {
                        int b = dom.first();
                        while (b != -1) {
                            if (Math.abs(va - dom.toVal(b)) > k) {
                                b = dom.next(b);
                                continue;
                            }
                            break block8;
                        }
                    }
                    this.removeElementary(a);
                }
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesNumeratorsGT(int k, int denominator) {
        int va;
        int sizeBefore = this.size();
        int a = this.last();
        while (a != -1 && (va = this.toVal(a)) / denominator > k) {
            this.removeElementary(a);
            a = this.prev(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesDenominatorsGT(int k, int numerator) {
        int va;
        if (!1.$assertionsDisabled && this.presentValue(0)) {
            throw new AssertionError();
        }
        int sizeBefore = this.size();
        int a = this.first();
        while (a != -1 && numerator / (va = this.toVal(a)) > k) {
            this.removeElementary(a);
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesNumeratorsLT(int k, int denominator) {
        int va;
        int sizeBefore = this.size();
        int a = this.first();
        while (a != -1 && (va = this.toVal(a)) / denominator < k) {
            this.removeElementary(a);
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesDenominatorsLT(int k, int numerator) {
        int va;
        int sizeBefore = this.size();
        int a = this.last();
        while (a != -1 && numerator / (va = this.toVal(a)) < k) {
            this.removeElementary(a);
            a = this.prev(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesIn(Domain dom) {
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return !dom.presentValue(this.firstValue()) || this.fail();
        }
        if (this.size() < dom.size()) {
            int a = this.first();
            while (a != -1) {
                if (dom.presentValue(this.toVal(a))) {
                    this.removeElementary(a);
                }
                a = this.next(a);
            }
        } else {
            int b = dom.first();
            while (b != -1) {
                if (this.presentValue(dom.toVal(b))) {
                    this.removeElementary(this.toIdx(dom.toVal(b)));
                }
                b = dom.next(b);
            }
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesNotIn(Domain dom) {
        if (this.lastValue() < dom.firstValue() || dom.lastValue() < this.firstValue()) {
            return this.fail();
        }
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return dom.presentValue(this.firstValue()) || this.fail();
        }
        int a = this.first();
        while (a != -1) {
            if (!dom.presentValue(this.toVal(a))) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesIn(Set<Integer> set) {
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return !set.contains(this.firstValue()) || this.fail();
        }
        if (this.size() < set.size()) {
            int a = this.first();
            while (a != -1) {
                if (set.contains(this.toVal(a))) {
                    this.removeElementary(a);
                }
                a = this.next(a);
            }
        } else {
            for (int v : set) {
                if (!this.presentValue(v)) continue;
                this.removeElementary(this.toIdx(v));
                if (this.size() != 0) continue;
                break;
            }
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesNotIn(Set<Integer> set) {
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return set.contains(this.firstValue()) || this.fail();
        }
        int a = this.first();
        while (a != -1) {
            if (!set.contains(this.toVal(a))) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesIn(int[] set) {
        if (!1.$assertionsDisabled && !Kit.isStrictlyIncreasing(set)) {
            throw new AssertionError();
        }
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return Arrays.binarySearch(set, this.firstValue()) < 0 || this.fail();
        }
        for (int i = set.length - 1; i >= 0; --i) {
            int v = set[i];
            if (!this.presentValue(v)) continue;
            this.removeElementary(this.toIdx(v));
            if (this.size() == 0) break;
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesNotIn(int[] set) {
        if (!1.$assertionsDisabled && !Kit.isStrictlyIncreasing(set)) {
            throw new AssertionError();
        }
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return Arrays.binarySearch(set, this.firstValue()) >= 0 || this.fail();
        }
        int i = 0;
        int a = this.first();
        while (a != -1) {
            int va = this.toVal(a);
            while (i < set.length && va > set[i]) {
                ++i;
            }
            if (i == set.length || va != set[i]) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesIn(SetDense set) {
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return Arrays.binarySearch(set.dense, 0, set.size(), this.firstValue()) < 0 || this.fail();
        }
        for (int i = set.limit; i >= 0; --i) {
            int v = set.dense[i];
            if (!this.presentValue(v)) continue;
            this.removeElementary(this.toIdx(v));
            if (this.size() == 0) break;
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeValuesInRange(int start, int stop) {
        if (start >= stop) {
            return true;
        }
        int first = this.firstValue();
        int last = this.lastValue();
        if (start > last || stop < first) {
            return true;
        }
        int left = Math.max(start, first);
        int right = Math.min(stop - 1, last);
        if (left == first) {
            if (right == last) {
                return this.fail();
            }
        } else if (!this.presentValue(left)) {
            if (this.size() < right - left) {
                int a = this.first();
                while (a != -1 && (left = this.toVal(a)) < start) {
                    a = this.next(a);
                }
            } else {
                ++left;
                while (!this.presentValue(left) && left <= right) {
                    ++left;
                }
            }
        }
        if (left > right) {
            return true;
        }
        int sizeBefore = this.size();
        int a = this.toIdx(left);
        while (a != -1 && (left = this.toVal(a)) <= right) {
            this.removeValue(left);
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public boolean removeIndexesChecking(Predicate<Integer> p) {
        int sizeBefore = this.size();
        if (sizeBefore == 1) {
            return !p.test(this.first()) || this.fail();
        }
        int a = this.first();
        while (a != -1) {
            if (p.test(a)) {
                this.removeElementary(a);
            }
            a = this.next(a);
        }
        return this.afterElementaryCalls(sizeBefore);
    }

    default public int[] valuesChecking(Predicate<Integer> p) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int a = this.first();
        while (a != -1) {
            int va = this.toVal(a);
            if (p.test(va)) {
                values.add(va);
            }
            a = this.next(a);
        }
        return Kit.intArray(values);
    }

    default public boolean subsetOf(Domain dom) {
        int a = this.first();
        while (a != -1) {
            if (!dom.presentValue(this.toVal(a))) {
                return false;
            }
            a = this.next(a);
        }
        return true;
    }

    default public boolean overlapWith(Domain dom) {
        int a = this.first();
        while (a != -1) {
            if (dom.presentValue(this.toVal(a))) {
                return true;
            }
            a = this.next(a);
        }
        return false;
    }

    public Object allValues();

    default public String prettyValueOf(int a) {
        return this.toVal(a) + "";
    }

    default public String prettyAssignedValue() {
        return this.prettyValueOf(this.unique());
    }

    default public void display(boolean exhaustively) {
        System.out.println("  Domain " + this + " (ivs=" + this.indexesMatchValues() + ", domainType=" + this.typeIdentifier() + ")");
        System.out.println("\t initSize = " + this.initSize() + " and size = " + this.size());
        System.out.println("\t first=" + this.first() + " and last=" + this.last());
        if (this.size() != 0) {
            System.out.println("\t first value = " + this.firstValue() + " and last value = " + this.lastValue());
        }
        if (exhaustively) {
            System.out.println("\t values = {" + this.stringListOfValues() + "}\nStructures\n" + this.stringOfStructures());
        }
    }

    default public String stringListOfValues() {
        int prev;
        if (this.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int startInterval = prev = this.firstValue();
        int a = this.next(this.first());
        while (a != -1) {
            int va = this.toVal(a);
            if (va != prev + 1) {
                sb.append(prev == startInterval ? Integer.valueOf(prev) : startInterval + (prev == startInterval + 1 ? " " : "..") + prev).append(" ");
                startInterval = va;
            }
            prev = va;
            a = this.next(a);
        }
        return sb.append(prev == startInterval ? Integer.valueOf(prev) : startInterval + (prev == startInterval + 1 ? " " : "..") + prev).toString();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        domainTypes = new ArrayList<int[]>();
    }
}

