/*
 * Decompiled with CFR 0.152.
 */
package utility;

import sets.SetDense;

public final class Bit {
    public static final short ALL_SHORT_BITS_TO_1 = -1;
    public static final int ALL_INT_BITS_TO_1 = -1;
    public static final long ALL_LONG_BITS_TO_1 = -1L;
    public static final byte[] ONE_BYTE_BIT_TO_0 = Bit.buildOneByteBitTo0();
    public static final int[] ONE_INT_BIT_TO_0 = Bit.buildOneIntBitTo0();
    public static final long[] ONE_LONG_BIT_TO_0 = Bit.buildOneLongBitTo0();
    public static final byte[] ONE_BYTE_BIT_TO_1 = Bit.buildOneByteBitTo1();
    public static final short[] ONE_SHORT_BIT_TO_1 = Bit.buildOneShortBitTo1();
    public static final int[] ONE_INT_BIT_TO_1 = Bit.buildOneIntBitTo1();
    public static final long[] ONE_LONG_BIT_TO_1 = Bit.buildOneLongBitTo1();

    private static byte[] buildOneByteBitTo0() {
        byte[] t = new byte[8];
        t[7] = 127;
        int current = -65;
        for (int i = 6; i >= 0; --i) {
            t[i] = current;
            current = (byte)(current >> 1);
        }
        return t;
    }

    private static int[] buildOneIntBitTo0() {
        int[] t = new int[32];
        t[31] = Integer.MAX_VALUE;
        int current = -1073741825;
        for (int i = 30; i >= 0; --i) {
            t[i] = current;
            current >>= 1;
        }
        return t;
    }

    private static long[] buildOneLongBitTo0() {
        long[] t = new long[64];
        t[63] = Long.MAX_VALUE;
        long current = -4611686018427387905L;
        for (int i = 62; i >= 0; --i) {
            t[i] = current;
            current >>= 1;
        }
        return t;
    }

    private static byte[] buildOneByteBitTo1() {
        byte[] t = new byte[8];
        byte current = 1;
        for (int i = 0; i < t.length; ++i) {
            t[i] = current;
            current = (byte)(current << 1);
        }
        return t;
    }

    private static short[] buildOneShortBitTo1() {
        short[] t = new short[16];
        short current = 1;
        for (int i = 0; i < t.length; ++i) {
            t[i] = current;
            current = (short)(current << 1);
        }
        return t;
    }

    private static int[] buildOneIntBitTo1() {
        int[] t = new int[32];
        int current = 1;
        for (int i = 0; i < t.length; ++i) {
            t[i] = current;
            current <<= 1;
        }
        return t;
    }

    private static long[] buildOneLongBitTo1() {
        long[] t = new long[64];
        long current = 1L;
        for (int i = 0; i < t.length; ++i) {
            t[i] = current;
            current <<= 1;
        }
        return t;
    }

    public static boolean isIncluded(long[] t1, long[] t2) {
        assert (t1.length == t2.length);
        for (int i = 0; i < t1.length; ++i) {
            if ((t1[i] | t2[i]) == t2[i]) continue;
            return false;
        }
        return true;
    }

    public static int firstPositionOfNonInclusion(long[] t1, long[] t2) {
        assert (t1.length == t2.length);
        int position = 0;
        for (int i = 0; i < t1.length; ++i) {
            if ((t1[i] | t2[i]) != t2[i]) {
                long l1 = t1[i];
                long l2 = t2[i];
                for (int j = 0; j < 64; ++j) {
                    if ((l1 & ONE_LONG_BIT_TO_1[j]) == 0L || (l2 & ONE_LONG_BIT_TO_1[j]) != 0L) continue;
                    return position + j;
                }
            }
            position += 64;
        }
        return -1;
    }

    public static boolean nonNullIntersection2(long[] t1, long[] t2, int j) {
        if (t1.length != t2.length) {
            if (t2[1] == 0L) {
                for (int k = 2; k < t2.length; k += 2) {
                    if (t2[k] == (long)j) {
                        return (t1[j] & t2[k + 1]) != 0L;
                    }
                    if (t2[k] <= (long)j) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int k = t2.length - 2; k >= 2; k -= 2) {
                    if (t2[k] == (long)j) {
                        return (t1[j] & t2[k + 1]) != 0L;
                    }
                    if (t2[k] >= (long)j) {
                        continue;
                    }
                    break;
                }
            }
            return (t1[j] & t2[0]) != 0L;
        }
        return (t1[j] & t2[j]) != 0L;
    }

    public static void or2(long[] inout, long[] in, SetDense dset) {
        int[] dense = dset.dense;
        if (inout.length != in.length) {
            for (int i = dset.limit; i >= 0; --i) {
                int k;
                int j = dense[i];
                boolean found = false;
                if (in[1] == 0L) {
                    for (k = 2; !found && k < in.length; k += 2) {
                        if (in[k] == (long)j) {
                            int n = j;
                            inout[n] = inout[n] | in[k + 1];
                            found = true;
                            continue;
                        }
                        if (in[k] <= (long)j) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (k = in.length - 2; !found && k >= 2; k -= 2) {
                        if (in[k] == (long)j) {
                            int n = j;
                            inout[n] = inout[n] | in[k + 1];
                            found = true;
                            continue;
                        }
                        if (in[k] >= (long)j) {
                            continue;
                        }
                        break;
                    }
                }
                if (found) continue;
                int n = j;
                inout[n] = inout[n] | in[0];
            }
        } else {
            for (int i = dset.limit; i >= 0; --i) {
                int j;
                int n = j = dense[i];
                inout[n] = inout[n] | in[j];
            }
        }
    }

    public static void orInverse2(long[] inout, long[] in, SetDense dset) {
        int[] dense = dset.dense;
        if (inout.length != in.length) {
            for (int i = dset.limit; i >= 0; --i) {
                int k;
                int j = dense[i];
                boolean found = false;
                if (in[1] == 0L) {
                    for (k = 2; !found && k < in.length; k += 2) {
                        if (in[k] == (long)j) {
                            int n = j;
                            inout[n] = inout[n] | in[k + 1] ^ 0xFFFFFFFFFFFFFFFFL;
                            found = true;
                            continue;
                        }
                        if (in[k] <= (long)j) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (k = in.length - 2; !found && k >= 2; k -= 2) {
                        if (in[k] == (long)j) {
                            int n = j;
                            inout[n] = inout[n] | in[k + 1] ^ 0xFFFFFFFFFFFFFFFFL;
                            found = true;
                            continue;
                        }
                        if (in[k] >= (long)j) {
                            continue;
                        }
                        break;
                    }
                }
                if (found) continue;
                int n = j;
                inout[n] = inout[n] | in[0] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            for (int i = dset.limit; i >= 0; --i) {
                int j;
                int n = j = dense[i];
                inout[n] = inout[n] | in[j] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
    }

    public static void and(long[] inout, long[] in, SetDense dset) {
        int[] dense = dset.dense;
        for (int i = dset.limit; i >= 0; --i) {
            int j;
            int n = j = dense[i];
            inout[n] = inout[n] & in[j];
        }
    }

    public static int firstNonNullWord2(long[] t1, long[] t2, SetDense dset) {
        int[] dense = dset.dense;
        if (t1.length != t2.length) {
            for (int i = dset.limit; i >= 0; --i) {
                int k;
                int j = dense[i];
                boolean found = false;
                if (t2[1] == 0L) {
                    for (k = 2; !found && k < t2.length; k += 2) {
                        if (t2[k] == (long)j) {
                            if ((t1[j] & t2[k + 1]) != 0L) {
                                return j;
                            }
                            found = true;
                            continue;
                        }
                        if (t2[k] <= (long)j) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (k = t2.length - 2; !found && k >= 2; k -= 2) {
                        if (t2[k] == (long)j) {
                            if ((t1[j] & t2[k + 1]) != 0L) {
                                return j;
                            }
                            found = true;
                            continue;
                        }
                        if (t2[k] >= (long)j) {
                            continue;
                        }
                        break;
                    }
                }
                if (found || (t1[j] & t2[0]) == 0L) continue;
                return j;
            }
            return -1;
        }
        for (int i = dset.limit; i >= 0; --i) {
            int j = dense[i];
            if ((t1[j] & t2[j]) == 0L) continue;
            return j;
        }
        return -1;
    }

    public static int firstErasingWord(long[] t1, long[] t2, SetDense dset) {
        int[] dense = dset.dense;
        for (int i = dset.limit; i >= 0; --i) {
            int j = dense[i];
            if ((t1[j] & t2[j]) == t1[j]) continue;
            return j;
        }
        return -1;
    }

    public static long[] inverse(long[] inout) {
        for (int i = 0; i < inout.length; ++i) {
            inout[i] = inout[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return inout;
    }

    public static long[] inverse(long[] inout, SetDense dset) {
        int[] dense = dset.dense;
        for (int i = dset.limit; i >= 0; --i) {
            int j = dense[i];
            inout[j] = inout[j] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return inout;
    }

    public static long[] inverse(long[] out, long[] in) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return out;
    }

    public static long[] inverse(long[] out, long[] in, SetDense dset) {
        int[] dense = dset.dense;
        for (int i = dset.limit; i >= 0; --i) {
            int j = dense[i];
            out[j] = in[j] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return out;
    }

    public static int count1(long[] t) {
        int cnt = 0;
        for (int i = 0; i < t.length; ++i) {
            cnt += Long.bitCount(t[i]);
        }
        return cnt;
    }

    public static int firstZeroIn(long[] t) {
        int position = 0;
        for (int i = 0; i < t.length; ++i) {
            if ((0xFFFFFFFFFFFFFFFFL & t[i]) != -1L) {
                long l = t[i];
                for (int j = 0; j < 64; ++j) {
                    if ((l & ONE_LONG_BIT_TO_1[j]) != 0L) continue;
                    return position + j;
                }
            }
            position += 64;
        }
        return -1;
    }

    public static boolean isPresent(long[] t, int idx) {
        return (t[idx / 64] & ONE_LONG_BIT_TO_1[idx % 64]) != 0L;
    }

    public static long bitsA1To(int limit) {
        long v = 0L;
        for (int i = 0; i < limit; ++i) {
            v |= ONE_LONG_BIT_TO_1[i];
        }
        return v;
    }

    public static long bitsAt1From(int from) {
        long v = 0L;
        for (int i = from; i < 64; ++i) {
            v |= ONE_LONG_BIT_TO_1[i];
        }
        return v;
    }

    public static void setTo0(byte[] t, int bitPosition) {
        int bytePosition;
        int n = bytePosition = bitPosition / 8;
        t[n] = (byte)(t[n] & ONE_BYTE_BIT_TO_0[bitPosition % 8]);
    }

    public static void setTo1(byte[] t, int bitPosition) {
        int bytePosition;
        int n = bytePosition = bitPosition / 8;
        t[n] = (byte)(t[n] | ONE_BYTE_BIT_TO_1[bitPosition % 8]);
    }

    public static void setTo0(long[] t, int bitPosition) {
        int bytePosition;
        int n = bytePosition = bitPosition / 64;
        t[n] = t[n] & ONE_LONG_BIT_TO_0[bitPosition % 64];
    }

    public static void setTo1(long[] t, int bitPosition) {
        int bytePosition;
        int n = bytePosition = bitPosition / 64;
        t[n] = t[n] | ONE_LONG_BIT_TO_1[bitPosition % 64];
    }

    public static boolean isAt1(byte[] t, int bitPosition) {
        int bytePosition = bitPosition / 8;
        return (t[bytePosition] & ONE_BYTE_BIT_TO_1[bitPosition % 8]) != 0;
    }

    public static String decrypt(long v, int limit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            sb.append((v & ONE_LONG_BIT_TO_1[i]) != 0L ? "1" : "0");
        }
        return sb.toString();
    }

    public static String decrypt(long v) {
        return Bit.decrypt(v, 64);
    }

    public static String decrypt(long[] t, int globalLimit) {
        StringBuilder sb = new StringBuilder();
        for (long l : t) {
            if (globalLimit <= 0) break;
            sb.append(Bit.decrypt(l, Math.min(globalLimit, 64))).append(' ');
            globalLimit -= 64;
        }
        return sb.toString();
    }

    public static String decrypt(long[] t) {
        return Bit.decrypt(t, Integer.MAX_VALUE);
    }

    public static int convert(int v, int nBytesToCopy, byte[] buffer, int position) {
        for (int i = 0; i < nBytesToCopy; ++i) {
            buffer[position++] = (byte)v;
            v >>= 8;
        }
        return position;
    }

    public static int convert(long[] t, int nBitsToCopy, byte[] buffer, int position) {
        for (long l : t) {
            for (int cnt = 0; cnt < 8; ++cnt) {
                if (nBitsToCopy <= 0) {
                    return position;
                }
                buffer[position++] = (byte)l;
                l >>= 8;
                nBitsToCopy -= 8;
            }
        }
        return position;
    }

    public static void main(String[] args) {
        long[] t1 = new long[]{4532L, -65L, 900L};
        long[] t2 = new long[]{4532L, 675L, -900L};
        System.out.println(Bit.decrypt(t1, 115));
        System.out.println(Bit.decrypt(t2, 115));
        System.out.println(Bit.firstPositionOfNonInclusion(t1, t2));
    }
}

