/*
 * Decompiled with CFR 0.152.
 */
package solver;

import constraints.Constraint;
import interfaces.Observers;
import java.text.NumberFormat;
import learning.IpsRecorderForEquivalence;
import learning.ReductionOperator;
import org.xcsp.common.Types;
import problem.Features;
import propagation.Forward;
import propagation.GAC;
import propagation.SAC;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public abstract class Statistics
implements Observers.ObserverRuns,
Observers.ObserverSearch {
    public static final String N_BUILT_BRANCHES = "nBuiltBranches";
    public static final String SUM_BRANCH_SIZES = "sumBranchSizes";
    public static final String MAP_SIZE = "mapSize";
    public static final String N_INFERENCES = "nInferences";
    public static final String N_TOO_LARGE_KEYS = "nTooLargeKeys";
    public static final String N_SELIMINABLES = "nSEliminables";
    public static final String N_RELIMINABLES = "nREliminables";
    public static final String N_DELIMINABLES = "nDEliminables";
    public static final String N_IELIMINABLES = "nIEliminables";
    public static final String N_PELIMINABLES = "nPEliminables";
    public static final String N_SINGLETON_TESTS = "nSingletonTests";
    public static final String N_EFFECTIVE_SINGLETON_TESTS = "nEffectiveSingletonTests";
    public static final String N_FOUND_SINGLETONS = "nFoundSingletons";
    public static final String GUARANTEED_GAC = "guaranteedGAC";
    public static final String STOP = "Stop";
    private static NumberFormat nformat = NumberFormat.getInstance();
    public final Solver solver;
    public final Kit.Stopwatch stopwatch = new Kit.Stopwatch();
    public long nNodes = 1L;
    public long nDecisions;
    public long nWrongDecisions;
    public long nBacktracks;
    public long nAssignments;
    public long nFailedAssignments;
    public long nPreproRemovedValues;
    public long nPreproRemovedTuples;
    public long nPreproAddedCtrs;
    public long nPreproAddedNogoods;
    public long nPreproInconsistencies;
    public long solvingWck;
    public long preproWck;
    public long searchWck;
    public long firstSolWck;
    public long firstSolCpu;
    public long lastSolWck;
    public long lastSolCpu;
    private long tmpNbAssignments;
    private long tmpNbBacktracks;
    private long tmpNbFailedAssignments;

    @Override
    public final void beforePreprocessing() {
        this.stopwatch.start();
        if (this.solver instanceof Solver && this.solver.nogoodRecorder != null) {
            this.nPreproAddedNogoods = this.solver.nogoodRecorder.nNogoods;
        }
        this.nPreproAddedCtrs = this.solver.problem.constraints.length;
    }

    @Override
    public final void afterPreprocessing() {
        this.preproWck += this.stopwatch.wckTime();
        if (this.solver instanceof Solver && this.solver.nogoodRecorder != null) {
            this.nPreproAddedNogoods = (long)this.solver.nogoodRecorder.nNogoods - this.nPreproAddedNogoods;
        }
        this.nPreproAddedCtrs = (long)this.solver.problem.constraints.length - this.nPreproAddedCtrs;
        this.nPreproRemovedValues = Variable.nRemovedValuesFor(this.solver.problem.variables);
        this.nPreproRemovedTuples = this.solver.propagation.nTuplesRemoved;
        this.nPreproInconsistencies = this.solver.stopping == Enums.EStopping.FULL_EXPLORATION ? 1L : 0L;
    }

    @Override
    public final void beforeSolving() {
        this.stopwatch.start();
    }

    @Override
    public final void afterSolving() {
        this.solvingWck += this.stopwatch.wckTime();
    }

    @Override
    public void afterRun() {
        this.searchWck = this.stopwatch.wckTime();
    }

    public void onAssignment(Variable x) {
        ++this.nNodes;
        if (x.dom.size() > 1) {
            ++this.nDecisions;
        }
    }

    public void onRefutation(Variable x) {
        if (x.dom.size() > 1) {
            ++this.nNodes;
            ++this.nDecisions;
        }
    }

    public Statistics(Solver solver) {
        this.solver = solver;
    }

    public long numberSafe() {
        return this.nNodes + this.nAssignments + this.nBacktracks;
    }

    public void store() {
        this.tmpNbAssignments = this.nAssignments;
        this.tmpNbFailedAssignments = this.nFailedAssignments;
        this.tmpNbBacktracks = this.nBacktracks;
    }

    public void restore() {
        this.nAssignments = this.tmpNbAssignments;
        this.nFailedAssignments = this.tmpNbFailedAssignments;
        this.nBacktracks = this.tmpNbBacktracks;
    }

    public final long nEffectiveFilterings() {
        return this.solver.problem.features.nEffectiveFilterings;
    }

    public final long nRevisions() {
        return this.solver.propagation instanceof Forward ? ((Forward)this.solver.propagation).reviser.nRevisions : 0L;
    }

    public final long nUselessRevisions() {
        return this.solver.propagation instanceof Forward ? ((Forward)this.solver.propagation).reviser.nUselessRevisions : 0L;
    }

    public final long nSingletonTests() {
        return this.solver.propagation.nSingletonTests;
    }

    public final long nEffectiveSingletonTests() {
        return this.solver.propagation.nEffectiveSingletonTests;
    }

    public void manageSolution() {
        long cpu = this.solver.head.stopwatch.cpuTime();
        long wck = this.solver.head.instanceStopwatch.wckTime();
        if (this.solver.solRecorder.found == 1L) {
            this.firstSolCpu = cpu;
            this.firstSolWck = wck;
        }
        this.lastSolCpu = cpu;
        this.lastSolWck = wck;
    }

    public final Features.MapAtt solverConstructionAttributes() {
        Features.MapAtt m = new Features.MapAtt("Solver");
        if (this.solver.propagation.getClass() == GAC.class) {
            m.put(GUARANTEED_GAC, Constraint.isGuaranteedGAC(this.solver.problem.constraints));
        }
        m.separator();
        m.put("wck", this.solver.head.instanceStopwatch.wckTimeInSeconds());
        m.put("cpu", this.solver.head.stopwatch.cpuTimeInSeconds());
        m.put("mem", Kit.memoryInMb());
        return m;
    }

    public final Features.MapAtt preproAttributes() {
        Features.MapAtt m = new Features.MapAtt("Preprocessing");
        m.put("eff", this.nEffectiveFilterings());
        m.putIf("revisions", "(" + this.nRevisions() + ",useless=" + this.nUselessRevisions() + ")", this.nRevisions() > 0L);
        m.put("nValues", Variable.nValidValuesFor(this.solver.problem.variables));
        if (this.solver.propagation instanceof GAC) {
            m.put("nACremovedValues", ((GAC)this.solver.propagation).nPreproRemovals);
        }
        m.put("inconsistency", this.nPreproInconsistencies > 0L);
        m.separator();
        if (this.nPreproRemovedTuples > 0L || this.nPreproAddedNogoods > 0L || this.nPreproAddedCtrs > 0L) {
            m.put("nRemovedTuples", this.nPreproRemovedTuples);
            m.put("nNogoods", this.nPreproAddedNogoods);
            m.put("nAddedCtrs", this.nPreproAddedCtrs);
            m.separator();
        }
        if (this.nSingletonTests() > 0L) {
            m.put(N_SINGLETON_TESTS, this.nSingletonTests());
            m.put(N_EFFECTIVE_SINGLETON_TESTS, this.nEffectiveSingletonTests());
            if (this.solver.propagation instanceof SAC) {
                m.put(N_FOUND_SINGLETONS, ((SAC)this.solver.propagation).nFoundSingletons);
            }
            if (this.solver.propagation instanceof SAC.SACGreedy) {
                m.put(N_BUILT_BRANCHES, ((SAC.SACGreedy)this.solver.propagation).nBranchesBuilt);
                m.put(SUM_BRANCH_SIZES, ((SAC.SACGreedy)this.solver.propagation).sumBranchSizes);
            }
            m.separator();
        }
        if (this.solver.solRecorder.found > 0L) {
            m.put("foundSolutions", this.solver.solRecorder.found);
            m.put("firstSolCpu", (double)this.firstSolCpu / 1000.0);
            m.separator();
        }
        m.put("wck", (double)this.preproWck / 1000.0);
        m.put("cpu", this.solver.head.stopwatch.cpuTimeInSeconds());
        m.put("mem", Kit.memoryInMb());
        return m;
    }

    public abstract Features.MapAtt runAttributes();

    public abstract Features.MapAtt cumulatedAttributes();

    public Features.MapAtt globalAttributes() {
        Features.MapAtt m = this.cumulatedAttributes();
        m.put(STOP, this.solver.stopping == null ? "no" : this.solver.stopping.toString());
        m.put("wrong", this.solver.stats.nWrongDecisions);
        if (this.solver.solRecorder.found > 0L) {
            if (this.solver.problem.settings.framework != Types.TypeFramework.CSP) {
                m.put("bestBound", this.solver.solRecorder.bestBound);
                m.put("bestBoundWck", (double)this.lastSolWck / 1000.0);
                m.put("bestBoundCpu", (double)this.lastSolCpu / 1000.0);
            }
            m.put("foundSolutions", this.solver.solRecorder.found);
            m.put("firstSolCpu", (double)this.firstSolCpu / 1000.0);
            m.separator();
        }
        m.put("wck", this.solver.head.instanceStopwatch.wckTimeInSeconds());
        m.put("cpu", this.solver.head.stopwatch.cpuTimeInSeconds());
        m.put("mem", Kit.memoryInMb());
        return m;
    }

    public static final class StatisticsBacktrack
    extends Statistics {
        protected Solver solver;

        public StatisticsBacktrack(Solver solver) {
            super(solver);
            this.solver = solver;
        }

        @Override
        public Features.MapAtt runAttributes() {
            Features.MapAtt m = new Features.MapAtt("Run");
            m.put("run", this.solver.restarter.numRun);
            m.put("dpt", this.solver.minDepth + ".." + this.solver.maxDepth);
            m.put("eff", this.nEffectiveFilterings());
            m.put("wrg", this.nWrongDecisions);
            if (Kit.memory() > 10000000000L) {
                m.put("mem", Kit.memoryInMb());
            }
            m.put("wck", this.stopwatch.wckTimeInSeconds());
            if (this.solver.nogoodRecorder != null) {
                m.putWhenPositive("ngd", this.solver.nogoodRecorder.nNogoods);
            }
            if (this.solver.solRecorder.found > 0L) {
                if (this.solver.problem.settings.framework == Types.TypeFramework.CSP) {
                    m.put("nSols", this.solver.solRecorder.found);
                } else if (this.solver.problem.optimizer.minBound == 0L || this.solver.problem.optimizer.minBound == Long.MIN_VALUE) {
                    m.put("bnd", nformat.format(this.solver.solRecorder.bestBound));
                } else {
                    m.put("bnds", this.solver.problem.optimizer.stringBounds());
                }
            }
            if (this.solver.head.control.general.verbose <= 1) {
                return m;
            }
            m.separator();
            m.put("decs", this.nDecisions);
            m.put("backs", this.nBacktracks);
            m.put("failed", this.nFailedAssignments);
            m.putIf("revisions", "(" + this.nRevisions() + ",useless=" + this.nUselessRevisions() + ")", this.nRevisions() > 0L);
            if (this.nSingletonTests() > 0L) {
                m.put(Statistics.N_SINGLETON_TESTS, this.nSingletonTests());
                m.put(Statistics.N_EFFECTIVE_SINGLETON_TESTS, this.nEffectiveSingletonTests());
            }
            if (Kit.memory() > 10000000000L) {
                m.put("mem", Kit.memoryInMb());
            }
            m.separator();
            if (this.solver.ipsRecorder != null && this.solver.ipsRecorder instanceof IpsRecorderForEquivalence && !this.solver.ipsRecorder.stopped) {
                IpsRecorderForEquivalence learner = (IpsRecorderForEquivalence)this.solver.ipsRecorder;
                m.put(Statistics.MAP_SIZE, learner.getMapSize());
                m.put(Statistics.N_INFERENCES, learner.nInferences);
                m.put(Statistics.N_TOO_LARGE_KEYS, learner.nTooLargeKeys);
            }
            if (this.solver.ipsRecorder != null) {
                ReductionOperator ro = this.solver.ipsRecorder.reductionOperator;
                m.put(Statistics.N_SELIMINABLES, Kit.decimalFormat.format(ro.getProportionOfNbSEliminableVariables()));
                m.put(Statistics.N_RELIMINABLES, Kit.decimalFormat.format(ro.getProportionOfNbREliminableVariables()));
                m.put(Statistics.N_IELIMINABLES, Kit.decimalFormat.format(ro.getProportionOfNbIEliminableVariables()));
                m.put(Statistics.N_DELIMINABLES, Kit.decimalFormat.format(ro.getProportionOfNbDEliminableVariables()));
                m.put(Statistics.N_PELIMINABLES, Kit.decimalFormat.format(ro.getProportionOfNbPEliminableVariables()));
                m.separator();
            }
            return m;
        }

        @Override
        public Features.MapAtt cumulatedAttributes() {
            Features.MapAtt m = new Features.MapAtt("Global");
            m.put("eff", this.nEffectiveFilterings());
            m.putIf("revisions", "(" + this.nRevisions() + ",useless=" + this.nUselessRevisions() + ")", this.nRevisions() > 0L);
            if (this.nSingletonTests() > 0L) {
                m.put(Statistics.N_SINGLETON_TESTS, this.nSingletonTests());
                m.put(Statistics.N_EFFECTIVE_SINGLETON_TESTS, this.nEffectiveSingletonTests());
            }
            if (this.solver.nogoodRecorder != null) {
                m.putWhenPositive("nogoods", this.solver.nogoodRecorder.nNogoods);
            }
            m.separator();
            return m;
        }
    }
}

